SET NAMES 'utf8';
SET FOREIGN_KEY_CHECKS=0;

-- SEPARATOR

DELETE FROM `Groups` WHERE `ID` IN (1,2000000,3000000,3100000,3200000,3300000,4000000);
LOCK TABLES `Groups` WRITE;
INSERT INTO `Groups`
  (`ID`,`ParentID`,`Name`,`InterfaceID`,`IsDefault`,`IsDepartment`,`Comment`)
VALUES
(1,1,'Пользователи','User','no','no','Главная корневая группа'),
(2000000,1,'Клиенты',NULL,'yes','no','Группа всех клиентов'),
(3000000,1,'Сотрудники','Administrator','no','no','Группа сотрудников компании'),
(3100000,3000000,'Служба технической поддержки',NULL,'no','yes','Вопросы технического характера'),
(3900000,3000000,'Разработчики',NULL,'no','no','Группа разработчиков'),
(3200000,3000000,'Бухгалтерия',NULL,'no','yes','Вопросы документации и бухгалтерской отчетности'),
(3300000,3000000,'Менеджеры',NULL,'no','yes','Коммерческие предложения и жалобы'),
(4000000,1,'Система',NULL,'no','no','Группа всех клиентов');
UNLOCK TABLES;

-- SEPARATOR

DELETE FROM `Users` WHERE `ID` IN (1,10,50,100,200,300);
LOCK TABLES `Users` WRITE;
INSERT INTO `Users`
  (`ID`,`GroupID`,`Name`,`Watchword`,`Email`,`Sign`,`IsActive`,`IsProtected`,`AdminNotice`)
VALUES
(1,4000000,'Система','54b53072540eeeb8f8e9343e71f28176','system@system.com','С уважением, биллинговая система JBs.','no','yes','От этого пользователя работает биллинговая система'),
(10,2000000,'Гость','19e66fdb0d643d2f36080a9dca4c5de4','guest@system.com','С уважением, Гость.','no','yes',''),
(50,3900000,'Joonte Software','bf4f00d4c5f44227066f5668a599bf9f','office@joonte.com','С уважением, Joonte Software.','no','yes',''),
(100,3000000,'ООО \"Компания\"',MD5('default'),'admin@example.com','С уважением, ООО \"Компания\".','yes','yes','От этого пользователя рассылаются уведомления, у него хранится профиль компании'),
(200,2000000,'Клиент',MD5('nopassword'),'client@example.com','С уважением, Клиент.','no','yes',''),
(300,3000000,'Сайт компании','e02f7b992578cd299e3e3edaed120689','site@example.com','С уважением, сайт ООО \"Компания\".','no','yes','Пользователь с доступом только к API, используется для работы сайта');
UNLOCK TABLES;

-- SEPARATOR
UPDATE `Users` SET `ConfirmedWas` = '{"1672520401":"System User"}' WHERE `ID` < 2000;

-- SEPARATOR
INSERT INTO `Contacts` (`UserID`,`Address`)
	SELECT `Users`.`ID`,`Users`.`Email` FROM `Users` ORDER BY `ID`;
-- SEPARATOR
UPDATE `Contacts` SET `CreateDate` = UNIX_TIMESTAMP(), `MethodID` = 'Email', `IsPrimary` = 'yes', `IsActive` = 'yes';
-- SEPARATOR
INSERT INTO `Contracts` (`UserID`,`TypeID`,`Customer`,`StatusID`) VALUES (300,'Default','Наш сайт','Complite');



-- SEPARATOR

DELETE FROM `Tasks` WHERE `ID` IN (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,17,18);
LOCK TABLES `Tasks` WRITE;
INSERT INTO `Tasks`
  (`ID`,`UserID`,`TypeID`,`Params`,`IsActive`)
VALUES
(1,1,'GC','[]','yes'),
(2,1,'Temp','[]','yes'),
(3,1,'BackUp','[]','yes'),
(4,1,'Logs','[]','yes'),
(5,1,'TicketsMessages','[]','yes'),
(6,1,'WorksComplite','[]','yes'),
(7,1,'WorksCompliteReports','[]','yes'),
(8,1,'CaclulatePartnersReward','[]','yes'),
(9,1,'OrdersForSuspend','[]','yes'),
(10,1,'RecoveryProfiles','[]','yes'),
(11,1,'RecoveryServers','[]','yes'),
(12,1,'RecoveryUsers','[]','yes'),
(13,1,'CheckEmail','[]','yes'),
(14,1,'OrdersForDelete','[]','yes'),
(15,1,'Taxation','[]','yes'),
/* 16 задача внутренняя, для тех у кого старый биллинг был */
(17,1,'DBO','[]','yes'),
(18,1,'YandexMetrika','[]','yes'),
(19,1,'RecoveryServices','[]','yes'),
(20,1,'NotConfirmedInvoices','[]','yes')
;
UNLOCK TABLES;


-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (1,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Без категории','Статьи не вошедшие ни в какие категории','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (2,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Новости','Новости хостинга, RSS','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (3,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Соглашения','Шаблоны соглашений','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (4,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Договора','Шаблоны договоров','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)

VALUES (5,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Конверты','Шаблоны конвертов','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (6,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Платёжные системы','Шаблоны счетов','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (7,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Регистраторы','Шаблоны писем о переносе доменов к регистраторам','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (8,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Подсказки','Подсказки платёжных систем и т.п.','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (9,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Описания страниц','Описания страниц биллинговой системы','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (10,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Шаблоны тикетов','Шаблоны для создания тикета','yes','yes');
-- SEPARATOR
INSERT INTO `ClausesGroups` (`ID`,`PublicDate`,`ChangedDate`,`AuthorID`,`EditorID`,`Name`,`Notice`,`IsProtected`,`IsPublish`)
	VALUES (11,UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),100,100,'Кнопки тикетницы','Кнопки быстрого ответа в тикетнице','yes','yes');

-- SEPARATOR

DELETE FROM `Clauses` WHERE `Partition` IN ('User/Panel','/Help/Services/Paying','News','/Contacts');
INSERT INTO `Clauses`
  (`GroupID`,`AuthorID`,`EditorID`,`IsXML`,`IsDOM`,`IsProtected`,`Partition`,`Title`,`Text`)
VALUES
(1,100,100,'yes','no','yes','User/Panel','Рекламная панель','<P />'),
(4,100,100,'yes','yes','yes','/Documents','Шаблоны документов','<NOBODY><p>Всем физическим лицам услуги предоставляются на основании договора Публичной Оферты в соответствии с Гражданским Кодексом РФ. Безусловным принятием условий договора Публичной Оферты считается осуществление платежа в счет оплаты услуг. Если Вы физическое лицо, то Вам не надо заключать отдельный договор в письменном виде.</p>
<p>Условия могут быть изменены Исполнителем в одностороннем порядке. Новая редакция Условий вступает в силу по истечении 3 (трех) дней с момента ее размещения на WEB-сервере Исполнителя, если иное не предусмотрено новой редакцией Условий. Исполнитель уведомляет пользователей об изменении Условий по электронной почте не позднее, чем за 3 дня до вступления изменений в силу.</p>
<BR />
<COMP path="Clauses/Menu" args="Contracts%/Content"> [шаблоны документов] </COMP></NOBODY>'),
(8,100,100,'yes','no','yes','/Help/Services/Paying','Продление услуг','<TABLE width=\"400\">\n <TR>\n  <TD>\n   <SPAN>Для продления услуги, найдите необходимый заказ в списке заказов. Напротив заказа нажмите кнопку <IMG width=\"22\" height=\"22\" src=\"/styles/billing/Images/Icons/Pay.gif\" /> и дальше следуйте инструкциям системы.</SPAN>\n  </TD>\n  <TD>\n  </TD>\n </TR>\n</TABLE>\n'),
(2,100,100,'yes','no','yes','News','Запуск биллинговой системы','<P>На нашем хостинге успешно запущена новая биллинговая система JBs от компании Joonte Software. Теперь заказывать еще проще и быстрее!</P>'),
(1,100,100,'yes','no','yes','/Contacts','Контакты','<NOBODY>\n <H1>Адрес офиса</H1>\n <P>000000, г. Москва, ул. Ленина, д. 10, офис 100.</P>\n <H1>Офисный телефон</H1>\n <P>\n  <SPAN>+7 (495) 00-00-00 (понедельник - пятница с 10:00 до 18:00).</SPAN>\n </P>\n<H1>Техническая поддержка</H1>\n <P>\n  <SPAN>По всем техническим вопросам просим Вас обращаться через специализированный </SPAN>\n  <A href=\"/Tickets\">центр поддержки</A>\n </P>\n');

-- SEPARATOR
-- Шаблоны договоров

set @Text = '<NOBODY>
 <TABLE border="1" align="right" cellpadding="2">
  <TR>
   <TD align="center">%MotionDocumentID%</TD>
  </TR>
 </TABLE>
 <H1 align="center">ДОГОВОР №%Contract.Number% от %Contract.CreateDate%</H1>
 <DIV id="Agreement">[соглашение сторон]</DIV>
 <DIV id="Content">[содержимое договора]</DIV>
 <HR />
 <H2>Реквизиты и подписи сторон</H2>
 <H2>Исполнитель:</H2>
 <FONT size="1">
  <TABLE border="1" width="100%" cellpadding="5">
   <TR>
    <TD>Полное название организации</TD>
    <TD>%Executor.CompanyForm% "%Executor.CompanyName%"</TD>
   </TR>
   <TR>
    <TD>ИНН | КПП</TD>
    <TD>%Executor.Inn% | %Executor.Kpp%</TD>
   </TR>
   <TR>
    <TD>Юридический адрес</TD>
    <TD>%Executor.jIndex%, %Executor.jCountry%, %Executor.jCity%, %Executor.jType% %Executor.jAddress%</TD>
   </TR>
   <TR>
    <TD>Почтовый адрес</TD>
    <TD>%Executor.pIndex%, %Executor.pCountry%, %Executor.pCity%, %Executor.pType% %Executor.pAddress%</TD>
   </TR>
   <TR>
    <TD>Телефон</TD>
    <TD>%Executor.Phone%</TD>
   </TR>
   <TR>
    <TD>Электронный адрес</TD>
    <TD>%Executor.Email%</TD>
   </TR>
   <TR>
    <TD>Наименование банка</TD>
    <TD>%Executor.BankName%</TD>
   </TR>
   <TR>
    <TD>Номер расчетного счета</TD>
    <TD>%Executor.BankAccount%</TD>
   </TR>
   <TR>
    <TD>БИК</TD>
    <TD>%Executor.Bik%</TD>
   </TR>
   <TR>
    <TD>Корреспондентский счет</TD>
    <TD>%Executor.Kor%</TD>
   </TR>
  </TABLE>
 </FONT>
 <BR />
 <H2>Заказчик:</H2>
 <DIV id="Customer">[данные клиента]</DIV>
 <DIV id="Footer">[подписи сторон]</DIV>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
	VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Template','Шаблон договора исполнителя юридического лица',@Text);

-- SEPARATOR

set @Text = '<NOBODY>
 <TABLE border="1" align="right" cellpadding="2">
  <TR>
   <TD align="center">%MotionDocumentID%</TD>
  </TR>
 </TABLE>
 <H1 align="center">ДОГОВОР №%Contract.Number% от %Contract.CreateDate%</H1>
 <DIV id="Agreement">[соглашение сторон]</DIV>
 <DIV id="Content">[содержимое договора]</DIV>
 <HR />
 <H2>Реквизиты и подписи сторон</H2>
 <H2>Исполнитель:</H2>
 <FONT size="1">
  <TABLE border="1" width="100%" cellpadding="5">
   <TR>
    <TD>Полное название организации</TD>
    <TD>Индивидуальный предприниматель %Executor.CompanyName%</TD>
   </TR>
   <TR>
    <TD>ИНН | КПП</TD>
    <TD>%Executor.Inn% | %Executor.Kpp%</TD>
   </TR>
   <TR>
    <TD>Юридический адрес</TD>
    <TD>%Executor.jIndex%, %Executor.jCountry%, %Executor.jCity%, %Executor.jType% %Executor.jAddress%</TD>
   </TR>
   <TR>
    <TD>Почтовый адрес</TD>
    <TD>%Executor.pIndex%, %Executor.pCountry%, %Executor.pCity%, %Executor.pType% %Executor.pAddress%</TD>
   </TR>
   <TR>
    <TD>Телефон</TD>
    <TD>%Executor.Phone%</TD>
   </TR>
   <TR>
    <TD>Электронный адрес</TD>
    <TD>%Executor.Email%</TD>
   </TR>
   <TR>
    <TD>WEB-сервер</TD>
    <TD>%Executor.SiteURL%</TD>
   </TR>
   <TR>
    <TD>Наименование банка</TD>
    <TD>%Executor.BankName%</TD>
   </TR>
   <TR>
    <TD>Номер расчетного счета</TD>
    <TD>%Executor.BankAccount%</TD>
   </TR>
   <TR>
    <TD>БИК</TD>
    <TD>%Executor.Bik%</TD>
   </TR>
   <TR>
    <TD>Корреспондентский счет</TD>
    <TD>%Executor.Kor%</TD>
   </TR>
  </TABLE>
 </FONT>
 <BR />
 <H2>Заказчик:</H2>
 <DIV id="Customer">[данные клиента]</DIV>
 <DIV id="Footer">[подписи сторон]</DIV>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Individual/Template','Шаблон договора исполнителя индивидуального предпринимателя',@Text);

-- SEPARATOR

set @Text = '<NOBODY>
<h2>1. Используемые термины</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">1.1.</td>
		<td align="justify" width="95%">Автоматизированная Система Управления (далее АСУ) – аппаратно-программный комплекс Исполнителя, предоставляемый Заказчику, служащий для автоматизированного удаленного взаимодействия между Заказчиком и Исполнителем.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">1.2.</td>
		<td align="justify" width="95%">Канал связи – это адрес электронной почты и/или номер факса, сообщенные Исполнителю Заказчиком посредством АСУ, а так же внутренняя система сообщений АСУ.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">1.3.</td>
		<td align="justify" width="95%">Техническая поддержка – комплекс мер, проводимых Исполнителем для обеспечения надлежащего предоставления услуг Заказчику, заявленных в настоящем Договоре, а так же своевременное предоставление информации необходимой Заказчику для использования услуг.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">1.4.</td>
		<td align="justify" width="95%">Служба Технической Поддержки (далее СТП) – персонал Исполнителя, осуществляющий техническую поддержку.</td>
	</tr>
</tbody>
</table>

<h2>2. Предмет договора</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">2.1.</td>
		<td align="justify" width="95%">Исполнитель предоставляет Заказчику платные услуги, согласно условиям, предусмотренным настоящим Договором, а также приложениями к нему.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">2.2.</td>
		<td align="justify" width="95%">Приложения являются официальными документами Исполнителя и устанавливаются Исполнителем одинаковыми для всех потребителей, за исключением случаев, когда Законом или иным правовым документом допускается предоставление льгот отдельным категориям потребителей услуг. В случае, если пункты договора и приложения перекрывают друг друга, то необходимо руководствоваться пунктами приложения.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">2.3.</td>
		<td align="justify" width="95%">Стороны по настоящему Договору признают юридическую силу текстов документов, полученных по каналам связи, наравне с документами, исполненными в простой письменной форме. Исключение из этого правила составляют заключение настоящего Договора и обмен претензиями, для которых простая письменная форма обязательна.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">2.4.</td>
		<td align="justify" width="95%">Стороны принимают на себя всю ответственность за действия сотрудников, имеющих доступ к каналам связи.</td>
	</tr>
</tbody>
</table>

<h2>3. Порядок регистрации Заказчика в АСУ и изменения контактной информации</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.1.</td>
		<td align="justify" width="95%">Для заключения настоящего Договора Заказчик обязуется зарегистрироваться в АСУ. Пароль для доступа в АСУ Заказчик выбирает при регистрации самостоятельно.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.2.</td>
		<td align="justify" width="95%">Все сведения, предоставляемые Заказчиком при регистрации и заключении Договора, должны быть достоверными. Исполнитель не несет ответственность за убытки любого рода, возникшие в результате предоставления клиентом недостоверной информации.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.3.</td>
		<td align="justify" width="95%">Исполнитель хранит данные, указанные Заказчиком при регистрации в информационной базе АСУ и использует их для выполнения своих обязательств по оказанию услуг, определенных настоящим Договором, направления оповещений о технических работах, изменениях в настоящем Договоре и/или Приложениях к нему.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.4.</td>
		<td align="justify" width="95%">Заказчик несет ответственность за все действия, произведённые со своего аккаунта.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.5.</td>
		<td align="justify" width="95%">В случае предоставления Заказчиком третьим лицам доступа к каким-либо ресурсам Заказчика, ответственность за действия таких третьих лиц несет исключительно Заказчик.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.6.</td>
		<td align="justify" width="95%">Заказчик несет ответственность за сохранность своих учетных данных и за убытки или иной ущерб, которые могут возникнуть по причине несанкционированного использования учетных данных. По факту утери или несанкционированного доступа к учетным данным или возможности возникновения такой ситуации, Заказчик обязан незамедлительно направить запрос Исполнителю посредством АСУ или по другим каналам связи на изменение учетных данных.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">3.7.</td>
		<td align="justify" width="95%">При изменении данных, указанных при регистрации или иных данных сообщенных Заказчиком посредством АСУ, Заказчик, так же при помощи АСУ, обязан уведомить Исполнителя в срок не более 7 (семи) дней с момента изменения.</td>
	</tr>
</tbody>
</table>

<h2>4. Порядок обработки заявок СТП</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.1.</td>
		<td align="justify" width="95%">СТП обеспечивает предоставление надлежащего сервиса Заказчику в пределах, обусловленных Договором, а также осуществляет обработку запросов Заказчика.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.2.</td>
		<td align="justify" width="95%">Основанием для выполнения работ является заявка Заказчика. Заявка направляется через форму для отправления заявки в АСУ, либо по электронной почте на адрес %Executor.Email%.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.3.</td>
		<td align="justify" width="95%">Заявка должна иметь все необходимые реквизиты для точной идентификации Заказчика, а так же должны быть точно и ясно сформулированы задачи, требующие исполнения.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.4.</td>
		<td align="justify" width="95%">Каждая заявка имеет приоритет исполнения. Заказчик выставляет приоритет заявке по следующему правилу:<br />
Высокий - используется только в случаях невозможности использования услуг Исполнителя.<br />
Средний - проблемы технического характера, которые Заказчик не может устранить самостоятельно.<br />
Низкий - вопросы, просьбы, предложения Заказчика, а также все остальное, что не вошло в другие приоритеты.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.5.</td>
		<td align="justify" width="95%">Все заявки по электронной почте должны отправляться в одной из кодировок WINDOWS-1251, KOI8-R, UTF-8, в области символов ранее означенных кодировок в формате, определенным RFC-822.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.6.</td>
		<td align="justify" width="95%">Все заявки обрабатываются в порядке поступления. Максимальный срок обработки заявки СПТ - 12 часов.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.7.</td>
		<td align="justify" width="95%">Вне очереди обрабатываются заявки с приоритетом "Высокий".</td>
	</tr>
</tbody>
</table>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.8.</td>
		<td align="justify" width="95%">Заявки по другим каналам (в частности, Telegram, Jabber, SMS) не обрабатываются.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.9.</td>
		<td align="justify" width="95%">СТП не обязана осуществлять консультирование по вопросам не касающихся предоставления услуг Исполнителя. Подобные консультации могут предоставляться по дополнительной договоренности.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.10.</td>
		<td align="justify" width="95%">Ответы на стандартные, часто задаваемые вопросы, могут выдаваться в виде ссылок на соответствующую страницу инструкций на WEB-сервере Исполнителя %Executor.SiteURL% или на соответствующие страницы сайтов поддержки сервиса, сайты разработчиков программного обеспечения.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.11.</td>
		<td align="justify" width="95%">В выполнении заявки может быть отказано по следующим основным причинам:<br />
отсутствие авторизационной информации, в случае если авторизация была необходимой;<br />
требование предоставления услуг, не соответствующих условиям договора;<br />
в случае блокирования предоставления услуг;<br />
использования клиентом ненормативной лексики, хамстве;<br />
попытках принижения человеческого достоинства;<br />
намеренном затягивании диалога с поддержкой;<br />
</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.12.</td>
		<td align="justify" width="95%">При обработке заявки, посланной по электронной почте, Исполнитель не несет ответственности за работоспособность почтовых сервисов третьих лиц.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">4.13.</td>
		<td align="justify" width="95%">В случае претензий по выполнению заявок Заказчик может обратиться с жалобами к руководству Исполнителя по электронной почте %Executor.Email%. В жалобе необходимо указывать номер(а) запроса(ов) обращений в СТП, по которым возникли претензии. Ответ на претензии отправляется руководством Исполнителя Заказчику не позднее чем через два рабочих дня после подачи претензии.</td>
	</tr>
</tbody>
</table>

<h2>5. Обязанности сторон</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">5.1.</td>
		<td align="justify" width="95%">Исполнитель обязуется:
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.1.</td>
					<td align="justify" width="95%">Предоставить услуги Заказчику в соответствии с условиями и требованиями, изложенными в настоящем Договоре, а так же приложениями к нему.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.2.</td>
					<td align="justify" width="95%">Осуществлять техническую поддержку услуг предоставленных Заказчику.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.3.</td>
					<td align="justify" width="95%">Публиковать сообщения, связанные с внесением Исполнителем изменений в настоящий Договор и приложений к нему в новостном блоке на WEB-сервере Исполнителя %Executor.SiteURL%, а так же по одному из каналов связи не менее чем за 7 (семь) календарных дней до их введения.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.4.</td>
					<td align="justify" width="95%">Вести учет потребления и оплаты услуг Заказчика посредством АСУ.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.5.</td>
					<td align="justify" width="95%">Сохранять конфиденциальность информации сообщенной Заказчиком посредством АСУ, а так же любой другой информации Заказчика относящийся к предоставлению услуг, за исключением случаев, предусмотренных действующим законодательством Российской Федерации.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.1.6.</td>
					<td align="justify" width="95%">Своевременно уведомлять Заказчика по одному из каналов связи о произведенных действиях в АСУ, а так же об истечении срока действия предоставляемых услуг по настоящему Договору.</td>
				</tr>
			</tbody>
			</table>
		</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">5.2.</td>
		<td align="justify" width="95%">Заказчик обязуется:
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.2.1.</td>
					<td align="justify" width="95%">Принять услуги Исполнителя в соответствии с условиями и требованиями, изложенными в настоящем Договоре, а так же приложений к нему.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.2.2.</td>
					<td align="justify" width="95%">Своевременно оплачивать услуги Исполнителя согласно условиям настоящего Договора и ценам указанных в приложениях к Договору.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.2.3.</td>
					<td align="justify" width="95%">Сообщить Исполнителю при регистрации в АСУ полную и достоверную информацию путем заполнения профиля.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.2.4.</td>
					<td align="justify" width="95%">При получении Заказчиком от Исполнителя документов в двух экземплярах, Заказчик обязуется один экземпляр с подписью и печатью отправить обратно Исполнителю в срок не превышающий 14 (четырнадцати) календарных дней.</td>
				</tr>
			</tbody>
			</table>
			<table style="width: 100%;">
			<tbody>
				<tr>
					<td valign="top">5.2.5.</td>
					<td align="justify" width="95%">Незамедлительно уведомить Исполнителя в случае хищения или утери пароля авторизующего Заказчика в АСУ.</td>
				</tr>
			</tbody>
			</table>
		</td>
	</tr>
</tbody>
</table>

<h2>6. Стоимость услуг и порядок оплаты</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.1.</td>
		<td align="justify" width="95%">Стоимость услуг указана на WEB-сервере Исполнителя %Executor.SiteURL%.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.2.</td>
		<td align="justify" width="95%">Оплата услуг Исполнителя производится Заказчиком путем авансовых платежей в течение 10 (десяти) банковских дней со дня выставления счета Исполнителем. Запрос на формирование счета осуществляется Заказчиком посредством АСУ.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.3.</td>
		<td align="justify" width="95%">Платежи осуществляются безналичным расчетом путем перечисления денежных средств на расчетный счет Исполнителя.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.4.</td>
		<td align="justify" width="95%">Факт оплаты счета считается подтвержденным при поступлении сведений из банка о зачислении денежных средств на расчетный счет Исполнителя.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.5.</td>
		<td align="justify" width="95%">Заказчик несет ответственность за правильность и своевременность осуществления платежей за услуги, предоставляемые Исполнителем по настоящему Договору.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.6.</td>
		<td align="justify" width="95%">При изменении банковских реквизитов Исполнителя, с момента оповещения Заказчика по одному из каналов связи и опубликования новых реквизитов посредством WEB-сервера Исполнителя %Executor.SiteURL% в разделе "Реквизиты" Заказчик несет ответственность за платежи, произведенные по устаревшим реквизитам.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.7.</td>
		<td align="justify" width="95%">При несвоевременной оплате услуг Исполнитель автоматически приостанавливает предоставление услуг Заказчику с немедленным уведомлением об этом Заказчика по одному из каналов связи. В течение 10 (десяти) дней после образования нулевого баланса на лицевом счету Заказчика, лицевой счет и информация Заказчика сохраняются. По истечении этого срока вся информация Заказчика удаляется.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.8.</td>
		<td align="justify" width="95%">В случае положительного баланса лицевого счета заказчика в АСУ и при условии отсутствия у Заказчика активных заказов и не использовании услуг Исполнителя в течение 3 (трех) и более календарных месяцев, Исполнитель вправе списать остаток средств с баланса лицевого счета Заказчика в счет предоставления последнему доступа в АСУ и хранения его информации в информационной базе АСУ.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.9.</td>
		<td align="justify" width="95%">Исполнитель высылает оригиналы бухгалтерских документов Заказчику одним из следующих способов: через электронный документооборот, по почтовому адресу, указанному Заказчиком посредством АСУ, или вручает сотруднику заказчика в офисе Исполнителя.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.10.</td>
		<td align="justify" width="95%">Заказчик может следить за состоянием обработки Исполнителем документов посредством АСУ.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.11.</td>
		<td align="justify" width="95%">Факт оказания услуг по Договору подтверждается Актом оказания услуг. Акт в двух экземплярах изготавливается Исполнителем и направляется заказным письмом Заказчику.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.12.</td>
		<td align="justify" width="95%">По окончании предоставления Исполнителем услуг Заказчику, Заказчик высылает обратно Исполнителю один экземпляр Акта (согласно пункту 5.2.4 настоящего Договора). Если Заказчик нарушил условия пункта 5.2.4 настоящего Договора, то услуги, предоставляемые Исполнителем, считаются оказанными в полном объеме, а стороны не имеют взаимных претензий. Юридическим лицам Акт выполненных работ отправляется в обязательном порядке, физическим лицам - по запросу самого лица.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.13</td>
		<td align="justify" width="95%"> Исполнитель в праве в одностороннем порядке изменять стоимость и параметры предоставляемых услуг, о чем обязан извещать Заказчика не позднее, чем за 7 (семь) календарных дней до вступления изменений в силу с помощью публикации указанных изменений в блоке тарифов на своем WEB-сервере.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.14</td>
		<td align="justify" width="95%">Для всех заказываемых услуг включено автоматическое продление. Отключение автопродления производится клиентом самостоятельно, через меню услуги.</td>
	</tr>
	<tr>
		<td></td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.15</td>
		<td align="justify" width="95%">Предоставляемые скидки и бонусы на услуги (по периоду оплаты, акциям и т.п.) не суммируются. При оплате учитывается наибольшая скидка.</td>
	</tr>
	<tr>
		<td></td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">6.16</td>
		<td align="justify" width="95%">В случае восстановления удалённого заказа из резервной копии, при возврате денежных средств, удерживается сумма эквивалентная стоимости четырёх месяцев по тарифу Заказчика, но не менее 250 рублей</td>
	</tr>
</tbody>
</table>


<h2>7. Ответственность сторон</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.1.</td>
		<td align="justify" width="95%">Исполнитель не несет ответственности перед Заказчиком или третьими сторонами за любые задержки, прерывания, ущерб или потери, происходящие из-за:<br />
а) дефектов в любом электронном или механическом оборудовании, не принадлежащем Исполнителю;<br />
б) проблем при передаче данных или соединении, произошедших не по вине Исполнителя;<br />
в) нарушений в работе оборудования, принадлежащего Исполнителю, которые Исполнитель устранил в течение 72 часов;<br />
г) вследствие обстоятельств непреодолимой силы в общепринятом смысле.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.2.</td>
		<td align="justify" width="95%">Исполнитель не несет ответственности перед Заказчиком за задержки, перебои в работе и невозможность полноценного использования услуг Исполнителя, происходящие прямо или косвенно по причине действия или бездействия третьих лиц и/или неработоспособности транспортно-информационных каналов, находящихся за пределами собственных ресурсов.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.3.</td>
		<td align="justify" width="95%">Исполнитель не несет ответственности в случае обращения к нему клиента Заказчика, если последний в течение 7 дней по инициативе своего клиента не отвечает на его электронные, телефонные, а также письменные запросы.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.4.</td>
		<td align="justify" width="95%">При перерывах в оказании услуг по вине Исполнителя, Заказчик имеет право на компенсацию в виде предоставления пользования услугой в двукратном размере относительно времени перерыва предоставления услуги.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.5.</td>
		<td align="justify" width="95%">Заказчик согласен с тем, что размер ответственности Исполнителя ограничен исключительно п. 7.4 настоящего Договора и никакие другие убытки Заказчику Исполнителем не возмещаются.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.6.</td>
		<td align="justify" width="95%">Исполнитель имеет право прекратить предоставление Заказчику Услуг и в одностороннем порядке расторгнуть настоящий Договор в случае, если Заказчик нарушил любой пункт Договора или приложений к нему.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.7.</td>
		<td align="justify" width="95%">Любая другая ответственность сторон, не предусмотренная настоящим Договором и Приложениями, определяется в соответствие с действующим законодательством Российской Федерации.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.8.</td>
		<td align="justify" width="95%">Исполнитель может приостанавливать предоставление Услуг на время, необходимое для проведения регламентных работ на оборудовании, предварительно уведомляя об этом Заказчика, не менее чем за сутки до начала проведения работ на оборудовании. Суммарное время недоступности серверов, связанное с регламентными работами, не должно превышать 10 (десять) часов в месяц.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">7.9.</td>
		<td align="justify" width="95%"> Исполнитель не несет ответственности за информацию находящуюся на аккаунте Заказчика.</td>
	</tr>
</tbody>
</table>

<h2>8. Момент заключения Договора. Срок действия договора. Порядок изменения и расторжения.</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.1.</td>
		<td align="justify" width="95%">Настоящий Договор вступает в силу с момента: <br />
а) подписания Договора обеими Сторонами, по дате последней подписи;<br />
б) поступления предварительной оплаты за услуги, что будет являться акцептом настоящей оферты.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.2.</td>
		<td align="justify" width="95%">Договор действует до конца календарного года. В случае, если в течение 14 (четырнадцати) календарных дней до окончания календарного года ни одна из сторон в письменном виде не заявит о своем желании прекратить действие настоящего Договора, настоящий Договор автоматически продлевается на последующий календарный год.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.3.</td>
		<td align="justify" width="95%">Исполнитель вправе в одностороннем порядке вносить изменения в договор и в приложения к настоящему Договору, уведомив Заказчика о произведенных изменениях не позднее, чем за 7 (семь) календарных дней до вступления изменений в силу с помощью публикации указанных изменений на своем WEB-сервере %Executor.SiteURL%.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.4.</td>
		<td align="justify" width="95%">Изменения вступают в силу не менее чем через 14 (четырнадцать) календарных дней с момента оповещения и опубликования.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.5.</td>
		<td align="justify" width="95%">В случае согласия заказчика с такими изменениями, настоящий Договор продолжает свое действие с учетом указанных изменений.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.6.</td>
		<td align="justify" width="95%">В случае несогласия с такими изменениями, Заказчик обязуется оповестить об этом Исполнителя не позднее 7 (семи) календарных дней до предполагаемого момента расторжения Договора официальным письмом с уведомлением о вручении.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.7.</td>
		<td align="justify" width="95%">В случае получения Исполнителем официального письма после вступления в силу изменений, Договор прекращает свое действие от даты получения уведомления. Услуги, полученные Заказчиком со дня введения в действие изменений до даты получения уведомления включительно, оказываются заказчику с учетом введенных изменений.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.8.</td>
		<td align="justify" width="95%">Настоящий Договор может быть прекращен по инициативе любой из Сторон, при несостоятельности (банкротстве) любой из Сторон.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.9.</td>
		<td align="justify" width="95%">При нарушении одной из Сторон условий настоящего Договора, другая Сторона имеет право на одностороннее расторжение Договора, о чем письменно уведомляет Сторону, нарушившую условия Договора, не позднее, чем за 14 (четырнадцать) календарных дней до его расторжения.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.10.</td>
		<td align="justify" width="95%">Настоящий Договор может быть расторгнут по инициативе Заказчика, при отсутствии его нарушений по настоящему Договору, по истечении оплаченного периода путем отказа от предоплаты услуг за следующий период или на основании уведомления, изложенного в письменной форме. В этом случае, неиспользованный остаток денежных средств Заказчика возвращается по письменному заявлению, а задолженность Заказчика по оплате услуг компенсируется Заказчиком. Возврат средств Заказчику производится только в безналичном порядке. Перечисление возвращаемых средств третьему лицу по просьбе Заказчика не производится.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">8.11.</td>
		<td align="justify" width="95%">Договор может быть расторгнут в любое время по соглашению Сторон.</td>
	</tr>
</tbody>
</table>

<h2>9. Порядок рассмотрения претензий и разрешение споров</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">9.1.</td>
		<td align="justify" width="95%">Стороны будут регулировать путем переговоров любые спорные вопросы, разногласия или претензии, которые могут возникнуть в отношении настоящего Договора или в связи с ним.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">9.2.</td>
		<td align="justify" width="95%">В случае, если стороны не достигнут Договоренности по спорным вопросам путем переговоров, они подлежат разрешению в Арбитражном суде.</td>
	</tr>
</tbody>
</table>

<h2>10. Форс-мажор</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">10.1.</td>
		<td align="justify" width="95%">Стороны освобождаются от ответственности за частичное или полное неисполнение обязательств по настоящему Договору при возникновении форс-мажорных обстоятельств, исключающих или объективно препятствующих исполнению данного Договора, Стороны не имеют взаимных претензий, и каждая из Сторон принимает на себя свой риск последствий этих обстоятельств. Факт наступления и окончания действия форс-мажорных обстоятельств подтверждается документально.</td>
	</tr>
</tbody>
</table>

<h2>11. Прочие условия</h2>

<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">11.1.</td>
		<td align="justify" width="95%">Настоящий Договор составлен в двух экземплярах, каждый из которых обладает одинаковой юридической силой.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">11.2.</td>
		<td align="justify" width="95%">Стороны обязуются не передавать третьим лицам информацию, полученную в процессе выполнения условий настоящего Договора, без согласия обеих сторон. За исключением официальных запросов правоохранительных органов.</td>
	</tr>
</tbody>
</table>
<table style="width: 100%;">
<tbody>
	<tr>
		<td valign="top">11.3.</td>
		<td align="justify" width="95%">Во всех случаях, не оговоренных и не предусмотренных в настоящем Договоре и/или Приложениях к настоящему Договору, стороны должны руководствоваться действующим законодательством Российской Федерации.</td>
	</tr>
</tbody>
</table>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Content','Базовый договор',@Text);

-- SEPARATOR
-- Шаблоны договора индивидуального предпринимателя

set @Text = '<P align="justify">Индивидуальный предприниматель "%Executor.CompanyName%", именуемый(ая) в дальнейшем "Исполнитель", действующий(ая) на основании Свидетельства серия %Executor.SvLine% №%Executor.SvNumber% от %Executor.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с одной стороны, и Индивидуальный предприниматель "%Customer.CompanyName%", именуемый(ая) в дальнейшем "Заказчик", действующий(ая) на основании Свидетельства серия %Customer.SvLine% №%Customer.SvNumber% от %Customer.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Individual/Agreement/Individual','Соглашение исполнителя индивидуального предпринимателя с индивидуальным предпринимателем',@Text);

-- SEPARATOR

set @Text = '<P align="justify">%Executor.dPost% %Executor.dSourname% %Executor.dName% %Executor.dLastname% от имени %Executor.CompanyForm% "%Executor.CompanyName%", именуемое в дальнейшем "Исполнитель", действующий(ая) на основании %Executor.Basis% с одной стороны, и Индивидуальный предприниматель "%Customer.CompanyName%", именуемый(ая) в дальнейшем "Заказчик", действующий(ая) на основании Свидетельства серия %Customer.SvLine% №%Customer.SvNumber% от %Customer.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4, 100,100,'yes','yes','yes','Contracts/Types/Individual/Agreement/Juridical','Соглашение исполнителя юридического лица с индивидуальным предпринимателем',@Text);

-- SEPARATOR

set @Text = '<FONT size="1">
 <TABLE border="1" width="100%" cellpadding="5">
  <TR>
   <TD>Полное название организации</TD>
   <TD>Индивидуальный предприниматель "%Customer.CompanyName%"</TD>
  </TR>
  <TR>
   <TD>ИНН | КПП</TD>
   <TD>%Customer.Inn% | %Customer.Kpp%</TD>
  </TR>
  <TR>
   <TD>Юридический адрес</TD>
   <TD>%Customer.jIndex%, %Customer.jCountry%, %Customer.jCity%, %Customer.jType% %Customer.jAddress%</TD>
  </TR>
  <TR>
   <TD>Почтовый адрес</TD>
   <TD>%Customer.pIndex%, %Customer.pCountry%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>Телефон</TD>
   <TD>%Customer.Phone%</TD>
  </TR>
  <TR>
   <TD>Электронный адрес</TD>
   <TD>%Customer.Email%</TD>
  </TR>
  <TR>
   <TD>Наименование банка</TD>
   <TD>%Customer.BankName%</TD>
  </TR>
  <TR>
   <TD>Расчетный счет</TD>
   <TD>%Customer.BankAccount%</TD>
  </TR>
  <TR>
   <TD>БИК</TD>
   <TD>%Customer.Bik%</TD>
  </TR>
  <TR>
   <TD>Корреспондентский счет</TD>
   <TD>%Customer.Kor%</TD>
  </TR>
 </TABLE>
</FONT>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Individual/Customer','Реквизиты клиента индивидуального предпринимателя',@Text);

-- SEPARATOR

set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>%Executor.dPost% %Executor.CompanyForm% "%Executor.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>ИП "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Customer.dSourname% %Customer.dName% %Customer.dLastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Individual/Footer/Juridical','Подпись исполнителя индивидуального предпринимателя с юридическим лицом',@Text);

-- SEPARATOR

set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>ИП "%Executor.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV id="SignDate">-</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>ИП "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Customer.dSourname% %Customer.dName% %Customer.dLastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Individual/Footer/Individual','Подпись исполнителя индивидульного предпринимателя лица с индивидуальным предпринимателем',@Text);

-- SEPARATOR
-- Шаблоны договора юридического лица
set @Text = '<P align="justify">Индивидуальный предприниматель "%Executor.CompanyName%", именуемый(ая) в дальнейшем "Исполнитель", действующий(ая) на основании Свидетельства серия %Executor.SvLine% №%Executor.SvNumber% от %Executor.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с одной стороны, и %Customer.dPost% %Customer.dSourname% %Customer.dName% %Customer.dLastname% %Customer.CompanyForm% "%Customer.CompanyName%", именуемое в дальнейшем "Заказчик", действующий(ая) на основании %Customer.Basis%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`) 
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Agreement/Individual','Соглашение исполнителя индивидуального предпринимателя с юридическим лицом',@Text);

-- SEPARATOR
set @Text = '<P align="justify">%Executor.dPost% %Executor.dSourname% %Executor.dName% %Executor.dLastname% от имени %Executor.CompanyForm% "%Executor.CompanyName%", именуемое в дальнейшем "Исполнитель", действующий(ая) на основании %Executor.Basis%, с одной стороны, и %Customer.dPost% %Customer.dSourname% %Customer.dName% %Customer.dLastname% от имени %Customer.CompanyForm% "%Customer.CompanyName%", именуемое в дальнейшем "Заказчик", действующий(ая) на основании %Customer.Basis%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Agreement/Juridical','Соглашение исполнителя юридического лица с юридическим лицом',@Text);

-- SEPARATOR
set @Text = '<FONT size="1">
 <TABLE border="1" width="100%" cellpadding="5">
  <TR>
   <TD>Полное название организации</TD>
   <TD>%Customer.CompanyForm% "%Customer.CompanyName%"</TD>
  </TR>
  <TR>
   <TD>ИНН | КПП</TD>
   <TD>%Customer.Inn% | %Customer.Kpp%</TD>
  </TR>
  <TR>
   <TD>Юридический адрес</TD>
   <TD>%Customer.jIndex%, %Customer.jCountry%, %Customer.jCity%, %Customer.jType% %Customer.jAddress%</TD>
  </TR>
  <TR>
   <TD>Почтовый адрес</TD>
   <TD>%Customer.pIndex%, %Customer.pCountry%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>Телефон</TD>
   <TD>%Customer.Phone%</TD>
  </TR>
  <TR>
   <TD>Электронный адрес</TD>
   <TD>%Customer.Email%</TD>
  </TR>
  <TR>
   <TD>Наименование банка</TD>
   <TD>%Customer.BankName%</TD>
  </TR>
  <TR>
   <TD>Расчетный счет</TD>
   <TD>%Customer.BankAccount%</TD>
  </TR>
  <TR>
   <TD>БИК</TD>
   <TD>%Customer.Bik%</TD>
  </TR>
  <TR>
   <TD>Корреспондентский счет</TD>
   <TD>%Customer.Kor%</TD>
  </TR>
 </TABLE>
</FONT>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Customer','Реквизиты клиента юридического лица',@Text);


-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>ИП %Executor.CompanyName%</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>%Customer.dPost% %Customer.CompanyForm% "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Customer.dSourname% %Customer.dName% %Customer.dLastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Footer/Individual','Подпись исполнителя индивидуального предпринимателя с юридическим лицом',@Text);

-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>%Executor.dPost% %Executor.CompanyForm% "%Executor.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>%Customer.dPost% %Customer.CompanyForm% "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Customer.dSourname% %Customer.dName% %Customer.dLastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Juridical/Footer/Juridical','Подпись исполнителя юридического лица с юридическим лицом',@Text);

-- SEPARATOR
-- Шаблоны договора физического лица
set @Text = '<P align="justify">Индивидуальный предприниматель "%Executor.CompanyName%", именуемый(ая) в дальнейшем "Исполнитель", действующий(ая) на основании Свидетельства серия %Executor.SvLine% №%Executor.SvNumber% от %Executor.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с одной стороны, и %Customer.Sourname% %Customer.Name% %Customer.Lastname%, именуемый(ая) в дальнейшем "Заказчик", паспорт %Customer.PasportLine% %Customer.PasportNum%, выданный %Customer.PasportWhom%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (3,100,100,'yes','yes','yes','Contracts/Types/Natural/Agreement/Individual','Соглашение исполнителя индивидуального предпринимателя с физическим лицом',@Text);


-- SEPARATOR
set @Text = '<P align="justify">%Executor.dPost% %Executor.dSourname% %Executor.dName% %Executor.dLastname% от имени %Executor.CompanyForm% "%Executor.CompanyName%", именуемое в дальнейшем "Исполнитель", действующий(ая) на основании %Executor.Basis%, с одной стороны, и %Customer.Sourname% %Customer.Name% %Customer.Lastname%, именуемый(ая) в дальнейшем "Заказчик", паспорт %Customer.PasportLine% %Customer.PasportNum%, выданный %Customer.PasportWhom%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (3,100,100,'yes','yes','yes','Contracts/Types/Natural/Agreement/Juridical','Соглашение исполнителя юридического лица с физическим лицом',@Text);

-- SEPARATOR
set @Text = '<FONT size="1">
 <TABLE border="1" width="100%" cellpadding="5">
  <TR>
   <TD>Фамилия Имя Отчество</TD>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD>Паспортные данные</TD>
   <TD>%Customer.PasportLine% %Customer.PasportNum% %Customer.PasportWhom%</TD>
  </TR>
  <TR>
   <TD>Почтовый адрес</TD>
   <TD>%Customer.pIndex% %Customer.pCountry% %Customer.pCity% %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>Телефон</TD>
   <TD>%Customer.Phone%</TD>
  </TR>
  <TR>
   <TD>Электронный адрес</TD>
   <TD>%Customer.Email%</TD>
  </TR>
 </TABLE>
</FONT>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Natural/Customer','Реквизиты клиента физического лица',@Text);


-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>ИП %Executor.CompanyName%</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>-</TD>
    </TR>
    <TR>
     <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Natural/Footer/Individual','Подпись исполнителя индивидуального предпринимателя с физическим лицом',@Text);


-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>%Executor.dPost% %Executor.CompanyForm% "%Executor.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>-</TD>
    </TR>
    <TR>
     <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/Natural/Footer/Juridical','Подпись исполнителя юридического лица с физическим лицом',@Text);

-- SEPARATOR
-- Шаблоны конвертов

set @Text = '<TABLE border="0" width="100%">
 <TR>
  <TD>
   <TABLE border="0" width="100%">
    <TR>
     <TD valign="top">Кому:</TD>
     <TD>%Customer.pRecipient%</TD>
    </TR>
    <TR>
     <TD valign="top">Куда:</TD>
     <TD>
      <SPAN>%Customer.pCity%,</SPAN>
      <BR />
      <SPAN>%Customer.pType% %Customer.pAddress%</SPAN>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
 <TR>
  <TD>
   <FONT size="1">Индекс места назначения</FONT>
   <BR />
   <FONT size="5">%Customer.pIndex%</FONT>
  </TD>
 </TR>
 <TR>
  <TD colspan="2">
   <HR />
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Envelope','Конверт получателя профиля почтового конверта',@Text);

-- SEPARATOR
set @Text = '<TABLE border="0" width="100%">
 <TR>
  <TD>
   <TABLE border="0" width="100%">
    <TR>
     <TD valign="top">Кому:</TD>
     <TD>ИП "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD valign="top">Куда:</TD>
     <TD>
      <SPAN>%Customer.pCity%,</SPAN>
      <BR />
      <SPAN>%Customer.pType% %Customer.pAddress%</SPAN>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
 <TR>
  <TD>
   <FONT size="1">Индекс места назначения</FONT>
   <BR />
   <FONT size="5">%Customer.pIndex%</FONT>
  </TD>
 </TR>
 <TR>
  <TD colspan="2">
   <HR />
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Individual','Конверт получателя профиля индивидуального предпринимателя',@Text);

-- SEPARATOR
set @Text = '<TABLE border="0" width="100%">
 <TR>
  <TD>
   <TABLE border="0" width="100%">
    <TR>
     <TD valign="top">Кому:</TD>
     <TD>%Customer.CompanyForm% "%Customer.CompanyName%"</TD>
    </TR>
    <TR>
     <TD valign="top">Куда:</TD>
     <TD>
      <SPAN>%Customer.pCity%,</SPAN>
      <BR />
      <SPAN>%Customer.pType% %Customer.pAddress%</SPAN>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
 <TR>
  <TD>
   <FONT size="1">Индекс места назначения</FONT>
   <BR />
   <FONT size="5">%Customer.pIndex%</FONT>
  </TD>
 </TR>
 <TR>
  <TD colspan="2">
   <HR />
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Juridical','Конверт получателя профиля юридического лица',@Text);

-- SEPARATOR
set @Text = '<TABLE border="0" width="100%">
 <TR>
  <TD>
   <TABLE border="0" width="100%">
    <TR>
     <TD valign="top">Кому:</TD>
     <TD>%Customer.pRecipient%</TD>
    </TR>
    <TR>
     <TD valign="top">Куда:</TD>
     <TD>
      <SPAN>%Customer.pCity%,</SPAN>
      <BR />
      <SPAN>%Customer.pType% %Customer.pAddress%</SPAN>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
 <TR>
  <TD>
   <FONT size="1">Индекс места назначения</FONT>
   <BR />
   <FONT size="5">%Customer.pIndex%</FONT>
  </TD>
 </TR>
 <TR>
  <TD colspan="2">
   <HR />
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Natural','Конверт получателя профиля физического лица',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <TABLE border="0" height="100%" width="100%">
  <TR>
   <TD height="100%">
    <TABLE align="right" width="980" border="0">
     <TR>
      <TD height="350" valign="top">
       <TABLE border="0" width="50%">
        <TR>
         <TD>
          <TABLE border="0" width="100%">
           <TR>
            <TD colspan="2">
             <HR />
            </TD>
           </TR>
           <TR>
            <TD valign="top">От:</TD>
            <TD>
             <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%"</SPAN>
             <BR />
             <FONT size="1">(бухгалтерия)</FONT>
            </TD>
           </TR>
           <TR>
            <TD valign="top">Откуда:</TD>
            <TD>
             <SPAN>%Executor.pCity%,</SPAN>
             <BR />
             <SPAN>%Executor.pType% %Executor.pAddress%</SPAN>
            </TD>
           </TR>
          </TABLE>
         </TD>
        </TR>
        <TR>
         <TD align="right">
          <FONT size="1">Индекс места отправления</FONT>
          <BR />
          <FONT size="5">%Executor.pIndex%</FONT>
         </TD>
        </TR>
       </TABLE>
      </TD>
     </TR>
     <TR>
      <TD valign="bottom" height="350">
       <TABLE width="100%" border="0">
        <TR>
         <TD width="50%" valign="bottom">
          <IMG id="pIndexImage" width="300" height="90" src="/styles/billing/Images/pIndexImage.png" />
         </TD>
         <TD id="Recipient" width="50%">[получатель]</TD>
        </TR>
       </TABLE>
      </TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Juridical/Template','Шаблон конверта исполнителя юридического лица',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <TABLE border="0" height="100%" width="100%">
  <TR>
   <TD height="100%">
    <TABLE align="right" width="980" border="0">
     <TR>
      <TD height="350" valign="top">
       <TABLE border="0" width="50%">
        <TR>
         <TD>
          <TABLE border="0" width="100%">
           <TR>
            <TD colspan="2">
             <HR />
            </TD>
           </TR>
           <TR>
            <TD valign="top">От:</TD>
            <TD>
             <SPAN>ИП "%Executor.CompanyName%"</SPAN>
             <BR />
             <FONT size="1">(бухгалтерия)</FONT>
            </TD>
           </TR>
           <TR>
            <TD valign="top">Откуда:</TD>
            <TD>
             <SPAN>%Executor.pCity%,</SPAN>
             <BR />
             <SPAN>%Executor.pType% %Executor.pAddress%</SPAN>
            </TD>
           </TR>
          </TABLE>
         </TD>
        </TR>
        <TR>
         <TD align="right">
          <FONT size="1">Индекс места отправления</FONT>
          <BR />
          <FONT size="5">%Executor.pIndex%</FONT>
         </TD>
        </TR>
       </TABLE>
      </TD>
     </TR>
     <TR>
      <TD valign="bottom" height="350">
       <TABLE width="100%" border="0">
        <TR>
         <TD width="50%" valign="bottom">
          <IMG id="pIndexImage" width="300" height="90" src="/styles/billing/Images/pIndexImage.png" />
         </TD>
         <TD id="Recipient" width="50%">[получатель]</TD>
        </TR>
       </TABLE>
      </TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (5,100,100,'yes','yes','yes','Envelopes/Individual/Template','Шаблон конверта исполнителя индивидуального предпринимателя',@Text);

-- SEPARATOR
-- added by lissyara 2011-08-23 in 11:03 MSK for partner profile
set @Text = '<P align="justify">Индивидуальный предприниматель "%Executor.CompanyName%", именуемый(ая) в дальнейшем "Исполнитель", действующий(ая) на основании Свидетельства серия %Executor.SvLine% №%Executor.SvNumber% от %Executor.SvDate%, выданного Инспекцией Министерства Российской федерации по налогам и сборам, с одной стороны, и %Customer.Sourname% %Customer.Name% %Customer.Lastname%, именуемый(ая) в дальнейшем "Заказчик", паспорт %Customer.PasportLine% %Customer.PasportNum%, выданный %Customer.PasportWhom%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (3,100,100,'yes','yes','yes','Contracts/Types/NaturalPartner/Agreement/Individual','Соглашение исполнителя индивидуального предпринимателя с физическим лицом',@Text);

-- SEPARATOR
set @Text = '<P align="justify">%Executor.dPost% %Executor.dSourname% %Executor.dName% %Executor.dLastname% от имени %Executor.CompanyForm% "%Executor.CompanyName%", именуемое в дальнейшем "Исполнитель", действующий(ая) на основании %Executor.Basis%, с одной стороны, и %Customer.Sourname% %Customer.Name% %Customer.Lastname%, именуемый(ая) в дальнейшем "Заказчик", паспорт %Customer.PasportLine% %Customer.PasportNum%, выданный %Customer.PasportWhom%, с другой стороны, именуемые совместно в дальнейшем Стороны, заключили Договор о нижеследующем:</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (3,100,100,'yes','yes','yes','Contracts/Types/NaturalPartner/Agreement/Juridical','Соглашение исполнителя юридического лица с физическим лицом',@Text);

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (3,100,100,'yes','yes','yes','Contracts/Types/Natural/Agreement/Juridical','Соглашение исполнителя юридического лица с физическим лицом',@Text);

-- SEPARATOR
set @Text = '<FONT size="1">
 <TABLE border="1" width="100%" cellpadding="5">
  <TR>
   <TD>Фамилия Имя Отчество</TD>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD>Паспортные данные</TD>
   <TD>%Customer.PasportLine% %Customer.PasportNum% %Customer.PasportWhom%</TD>
  </TR>
  <TR>
   <TD>Почтовый адрес</TD>
   <TD>%Customer.pIndex% %Customer.pCountry% %Customer.pCity% %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>Телефон</TD>
   <TD>%Customer.Phone%</TD>
  </TR>
  <TR>
   <TD>Электронный адрес</TD>
   <TD>%Customer.Email%</TD>
  </TR>
 </TABLE>
</FONT>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/NaturalPartner/Customer','Реквизиты клиента физического лица',@Text);


-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>%Executor.dPost% %Executor.CompanyForm% "%Executor.CompanyName%"</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>-</TD>
    </TR>
    <TR>
     <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses`
  (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES
(4,100,100,'yes','yes','yes','Contracts/Types/NaturalPartner/Footer/Juridical','Подпись исполнителя юридического лица с физическим лицом',@Text);

-- SEPARATOR
set @Text = '<TABLE width="100%">
 <TR>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Исполнителя:</TD>
    </TR>
    <TR>
     <TD>ИП %Executor.CompanyName%</TD>
    </TR>
    <TR>
     <TD>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</TD>
    </TR>
    <TR>
     <TD id="Sign">
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD id="Stamp">
      <DIV>%SignDate%</DIV>
      <SUP>[место печати]</SUP>
     </TD>
    </TR>
   </TABLE>
  </TD>
  <TD width="50%" valign="top">
   <TABLE cellpadding="5">
    <TR>
     <TD>От имени Заказчика:</TD>
    </TR>
    <TR>
     <TD>-</TD>
    </TR>
    <TR>
     <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
    </TR>
    <TR>
     <TD>
      <BR />
      <DIV>__________________</DIV>
      <SUP>[Подпись]</SUP>
     </TD>
    </TR>
    <TR>
     <TD>
      <DIV>"__"_________201__г.</DIV>
     </TD>
    </TR>
   </TABLE>
  </TD>
 </TR>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Types/NaturalPartner/Footer/Individual','Подпись исполнителя индивидуального предпринимателя с физическим лицом',@Text);


-- SEPARATOR
-- Шаблоны приложений
set @Text = '<NOBODY>
 <TABLE border="1" align="right" cellspacing="2">
  <TR>
   <TD aglin="center">%MotionDocumentID%</TD>
  </TR>
 </TABLE>
 <H1 align="center">ПРИЛОЖЕНИЕ №%ContractEnclosure.Number% от %ContractEnclosure.CreateDate%</H1>
 <P align="center">К ДОГОВОРУ №%Contract.Number% от %Contract.CreateDate%</P>
 <H2 id="Header" align="center">[заголовок приложения]</H2>
 <DIV id="Content">[содержимое приложения]</DIV>
 <DIV id="Footer">[подписи сторон]</DIV>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Enclosures/Template','Шаблон приложения к договору',@Text);

-- SEPARATOR
-- Шаблоны счетов платежных систем
set @Text = '<TABLE border="1" cellpadding="5" cellspacing="0" width="100%">
 <THEAD>
  <TR bgcolor="#DCDCDC">
   <TD align="center">Наименование услуги</TD>
   <TD align="center">Комментарий</TD>
   <TD align="center">№ заказа</TD>
   <TD align="center">Ед. изм.</TD>
   <TD align="center">Кол-во</TD>
   <TD align="center">Общая сумма</TD>
  </TR>
 </THEAD>
 <TBODY id="Items">
  <TR id="Item">
   <TD>%Service.Name%</TD>
   <TD>%Comment%</TD>
   <TD align="right">%Order.Number%</TD>
   <TD>%Service.Measure%</TD>
   <TD align="right">%Amount%</TD>
   <TD align="right">%Summ%</TD>
  </TR>
 </TBODY>
 <TFOOT>
  <TR>
   <TD colspan="5">Итого</TD>
   <TD align="right">%Invoice.Summ%</TD>
  </TR>
 </TFOOT>
</TABLE>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/Services','Шаблон таблицы услуг',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%Invoice.Summ% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/InOffice','Шаблон платежной системы оплата в офисе',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Email</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.pay_to_email%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Moneybookers','Шаблон платежной системы Moneybookers',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
<H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Кошелек №</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.eshopId%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/RBKMoney','Шаблон платежной системы RBKMoney',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Номер магазина</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.MrchLogin%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/ROBOKASSA','Шаблон платежной системы ROBOKASSA',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Номер магазина</TD>
   <TD align="center">Курс валюты</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.LMI_MERCHANT_ID%</TD>
   <TD align="right">%PaymentSystem.Course%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/PayMaster','Шаблон платежной системы PayMaster',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Кошелек №</TD>
   <TD align="center">Курс валюты</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.LMI_PAYEE_PURSE%</TD>
   <TD align="right">%PaymentSystem.Course%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/WebMoneyZ','Шаблон платежной системы WebMoneyZ',@Text);

-- SEPARATOR
set @Text = '<P>@link:Invoices/PaymentSystems/WebMoneyZ</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/WebMoneyR','Шаблон платежной системы WebMoneyR',@Text);

-- SEPARATOR
set @Text = '<P>@link:Invoices/PaymentSystems/WebMoneyZ</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/WebMoneyE','Шаблон платежной системы WebMoneyE',@Text);

-- SEPARATOR
set @Text = '<P>@link:Invoices/PaymentSystems/WebMoneyZ</P>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/WebMoneyU','Шаблон платежной системы WebMoneyU',@Text);

INSERT INTO `Clauses` (`AuthorID`,`EditorID`,`GroupID`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (100,100,6,'yes','yes','Invoices/PaymentSystems/WebMoneyP','Шаблон платежной системы WebMoneyP','<P>@link:Invoices/PaymentSystems/WebMoneyZ</P>');


-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Кошелек №</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.ShopId%</TD>
   <TD align="right">%Invoice.Foreign% руб</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/YooMoney','Шаблон платежной системы ЮKassa',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Кошелек №</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.receiver%</TD>
   <TD align="right">%Invoice.Foreign% руб</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Yandex.p2p','Шаблон платежной системы Yandex.p2p',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Кошелек №</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%PaymentSystem.Send.LMI_PAYEE_PURSE%</TD>
   <TD align="right">%Invoice.Foreign% RUB</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/ZPayment','Шаблон платежной системы ZPayment',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <DIV id="Logo">[логотип]</DIV>
 <P>
  <SPAN>Распечатайте счет и образец платежного поручения в удобном для Вас формате. Обращаем Ваше внимание на то, что поступившие платежи обрабатываются автоматически. </SPAN>
  <B>Настоятельно рекомендуем Вам в точности повторить назначение платежа, указанное в образце.</B>
 </P>
 <P><B>Внимание!</B><BR />
 <SPAN>Оплата счёта должна производиться Заказчиком. Оплата счёта третьими лицами не допускается.</SPAN></P>
 <H1>Образец платежного поручения</H1>
 <TABLE border="1" cellpadding="5" cellspacing="0" widht="100%">
  <TR>
   <TD>ИНН %Executor.Inn%</TD>
   <TD>КПП %Executor.Kpp%</TD>
   <TD rowspan="2" valign="bottom">Счет №</TD>
   <TD rowspan="2" valign="bottom">%Executor.BankAccount%</TD>
  </TR>
  <TR>
   <TD colspan="2" valign="bottom">
    <FONT size="1">Получатель</FONT>
    <BR />
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%"</SPAN>
   </TD>
  </TR>
  <TR>
   <TD colspan="2" rowspan="2" valign="bottom">
    <FONT size="1">Банк получателя</FONT>
    <BR />
    <SPAN>%Executor.BankName%</SPAN>
   </TD>
   <TD>БИК</TD>
   <TD>%Executor.Bik%</TD>
  </TR>
  <TR>
   <TD>Счет №</TD>
   <TD>%Executor.Kor%</TD>
  </TR>
  <TR>
   <TD colspan="4" bgcolor="#FDF6D3">
    <FONT size="1">Назначение платежа</FONT>
    <BR />
    <SPAN>Предоплата за web-услуги по счету №%Invoice.Number% от %Invoice.CreateDate% согласно договору №%Contract.Number% от %Contract.CreateDate%</SPAN>
   </TD>
  </TR>
 </TABLE>
 <P>Плательщик: Индивидуальный предприниматель "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%<BR />Заказчик: Индивидуальный предприниматель "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%</P>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
 <TABLE id="Rubbish" cellpadding="10">
  <TR>
   <TD>
    <SPAN>Руководитель предприятия</SPAN>
    <BR />
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%"</SPAN>
    <BR />
    <SPAN>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</SPAN>
   </TD>
   <TD id="dSign">__________________</TD>
   <TD id="Stamp" rowspan="2" />
  </TR>
  <TR>
   <TD>
    <SPAN>Главный бухгалтер</SPAN>
    <BR />
    <SPAN>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</SPAN>
   </TD>
   <TD id="aSign">__________________</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Individual/Individual','Шаблон платежной системы индивидуальный предприниматель исполнителя индивидуального предпринимателя',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <DIV id="Logo">[логотип]</DIV>
 <table border="0" cellpadding="0" cellspacing="0">
 <tbody>
 <tr>
 <td valign="top">
 <p><span>Распечатайте счет и образец платежного поручения в удобном для Вас формате. Обращаем Ваше внимание на то, что поступившие платежи обрабатываются автоматически.</span> <strong>Настоятельно рекомендуем Вам в точности повторить назначение платежа, указанное в образце.</strong></p>
 <p><strong>Внимание!</strong> <br /> <span>Оплата счёта должна производиться Заказчиком. Оплата счёта третьими лицами не допускается.</span></p>
 </td>
 <td>
 <div id="QRCode">[QR Code]</div>
 </td>
 </tr>
 </tbody>
 </table>
 <H1>Образец платежного поручения</H1>
 <TABLE border="1" cellpadding="5" cellspacing="0" widht="100%">
  <TR>
   <TD>ИНН %Executor.Inn%</TD>
   <TD>КПП %Executor.Kpp%</TD>
   <TD rowspan="2" valign="bottom">Счет №</TD>
   <TD rowspan="2" valign="bottom">%Executor.BankAccount%</TD>
  </TR>
  <TR>
   <TD colspan="2" valign="bottom">
    <FONT size="1">Получатель</FONT>
    <BR />
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%"</SPAN>
   </TD>
  </TR>
  <TR>
   <TD colspan="2" rowspan="2" valign="bottom">
    <FONT size="1">Банк получателя</FONT>
    <BR />
    <SPAN>%Executor.BankName%</SPAN>
   </TD>
   <TD>БИК</TD>
   <TD>%Executor.Bik%</TD>
  </TR>
  <TR>
   <TD>Счет №</TD>
   <TD>%Executor.Kor%</TD>
  </TR>
  <TR>
   <TD colspan="4" bgcolor="#FDF6D3">
    <FONT size="1">Назначение платежа</FONT>
    <BR />
    <SPAN>Предоплата за web-услуги по счету №%Invoice.Number% от %Invoice.CreateDate% согласно договору №%Contract.Number% от %Contract.CreateDate%</SPAN>
   </TD>
  </TR>
 </TABLE>
 <P>Плательщик: Индивидуальный предприниматель "%Customer.CompanyName%" ИНН: %Customer.Inn%<BR />Заказчик: Индивидуальный предприниматель "%Customer.CompanyName%" ИНН: %Customer.Inn%</P>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
 <TABLE id="Rubbish" cellpadding="10">
  <TR>
   <TD>
    <SPAN>Руководитель предприятия</SPAN>
    <BR />
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%"</SPAN>
    <BR />
    <SPAN>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</SPAN>
   </TD>
   <TD id="dSign">__________________</TD>
   <TD id="Stamp" rowspan="2" />
  </TR>
  <TR>
   <TD>
    <SPAN>Главный бухгалтер</SPAN>
    <BR />
    <SPAN>%Executor.aSourname% %Executor.aName% %Executor.aLastname%</SPAN>
   </TD>
   <TD id="aSign">__________________</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Individual/Juridical','Шаблон платежной системы индивидуальный предприниматель исполнителя юридического лица',@Text);


-- SEPARATOR
set @Text = '<NOBODY>
 <DIV id="Logo">[логотип]</DIV>
 <p><span>Распечатайте счет и образец платежного поручения в удобном для Вас формате. Обращаем Ваше внимание на то, что поступившие платежи обрабатываются автоматически.</span> <strong>Настоятельно рекомендуем Вам в точности повторить назначение платежа, указанное в образце.</strong></p>
 <p><strong>Внимание!</strong> <br /> <span>Оплата счёта должна производиться Заказчиком. Оплата счёта третьими лицами не допускается.</span></p>
 <H1>Образец платежного поручения</H1>
 <TABLE border="1" cellpadding="5" cellspacing="0" widht="100%">
  <TR>
   <TD>ИНН %Executor.Inn%</TD>
   <TD>КПП %Executor.Kpp%</TD>
   <TD rowspan="2" valign="bottom">Счет №</TD>
   <TD rowspan="2" valign="bottom">%Executor.BankAccount%</TD>
  </TR>
  <TR>
   <TD colspan="2" valign="bottom">
    <FONT size="1">Получатель</FONT>
    <BR />
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%"</SPAN>
   </TD>
  </TR>
  <TR>
   <TD colspan="2" rowspan="2" valign="bottom">
    <FONT size="1">Банк получателя</FONT>
    <BR />
    <SPAN>%Executor.BankName%</SPAN>
   </TD>
   <TD>БИК</TD>
   <TD>%Executor.Bik%</TD>
  </TR>
  <TR>
   <TD>Счет №</TD>
   <TD>%Executor.Kor%</TD>
  </TR>
  <TR>
   <TD colspan="4" bgcolor="#FDF6D3">
    <FONT size="1">Назначение платежа</FONT>
    <BR />
    <SPAN>Предоплата за web-услуги по счету №%Invoice.Number% от %Invoice.CreateDate% согласно договору №%Contract.Number% от %Contract.CreateDate%</SPAN>
   </TD>
  </TR>
 </TABLE>
 <P>Плательщик: %Customer.CompanyForm% "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%<BR />Заказчик: %Customer.CompanyForm% "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%</P>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
 <TABLE id="Rubbish" cellpadding="10">
  <TR>
   <TD>
    <SPAN>Руководитель предприятия</SPAN>
    <BR />
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%"</SPAN>
    <BR />
    <SPAN>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</SPAN>
   </TD>
   <TD id="dSign">__________________</TD>
   <TD id="Stamp" rowspan="2" />
  </TR>
  <TR>
   <TD>
    <SPAN>Главный бухгалтер</SPAN>
    <BR />
    <SPAN>%Executor.aSourname% %Executor.aName% %Executor.aLastname%</SPAN>
   </TD>
   <TD id="aSign">__________________</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Juridical/Individual','Шаблон платежной системы юридического лица исполнителя индивидуального предпринимателя',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <DIV id="Logo">[логотип]</DIV>
 <table border="0" cellpadding="0" cellspacing="0">
 <tbody>
 <tr>
 <td valign="top">
 <p><span>Распечатайте счет и образец платежного поручения в удобном для Вас формате. Обращаем Ваше внимание на то, что поступившие платежи обрабатываются автоматически.</span> <strong>Настоятельно рекомендуем Вам в точности повторить назначение платежа, указанное в образце.</strong></p>
 <p><strong>Внимание!</strong> <br /> <span>Оплата счёта должна производиться Заказчиком. Оплата счёта третьими лицами не допускается.</span></p>
 </td>
 <td>
 <div id="QRCode">[QR Code]</div>
 </td>
 </tr>
 </tbody>
 </table>
 <P>
  <SPAN>Распечатайте счет и образец платежного поручения в удобном для Вас формате. Обращаем Ваше внимание на то, что поступившие платежи обрабатываются автоматически. </SPAN>
  <B>Настоятельно рекомендуем Вам в точности повторить назначение платежа, указанное в образце.</B>
 </P>
 <P><B>Внимание!</B><BR />
 <SPAN>Оплата счёта должна производиться Заказчиком. Оплата счёта третьими лицами не допускается.</SPAN></P>
 <H1>Образец платежного поручения</H1>
 <TABLE border="1" cellpadding="5" cellspacing="0" widht="100%">
  <TR>
   <TD>ИНН %Executor.Inn%</TD>
   <TD>КПП %Executor.Kpp%</TD>
   <TD rowspan="2" valign="bottom">Счет №</TD>
   <TD rowspan="2" valign="bottom">%Executor.BankAccount%</TD>
  </TR>
  <TR>
   <TD colspan="2" valign="bottom">
    <FONT size="1">Получатель</FONT>
    <BR />
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%"</SPAN>
   </TD>
  </TR>
  <TR>
   <TD colspan="2" rowspan="2" valign="bottom">
    <FONT size="1">Банк получателя</FONT>
    <BR />
    <SPAN>%Executor.BankName%</SPAN>
   </TD>
   <TD>БИК</TD>
   <TD>%Executor.Bik%</TD>
  </TR>
  <TR>
   <TD>Счет №</TD>
   <TD>%Executor.Kor%</TD>
  </TR>
  <TR>
   <TD colspan="4" bgcolor="#FDF6D3">
    <FONT size="1">Назначение платежа</FONT>
    <BR />
    <SPAN>Предоплата за web-услуги по счету №%Invoice.Number% от %Invoice.CreateDate% согласно договору №%Contract.Number% от %Contract.CreateDate%</SPAN>
   </TD>
  </TR>
 </TABLE>
 <P>Плательщик: %Customer.CompanyForm% "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%<BR />Заказчик: %Customer.CompanyForm% "%Customer.CompanyName%" ИНН: %Customer.Inn% КПП: %Customer.Kpp%</P>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
 <TABLE id="Rubbish" cellpadding="10">
  <TR>
   <TD>
    <SPAN>Руководитель предприятия</SPAN>
    <BR />
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%"</SPAN>
    <BR />
    <SPAN>%Executor.dSourname% %Executor.dName% %Executor.dLastname%</SPAN>
   </TD>
   <TD id="dSign">__________________</TD>
   <TD id="Stamp" rowspan="2" />
  </TR>
  <TR>
   <TD>
    <SPAN>Главный бухгалтер</SPAN>
    <BR />
    <SPAN>%Executor.aSourname% %Executor.aName% %Executor.aLastname%</SPAN>
   </TD>
   <TD id="aSign">__________________</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Juridical/Juridical','Шаблон платежной системы юридического лица исполнителя юридического лица',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>Платежное поручение</H1>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR>
   <TD width="150" rowspan="6" valign="top">ИЗВЕЩЕНИЕ</TD>
   <TD width="500">
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%", ИНН: %Executor.Inn%, расс. счет: %Executor.BankAccount%</SPAN>
    <BR />
    <SPAN>в %Executor.BankName%, БИК: %Executor.Bik%, корр. счет: %Executor.Kor%</SPAN>
   </TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Плательщик:</TD>
  </TR>
  <TR>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Адрес плательщика:</TD>
  </TR>
  <TR>
   <TD>%Customer.pState%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>
    <TABLE border="1" width="100%" cellpadding="5" cellspacing="0">
     <TR bgcolor="#DCDCDC">
      <TD align="center">Назначение</TD>
      <TD align="center">Сумма</TD>
     </TR>
     <TR>
      <TD>За web-услуги по счету №%Invoice.Number%</TD>
      <TD align="right">%Invoice.Summ%</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
  <TR>
   <TD>Кассир</TD>
   <TD>
    <TABLE width="100%">
     <TR>
      <TD>Плательщик ____________________</TD>
      <TD align="right">Дата "____"___________201__г.</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <BR />
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR>
   <TD width="150" rowspan="6" valign="top">КВИТАНЦИЯ</TD>
   <TD width="500">
    <SPAN>Индивидуальный предприниматель "%Executor.CompanyName%", ИНН: %Executor.Inn%, расс. счет: %Executor.BankAccount%</SPAN>
    <BR />
    <SPAN>в %Executor.BankName%, БИК: %Executor.Bik%, корр. счет: %Executor.Kor%</SPAN>
   </TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Плательщик:</TD>
  </TR>
  <TR>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Адрес плательщика:</TD>
  </TR>
  <TR>
   <TD>%Customer.pState%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>
    <TABLE border="1" width="100%" cellpadding="5" cellspacing="0">
     <TR bgcolor="#DCDCDC">
      <TD align="center">Назначение</TD>
      <TD align="center">Сумма</TD>
     </TR>
     <TR>
      <TD>За web-услуги по счету №%Invoice.Number%</TD>
      <TD align="right">%Invoice.Summ%</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
  <TR>
   <TD>Кассир</TD>
   <TD>
    <TABLE width="100%">
     <TR>
      <TD>Плательщик ____________________</TD>
      <TD align="right">Дата "____"___________201__г.</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <BR />
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Natural/Individual','Шаблон платежной системы физического лица исполнителя индивидуального предпринимателя',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <table border="0" cellpadding="0" cellspacing="0">
 <tbody>
 <tr>
 <td valign="top">
  <H1>Платежное поручение</H1>
 </td>
 <td>
 <div id="QRCode">[QR Code]</div>
 </td>
 </tr>
 </tbody>
 </table>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR>
   <TD width="150" rowspan="6" valign="top">ИЗВЕЩЕНИЕ</TD>
   <TD width="500">
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%", ИНН: %Executor.Inn%, расс. счет: %Executor.BankAccount%</SPAN>
    <BR />
    <SPAN>в %Executor.BankName%, БИК: %Executor.Bik%, корр. счет: %Executor.Kor%</SPAN>
   </TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Плательщик:</TD>
  </TR>
  <TR>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Адрес плательщика:</TD>
  </TR>
  <TR>
   <TD>%Customer.pState%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>
    <TABLE border="1" width="100%" cellpadding="5" cellspacing="0">
     <TR bgcolor="#DCDCDC">
      <TD align="center">Назначение</TD>
      <TD align="center">Сумма</TD>
     </TR>
     <TR>
      <TD>За web-услуги по счету №%Invoice.Number%</TD>
      <TD align="right">%Invoice.Summ%</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
  <TR>
   <TD>Кассир</TD>
   <TD>
    <TABLE width="100%">
     <TR>
      <TD>Плательщик ____________________</TD>
      <TD align="right">Дата "____"___________201__г.</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <BR />
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR>
   <TD width="150" rowspan="6" valign="top">КВИТАНЦИЯ</TD>
   <TD width="500">
    <SPAN>%Executor.CompanyForm% "%Executor.CompanyName%", ИНН: %Executor.Inn%, расс. счет: %Executor.BankAccount%</SPAN>
    <BR />
    <SPAN>в %Executor.BankName%, БИК: %Executor.Bik%, корр. счет: %Executor.Kor%</SPAN>
   </TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Плательщик:</TD>
  </TR>
  <TR>
   <TD>%Customer.Sourname% %Customer.Name% %Customer.Lastname%</TD>
  </TR>
  <TR>
   <TD bgcolor="#DCDCDC">Адрес плательщика:</TD>
  </TR>
  <TR>
   <TD>%Customer.pState%, %Customer.pCity%, %Customer.pType% %Customer.pAddress%</TD>
  </TR>
  <TR>
   <TD>
    <TABLE border="1" width="100%" cellpadding="5" cellspacing="0">
     <TR bgcolor="#DCDCDC">
      <TD align="center">Назначение</TD>
      <TD align="center">Сумма</TD>
     </TR>
     <TR>
      <TD>За web-услуги по счету №%Invoice.Number%</TD>
      <TD align="right">%Invoice.Summ%</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
  <TR>
   <TD>Кассир</TD>
   <TD>
    <TABLE width="100%">
     <TR>
      <TD>Плательщик ____________________</TD>
      <TD align="right">Дата "____"___________201__г.</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <BR />
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <P>
  <SPAN>Всего к оплате: </SPAN>
  <B>%Invoice.Wizard%</B>
 </P>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/Natural/Juridical','Шаблон платежной системы физического лица исполнителя юридического лица',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <H1>СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%</H1>
 <DIV id="Services">[список услуг]</DIV>
 <H2>Платежное поручение</H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TR bgcolor="#DCDCDC">
   <TD align="center">Назначение</TD>
   <TD align="center">Сумма</TD>
  </TR>
  <TR>
   <TD>За web-услуги по счету №%Invoice.Number%</TD>
   <TD align="right">%Invoice.Foreign% %PaymentSystem.Measure%</TD>
  </TR>
 </TABLE>
</NOBODY>';
-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsXML`,`IsDOM`,`IsProtected`,`Partition`,`Title`,`Text`)
VALUES (6,100,100,'yes','yes','yes','Invoices/PaymentSystems/2Checkout','Шаблон платежной системы 2Checkout',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
<SPAN>Ваша ссылка как партнера:</SPAN>
 <SPAN class="Standard">http://demo.joonte.com/Index?OwnerID=%__USER.ID%</SPAN>
 <SPAN>разместите ее у себя на сайте.</SPAN>
 <SPAN><BR /><BR />
 Обратите внимание, что для начисления используется договор с профилем &quot;Партнёрская программа&quot;. Если он у вас отсутствует, создайте его в разделе &quot;<A href="/Contracts">Мой офис → Договоры</A>&quot;.<BR /><BR /></SPAN>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (9,100,100,'yes','yes','yes','Header:/DependUsers','Информация по партнерской программе',@Text);

-- SEPARATOR
/* added by lissyara 2011-06-22 in 15:22 MSK */
 INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6,100,100,'Invoices/PaymentSystems/W1', 'Шаблон платежной системы Wallet One', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Номер кошелька\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %PaymentSystem.Send.WMI_MERCHANT_ID%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/MailRu', 'Шаблон платежной системы MailRu', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Номер магазина\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %PaymentSystem.Send.shop_id%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/QIWI', 'Шаблон платежной системы QIWI', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Номер магазина\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %PaymentSystem.Send.from%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(10, 100, 100, 'CreateTicket/DOMAIN_OWNER_NOT_DEFINED', 'Определить владельца для домена', 'yes', 'yes', 'yes', 'yes', '<NOBODY>Для завершения регистрации домена Вам необходимо определить его владельца.<BR />\nДля этого, пройдите в раздел<BR />\n[color=green]Услуги -> Домены -> Мои заказы[/color]<BR />\nи нажмите соответствующую кнопку напротив заказа домена.</NOBODY>\n');

-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(10, 100, 100, 'CreateTicket/ERROR_DOMAIN_REGISTER', 'Ошибка регистрации домена', 'no', 'yes', 'no', 'yes', 'Здравствуйте. При регистрации заказанного вами домена, произошла ошибка, из-за того, что Вы ввели неверные паспортные данные в профиль.<BR />\nДля успешной регистрации доменного имени необходимо ввести корректные паспортные данные.<BR />\nОбратите внимание, что паспортные данные проверяет робот вышестоящего регистратора, и ошибочные он не пропустит.<BR />\nИсправить данные можно тут: [color=green]Мой офис -> Профили[/color]');


-- SEPARATOR
/* added by lissyara 2011-09-11 in 19:09 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(9,100, 100, 'Header:/Administrator/UpdateSystem', 'Инструкция по обновлению биллинга', 'yes', 'yes', 'no', 'yes', '<ul class="Standard">\n<li>Продукт предоставляется &quot;как есть&quot;.\n</li>\n<li>Все обновления вы выполняете на свой страх и риск - если у вас всё работает, и функционал вас устраивает — ничего не обновляйте.\n</li>\n<li>Разработчики не несут ответственности за простой вашей системы, и за недополученную прибыль.\n</li>\n<li>В случае любых проблем при обновлении, скопируйте вывод программы обновления (при необходимости, удалив из него пароли и прочую секретную информацию), и создайте тему на официальном <a href="http://forum.joonte.com/" target="_blank">форуме поддержки биллинговой системы</a>.\n</li>\n<li>Ознакомьтесь со <a href="http://forum.joonte.com/viewforum.php?f=12" target="_blank">списком изменений</a> в версии на которую обновляетесь, также, вполне возможно что для успешного обновления от вас потребуются какие-то действия &mdash; это будет описано там же, в теме посвящённой обновлению.</li>\n<li>Если вы пропустили какое-то обновление &mdash; будте готовы к проблемам. Обновления, конечно, последовательные, но &mdash; вероятность проблем возрастает.</li>\n<li><strong>Всегда</strong> делайте полную копию базы и всех файлов биллинга <strong>до</strong> обновления. </li></ul>');

-- SEPARATOR
/* added by lissyara 2011-09-21 in 11:13 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(9,100, 100, 'Header:/Administrator/ISPswOrders', 'Предупреждение для раздела софта от ISPsystem', 'no', 'yes', 'no', 'yes', 'Данная возможность является экспериментальной. Разработчики не дают никаких гарантий, что работа этого раздела будет корректной, и полностью функциональной.<br />\n    <br />\n    На данный момент, работает заказ &quot;внутренних&quot; лицензий, из расчёта что реально в ISPsystems заказываются вечные. <br />\n<br />\nА с учётом, что вечные они больше не продают - можно считать что раздел не работает. Только для тех у кого есть их запас.<br />\n<br />\nРеализован пробный период (тариф с нулевой ценой без продления), смена тарифа, блокировка, удаление. До заказа лицензии ищется свободная по базе, если такая есть - используется она, а не новая.');

-- SEPARATOR
/* added by lissyara 2011-09-21 in 19:28 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(9,100, 100, 'Header:/Administrator/ISPswSchemes', 'Тарифы на ПО ISPsystem', 'no', 'yes', 'no', 'yes', 'Даннный раздел используется для создания, удаления, изменения тарифных планов на программное обеспечение компании ISPsystem\n');

-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(9,100, 100, 'Header:/Administrator/ISPswGroups', 'Группы ПО ISPsystem', 'no', 'yes', 'no', 'yes', 'Группы ПО используются для объединения тарифных планов.<br />\n    <br />\n    Например, для возможности создания триального заказа, и дальнейшего перехода на обычный тарифный план - оба тарифа необходимо объединить в одну группу.');

-- SEPARATOR
/* added by lissyara 2011-12-19 in 14:12 MSK */
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES (6,100,100,'Invoices/PaymentSystems/InterKassa', 'Шаблон платежной системы ИнтерКасса', 'yes', 'yes', 'yes', '<NOBODY>
 <H1>
  СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%
 </H1>
 <DIV id="Services">
  [список услуг]
 </DIV>
 <H2>
  Платежное поручение
 </H2>
 <TABLE border="1" cellpadding="5" cellspacing="0">
  <TBODY>
   <TR bgcolor="#DCDCDC">
    <TD align="center">
     Назначение
    </TD>
    <TD align="center">
     Идентификатор магазина
    </TD>
    <TD align="center">
     Сумма
    </TD>
   </TR>
   <TR>
    <TD>
     За web-услуги по счету №%Invoice.Number%
    </TD>
    <TD align="right">
     %PaymentSystem.Send.ik_shop_id%
    </TD>
    <TD align="right">
     %Invoice.Foreign% %PaymentSystem.Measure%
    </TD>
   </TR>
  </TBODY>
 </TABLE>
</NOBODY>
', 'yes');

-- SEPARATOR
/* added by lissyara 2012-01-04 in 15:20 MSK */
INSERT INTO `Clauses`
(`GroupID`,`AuthorID`,`EditorID`,`Partition`,`Title`,`IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES
(9,100, 100, 'Header:/DependUsersStatistic', 'Информация о начислениях по партнёрской программе', 'no', 'yes', 'no', 'В данном разделе предоставлена информация о возможных начислениях в предыдущие периоды (&quot;возможных&quot; — потому, что начисления производятся лишь при наличии соответствующего партнёрского договора). Суммы могут незначительно отличаться от реальных, из-за округления.<br />\n<br />\nЗначения колонок:<br />\n<ul type="square">\n <li>\n  <strong>Год</strong>/<strong>Месяц</strong> — год/месяц начисления\n </li>\n <li>\n  <strong>Пользователей</strong> — число ваших рефералов, оплачивавших услуги в указанный период времени\n </li>\n <li>\n  <strong>Платежей</strong> — число платежей совершённых вашими рефералами\n </li>\n <li>\n  <strong>Сумма</strong> — сумма вашего партнёрского вознаграждения\n </li>\n</ul><br />', 'yes');

-- SEPARATOR
/* added by lissyara 2012-01-28 in 13:51 MSK */
INSERT INTO `Clauses`
(`GroupID`,`AuthorID`,`EditorID`,`Partition`,`Title`,`IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES
(1,100, 100, '/User/Announcement', 'Объявление для клиентов', 'no', 'yes', 'yes', '<NOBODY>Обратите внимание, что сегодня, 2012-01-28, в период с 21:00 до 21:10 MSK в датацентре будут проводиться плановые технические работы. Возможны кратковременные перерывы в доступности ваших сайтов.</NOBODY>', 'no');

-- SEPARATOR
/* added by lissyara 2012-01-28 in 13:54 MSK */
INSERT INTO `Clauses`
(`GroupID`,`AuthorID`,`EditorID`,`Partition`,`Title`,`IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES
(1,100, 100, '/User/Announcement', 'Объявление для клиентов', 'no', 'yes', 'yes', '<NOBODY>Обратите внимание, что 2012-02-28, в период с 21:00 до 23:00 MSK будут проводиться плановые технические работы на сервере srv3.isp.su. В указанный период времени, ваши сайты будут недоступны.</NOBODY>', 'no');

-- SEPARATOR
/* added by lissyara 2012-03-03 in 20:10 MSK, JBS-359 */
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/EasyPay', 'Шаблон платежной системы EasyPay', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Номер Поставщика\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %PaymentSystem.Send.EP_MerNo%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
/* added by lissyara, 2012-09-25 in 14:37 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES (1,100, 100, 'Contracts/Enclosures/Types/Tariffs/Content', 'Тарифы', 'yes', 'yes', 'yes', 'yes', '<NOBODY>\n <COMP path="Clauses/TariffList" args="NotUsed">\n [список тарифов]\n</COMP>\n</NOBODY>\n');


-- SEPARATOR
/* added by lissyara, 2013-05-29 in 21:38 MSK, for JBS-695 */
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES (11, 100, 100, '01:Info.gif', 'Ваш запрос принят в работу', 'no', 'yes', 'no', 'yes', 'Здравствуйте.<br />\nВаш запрос принят в работу.<br />\nКак только по нему появится новая информация, вам будет об этом сообщено в данном тикете.');
-- SEPARATOR
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES (11, 100, 100, '03:Dollar.gif', 'Запрос передан в бухгалтерию', 'no', 'yes', 'no', 'yes', '<p>\n Ваш запрос передан ответственному сотруднику в бухгалтерии.\n</p>\n<p>\n Обратите внимание, что бухгалтерия работает только по рабочим дням, с 9 до 18 часов.\n</p>');

-- SEPARATOR
-- added by lissyara 2015-05-15 in 16:54 MSK, for JBS-1051
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/Uniteller', 'Шаблон платежной системы Uniteller', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Номер магазина\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %PaymentSystem.Send.Shop_IDP%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
-- added by lissyara 2017-11-10 in 09:11 MSK, for JBS-1230
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/SberBank', 'Шаблон платежной системы SberBank', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');

-- SEPARATOR
-- added by lissyara 2017-11-10 in 09:11 MSK, for JBS-1230
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Invoices/PaymentSystems/PayBox', 'Шаблон платежной системы PayBox', 'yes', 'yes', 'yes', '<NOBODY>\r\n <H1>\r\n СЧЁТ №%Invoice.Number% от %Invoice.CreateDate%\r\n</H1>\r\n <DIV id="Services">\r\n [список услуг]\r\n</DIV>\r\n <H2>\r\n Платежное поручение\r\n</H2>\r\n <TABLE border="1" cellpadding="5" cellspacing="0">\r\n  <TBODY>\r\n   <TR bgcolor="#DCDCDC">\r\n    <TD align="center">\r\n    Назначение\r\n   </TD>\r\n    <TD align="center">\r\n    Сумма\r\n   </TD>\r\n   </TR>\r\n   <TR>\r\n    <TD>\r\n    За web-услуги по счету №%Invoice.Number%\r\n   </TD>\r\n    <TD align="right">\r\n    %Invoice.Foreign% %PaymentSystem.Measure%\r\n   </TD>\r\n   </TR>\r\n  </TBODY>\r\n </TABLE>\r\n</NOBODY>\r\n', 'yes');
-- SEPARATOR
-- added by lissyara 2023-03-07 in 12:06 MSK
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6, 100, 100, 'Header:/Administrator/Clauses', 'Предупреждение по статьям', 'yes', 'yes', 'yes', '<NOBODY><DIV>Обратите внимание что опубликованные статьи доступны по АПИ, не надо в них хранить пароли, заметки и т.п.</DIV></NOBODY>', 'yes');
-- SEPARATOR

INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`) VALUES
(6,100,100,'Invoices/PaymentSystems/Tinkoff','Шаблон платежной системы Tinkoff','yes','yes','yes','<NOBODY>\n <DIV id=\"SBP\" style=\"margin-left: auto; margin-right: 0;\" />\n <H1>\n СЧЕТ №%Invoice.Number% от %Invoice.CreateDate%\n</H1>\n <DIV id=\"Services\">\n [список услуг]\n</DIV>\n <H2>\n Платежное поручение\n</H2>\n <TABLE border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n  <TBODY>\n   <TR bgcolor=\"#DCDCDC\">\n    <TD align=\"center\">\n    Назначение\n   </TD>\n    <TD align=\"center\">\n    Сумма\n   </TD>\n   </TR>\n   <TR>\n    <TD>\n    За web-услуги по счету №%Invoice.Number%\n   </TD>\n    <TD align=\"right\">\n    %Invoice.Foreign% %PaymentSystem.Measure%\n   </TD>\n   </TR>\n  </TBODY>\n </TABLE>\n</NOBODY>\n','yes');
-- SEPARATOR

UNLOCK TABLES;
-- SEPARATOR


DELETE FROM `Config` WHERE `Param` = 'Copyright';
-- SEPARATOR
INSERT INTO `Config` (`HostID`,`Param`,`Value`)
VALUES ('billing','Copyright','ООО "Компания" 2000-2020 г.');
-- SEPARATOR
DELETE FROM `Config` WHERE `Param` = 'EmailSign';
-- SEPARATOR
INSERT INTO `Config` (`HostID`,`Param`,`Value`)
VALUES ('billing','EmailSign','С уважением, ООО "Компания".');



-- SEPARATOR
LOCK TABLES `ServicesGroups` WRITE;
DELETE FROM `ServicesGroups` WHERE `ID` IN(1000);
INSERT INTO `ServicesGroups`
  (`ID`,`Name`,`IsProtected`,`IsActive`,`SortID`)
VALUES
(1000,'Базовые услуги','yes','yes',10),
/* added by lissyara 2011-08-04 in 11:23 MSK */
(1100, 'Дополнительные услуги', 'yes', 'yes', 20);
UNLOCK TABLES;

-- SEPARATOR
LOCK TABLES `Services` WRITE;
DELETE FROM `Services` WHERE `ID` IN(1000,2000,2100,3000);
INSERT INTO `Services`
  (`ID`,`ServicesGroupID`,`GroupID`,`UserID`,`Name`,`NameShort`,`OperationSign`,`Measure`,`IsHidden`,`IsProtected`,`IsActive`)
VALUES
(1000,1000,2000000,1,'Пополнение средств','Пополнение','+','шт.','yes','yes','no'),
(1100,1000,2000000,1,'Партнёрское начисление','Начисление','+','шт.','yes', 'yes','no'),
(2000,1000,2000000,1,'Списание средств','Списание','-','шт.','yes','yes','no'),
(2100,1000,2000000,1,'Хранение информации пользователя','Хранение информации','-','шт.','yes','yes','no'),
(3000,1000,2000000,1,'Возврат средств на баланс','Возврат на баланс','+','шт.','yes','yes','no'),
(4000,1000,2000000,1,'Возврат средств на реквизиты пользователя','Возврат на реквизиты','+','шт.','yes','yes','no');
UNLOCK TABLES;

/* сопоставленяи платёжных систем и методов оплаты */
-- SEPARATOR
LOCK TABLES `PaymentSystemsCollation` WRITE;
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',10,'PayMaster','WebMoney','WebMoney.png','Оплата через WebMoney, банковскими картами VISA/MasterCard (без процентов),\nчерез интернет-банкинги, наличными через кассы магазинов и многими другими способами','WebMoney','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',20,'PayMaster','VISA','Visa.MasterCard.png','Оплата при помощи пластиковой карты VISA или MasterCard.','VISA/MasterCard','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'PayMaster','BeeLine','BeeLine.png','Оплата со счета телефона, оператор BeeLine','BeeLine','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'PayMaster','МТС','MTS.png','Оплата со счета телефона, оператор МТС','МТС','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'ROBOKASSA','МegaFon','МegaFon.png','Оплата со счета телефона, оператор МegaFon','МegaFon','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'PayMaster','ЕвроСеть','EuroSet.png','Оплата через офисы ЕвроСети','ЕвроСеть','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'PayMaster','Связной','Svyaznoi.png','Оплата через офисы Связного','Связной','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'WebMoneyR','WebMoney WMR','WMRM.gif','Оплата при помощи электронных денег платёжной системы WebMoney, валюта платежа - Российский рубль.','WebMoney WMR','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'WebMoneyZ','WebMoney WMZ','WMZM.gif','Оплата при помощи электронных денег платёжной системы WebMoney, валюта платежа - Доллар США.','WebMoney WMZ','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'WebMoneyE','WebMoney WME','WMEM.gif','Оплата при помощи электронных денег платёжной системы WebMoney, валюта платежа - евро.','WebMoney WME','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',999,'WebMoneyU','WebMoney WMU','WebMoney.png','Оплата при помощи электронных денег платёжной системы WebMoney, валюта платежа - Украинская гривна.','WebMoney WMU','картинка от обычных вебманей');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',30,'YooMoney','ЮMoney','YooMoney.png','ЮMoney (ранее: Яндекс.Деньги), это платежная система, которая позволяет оплачивать различные товары и услуги; совершать безопасные платежи в интернете; надежно хранить всю информацию о ваших зачислениях и платежах.','ЮMoney','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',40,'QIWI','QIWI','QIWI.png','Платёжная система использующая номер мобильного телефона в качестве номера кошелька. Большая сеть терминалов для оплаты.\n\nНапример: +7 926 123 45 67','QIWI','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'ZPayment','Z-Payment','Z-Payment.png','Оплата при помощи электронных денег платёжной системы Z-Payment.','Z-Payment','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'EasyPay','EasyPay','EasyPay.png','Оплата при помощи электронных денег платёжной системы EasyPay.','EasyPay','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',50,'RBKMoney','RBK Money','RBKMoney.png','(в прошлом — RUpay) — первая электронная платёжная система в России бесплатная для пользователей. Комиссия на оплату услуг и товаров в интернете — 0%','RBK Money','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',60,'ROBOKASSA','ROBOKASSA','ROBOKASSA.png','Оплата любыми способами - все виды электронных денег, VISA, MasterCard, Maestro, оплата через SMS, терминалы, электронный банкинг и много других способов','ROBOKASSA','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'InterKassa','ИнтерКасса','InterKassa.png','Оплата при помощи платёжной системы ИнтерКасса.','ИнтерКасса','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'MailRu','Деньги@Mail.Ru','MailRu.png','Оплата при помощи электронных денег платёжной системы Деньги@Mail.Ru.','Деньги@Mail.Ru','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'W1','Единый кошелек','W1R.gif','Оплата при помощи электронных денег платёжной системы Единый кошелек.','Единый кошелек','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'no',9999,'Moneybookers','Moneybookers','','Система электронных переводов Moneybookers','Moneybookers','нет картинки');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'Checkout','2Checkout','2CheckOut.png','Оплата при помощи пластиковых карт и PayPal через процессинговый центр 2Checkout','2Checkout','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'OKPAY','OKPAY','OKPAY.png','Оплата при помощи электронных денег платёжной системы OKPAY.','OKPAY','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'OnPay','OnPay.ru','OnPay.png','Оплата при помощи электронных денег платёжной системы OnPay.ru','OnPay.ru','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',100,'Natural','Банк (физ. лица)','Bank.png','Оплата платежом через банк (СберБанк или любой другой).','Банк (физ. лица)','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',120,'Juridical','Банк без. нал. (юр. лица)','Bank.png','Оплата банковским платежом, для юридических лиц','Банк без. нал. (юр. лица)','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',110,'Individual','Банк без. нал. (ИП)','Bank.png','Оплата банковским платежом, для индивидульных предпренимателей','Банк без. нал. (ИП)','');
-- SEPARATOR
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',150,'InOffice','Наличными в офисе','Cash.png','Оплата наличными, в нашем офисе.','Наличными в офисе','');
-- SEPARATOR
-- added by lissyara 2015-05-15 in 16:54 MSK, for JBS-1051
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',15,'Uniteller','VISA','Visa.MasterCard.png','Оплата при помощи пластиковой карты VISA или MasterCard.','VISA/MasterCard','');
-- SEPARATOR
-- added by lissyara 2017-11-10 in 09:12 MSK, for JBS-1230
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',15,'SberBank','VISA','Visa.MasterCard.png','Оплата при помощи пластиковой карты МИР, VISA или MasterCard.','МИР/VISA/MasterCard','');
-- SEPARATOR
-- added by lissyara, 2019-09-14 in 20:58 MSK, for new webmoney rouble
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',999,'WebMoneyP','WebMoney Рубль','WMRM.gif','Оплата при помощи электронных денег платёжной системы WebMoney, валюта платежа - Российский рубль.','WebMoney P','');
-- SEPARATOR
-- added by lissyara, 2025-12-16 in 20:48 MSK
INSERT INTO `PaymentSystemsCollation` VALUES (NULL,'yes',15,'Tinkoff','СБП','SBP.png','Система быстрых платежей','СБП','');



-- SEPARATOR
UNLOCK TABLES;
-- SEPARATOR

SET FOREIGN_KEY_CHECKS=1;

ALTER TABLE `Users` AUTO_INCREMENT=2001;
ALTER TABLE `Tasks` AUTO_INCREMENT=1000;
ALTER TABLE `Profiles` AUTO_INCREMENT=100;
ALTER TABLE `Orders` AUTO_INCREMENT=1000;


