SET NAMES 'utf8';
SET FOREIGN_KEY_CHECKS=0;

LOCK TABLES `Tasks` WRITE;
DELETE FROM `Tasks` WHERE `ID` IN(51,52,53,54,55,56,57,58,59,60,61,62,64,65,66,67,69,70,71,73,74,75,77,78,79,80,81,83,86,91,93,94);
INSERT INTO `Tasks`
  (`ID`,`UserID`,`TypeID`,`Params`,`IsActive`)
VALUES
(51,1,'NoticeSuspend','[]','yes'),
(52,1,'Consider','[]','yes'),
(53,1,'NoticeDelete','[]','yes'),
(54,1,'HostingForDelete','[]','yes'),
(58,1,'DomainForDelete','[]','yes'),
(59,1,'DomainOrdersWhoIsUpdate','[]','yes'),
(60,1,'ServersQuestioning','[]','yes'),
(61,1,'ServersUpTime','[]','yes'),
(62,1,'ServerAccountsResources','[]','yes'),
(70,1,'VPSForDelete','[]','yes'),
(74,1,'DSForDelete','[]','yes'),
(75,1,'DSCalculateNumServers','[]','yes'),
(76,1,'DSServersIPMI','[]','yes'),
(78,1,'ExtraIPForDelete','[]','yes'),
(84,1,'ISPswForDelete','[]','yes'),
(86,1,'ServersAutoBalance','[]','yes'),
(94,1,'DNSmanagerForDelete','[]','yes')
;

UNLOCK TABLES;

-- Приложения к договорам

set @Text = '<NOBODY>
 <P align="justify">Настоящий Регламент определяет порядок оказания услуг Исполнителем, своим Заказчикам по размещению виртуального web-сервера на оборудовании исполнителя, а так же, порядок использования таких услуг со стороны Заказчика или пользователя, порядок взаимодействия между Исполнителем и Заказчиком или пользователем, а также иные вопросы, не оговоренные явно в Договоре.</P>
 <H2>1. Предоставление услуг</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.1.</TD>
   <TD align="justify" width="95%">Учитывая, что Интернет распространен практически во всех государствах мира, имеющих различное законодательство, Исполнитель настоящим Договором предупреждает Заказчика, что случайные или намеренные действия в Интернет могут привести к нарушению национального законодательства других стран. Исполнитель не несет ответственности за такие возможные нарушения со стороны Заказчика.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.2.</TD>
   <TD align="justify" width="95%">Заказчик принимает на себя полную ответственность и риски, связанные с использованием сети Интернет посредством Услуг, в том числе ответственность за оценку точности, полноты и полезности любых мнений, идей, иной информации, а также свойств товаров и услуг, распространяемых в Интернет и предоставляемых Заказчику посредством Услуг.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.3.</TD>
   <TD align="justify" width="95%">В случае если Заказчик предоставляет третьим лицам доступ к имеющимся у него ресурсам и сервисам, ответственность за деятельность таких третьих лиц несет исключительно Заказчик.</TD>
  </TR>
 </TABLE>
 <H2>2. Права и ответственность сторон</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.1.</TD>
   <TD align="justify" width="95%">
    <SPAN>Исполнитель, сохраняя за собой все права по Договору вправе незамедлительно приостановить оказание услуг в случаях:</SPAN>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">если по обоснованному мнению Исполнителя использование Заказчиком услуг может нанести ущерб Исполнителю и/или вызвать сбой технических и программных средств Исполнителя и третьих лиц;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, передавать, воспроизводить, распространять, любым способом, а так же в любом виде использовать полученные посредством услуг программное обеспечение и/или другие материалы, полностью или частично защищенные авторскими и другими правами, без разрешения правообладателя;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">публикации и/или передачи со стороны Заказчика, с использованием оборудования Исполнителя, любой информации, относящейся к пропаганде жестокости, насилия, совершению террористических актов, разжиганию расовой, национальной, религиозной вражды, пропаганде войны.</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, передавать, распространять любым способом любую информацию или программное обеспечение, которое содержит в себе какие-либо вредоносные компоненты;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">наличия со стороны Заказчика действий, направленных на то, чтобы посылать содержащую рекламу информацию (спам) без согласия со стороны адресата при наличие письменных заявлений от получателей такой рассылки на имя Исполнителя с обоснованными претензиями на адрес Заказчика. При этом понятие "спам" определяется общеизвестными "правилами пользования сетью" размещенными в сети Интернет и являющимися обычаем делового оборота;</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE>
  <TR>
   <TD width="5%" />
   <TD align="justify" width="95%">
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, распространять либо использовать идентификационные персональные данные (имена, адреса, телефоны и т.п.) третьих лиц, кроме случаев, когда эти лица прямо уполномочили Заказчика на такое использование;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">распространения и/или публикации любой информации, которая противоречит требованиям законодательства Российской Федерации, положениям лицензий Министерства связи РФ (Министерства информационных технологий и связи в РФ), нормам международного права, и ущемляет права третьих лиц, а так же перенаправление пользователей на ресурсы сети Интернет содержащих такую информацию;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">опубликования или распространения Заказчиком любой информации или программного обеспечения, которое содержит в себе коды, по своему действию соответствующие действию компьютерных вирусов или других компонентов, приравненных к ним;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">рекламирования товаров, услуг, иных материалов, распространение которых ограничено либо запрещено действующим законодательством Российской Федерации;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">фальсифицирования своего IР-адреса, а также адресов, используемых в других сетевых протоколах, при передаче данных в сеть Интернет;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">использования несуществующих обратных адресов при отправке электронных писем и других сообщений;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">осуществления действий, направленных на нарушение нормального функционирования элементов сети Интернет (компьютеров, другого оборудования или программного обеспечения), не принадлежащих Заказчику;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">осуществления действий, направленных на получение несанкционированного доступа к ресурсу Сети (компьютеру, другому оборудованию или информационному ресурсу), последующее использование такого доступа, а также уничтожение или модификация программного обеспечения или данных, не принадлежащих Заказчику, без согласования с владельцами этого программного обеспечения или данных либо администраторами данного информационного ресурса. Под несанкционированным доступом понимается любой доступ способом, отличным от предполагавшегося владельцем ресурса;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">осуществления действий по передаче компьютерам или оборудованию третьих лиц бессмысленной или бесполезной информации, создающей излишнюю (паразитную) нагрузку на эти компьютеры или оборудование, а также промежуточные участки  сети, в объемах, превышающих минимально необходимые для проверки связности сетей и доступности отдельных ее элементов;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">осуществления действий по сканированию узлов сетей с целью выявления внутренней структуры сетей, уязвимости безопасности, списков открытых портов и т.п., без явного согласия владельца проверяемого ресурса;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">осуществления иных действий, не предусмотренных Договором и/или Стандартами, но содержащих состав уголовного либо административного правонарушения, либо нарушающих права и законные интересы третьих лиц;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">если Исполнитель получает соответствующий запрос или указание со стороны какого-либо государственного, регулирующего или иного компетентного органа;</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.2.</TD>
   <TD align="justify" width="95%">Время приостановления оказания услуг по причинам, указанным в п. 2.1, не считается перерывом в оказании услуг и не может рассматриваться как нарушение Исполнителем своих обязательств, предусмотренных Договором и Приложениями к нему.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.3.</TD>
   <TD align="justify" width="95%">Приостановление оказания услуг и/или отключение программных или аппаратных средств Заказчика осуществляется до выполнения Заказчиком требований Исполнителя по устранению нарушений и не отменяет выполнения Заказчиком всех своих обязательств по Договору.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.5.</TD>
   <TD align="justify" width="95%">Исполнитель не гарантирует принятие почты Заказчика от удаленных сетей, функционирование которых привело к занесению адреса такой сети в списки, по которым программа доставки почты Исполнителя не осуществляет прием почты.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.6.</TD>
   <TD align="justify" width="95%">Исполнитель не контролирует содержание информации, хранимой, публикуемой или распространяемой Заказчиком с использованием предоставленных услуг, и не несет никакой ответственности за точность, качество и содержание такой информации.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.7.</TD>
   <TD align="justify" width="95%">Исполнитель не несет ответственности за содержание информационных узлов, создаваемых и поддерживаемых Заказчиком или пользователями, и не осуществляет какой-либо предварительной цензуры. В случае явного нарушения законодательства предоставление Услуг может быть приостановлено без предварительного предупреждения. При этом Исполнитель имеет право при необходимости контролировать содержание информационных ресурсов Заказчика или его пользователей.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.8.</TD>
   <TD align="justify" width="95%">Исполнитель не несет ответственности за нарушение прав третьих лиц, возникших в результате действий Заказчика, совершенных с использованием Услуг, предоставляемых Исполнителем.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.9.</TD>
   <TD align="justify" width="95%">Исполнитель не несет ответственности за качество каналов связи общего пользования, посредством которых осуществляется доступ к Услугам.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.10.</TD>
   <TD align="justify" width="95%">Исполнитель не несет ответственности по претензиям Заказчика к качеству соединения с сетью Интернет, связанным с качеством функционирования сетей других провайдеров, политикой обмена трафиком между провайдерами, с функционированием оборудования и программного обеспечения Заказчика и другими обстоятельствами, находящимися вне зоны компетенции, влияния и контроля Исполнителя.</TD>
  </TR>
 </TABLE>
 <H2>3. Порядок обработки заявок СТП</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.1.</TD>
   <TD align="justify" width="95%">СТП осуществляет управление, контроль над работой технического оборудования и системных программных средств, обеспечивает предоставление надлежащего сервиса Заказчику в пределах, обусловленных Договором, а также осуществляет обработку запросов Заказчика.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.2.</TD>
   <TD align="justify" width="95%">
    <SPAN>Каждая заявка имеет приоритет исполнения. Заказчик выставляет приоритет заявке по следующему правилу:</SPAN>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">Высокий - используется только в случаях крайней необходимости, если виртуальный web-сервер Заказчика и/или один из сервисов (MYSQL, FTP, POP/SMTP) недоступен.</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">Средний - проблемы технического характера, которые Заказчик не может устранить самостоятельно.</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">Низкий - вопросы, просьбы, предложения Заказчика, а также все остальное, что не вошло в другие приоритеты.</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.3.</TD>
   <TD align="justify" width="95%">
    <SPAN>Следующие действия выполняются СТП только при отправлении заявки посредством АСУ:</SPAN>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">удаление какой-либо информации Заказчика;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">изменение любых паролей доступа к ресурсам Заказчика;</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.4.</TD>
   <TD align="justify" width="95%">Заказчик также может обратиться в СТП по телефону, однако изменения в конфигурации серверов производятся только на основании письменных заявок по каналам связи.</TD>
  </TR>
 </TABLE>
 <H2>4. Обеспечение информационной безопасности и целостности данных</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.</TD>
   <TD align="justify" width="95%">Исполнитель обеспечивает базовую информационную безопасность серверов и ресурсов Заказчика в пределах, определяемых обычными условиями, если только в Договоре явно не оговорено иное.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.</TD>
   <TD align="justify" width="95%">Исполнитель не несет ответственности за возможную компрометацию паролей Заказчика, произошедшую по его вине, но по требованию Заказчика производит оперативную смену таких паролей.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.3.</TD>
   <TD align="justify" width="95%">Исполнитель обеспечивает резервное копирование статической информации Заказчика, размещенной на серверах Исполнителя, по собственному графику (7 раз в неделю), если только такой график и порядок создания резервных копий не оговорены особо в условиях Договора.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.4.</TD>
   <TD align="justify" width="95%">В случаях, если потеря информации произошла по вине Исполнителя, он принимает все необходимые меры для максимально быстрого восстановления информации.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.5.</TD>
   <TD align="justify" width="95%">Если потеря данных была вызвана действиями Заказчика, восстановление данных производится по запросу в СТП в течение 48 часов.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.6.</TD>
   <TD align="justify" width="95%">Если в условиях Договора не оговорен особый режим резервного копирования (рассматриваемый как дополнительная услуга), восстановление производится из последнего архива.</TD>
  </TR>
 </TABLE>
 <H2>5. Функционирование программного обеспечения клиентов</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.1.</TD>
   <TD align="justify" width="95%">Исполнитель обеспечивает работоспособность предоставляемых сервисов и их совместимость с другим программным обеспечением в пределах, определяемых документацией на соответствующие сервисы.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.2.</TD>
   <TD align="justify" width="95%">Исполнитель не гарантирует работоспособность и совместимость программного обеспечения, разработанного Заказчиком, или третьими лицами. Программные средства могут быть установлены и использованы Заказчиком без какой-либо гарантии со стороны Исполнителя.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.3.</TD>
   <TD align="justify" width="95%">Исполнитель не гарантирует работоспособность предоставленного им программного обеспечения в случае, если Заказчик вносил в это программное обеспечение свои изменения.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.</TD>
   <TD align="justify" width="95%">Исполнитель вправе приостанавливать, блокировать или запрещать использование Заказчиком программного обеспечения (ПО) в случае, если эксплуатация такого программного обеспечения приводит или может привести к аварийным ситуациям, нарушению системы безопасности, нарушению настоящего Регламента или условий Договора.</TD>
  </TR>
 </TABLE>
 <H2>6. Использование ресурсов системы</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.1.</TD>
   <TD align="justify" width="95%">Заказчик использует ресурсы системы Исполнителя в соответствии с тарифным планом, если только дополнительными соглашениями не оговорено иное.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.2.</TD>
   <TD align="justify" width="95%">В целях коллективной безопасности Исполнитель оставляет за собой право приостановить предоставление услуги Заказчику в случае нанесения им вреда Исполнителю, либо какому-либо из его клиентов.</TD>
  </TR>
 </TABLE>
	<table style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top"><a name="6.3"></a>6.3.</td>
				<td align="justify" width="95%">Исполнитель может в любой момент времени, по своему усмотрению, переместить аккаунт Заказчика на другой сервер Исполнителя.</td>
			</tr>
		</tbody>
	</table>
	<table style="width: 100%;">
			<tbody>
			<tr>
				<td valign="top"><a name="6.4"></a>6.4.</td>
				<td align="justify" width="95%">Исполнитель может ограничить доступ и/или лимиты ресурсов, использование которых Заказчиком приводит к сбоям в работе оборудования/программного обеспечения исполнителя, или мешает работе сайтов других клиентов.</td>
			</tr>
		</tbody>
	</table>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Enclosures/Types/HostingRules/Content','Регламент предоставления услуг хостинга',@Text);

-- SEPARATOR
set @Text = '<NOBODY>
 <P align="justify">Настоящий Регламент определяет порядок оказания услуг Исполнителем, своим Заказчикам по регистрации доменных имен, а так же, порядок использования таких услуг со стороны Заказчика или пользователя, порядок взаимодействия между Исполнителем и Заказчиком или пользователем, а также иные вопросы, не оговоренные явно в Договоре.</P>
 <H2>1. Термины и определения</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.1.</TD>
   <TD align="justify" width="95%">Домен - область пространства иерархических имен сети Интернет, которая обозначается уникальным доменным именем, обслуживается набором серверов доменных имен (DNS) и централизованно администрируется Администратором домена. Для каждого зарегистрированного доменного имени определен единственный Администратор.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.2.</TD>
   <TD align="justify" width="95%">Реестр - центральная база данных домена, содержащая информацию о зарегистрированных доменных именах, Администраторах доменов, иную информацию, необходимую для регистрации доменов.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.3.</TD>
   <TD align="justify" width="95%">Регистратор - юридическое лицо, оказывающее услуги по регистрации доменных имен и обеспечивающее передачу в Реестр необходимой информации.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.4.</TD>
   <TD align="justify" width="95%">Заявитель (Заказчик) - физическое или юридическое лицо, обратившееся за услугой по регистрации доменного имени и заключившее с этой целью Договор с Исполнителем.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.5.</TD>
   <TD align="justify" width="95%">Регистрация доменного имени - занесение Регистратором в Реестр на основании заявки Заявителя информации о доменном имени и его Администраторе. Доменное имя считается зарегистрированным с момента занесения в Реестр информации о нем. Срок действия регистрации, в течение которого осуществляется хранение в Реестре информации о доменном имени, равен количеству лет, которое оплатил Заказчик. Регистрация домена может быть продлена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.6.</TD>
   <TD align="justify" width="95%">Администратор домена - лицо, на имя которого зарегистрирован домен. Администратор домена определяет порядок использования домена; несет ответственность за выбор доменного имени, возможные нарушения прав третьих лиц, связанные с выбором и использованием доменного имени, а также несет риск убытков, связанных с такими нарушениями.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.7.</TD>
   <TD align="justify" width="95%">Администрирование домена - определение Администратором домена порядка использования домена и осуществление организационной и технической поддержки его функционирования.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.8.</TD>
   <TD align="justify" width="95%">Аннулирование регистрации (освобождение доменного имени) - исключение информации о доменном имени и его Администраторе из Реестра.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.9.</TD>
   <TD align="justify" width="95%">Делегирование домена - размещение и хранение информации о доменном имени и соответствующих ему серверах доменных имен (DNS) на корневых серверах DNS домена, что обеспечивает функционирование домена в сети Интернет. Делегирование домена возможно только в течение срока действия регистрации домена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">1.10.</TD>
   <TD align="justify" width="95%">Заявка (Заказ) - обращение Исполнителя к Регистратору по установленной Регистратором форме, содержащее все необходимые сведения для регистрации (продления срока действия регистрации) доменного имени, либо изменяющие ранее сообщенные сведения.</TD>
  </TR>
 </TABLE>
 <H2>2. Общие положения</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.1.</TD>
   <TD align="justify" width="95%">Исполнитель осуществляет деятельность по регистрации доменных имен на основании договоров с Регистраторами доменов.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.2.</TD>
   <TD align="justify" width="95%">Заказ услуги является согласием Заказчика оплатить услугу по ценам, действующим на день начала исполнения Заказа.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.3.</TD>
   <TD align="justify" width="95%">Услуга предоставляется Заказчику на основании Договора, при наличии Заказа на услугу и при условии выполнения всех необходимых требований настоящего Регламента.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.4.</TD>
   <TD align="justify" width="95%">Услуга по регистрации домена считается оказанной с момента внесения в Реестр информации о домене.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">2.5.</TD>
   <TD align="justify" width="95%">Услуга по продлению регистрации домена считается оказанной с момента внесения в Реестр сведений о продлении регистрации на кол-во лет, которое оплатил Заказчик.</TD>
  </TR>
 </TABLE>
 <H2>3. Условия регистрации и делегирования доменов</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.1.</TD>
   <TD align="justify" width="95%">
    <SPAN>Условия регистрации домена. Регистрация домена не осуществляется в следующих случаях:</SPAN>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.1.1.</TD>
   <TD align="justify" width="95%">Доменное имя уже зарегистрировано.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.1.2</TD>
   <TD align="justify" width="95%">Доменное имя не удовлетворяет следующим требованиям:
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">не содержит минимального колличества символов в имени домена, определенного для выбранной доменной зоны или является зарезервированным и не доступным для публичного использования именем;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">•</TD>
      <TD align="justify" width="98%">в качестве доменного имени используются слова, противоречащие общественным интересам, принципам гуманности и морали (в частности, слова непристойного содержания, призывы антигуманного характера, оскорбляющие человеческое достоинство либо религиозные чувства, и т.д.)</TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.2.</TD>
   <TD align="justify" width="95%">
    <SPAN>Условия делегирования домена</SPAN>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.2.1.</TD>
   <TD align="justify" width="95%">
     <SPAN>Делегирование домена может быть осуществлено только после получения положительных результатов проверки правильности функционирования указанных Заказчиком серверов доменных имен (primary и secondary DNS), содержащих конфигурационные файлы зарегистрированного домена.</SPAN>
     <P>По крайней мере два из заявленных Заказчиком DNS-серверов должны иметь разные IP адреса и иметь надежное подключение к сети Интернет. Под "надежным подключением" понимается такое, при котором суммарное время отсутствия связи с сервером не превышает двух часов в сутки. Сопровождение указанных серверов должно соответствовать требованиям, изложенным в международных стандартах RFC-1032, RFC-1033, RFC-1034 и RFC-1591.</P>
     <P>В случае неполучения положительных результатов проверки правильности функционирования серверов доменных имен тестирование DNS-серверов прекращается. Повторная процедура тестирования DNS-серверов инициируется Заказчиком с использованием Web-интерфейса Исполнителя.</P>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.2.2.</TD>
   <TD align="justify" width="95%">Информация, касающаяся серверов доменных имен, должна соответствовать текущему состоянию сети.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">3.2.3.</TD>
   <TD align="justify" width="95%">Исполнитель, в случае невыполнения условий, изложенных в пунктах 3.2.1 и 3.2.2 настоящего Регламента, вправе в течение всего срока действия регистрации прекратить делегирование домена. Делегирование может быть восстановлено только после устранения указанных нарушений.</TD>
  </TR>
 </TABLE>
 <H2>4. Обработка Заказа на регистрацию домена</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.</TD>
   <TD align="justify" width="95%">Порядок обработки Заказа</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.1.</TD>
   <TD align="justify" width="95%">Формирование Заказа на оказание новой услуги осуществляется Заказчиком с использованием Web-интерфейса Исполнителя.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.2.</TD>
   <TD align="justify" width="95%">Аннулирование Заказа на оказание новой услуги может быть произведено Заказчиком на Web-сервере Исполнителя в разделе "Услуги - Домены - Заказы на домены" до момента начала исполнения Заказа.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.3.</TD>
   <TD align="justify" width="95%">Заказ считается готовым к исполнению и начинает исполняться с момента оплаты Заказчиком всех услуг в Заказе.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.4.</TD>
   <TD align="justify" width="95%">Заказы Заказчика на оказание новых услуг исполняются в порядке их поступления к Исполнителю.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.5.</TD>
   <TD align="justify" width="95%">Исполнитель проводит экспертизу Заказа на его соответствие требованиям, изложенным в настоящем Регламенте. В период проведения экспертизы до принятия решения по Заказу Исполнитель вправе запросить у Заказчика дополнительные сведения, необходимые для проведения экспертизы.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.6.</TD>
   <TD align="justify" width="95%">Исполнитель принимает решение о возможности регистрации заявленного домена, либо об отказе в регистрации по основаниям, предусмотренным настоящим Регламентом.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.7.</TD>
   <TD align="justify" width="95%">В случае возникновения сомнений в возможности регистрации какого-либо домена по основаниям, предусмотренным настоящим Регламентом, Исполнитель вправе приостановить регистрацию данного домена на срок не более 15 (пятнадцати) дней. По истечении этого срока Исполнитель обязан зарегистрировать домен, либо выдать мотивированный отказ в регистрации.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.8.</TD>
   <TD align="justify" width="95%">При наличии оснований для отказа в регистрации Исполнитель информирует Заказчика о невозможности регистрации заявленного им домена и об основаниях такого отказа.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.1.9.</TD>
   <TD align="justify" width="95%">Решение о регистрации, об отказе в регистрации, либо о приостановке исполнения Заказа, направляется Заказчику не позднее 2 (двух) рабочих дней с момента начала исполнения Заказа.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.</TD>
   <TD align="justify" width="95%">Особые условия</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.1.</TD>
   <TD align="justify" width="95%">Все сведения, предоставленные Заказчиком при регистрации в базе данных Исполнителя и заключении Договора, должны быть достоверными. В случае предоставления Заказчиком недостоверных сведений регистрация может быть аннулирована (домен освобожден).</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.2.</TD>
   <TD align="justify" width="95%">Исполнитель, в случае возникновения сомнений в достоверности предоставленных Заказчиком для регистрации домена данных, вправе в течение всего срока действия регистрации запросить дополнительные сведения и (или) потребовать подтверждения предоставленных. Запрос направляется по электронной почте на контактный адрес Заказчика, указанный в Договоре.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.3.</TD>
   <TD align="justify" width="95%">Исполнитель, в случае непредоставления Заказчиком дополнительных сведений и (или) неподтверждения ранее предоставленных данных в течение десяти календарных дней с момента первого запроса, вправе приостановить делегирование доменов Заказчика. Делегирование доменов может быть восстановлено в течение 3 (трех) рабочих дней с момента предоставления требуемой информации.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">4.2.4.</TD>
   <TD align="justify" width="95%"><SPAN>Регистрация домена аннулируется до истечения срока ее действия в следующих случаях:</SPAN>
    <TABLE width="100%">
     <TR>
      <TD valign="top">а)</TD>
      <TD align="justify" width="98%">по письменному заявлению Администратора домена;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">б)</TD>
      <TD align="justify" width="98%">в соответствии с п. 4.2.3 настоящего Регламента;</TD>
     </TR>
    </TABLE>
    <TABLE width="100%">
     <TR>
      <TD valign="top">в)</TD>
      <TD align="justify" width="98%">
       <SPAN>по вступившему в законную силу решению суда:</SPAN>
       <TABLE width="100%">
        <TR>
         <TD valign="top">•</TD>
         <TD align="justify" width="98%">признающему администрирование домена его Администратором нарушением прав истца;</TD>
        </TR>
       </TABLE>
       <TABLE width="100%">
        <TR>
         <TD valign="top">•</TD>
         <TD align="justify" width="98%">и(или) запрещающему использование в доменном имени обозначения, правами на которое обладает истец.</TD>
        </TR>
       </TABLE>
      </TD>
     </TR>
    </TABLE>
    <P>При этом преимущественным правом на регистрацию аннулированного домена обладает лицо, чьи права суд признал нарушенными. Для реализации преимущественного права указанное лицо обязано направить письменный запрос в адрес Исполнителя в срок не позднее 60 (шестидесяти) календарных дней со дня вступления решения суда в законную силу.</P>
   </TD>
  </TR>
 </TABLE>
 <table style="width: 100%;">
  <tbody>
  <tr>
   <td valign="top">4.2.5.</td>
   <td align="justify" width="95%">Регистрация так называемых "премиум" доменов возможна только в ручном режиме. При попытке регистрации такого домена в автоматическом режиме, производится автоматический возврат средств на расчётный счёт клиента в системе.</td>
  </tr>
 </tbody>
 </table>
 <H2>5. Продление регистрации домена</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.1.</TD>
   <TD align="justify" width="95%">Продление регистрации домена обеспечивает хранение в Реестре информации о домене на срок, равный количеству лет, заказанному заказчиком.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.2.</TD>
   <TD align="justify" width="95%">Делегирование домена приостанавливается Исполнителем, если регистрация домена не продлена Заказчиком до окончания срока ее действия. В случае продления регистрации до момента ее аннулирования, делегирование домена восстанавливается Исполнителем в течение 3 (трех) рабочих дней.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.3.</TD>
   <TD align="justify" width="95%">Регистрация домена аннулируется Исполнителем, если ее действие не будет продлено Заказчиком в течение 30 (тридцати) календарных дней с даты окончания срока регистрации домена. Срок аннулирования регистрации доменного имени может быть установлен или изменён на другой вышестоящим регистратором доменных имён, без предварительного уведомления.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.</TD>
   <TD align="justify" width="95%">Порядок продления регистрации
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.1.</TD>
   <TD align="justify" width="95%">Исполнитель направляет на контактные адреса электронной почты, указанные в Договоре Заказчика, уведомление о необходимости продления регистрации домена за два месяца до окончания срока регистрации домена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.2.</TD>
   <TD align="justify" width="95%">Продление регистрации домена производится Исполнителем при наличии оплаченного заказа на продление домена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.3.</TD>
   <TD align="justify" width="95%">Подать заявку на продление регистрации домена Заказчик может на Web-сервере Исполнителя в разделе "Услуги - Домены - Заказы на домены" (кнопка "оплатить/продлить домен").</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">5.4.4.</TD>
   <TD align="justify" width="95%">Отсутствие отказа от продления регистрации домена подтверждает согласие Заказчика на оказание ему услуги по продлению.</TD>
  </TR>
 </TABLE>
 <H2>6. Изменение данных Администратора домена.</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.1.</TD>
   <TD align="justify" width="95%">Параметры услуги по регистрации домена - данные технического характера, определяющие порядок функционирования домена. Данные Администратора домена - идентификационные и контактные данные Администратора домена, которые вносятся в Реестр при оказании услуги по регистрации домена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.2.</TD>
   <TD align="justify" width="95%">Изменить данные Администратора домена или изменить параметры услуги по регистрации домена можно только после того, как процедура исполнения Заказа на оказание услуги по регистрации домена завершена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.3.</TD>
   <TD align="justify" width="95%">Изменение данных Администратора домена в Реестре</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.3.1.</TD>
   <TD align="justify" width="95%">
    <SPAN>Изменение контактных данных Заказчика в Договоре</SPAN>
    <P>К контактным данным Заказчика относятся: номер телефона, номер факса, адреса электронной почты, почтовый адрес. Внесение изменений производится на Web-сервере Исполнителя в разделе "Мой офис - Мои профили".</P>
    <P>Изменение контактных данных Заказчика в Договоре будет произведено в течение 3 (трех) рабочих дней.</P>
   </TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">6.3.2.</TD>
   <TD align="justify" width="95%">
    <SPAN>Изменение идентификационных данных Заказчика в Договоре</SPAN>
    <P>К идентификационным данным Заказчика относятся: название организации, юридический адрес, ИНН, ФИО, паспортные данные, дата рождения. Изменение идентификационных данных производится по официальному письму Заказчика к Регистратору. Формы писем приведены на Web-сервере Регистратора.</P>
   </TD>
  </TR>
 </TABLE>
 <H2>7. Передача домена</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">7.1.</TD>
   <TD align="justify" width="95%">Передача домена иному юридическому или физическому лицу, заключившему с соответствующим Регистратором Договор в письменной форме на оказание услуг, может быть осуществлена на основании официального письма Администратора домена к соответствующему Регистратору. Формы таких писем приведены на Web-сервере Регистраторов.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">7.2.</TD>
   <TD align="justify" width="95%">При получения Регистратором официального письма от Администратора домена о передаче домена иному лицу, заключившему с Регистратором Договор в письменной форме на оказание услуг, а также официального письма от лица, которому передается домен, подтверждающего намерение стать Администратором домена, Регистратор производит действия по передаче домена и уведомляет об этом прежнего и нового Администраторов домена.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">7.3.</TD>
   <TD align="justify" width="95%">Условия и сроки действий описанных в п. 7.2 могут быть различными для разных Регистраторов.</TD>
  </TR>
 </TABLE>
 <HR BREAK="" />
 <H2>8. Переход к иному Регистратору</H2>
 <TABLE width="100%">
  <TR>
   <TD valign="top">8.1.</TD>
   <TD align="justify" width="95%">Администратор домена вправе передать вновь выбранному Регистратору обязанность по внесению в Реестр информации о доменном имени и его Администраторе.</TD>
  </TR>
 </TABLE>
 <TABLE width="100%">
  <TR>
   <TD valign="top">8.2.</TD>
   <TD align="justify" width="95%">Условия смены Регистратора могут быть различными у разных Регистраторов, поэтому подробную информацию необходимо уточнять у соответствующего Регистратора.</TD>
  </TR>
 </TABLE>
</NOBODY>';

INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Enclosures/Types/DomainRules/Content','Регламент на услуги регистрации и продления доменов',@Text);


-- SEPARATOR
/* added by lissyara 2011-08-03 in 16:08 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES (4,100,100, 'Contracts/Enclosures/Types/VPSRules/Content', 'Регламент предоставления услуг VPS', 'no', 'yes', 'yes', '<NOBODY>
 <P align="justify">
 Настоящий Регламент определяет порядок оказания услуг Исполнителем, своим Заказчикам по размещению виртуального сервера на оборудовании исполнителя, а так же, порядок использования таких услуг со стороны Заказчика или пользователя, порядок взаимодействия между Исполнителем и Заказчиком или пользователем, а также иные вопросы, не оговоренные явно в Договоре.
</P>
 <H2>
 1. Предоставление услуг
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.1.
   </TD>
    <TD align="justify" width="95%">
    Учитывая, что Интернет распространен практически во всех государствах мира, имеющих различное законодательство, Исполнитель настоящим Договором предупреждает Заказчика, что случайные или намеренные действия в Интернет могут привести к нарушению национального законодательства других стран. Исполнитель не несет ответственности за такие возможные нарушения со стороны Заказчика.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.2.
   </TD>
    <TD align="justify" width="95%">
    Заказчик принимает на себя полную ответственность и риски, связанные с использованием сети Интернет посредством Услуг, в том числе ответственность за оценку точности, полноты и полезности любых мнений, идей, иной информации, а также свойств товаров и услуг, распространяемых в Интернет и предоставляемых Заказчику посредством Услуг.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.3.
   </TD>
    <TD align="justify" width="95%">
    В случае если Заказчик предоставляет третьим лицам доступ к имеющимся у него ресурсам и сервисам, ответственность за деятельность таких третьих лиц несет исключительно Заказчик.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 2. Права и ответственность сторон
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.1.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Исполнитель, сохраняя за собой все права по Договору вправе незамедлительно приостановить оказание услуг в случаях:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        если по обоснованному мнению Исполнителя использование Заказчиком услуг может нанести ущерб Исполнителю и/или вызвать сбой технических и программных средств Исполнителя и третьих лиц;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, передавать, воспроизводить, распространять, любым способом, а так же в любом виде использовать полученные посредством услуг программное обеспечение и/или другие материалы, полностью или частично защищенные авторскими и другими правами, без разрешения правообладателя;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        публикации и/или передачи со стороны Заказчика, с использованием оборудования Исполнителя, любой информации, относящейся к пропаганде жестокости, насилия, совершению террористических актов, разжиганию расовой, национальной, религиозной вражды, пропаганде войны.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, передавать, распространять любым способом любую информацию или программное обеспечение, которое содержит в себе какие-либо вредоносные компоненты;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать содержащую рекламу информацию (спам) без согласия со стороны адресата при наличие письменных заявлений от получателей такой рассылки на имя Исполнителя с обоснованными претензиями на адрес Заказчика. При этом понятие &quot;спам&quot; определяется общеизвестными &quot;правилами пользования сетью&quot; размещенными в сети Интернет и являющимися обычаем делового оборота;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <HR />
 <TABLE>
  <TBODY>
   <TR>
    <TD width="5%"></TD>
    <TD align="justify" width="95%">
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, распространять либо использовать идентификационные персональные данные (имена, адреса, телефоны и т.п.) третьих лиц, кроме случаев, когда эти лица прямо уполномочили Заказчика на такое использование;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        распространения и/или публикации любой информации, которая противоречит требованиям законодательства Российской Федерации, положениям лицензий Министерства связи РФ (Министерства информационных технологий и связи в РФ), нормам международного права, и ущемляет права третьих лиц, а так же перенаправление пользователей на ресурсы сети Интернет содержащих такую информацию;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        опубликования или распространения Заказчиком любой информации или программного обеспечения, которое содержит в себе коды, по своему действию соответствующие действию компьютерных вирусов или других компонентов, приравненных к ним;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        рекламирования товаров, услуг, иных материалов, распространение которых ограничено либо запрещено действующим законодательством Российской Федерации;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        фальсифицирования своего IР-адреса, а также адресов, используемых в других сетевых протоколах, при передаче данных в сеть Интернет;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        использования несуществующих обратных адресов при отправке электронных писем и других сообщений;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий, направленных на нарушение нормального функционирования элементов сети Интернет (компьютеров, другого оборудования или программного обеспечения), не принадлежащих Заказчику;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий, направленных на получение несанкционированного доступа к ресурсу Сети (компьютеру, другому оборудованию или информационному ресурсу), последующее использование такого доступа, а также уничтожение или модификация программного обеспечения или данных, не принадлежащих Заказчику, без согласования с владельцами этого программного обеспечения или данных либо администраторами данного информационного ресурса. Под несанкционированным доступом понимается любой доступ способом, отличным от предполагавшегося владельцем ресурса;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий по передаче компьютерам или оборудованию третьих лиц бессмысленной или бесполезной информации, создающей излишнюю (паразитную) нагрузку на эти компьютеры или оборудование, а также промежуточные участки сети, в объемах, превышающих минимально необходимые для проверки связности сетей и доступности отдельных ее элементов;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий по сканированию узлов сетей с целью выявления внутренней структуры сетей, уязвимости безопасности, списков открытых портов и т.п., без явного согласия владельца проверяемого ресурса;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления иных действий, не предусмотренных Договором и/или Стандартами, но содержащих состав уголовного либо административного правонарушения, либо нарушающих права и законные интересы третьих лиц;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        если Исполнитель получает соответствующий запрос или указание со стороны какого-либо государственного, регулирующего или иного компетентного органа;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.2.
   </TD>
    <TD align="justify" width="95%">
    Время приостановления оказания услуг по причинам, указанным в п. 2.1, не считается перерывом в оказании услуг и не может рассматриваться как нарушение Исполнителем своих обязательств, предусмотренных Договором и Приложениями к нему.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.3.
   </TD>
    <TD align="justify" width="95%">
    Приостановление оказания услуг и/или отключение программных или аппаратных средств Заказчика осуществляется до выполнения Заказчиком требований Исполнителя по устранению нарушений и не отменяет выполнения Заказчиком всех своих обязательств по Договору.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <HR />
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.4.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не гарантирует принятие почты Заказчика от удаленных сетей, функционирование которых привело к занесению адреса такой сети в списки, по которым программа доставки почты Исполнителя не осуществляет прием почты.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.5.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не контролирует содержание информации, хранимой, публикуемой или распространяемой Заказчиком с использованием предоставленных услуг, и не несет никакой ответственности за точность, качество и содержание такой информации.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.6.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за содержание информационных узлов, создаваемых и поддерживаемых Заказчиком или пользователями, и не осуществляет какой-либо предварительной цензуры. В случае явного нарушения законодательства предоставление Услуг может быть приостановлено без предварительного предупреждения. При этом Исполнитель имеет право при необходимости контролировать содержание информационных ресурсов Заказчика или его пользователей.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.7.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за нарушение прав третьих лиц, возникших в результате действий Заказчика, совершенных с использованием Услуг, предоставляемых Исполнителем.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.8.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за качество каналов связи общего пользования, посредством которых осуществляется доступ к Услугам.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.9.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности по претензиям Заказчика к качеству соединения с сетью Интернет, связанным с качеством функционирования сетей других провайдеров, политикой обмена трафиком между провайдерами, с функционированием оборудования и программного обеспечения Заказчика и другими обстоятельствами, находящимися вне зоны компетенции, влияния и контроля Исполнителя.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 3. Порядок обработки заявок СТП
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.1.
   </TD>
    <TD align="justify" width="95%">
    СТП осуществляет управление, контроль над работой технического оборудования и системных программных средств, обеспечивает предоставление надлежащего сервиса Заказчику в пределах, обусловленных Договором, а также осуществляет обработку запросов Заказчика.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.2.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Каждая заявка имеет приоритет исполнения. Заказчик выставляет приоритет заявке по следующему правилу:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Высокий - используется только в случаях крайней необходимости, если недоступен виртуальный web-сервер Заказчика.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Средний - проблемы технического характера, которые Заказчик не можете устранить самостоятельно.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Низкий - вопросы, просьбы, предложения Заказчика, а также все остальное, что не вошло в другие приоритеты.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.3.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Следующие действия выполняются СТП только при отправлении заявки посредством АСУ:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        удаление какой-либо информации Заказчика;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        изменение любых паролей доступа к ресурсам Заказчика;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.4.
   </TD>
    <TD align="justify" width="95%">
    Заказчик также может обратиться в СТП по телефону, однако изменения в конфигурации серверов производятся только на основании письменных заявок по каналам связи.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 4. Обеспечение информационной безопасности и целостности данных
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.1.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель обеспечивает базовую информационную безопасность серверов и ресурсов Заказчика в пределах, определяемых обычными условиями, если только в Договоре явно не оговорено иное.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.2.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за возможную компрометацию паролей Заказчика, произошедшую по его вине, но по требованию Заказчика производит оперативную смену таких паролей.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <HR />
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.3.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не производит резервное копирование статической информации Заказчика, если только такой график и порядок создания резервных копий не оговорены особо в условиях Договора.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.4.
   </TD>
    <TD align="justify" width="95%">
    В случаях, если потеря информации произошла по вине Исполнителя, он принимает все необходимые меры для максимально быстрого восстановления информации.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.5.
   </TD>
    <TD align="justify" width="95%">
    Если потеря данных была вызвана действиями Заказчика, восстановление данных производится по запросу в СТП в течение 48 часов, при наличии резервной копии. Услуга восстановления данных является платной, стоимость услуги равна стоимости тарифного плана заказчика за месяц, но не менее 300 рублей.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.6.
   </TD>
    <TD align="justify" width="95%">
    Если в условиях Договора не оговорен особый режим резервного копирования (рассматриваемый как дополнительная услуга), восстановление производится из последнего архива.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 5. Функционирование программного обеспечения клиентов
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    5.1.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель обеспечивает работоспособность предоставляемых сервисов и их совместимость с другим программным обеспечением в пределах, определяемых документацией на соответствующие сервисы.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    5.2.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не гарантирует работоспособность и совместимость программного обеспечения, разработанного Заказчиком, или третьими лицами. Программные средства могут быть установлены и использованы Заказчиком без какой-либо гарантии со стороны Исполнителя.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    5.3.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не гарантирует работоспособность предоставленного им программного обеспечения в случае, если Заказчик вносил в это программное обеспечение свои изменения.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    5.4.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель вправе приостанавливать, блокировать или запрещать использование Заказчиком программного обеспечения (ПО) в случае, если эксплуатация такого программного обеспечения приводит или может привести к аварийным ситуациям, нарушению системы безопасности, нарушению настоящего Регламента или условий Договора.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 6. Использование ресурсов системы
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    6.1.
   </TD>
    <TD align="justify" width="95%">
    Заказчик использует ресурсы системы Исполнителя в соответствии с тарифным планом, если только дополнительными соглашениями не оговорено иное.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    6.2.
   </TD>
    <TD align="justify" width="95%">
    В целях коллективной безопасности Исполнитель оставляет за собой право приостановить предоставление услуги Заказчику в случае нанесения им вреда Исполнителю, либо какому-либо из его клиентов.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
	<table style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top"><a name="6.3"></a>6.3.</td>
				<td align="justify" width="95%">Исполнитель может в любой момент времени, по своему усмотрению, переместить аккаунт Заказчика на другой сервер Исполнителя.</td>
			</tr>
		</tbody>
	</table>
	<table style="width: 100%;">
			<tbody>
			<tr>
				<td valign="top"><a name="6.4"></a>6.4.</td>
				<td align="justify" width="95%">Исполнитель может ограничить доступ и/или лимиты ресурсов, использование которых Заказчиком приводит к сбоям в работе оборудования/программного обеспечения исполнителя, или мешает работе сайтов других клиентов.</td>
			</tr>
		</tbody>
	</table>
</NOBODY>
', 'yes');


-- SEPARATOR
/* added by lissyara 2011-12-07 in 16:02 MSK */
DELETE FROM `Clauses` WHERE `Partition` = 'Contracts/Enclosures/Types/DSRules/Content';
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`)
VALUES (4, 100, 100, 'Contracts/Enclosures/Types/DSRules/Content', 'Регламент предоставления услуг аренды сервера', 'no', 'yes', 'yes', 'yes', '<NOBODY>
 <P align="justify">
 Настоящий Регламент определяет порядок оказания услуг Исполнителем, своим Заказчикам по предоставлению оборудования исполнителя, а так же, порядок использования таких услуг со стороны Заказчика или пользователя, порядок взаимодействия между Исполнителем и Заказчиком или пользователем, а также иные вопросы, не оговоренные явно в Договоре.
</P>
 <H2>
 1. Предоставление услуг
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.1.
   </TD>
    <TD align="justify" width="95%">
    Учитывая, что Интернет распространен практически во всех государствах мира, имеющих различное законодательство, Исполнитель настоящим Договором предупреждает Заказчика, что случайные или намеренные действия в Интернет могут привести к нарушению национального законодательства 
других стран. Исполнитель не несет ответственности за такие возможные нарушения со стороны Заказчика.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.2.
   </TD>
    <TD align="justify" width="95%">
    Заказчик принимает на себя полную ответственность и риски, связанные с использованием сети Интернет посредством Услуг, в том числе ответственность за оценку точности, полноты и полезности любых мнений, идей, иной информации, а также свойств товаров и услуг, распространяемых в Интернет и предоставляемых Заказчику посредством Услуг.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    1.3.
   </TD>
    <TD align="justify" width="95%">
    В случае если Заказчик предоставляет третьим лицам доступ к имеющимся у него ресурсам и сервисам, ответственность за деятельность таких третьих лиц несет исключительно Заказчик.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>2. Права и ответственность сторон</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.1.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Исполнитель, сохраняя за собой все права по Договору вправе незамедлительно приостановить оказание услуг в случаях:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        если по обоснованному мнению Исполнителя использование Заказчиком услуг может нанести ущерб Исполнителю и/или вызвать сбой технических и программных средств Исполнителя и третьих лиц;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, передавать, воспроизводить, распространять, любым 
способом, а так же в любом виде использовать полученные посредством услуг программное обеспечение и/или другие материалы, полностью или частично защищенные авторскими и другими правами, без разрешения правообладателя;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        публикации и/или передачи со стороны Заказчика, с использованием оборудования Исполнителя, любой информации, относящейся к пропаганде жестокости, насилия, совершению террористических актов, разжиганию расовой, национальной, религиозной вражды, пропаганде войны.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, 
передавать, распространять любым способом любую информацию или программное обеспечение, которое содержит в себе какие-либо вредоносные компоненты;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать содержащую рекламу информацию (спам) без согласия со стороны адресата при наличие письменных заявлений от получателей такой рассылки на имя Исполнителя с обоснованными претензиями на адрес Заказчика. При этом понятие &quot;спам&quot; определяется общеизвестными &quot;правилами пользования сетью&quot; размещенными в сети Интернет и являющимися обычаем делового оборота;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE>
  <TBODY>
   <TR>
    <TD width="5%"></TD>
    <TD align="justify" width="95%">
     
<TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        наличия со стороны Заказчика действий, направленных на то, чтобы посылать, публиковать, распространять либо использовать идентификационные персональные данные (имена, адреса, телефоны и т.п.) третьих лиц, кроме случаев, когда эти лица прямо уполномочили Заказчика на такое использование;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        распространения и/или публикации любой информации, которая противоречит требованиям законодательства Российской Федерации, положениям лицензий Министерства связи РФ (Министерства информационных технологий и связи в РФ), нормам международного права, и ущемляет права третьих лиц, а так же перенаправление пользователей на ресурсы сети Интернет 
содержащих такую информацию;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        опубликования или распространения Заказчиком любой информации или программного обеспечения, которое содержит в себе коды, по своему действию соответствующие действию компьютерных вирусов или других компонентов, приравненных к ним;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        рекламирования товаров, услуг, иных материалов, распространение которых ограничено либо запрещено действующим законодательством Российской Федерации;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
   
    </TD>
        <TD align="justify" width="98%">
        фальсифицирования своего IР-адреса, а также адресов, используемых в других сетевых протоколах, при передаче данных в сеть Интернет;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        использования несуществующих обратных адресов при отправке электронных писем и других сообщений;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий, направленных на нарушение нормального функционирования элементов сети Интернет (компьютеров, другого оборудования или программного обеспечения), не принадлежащих Заказчику;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 
100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий, направленных на получение несанкционированного доступа к ресурсу Сети (компьютеру, другому оборудованию или информационному ресурсу), последующее использование такого доступа, а также уничтожение или модификация программного обеспечения или данных, не принадлежащих Заказчику, без согласования с владельцами этого программного обеспечения или данных либо администраторами данного информационного ресурса. Под несанкционированным доступом понимается любой доступ способом, отличным от предполагавшегося владельцем ресурса;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий по передаче компьютерам или оборудованию третьих лиц бессмысленной или бесполезной 
информации, создающей излишнюю (паразитную) нагрузку на эти компьютеры или оборудование, а также промежуточные участки сети, в объемах, превышающих минимально необходимые для проверки связности сетей и доступности отдельных ее элементов;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления действий по сканированию узлов сетей с целью выявления внутренней структуры сетей, уязвимости безопасности, списков открытых портов и т.п., без явного согласия владельца проверяемого ресурса;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        осуществления иных действий, не предусмотренных Договором и/или Стандартами, но содержащих состав уголовного либо 
административного правонарушения, либо нарушающих права и законные интересы третьих лиц;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        если Исполнитель получает соответствующий запрос или указание со стороны какого-либо государственного, регулирующего или иного компетентного органа;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        если Заказчик использует ресурсы Исполнителя для размещения прокси серверов, генерации паразитного траффика, постоянно использует более 30% полосы пропускания выделенного Заказчику канала связи с Интернет;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%
;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.2.
   </TD>
    <TD align="justify" width="95%">
    Время приостановления оказания услуг по причинам, указанным в п. 2.1, не считается перерывом в оказании услуг и не может рассматриваться как нарушение Исполнителем своих обязательств, предусмотренных Договором и Приложениями к нему.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.3.
   </TD>
    <TD align="justify" width="95%">
    Приостановление оказания услуг и/или отключение программных или аппаратных средств Заказчика осуществляется до выполнения Заказчиком требований Исполнителя по устранению нарушений и не отменяет выполнения Заказчиком всех своих обязательств по Договору.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.4.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не контролирует содержание информации, хранимой, 
публикуемой или распространяемой Заказчиком с использованием предоставленных услуг, и не несет никакой ответственности за точность, качество и содержание такой информации.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.5.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за содержание информационных узлов, создаваемых и поддерживаемых Заказчиком или пользователями, и не осуществляет какой-либо предварительной цензуры. В случае явного нарушения законодательства предоставление Услуг может быть приостановлено без предварительного предупреждения. При этом Исполнитель имеет право при необходимости контролировать содержание информационных ресурсов Заказчика или его пользователей.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.6.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за 
нарушение прав третьих лиц, возникших в результате действий Заказчика, совершенных с использованием Услуг, предоставляемых Исполнителем.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.7.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за качество каналов связи общего пользования, посредством которых осуществляется доступ к Услугам.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.8.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности по претензиям Заказчика к качеству соединения с сетью Интернет, связанным с качеством функционирования сетей других провайдеров, политикой обмена трафиком между провайдерами, с функционированием оборудования и программного обеспечения Заказчика и другими обстоятельствами, находящимися вне зоны компетенции, влияния и контроля Исполнителя.
   </TD>
   
</TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    2.9.
   </TD>
    <TD align="justify" width="95%">
    В случае отказа Заказчиком от оплаченного сервера, взимается стоимость установки сервера, в размере стоимости аренды за 30 (тридцать) календарных дней.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 3. Порядок обработки заявок СТП
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.1.
   </TD>
    <TD align="justify" width="95%">
    СТП осуществляет управление, контроль над работой технического оборудования и системных программных средств, обеспечивает предоставление надлежащего сервиса Заказчику в пределах, обусловленных Договором, а также осуществляет обработку запросов Заказчика.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.2.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Каждая заявка имеет приоритет 
исполнения. Заказчик выставляет приоритет заявке по следующему правилу:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Высокий - используется только в случаях крайней необходимости, если недоступен виртуальный web-сервер Заказчика.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Средний - проблемы технического характера, которые Заказчик не можете устранить самостоятельно.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        Низкий - вопросы, просьбы, предложения Заказчика, а также все остальное, что не вошло в другие приоритеты.
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.3.
   </TD>
    <TD align="justify" width="95%">
     <SPAN>Следующие действия выполняются СТП только при отправлении заявки посредством АСУ:</SPAN>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        удаление какой-либо информации Заказчика;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
     <TABLE style="width: 100%;">
      <TBODY>
       <TR>
        <TD valign="top">
        •
       </TD>
        <TD align="justify" width="98%">
        изменение любых паролей доступа к ресурсам Заказчика;
       </TD>
       </TR>
      </TBODY>
     </TABLE>
    </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    3.4.
   </TD>
    <TD 
align="justify" width="95%">
    Заказчик также может обратиться в СТП по телефону, однако изменения в конфигурации серверов производятся только на основании письменных заявок по каналам связи.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 4. Обеспечение информационной безопасности и целостности данных
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.1.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель обеспечивает базовую информационную безопасность серверов и ресурсов Заказчика в пределах, определяемых обычными условиями, если только в Договоре явно не оговорено иное.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    4.2.
   </TD>
    <TD align="justify" width="95%">
    Исполнитель не несет ответственности за возможную компрометацию паролей Заказчика, произошедшую по его вине, но по требованию Заказчика производит оперативную смену таких паролей.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
 <H2>
 6. Использование ресурсов системы
</H2>
 <TABLE style="width: 100%;">
  <TBODY>
   <TR>
    <TD valign="top">
    5.1.
   </TD>
    <TD align="justify" width="95%">
    Заказчик использует ресурсы системы Исполнителя в соответствии с тарифным планом, если только дополнительными соглашениями не оговорено иное.
   </TD>
   </TR>
  </TBODY>
 </TABLE>
	<TABLE style="width: 100%;">
	<TBODY>
		<TR>
			<TD valign="top">5.2.</TD>
			<TD align="justify" width="95%">В целях коллективной безопасности Исполнитель оставляет за собой право приостановить предоставление услуги Заказчику в случае нанесения им вреда Исполнителю, либо какому-либо из его клиентов.</TD>
		</TR>
	</TBODY>
	</TABLE>
	<table style="width: 100%;">
	<tbody>
		<tr>
			<td valign="top"><a name="5.3"></a>5.3.</td>
			<td align="justify" width="95%">Исполнитель может ограничить доступ и/или лимиты ресурсов, использование которых Заказчиком приводит к сбоям в работе оборудования/программного обеспечения исполнителя, или мешает работе виртуальных серверов других клиентов.</td>
		</tr>
	</tbody>
	</table>
</NOBODY>
');


-- SEPARATOR
/* added by lissyara 2012-02-24 in 11:21 MSK */
INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `Text`, `IsPublish`)
VALUES (4, 100, 100, 'Contracts/Enclosures/Types/ISPswRules/Content', 'Регламент предоставления услуг ПО ISPsystem', 'no', 'yes', 'yes', '<NOBODY>
<H2>
Приведенный ниже текст является публичной офертой.
</H2>
<P align="justify">
Публичной офертой является предложение, содержащее все существенные условия договора, из которого усматривается воля лица, делающего предложение, заключить договор на указанных в предложении условиях с любым, кто отзовется на это предложение.
</P>
<P align="justify">
Для того чтобы заключить договор, лицо, откликнувшееся на такое предложение, должно осуществить акцепт оферты, т.е. выразить свое согласие на заключение договора на условиях, изложенных в оферте.
</P>
<P align="justify">
Такое согласие, в частности, может быть выражено путем совершения указанных в оферте действий, определенных самой офертой как ее акцепт. Применительно к программе для ЭВМ таким действием может быть начало ее использования.
</P>
<P align="justify">
Приведенный ниже текст является публичной офертой компании «%Executor.CompanyName%». Акцепт этой оферты может быть осуществлен путем совершения указанных в оферте действий. Совершение этих действий, т.е. акцепт оферты, влечет за собой заключение между Вами и компанией «%Executor.CompanyName%» лицензионного договора о предоставлении Вам права использования выбранной Вами программы для ЭВМ.
</P>
<P align="justify">
В данном случае сделка будет считаться совершенной в письменной форме, т.е. заключенный таким способом договор будет обладать той же «юридической силой», что и договор, заключенный путем составления на бумажном носителе документа, подписанного сторонами (обычный «бумажный» договор).
</P>
<H2>
Предложение о заключении лицензионного договора (публичная оферта)
</H2>
<UL>
<LI>
<P align="justify">
%Executor.CompanyForm% «%Executor.CompanyName%» (далее – компания «%Executor.CompanyName%») адресует настоящую публичную оферту любому лицу, желающему использовать программу для ЭВМ «ISPmanager 4» или иную программу для ЭВМ, разработчиком и обладателем исключительного права на которую является компания «ISPsystem» (далее – Программный продукт), и обладающему аппаратными и (или) программными средствами, необходимыми для использования данной программы.
</P>
</LI>
<LI>
<P align="justify">
Акцептом настоящей оферты является:
</P>
<P align="justify">
установка Программного продукта, т.е. запись копии Программного продукта в память ЭВМ в целях последующего использования его функциональных возможностей – в случае, если данный Программный продукт не был установлен ранее,
</P>
<P align="justify">
либо
</P>
<P align="justify">
запуск и последующее использование функциональных возможностей Программного продукта – в случае, если Программный продукт уже был установлен и использовался на основании ранее действующего лицензионного договора с компанией «ISPsystem».
</P>
</LI>
<LI>Акцепт настоящей оферты, осуществленный в порядке, указанном выше в пункте II, означает согласие акцептирующего лица со всеми приведенными ниже в разделе «Лицензионный договор» условиями, а также условиями технического сопровождения Программных продуктов, изложенных в Регламенте технического сопровождения, размещенном на Интернет-сайте компании «ISPsystem», и влечет за собой заключение лицензионного договора между данным лицом и компанией «%Executor.CompanyName%» на определенных настоящей офертой условиях.
</LI>
<LI>Во всех случаях, когда в тексте настоящей оферты дается отсылка на иные тексты, размещенные на Интернет-сайте компании «%Executor.CompanyName%», данные тексты следует рассматривать как неотъемлемую часть настоящей оферты, если иное прямо не указано в самой оферте.
</LI>
</UL>
<H2>
ЛИЦЕНЗИОННЫЙ ДОГОВОР о предоставлении права использования программы для ЭВМ
</H2>
<H2>
1. Основные понятия и определения
</H2>
<P align="justify">
1.1. Правообладатель (компания «ISPsystem») – ЗАО «ИСПсистем».
</P>
<P align="justify">
1.2. Лицензиар – компания «%Executor.CompanyName%».
</P>
<P align="justify">
1.3. Пользователь (лицензиат) – любое лицо, акцептировавшее настоящую оферту в порядке, указанном выше в пункте II, и тем самым заключившее Лицензионный договор с компанией «%Executor.CompanyName%».
</P>
<P align="justify">
1.4. Лицензионный договор (Лицензия) – настоящий сублицензионный договор о предоставлении права использования программы для ЭВМ, приобретенного компанией «%Executor.CompanyName%» на основании лицензионного договора с Правообладателем и предоставляемого Пользователю с письменного согласия Правообладателя.
</P>
<P align="justify">
1.5. Программный продукт – программа для ЭВМ «ISPmanager 4» или иная программа для ЭВМ, разработчиком и обладателем исключительного права на которую является компания «ISPsystem».
</P>
<P align="justify">
Перечень Программных продуктов, права использования которых могут быть предоставлены на условиях настоящего Лицензионного договора, приведен на Интернет-сайте компании «%Executor.CompanyName%».
</P>
<P align="justify">
Описание программных продуктов, в том числе информация о поддерживаемых ими операционных системах, приведены на Интернет-сайте компании «ISPsystem».
</P>
<P align="justify">
1.6. Сопутствующие материалы – представленные в письменной форме, а также в форме изображения или иной форме материалы, представляющие собой описание Программного продукта, инструкции по его установке, настройке и использованию и т.п.
</P>
<P align="justify">
1.7. Ключи активации – элемент системы технических средств защиты авторских прав, используемой компанией «ISPsystem» для защиты Программных продуктов от неправомерного использования.
</P>
<P align="justify">
1.8. Интернет-сайт компании «%Executor.CompanyName%» – совокупность веб-страниц, размещенных в информационно-телекоммуникационной сети Интернет и объединенных единым адресным пространством домена %Executor.SiteURL%
</P>
<P align="justify">
1.9. Интернет-сайт компании «ISPsystem» – совокупность веб-страниц, размещенных в информационно-телекоммуникационной сети Интернет и объединенных единым адресным пространством домена ispsystem.com
</P>
<H2>
2. Способы использования Программного продукта
</H2>
<P align="justify">
2.1. Пользователю предоставляется право использования Программного продукта следующими способами:
</P>
<P align="justify">
2.1.1. путем воспроизведения Программного продукта посредством записи одной копии Программного продукта в память ЭВМ; Пользователь также вправе изготовить в любой форме резервную копию Программного продукта для замены оригинальной копии, в случае если она будет утеряна, уничтожена или станет непригодной для использования;
</P>
<P align="justify">
2.1.2. путем доведения Программного продукта до всеобщего сведения таким образом, что любое или определенное Пользователем лицо могло получить к нему доступ по информационно-телекоммуникационной сети, в том числе сети Интернет; при этом доведение до всеобщего сведения может быть осуществлено исключительно такими способами, при которых третьим лицам предоставляется доступ только к порождаемым Программным продуктом аудиовизуальным отображениям и (или) предоставляется возможность интерактивного взаимодействия с функциональной частью Программного продукта;
</P>
<P align="justify">
2.1.3. путем распространения Программного продукта посредством продажи или иного отчуждения его экземпляров исключительно в тех случаях, когда распространение осуществляется путем продажи или иного отчуждения Пользователем сервера (ЭВМ) с установленным на нем Программным продуктом, при условии, что записанная в память сервера (ЭВМ) копия Программного продукта (соответствующий данной копии Ключ активации) была приобретена Пользователем правомерно;
</P>
<P align="justify">
2.1.4. путем публичного показа Программного продукта, т.е. публичного показа порождаемых им аудиовизуальных отображений, публичной демонстрации функциональных возможностей Программного продукта.
</P>
<P align="justify">
2.2. Право использования Программного продукта предоставляется Пользователю со следующими ограничениями:
</P>
<P align="justify">
2.2.1. Пользователю запрещается реализовывать предоставленное ему право на доведение Программного продукта до всеобщего сведения каким-либо способом, при котором третьим лицам предоставляется фактическая возможность воспроизведения Программного продукта полностью или частично, за исключением записи части Программного продукта в память ЭВМ, когда такая запись является временной и составляет неотъемлемую и существенную часть технологического процесса, имеющего единственной целью просмотр порождаемых Программным продуктом аудиовизуальных отображений и (или) интерактивное взаимодействие с функциональной частью Программного продукта; также запрещается доводить Программный продукт до всеобщего сведения таким способом, при котором использование функциональных возможностей Программного продукта третьими лицами становится возможным без подключения к информационно-телекоммуникационной сети;
</P>
<P align="justify">
2.2.2. Пользователю запрещается модифицировать Программный продукт, т.е. вносить в него любые изменения, за исключением:
</P>
<UL>
<LI>изменения настроек Программного продукта или иных подобных изменений, осуществляемых путем использования описанных в документации (Сопроводительных материалах) возможностей пользовательского интерфейса Программного продукта;
</LI>
<LI>адаптации, т.е. изменений, независимо от способа их осуществления, которые производятся исключительно в целях функционирования Программного продукта на конкретных технических средствах Пользователя или под управлением конкретных программ Пользователя; при этом в случае, если в результате адаптации Программного продукта будет изменен его объектный код, Пользователю может быть отказано в техническом сопровождении Программного продукта без возмещения возможных убытков;
</LI>
<LI>установки обновлений Программного продукта, выпущенных компанией «ISPsystem»;
</LI>
</UL>
<P align="justify">
2.2.3. за исключением предусмотренных законом случаев Пользователю запрещается декомпилировать Программный продукт, а также осуществлять любые иные действия, направленные на восстановление исходного кода (исходного текста) Программного продукта;
</P>
<P align="justify">
2.2.4. при любом использовании Программного продукта Пользователю запрещается осуществлять какие-либо действия, результатом которых является изменение или удаление порождаемых Программным продуктом визуальных отображений товарного знака, знака обслуживания, коммерческого обозначения или знака охраны авторского права; также запрещается осуществлять любые действия, в результате которых существенно затрудняется распознавание указанных в настоящем пункте визуальных отображений, в частности, их затемнение или существенное уменьшение их оригинальных размеров.
</P>
<H2>
3. Вознаграждение и срок использования Программного продукта
</H2>
<P align="justify">
3.1. Размер вознаграждения за предоставление права использования Программного продукта зависит от выбранного Пользователем Программного продукта, срока его использования (срока, на который Пользователю предоставляется право использования Программного продукта) и условий его технического сопровождения и определяется исходя из соотношений, указанных на Интернет-сайте компании «%Executor.CompanyName%».
</P>
<P align="justify">
3.2. ЗАКАЗ ЛИЦЕНЗИИ
</P>
<P align="justify">
3.2.1. Для целей настоящего Лицензионного договора понятие «заказ лицензии» означает совокупность указанных в настоящем пункте 3.2 действий Пользователя, результатом совершения которых является сообщение компании «%Executor.CompanyName%» информации о выбранном Пользователем Программном продукте, сроке его использования и условиях его технического сопровождения, IP адресе сервера (ЭВМ) на котором будет установлен Программный продукт, а также сведений, позволяющих идентифицировать Пользователя как клиента компании «%Executor.CompanyName%» и сторону по настоящему Лицензионному договору.
</P>
<P align="justify">
3.2.2. Пользователь по своему усмотрению осуществляет выбор необходимого ему Программного продукта, срока его использования и условий его технического сопровождения из числа предложенных стандартных вариантов, каждому из которых соответствует определенный размер вознаграждения. Такой выбор осуществляется Пользователем посредством интерактивного взаимодействия с функциональной частью Интернет-сайта компании «%Executor.CompanyName%», осуществляемого через графический пользовательский интерфейс.
</P>
<P align="justify">
3.2.3. После выбора Программного продукта, срока его использования и условий его технического сопровождения Пользователь должен указать IP-адрес сервера (ЭВМ), на котором будет установлен Программный продукт.
</P>
<P align="justify">
3.2.4. В случае если заказ лицензии осуществляется впервые, Пользователь также должен предоставить о себе информацию, необходимую для идентификации Пользователя как клиента компании «%Executor.CompanyName%» и стороны по настоящему Лицензионному договору, а также указать свои контактные данные.
</P>
<P align="justify">
3.2.5. Предоставление указанной выше в пунктах 3.2.3 и 3.2.4 информации осуществляется посредством заполнения соответствующих web-форм, размещенных на Интернет-сайте компании «%Executor.CompanyName%».
</P>
<P align="justify">
3.3. Совершение указанных выше в пункте 3.2 действий не влечет за собой заключение настоящего Лицензионного договора.
</P>
<P align="justify">
3.4. Заказ лицензии может быть осуществлен не самим Пользователем, а другим лицом, действующим от имени Пользователя, которому Пользователь предоставил информацию, необходимую для заказа лицензии. В частности, фактические действия по заказу лицензии могут быть совершены техническим специалистом компании-аутсорсера или иным лицом, которое на основании договора с Пользователем осуществляет техническое обслуживание сервера (ЭВМ), на котором устанавливается Программный продукт. В этом случае Лицензионный договор также считается заключенным между компанией «%Executor.CompanyName%» и Пользователем, как если бы заказ лицензии был осуществлен Пользователем самостоятельно.
</P>
<P align="justify">
3.5. Пользователю предоставляется возможность заказа следующих видов лицензий: «стандартная» лицензия, «партнерская» лицензия, «триал» лицензия.
</P>
<P align="justify">
3.6. При заказе «стандартной» или «партнерской» лицензии право использования Программного продукта предоставляется только после уплаты вознаграждения за предоставление данного права в размере, соответствующем выбранному Пользователем Программному продукту, сроку его использования и условиям его технического сопровождения и определяемом исходя из соотношений, указанных на Интернет-сайте компании «%Executor.CompanyName%».
</P>
<P align="justify">
3.7. При заказе «триал» лицензии право использования Программного продукта предоставляется безвозмездно на определенный срок, по истечении которого использование Программного продукта может быть продолжено только на платной основе. Такое право предоставляется Пользователю для ознакомления с функциональными возможностями Программного продукта, оценки его качества и пригодности для нужд Пользователя.
</P>
<P align="justify">
3.8. При заказе «стандартной» лицензии техническое сопровождение программного продукта полностью осуществляется компанией «ISPsystem», включая техническую поддержку (консультирование Пользователя по вопросам установки, настройки и использования Программного продукта) и установку Программного продукта на сервер, осуществляемые специалистами компании «ISPsystem».
</P>
<P align="justify">
3.9. При заказе «партнерской» или «триал» лицензии техническая поддержка и установка Программного продукта на сервер специалистами компании «ISPsystem» не осуществляются.
</P>
<P align="justify">
3.10. Техническое сопровождение Программных продуктов компанией «ISPsystem», в том числе техническая поддержка и установка программных Продуктов на серверы, осуществляемые специалистами компании «ISPsystem», осуществляется в соответствии с Регламентом технического сопровождения, текст которого размещен на Интернет-сайте компании «ISPsystem».
</P>
<P align="justify">
Особые условия заказа «триал» лицензий
</P>
<P align="justify">
3.11. Право осуществлять заказ «триал» лицензий предоставляется Пользователю со следующими ограничениями:
</P>
<P align="justify">
3.11.1. в случае заказа «триал» лицензии на Программный продукт, следующая «триал» лицензия на данный Программный продукт может быть заказана не ранее, чем через 6 (шесть) месяцев;
</P>
<P align="justify">
3.11.2. в течение 6 (шести) месяцев с момента заказа «триал» лицензии на соответствующий Программный продукт IP адрес сервера (ЭВМ), указанный при заказе данной «триал» лицензии, может быть использован только для целей заказа «коммерческой» лицензии на данный Программный продукт (Ключей активации, предоставляемых на платной основе и позволяющих продолжить использование Программного продукта по истечении разрешенного срока безвозмездного использования); при этом «коммерческая» лицензия может быть заказана только у того лица, у которого была заказана «триал» лицензия: в случае заказа «триал» лицензии у компании «%Executor.CompanyName%» заказ «коммерческой» лицензии у другого партнера компании «ISPsystem» или напрямую у компании «ISPsystem» будет недоступен.
</P>
<P align="justify">
3.12. В виду того, что на основании договора, заключенного между компаниями «%Executor.CompanyName%» и «ISPsystem», компания «ISPsystem» вправе отказать в предоставлении «триал» лицензии для определенного Пользователя и (или) IP адреса, компания «%Executor.CompanyName%» не гарантирует, что «триал» лицензия (право безвозмездного использования Программного продукта в течение определенного срока, а также Ключи активации, необходимые для реализации данного права) будет предоставлена Пользователю по его запросу.
</P>
<H2>
4. Территория использования Программного продукта
</H2>
<P align="justify">
4.1. Право использования Программного продукта предоставляется Пользователю без ограничения по территории использования Программного продукта (Программный продукт может быть использован на территории всего мира).
</P>
<H2>
5. Обновление Программного продукта
</H2>
<P align="justify">
5.1. Компания «ISPsystem» периодически выпускает обновления Программного продукта.
</P>
<P align="justify">
5.2. Пользователь вправе использовать обновления Программного продукта на условиях настоящей Лицензии без выплаты дополнительного вознаграждения.
</P>
<P align="justify">
5.3. Право использования обновлений Программных продуктов считается предоставленным Пользователю с момента обеспечения компанией «ISPsystem» технической возможности их загрузки.
</P>
<P align="justify">
5.4. После установки обновлений Пользователь вправе использовать Программный продукт на тех же условиях, что и до установки обновлений.
</P>
<P align="justify">
5.5. Стороны соглашаются и подтверждают свое понимание того, что установка обновлений для Программного продукта не является и для целей настоящего Лицензионного договора не должна считаться юридическим фактом, влекущим за собой заключение нового лицензионного договора о предоставлении права использования Программного продукта или продление срока действия настоящей Лицензии.
</P>
<H2>
6. Сопутствующие материалы
</H2>
<P align="justify">
6.1. Доступ к Сопутствующим материалам в общем случае осуществляется через пользовательский интерфейс Программного продукта, однако Сопутствующие материалы являются самостоятельными объектами интеллектуальной собственности, исключительные права на которые принадлежат компании «ISPsystem».
</P>
<P align="justify">
6.2. Пользователь вправе использовать Сопутствующие материалы для собственных нужд в течение всего срока действия настоящего Лицензионного договора, а также осуществлять их воспроизведение (копирование) для тех же целей, но не вправе осуществлять распространение Сопутствующих материалов, доведение их до всеобщего сведения, в частности путем их размещения в информационно-телекоммуникационной сети Интернет, или использовать Сопутствующие материалы иным способом без предварительного согласия компании «ISPsystem».
</P>
<H2>
7. Технические средства защиты авторских прав
</H2>
<P align="justify">
7.1. Для защиты Программных продуктов от неправомерного использования компанией «ISPsystem» реализована система технических средств защиты авторских прав (далее – «система защиты»), необходимым элементом которой являются Ключи активации, каждый из которых является уникальным. Ключ активации необходим для использования каждого экземпляра (копии) любого из Программных продуктов.
</P>
<P align="justify">
7.2. Ключ активации является уникальным для каждого IP адреса. В целях предотвращения неправомерного использования Программных продуктов срок действия каждого Ключа активации ограничен, в связи с чем для использования Программного продукта в течение всего срока действия настоящей Лицензии необходима периодическая замена Ключа активации на новый.
</P>
<P align="justify">
Замена Ключа активации осуществляется автоматически: Программный продукт, используя встроенную функцию, направляет запрос на сервер компании «ISPsystem» и загружает новый Ключ активации. Направление запроса на сервер и загрузка нового Ключа активации осуществляется с использованием информационно-телекоммуникационной сети Интернет.
</P>
<P align="justify">
7.3. При автоматическом обновлении Ключа активации не происходит сбора какой-либо информации, за исключением информации об установленной на сервере (ЭВМ) версии Программного продукта и Ключе активации, присутствующем на данном сервере (ЭВМ) на момент обновления.
</P>
<P align="justify">
7.4. В связи с указанными выше в пункте 7.2 особенностями системы защиты, необходимым условием использования любого из Программных продуктов является наличие у сервера (ЭВМ), на котором устанавливается Программный продукт, постоянно функционирующего соединения с информационно-телекоммуникационной сетью Интернет и публичного IP адреса. IP адрес данного сервера (ЭВМ) должен оставаться неизменным: в случае смены IP адреса без согласования с компанией «%Executor.CompanyName%» запуск Программного продукта будет невозможен.
</P>
<P align="justify">
7.5. Пользователь обязан обеспечить соблюдение указанных выше в пункте 7.4 условий в течение всего срока действия Лицензии. В случае если соблюдение данного требования является невозможным или затруднительным, следует воздержаться от заключения настоящего Лицензионного договора.
</P>
<P align="justify">
ИЗМЕНЕНИЕ IP АДРЕСА СЕРВЕРА
</P>
<P align="justify">
7.6. При наличии объективных обстоятельств, обуславливающих необходимость замены IP адреса, указанного при заказе лицензии, Пользователю может быть предоставлена возможность использования Программного продукта на сервере (ЭВМ) с другим IP адресом.
</P>
<P align="justify">
7.7. Регистрация нового IP адреса осуществляется компанией «%Executor.CompanyName%» по заявке Пользователя, но не чаще 1 (одного) раза в календарный месяц. Порядок направления заявок на смену IP адреса, а также порядок их обработки указаны на Интернет-сайте компании «%Executor.CompanyName%».
</P>
<P align="justify">
7.8. В виду того, что на основании договора, заключенного между компаниями «%Executor.CompanyName%» и «ISPsystem», компания «ISPsystem» вправе отказать в регистрации нового IP адреса и (или) заблокировать возможность смены определенного IP адреса в случае многократных замен, а также при наличии обоснованных подозрений, что замена IP адреса осуществляется в целях обхода системы защиты, компания «%Executor.CompanyName%» не гарантирует, что регистрация нового IP адреса сервера (ЭВМ) будет произведена по запросу Пользователя, и не несет ответственности за возможные убытки, возникшие у Пользователя в связи с невозможностью использования Программного продукта с IP адресом сервера (ЭВМ) отличным от того, что был указан при заказе лицензии.
</P>
<P align="justify">
БЛОКИРОВКА IP АДРЕСА СЕРВЕРА
</P>
<P align="justify">
7.9. В случае если была заказана «вечная лицензия» (Ключи активации, позволяющие использовать Программный продукт в течение неограниченного срока) и Программный продукт при этом не использовался (Ключ активации не обновлялся) в течение 3 (трех) и более месяцев, возможность обновления Ключа активации для Программного продукта, установленного на сервере (ЭВМ) с данным IP адресом, автоматически блокируется с предварительным уведомлением Пользователя о предстоящей блокировке.
</P>
<P align="justify">
7.10. В случае если возможность обновления Ключа активации для Программного продукта, установленного на сервере (ЭВМ) с определенным IP адресом, была заблокирована в порядке, описанном выше в пункте 7.9,
</P>
<P align="justify">
7.10.1. восстановление доступа к загрузке Ключей активации осуществляется компанией «%Executor.CompanyName%» по заявке Пользователя, за исключением случая, когда в период, прошедший с момента блокировки IP адреса (блокировки возможности обновления Ключа активации для Программного продукта, установленного на сервере (ЭВМ) с данным IP адресом) данный IP адрес был зарегистрирован за другим пользователем – в этом случае восстановление доступа к загрузке Ключей активации осуществляется только после регистрации нового IP адреса;
</P>
<P align="justify">
7.10.2. регистрация нового IP адреса (в указанном выше случае, а также в случае, если Пользователь желает зарегистрировать новый IP адрес по своей инициативе) осуществляется по заявке Пользователя в общем порядке, предусмотренном для регистрации новых IP адресов с учетом положения, закрепленного пунктом 7.8 настоящего Лицензионного договора.
</P>
<H2>
8. Ответственность Пользователя за нарушение условий Лицензии
</H2>
<P align="justify">
8.1. В случае нарушения Пользователем условий настоящей Лицензии, в частности в случае использования им Программного продукта за пределами предоставленного ему права или несоблюдения им установленных настоящей Лицензией запретов, настоящий Лицензионный договор может быть расторгнут в одностороннем порядке, в результате чего все права, полученные Пользователем по настоящей Лицензии, будут прекращены.
</P>
<P align="justify">
8.2. При расторжении настоящего Лицензионного договора по указанному выше в пункте 8.1 основанию, договор прекращается по истечении 30 (тридцати) дней с момента получения Пользователем требования компании «%Executor.CompanyName%» либо компании «ISPsystem» об устранении допущенных Пользователем нарушений, если в течение данного срока указанные нарушения не будут устранены.
</P>
<P align="justify">
8.3. В случае если настоящий Лицензионный договор был прекращен в одностороннем порядке по указанному выше в пункте 8.1 основанию, Пользователю может быть отказано в заключении с ним нового лицензионного договора.
</P>
<H2>
9. Порядок разрешения споров
</H2>
<P align="justify">
9.1. Споры и разногласия, возникшие между сторонами по настоящему Лицензионному договору, разрешаются путем переговоров между Сторонами. В случае невозможности разрешения разногласий путем переговоров, спор между Сторонами подлежит рассмотрению в судебном порядке в суде гор. Саратова, на основе действующего законодательства Российской Федерации.
</P>
<H2>
10. Действие Лицензии
</H2>
<P align="justify">
10.1. Право использования выбранного Пользователем Программного продукта на условиях настоящей Лицензии в течение срока, выбранного Пользователем из числа предложенных стандартных вариантов, предоставляется Пользователю после уплаты определенного в соответствии с настоящим Лицензионным договором вознаграждения, а в случае заказа «триал» лицензии – после заключения настоящего Лицензионного договора, и считается предоставленным с момента открытия Пользователю доступа к загрузке Ключей активации, необходимых для использования выбранного Пользователем Программного продукта в течение выбранного им стандартного срока.
</P>
<P align="justify">
10.2. Срок действия настоящего Лицензионного договора равен выбранному Пользователем при заказе лицензии сроку использования Программного продукта. По истечении данного срока настоящий Лицензионный договор (Лицензия) прекращается.
</P>
<P align="justify">
Установленное настоящим пунктом 10.2 правило применяется, в том числе, при заказе «триал» лицензии: по истечении установленного срока безвозмездного использования Программного продукта настоящий Лицензионный договор (Лицензия) прекращается, и последующее использование Программного продукта может осуществляться Пользователем только на основании возмездного лицензионного договора после уплаты соответствующего вознаграждения.
</P>
</NOBODY>
', 'yes');


-- SEPARATOR
/* added by lissyara, 2013-05-28 in 10:03 MSK, for JBS-674 */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Enclosures/Types/ExtraIPRules/Content','Регламент предоставления услуги выделенного IP адреса','<NOBODY><P align="justify">
Регламент предоставления услуги выделенного IP адреса полностью соответствует <a href="/Clause?ClauseID=Contracts/Enclosures/Types/HostingRules/Content">регламенту предоставления услуги хостинга</a>.
</P></NOBODY>');

-- SEPARATOR
/* added by lissyara, 2014-12-25 in 21:37 MSK */
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (4,100,100,'yes','yes','yes','Contracts/Enclosures/Types/DNSmanagerRules/Content','Регламент предоставления услуги вторичного DNS','<NOBODY><P align="justify">
Регламент предоставления услуги вторичного сервера DNS (системы доменных имён) полностью соответствует <a href="/Clause?ClauseID=Contracts/Enclosures/Types/HostingRules/Content">регламенту предоставления услуги хостинга</a>.
</P></NOBODY>');

INSERT INTO `Clauses` (`GroupID`, `AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`)
VALUES (9, 100, 100, 'Header:/DNSmanagerOrders', 'Дополнительная услуга - DNSmanager', 'no', 'yes', 'yes', 'yes', '<NOBODY>\n <TABLE class="Warning">\n  <TBODY>\n   <TR>\n    <TD>\n     <P>\n     Услуга &quot;DNSmanager&quot; необходима тем кто арендует у нас, или имеет свой выделенный сервер в датацентре - для поддержки DNS зон доменов (Большинство доменных зон требует чтобы у домена было как минимум два DNS сервера, находящихся в разных IP сетях /24 - а с VPS или выделенным сервером выдаётся лишь один IP адрес).\n    </P>\n     <P>\n     Обратите внимание, что при заказе сервера VPS, данная услуга заказывается автоматически, бесплатно.\n    </P>\n    </TD>\n   </TR>\n  </TBODY>\n </TABLE>\n <BR />\n</NOBODY>\n');



-- SEPARATOR


LOCK TABLES `Services` WRITE;
DELETE FROM `Services` WHERE `ID` IN(10000,20000,30000,40000,50000,51000,52000,53000);

INSERT INTO `Services` (`ID`,`GroupID`,`UserID`,`ServicesGroupID`,`Name`,`NameShort`,`Code`,`Item`,`Measure`,`ConsiderTypeID`,`CostOn`,`Cost`,`IsHidden`,`IsProtected`,`IsActive`,`IsProlong`,`Priority`,`SortID`,`Params`) VALUES
(10000, 2000000, 1, 1000, 'Поддержка заказа хостинга', 'Хостинг', 'Hosting', 'Хостинг', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 300, 100,''),
(20000, 2000000, 1, 1000, 'Поддержка заказа домена', 'Домены', 'Domain', 'Домены', 'год', 'Yearly', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 999, 200,''),
(30000, 2000000, 1, 1000, 'Поддержка заказа виртуального сервера', 'Виртуальный сервер', 'VPS', 'Виртуальный сервер', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 300, 300,''),
(40000, 2000000, 1, 1000, 'Поддержка заказа выделенного сервера', 'Выделенный сервер', 'DS', 'Выделенный сервер', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 300, 400,''),
(50000, 2000000, 1, 1100, 'Поддержка заказа дополнительного IP адреса', 'IP адрес', 'ExtraIP', 'IP адреса', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 100, 5000,'{"Tags":{"Services":[10000,30000,40000]}}'),
(51000, 2000000, 1, 1100, 'Заказ программного обеспечения ISPsystems', 'ПО ISPsystem', 'ISPsw', 'Лицензии ISPsystem', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 100, 5100,'{"Tags":{"Services":[30000,40000]}}'),
(52000, 2000000, 1, 1100, 'Вторичный DNS', 'Вторичный DNS', 'DNSmanager', 'Вторичный DNS', 'дн.', 'Daily', 0.00, 0.00, 'no', 'yes', 'yes', 'yes', 100, 5200,'{"Tags":{"Services":[30000,40000]}}');

UNLOCK TABLES;

LOCK TABLES `Clauses` WRITE;
-- SEPARATOR
/* added by serge 2011-09-05 in 16:00 MSK for domain transfer*/
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.101domain.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/101DOMAIN/external','Трансфер внешний. 101DOMAIN.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://hosting.agava.ru/domains</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/AGAVA/external','Трансфер внешний. AGAVA.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.beeline.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/BEELINE/external','Трансфер внешний. BEELINE.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.r01.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/R01/external','Трансфер внешний. R01.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.demos-internet.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/DEMOS/external','Трансфер внешний. DEMOS.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.caravan.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/CARAVAN/external','Трансфер внешний. CARAVAN.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.comstar.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/COMSTAR/external','Трансфер внешний. COMSTAR.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.regplanet.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/CT/external','Трансфер внешний. CT.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.naunet.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/NAUNET/external','Трансфер внешний. NAUNET.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.netfox.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/NETFOX/external','Трансфер внешний. NETFOX.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.webdrive.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGGI/external','Трансфер внешний. REGGI.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.nic.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/RUCENTER/external','Трансфер внешний. RUCENTER.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.nic.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/RUCENTRE/external','Трансфер внешний. RUCENTRE.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.nic.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/RU-CENTER/external','Трансфер внешний. RU-CENTER.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.reghost.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGHOST/external','Трансфер внешний. REGHOST.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.reg.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGRU/external','Трансфер внешний. REGRU.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.registrant.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGISTRANT/external','Трансфер внешний. REGISTRANT.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.domenus.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/DOMENUS/external','Трансфер внешний. DOMENUS.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.mastername.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGISTRATOR/external','Трансфер внешний. REGISTRATOR.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.webnames.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGTIME/external','Трансфер внешний. REGTIME.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.relcom.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/RELCOM/external','Трансфер внешний. RELCOM.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.rtcomm.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/RTCOMM/external','Трансфер внешний. RTCOMM.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.salenames.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/SALENAMES/external','Трансфер внешний. SALENAMES.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.centrohost.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/CENTROHOST/external','Трансфер внешний. CENTROHOST.',@Text);

-- SEPARATOR
set @Text = '<P>Подробную информацию по переносу домена ищите на сайте регистратора http://www.getname.ru</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/ELVIS/external','Трансфер внешний. ELVIS.',@Text);

-- SEPARATOR
set @Text = '<P>Шаблоны писем на смену обслуживающего партнера (данные нашего партнерского аккаунта указаны выше):<BR />
для юридических лиц:		http://www.reg.ru/docs/letters/dom_transfer_acc_org_ru.rtf<BR />
для физических лиц и ИП:	http://www.reg.ru/docs/letters/dom_transfer_acc_pers_ru.rtf</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGRU/internal','Трансфер внутренний. REGRU.',@Text);

-- SEPARATOR
set @Text = '<P>Администратору домена следует прислать копию паспорта (если администратор — физическое лицо) или заявление на официальном бланке организации с печатью и подписью руководителя (для юридических лиц) на e-mail support@webnames.ru (в отсканированном виде) или по факсу +7 846 9799038, и сообщить о своем желании передать свой домен под сопровождение нового партнера указав наш логин и номер договора (данные были указаны выше).<BR />
<BR />Перенос домена на наш аккаунт может занять у регистратора до 5 рабочих дней. В переносе может быть отказано на основании причин, указанных в правилах регистрации доменов.</P>';
INSERT INTO `Clauses` (`GroupID`,`AuthorID`,`EditorID`,`IsProtected`,`IsXML`,`IsDOM`,`Partition`,`Title`,`Text`)
VALUES (7,100,100,'no','no','no','Registrators/REGTIME/Internal','Трансфер внутренний. REGTIME.',@Text);


-- SEPARATOR
INSERT INTO `Clauses` (`AuthorID`, `EditorID`, `Partition`, `Title`, `IsProtected`, `IsXML`, `IsDOM`, `IsPublish`, `Text`) VALUES
(100, 100, 'CreateTicket/LOCK_OVERLIMITS', 'Аккаунт заблокирован за превышение использования CPU', 'no', 'yes', 'yes', 'yes', '<NOBODY>
<P>Уведомляем Вас о том, что ваш аккаунт %Login%, паркованный домен %Domain%, превысил использование процессорного времени, определённое вашим тарифом "%Scheme%". Поскольку превышения были систематические, и наши предыдущие уведомления вы проигнорировали - мы вынуждены заблокировать ваш аккаунт.
<BR /><BR />
Средняя нагрузка за последние %PeriodToLock% дней составила: %BUsage%%, при лимите тарифного плана: %QuotaCPU%% (%QuotaCPUTime% сек.).
<BR /><BR />
За вчерашний день, нагрузка [%SUsage%%] распределялась следующим образом:
Пользовательское время: %UTime% сек.
Системное время: %STime% сек.
Всего: %ATime% сек.
<BR /><BR />
%UnLockOverlimitsText%
Подробную статистику использования ресурсов, вы можете узнать в панели управления хостингом:<BR />
%Url%
</P>
</NOBODY>');


UNLOCK TABLES;


-- SEPARATOR
SET FOREIGN_KEY_CHECKS=1;


