<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Graphs');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$FnNames = Array();	// имена функций, нужны на выхлоп
$JsFuncs = '';		// функции для графиков
$CallBacks = '';	// обратные вызовы, для показа графиков
#-------------------------------------------------------------------------------
//Debug(SprintF('[comp/Charts/Line]: Graphs = %s',print_r($Graphs,true)));
#-------------------------------------------------------------------------------
foreach(Array_keys($Graphs) as $Key){
	#-------------------------------------------------------------------------------
	#Debug(SprintF('[comp/Charts/Line]: key = %s; Graph = %s',$Key,print_r($Graphs[$Key],true)));
	#-------------------------------------------------------------------------------
	// если не заданы даныне - пропускаем цикл
	if(!IsSet($Graphs[$Key]['Data']) || SizeOf($Graphs[$Key]['Data']) < 2)
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// имя функции для каллбака
	$FnName = SubStr(Md5(MicroTime()),0,8);
	#-------------------------------------------------------------------------------
	$FnNames[] = $FnName;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// JS массив данных, описание колонок таблицы
	$JsData = $Columns = Array();
	#-------------------------------------------------------------------------------
	// строим описание колонок
	foreach($Graphs[$Key]['Columns'] as $Column)
		$Columns[] = SPrintF("data.addColumn('%s','%s');",$Column[0],$Column[1]);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// собираем опции
	$Options = SPrintF("hAxis:{title:'%s'},vAxis:{title:'%s'},title:'%s'",$Graphs[$Key]['hAxisTitle'],$Graphs[$Key]['vAxisTitle'],$Graphs[$Key]['Title']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем даныне для графика, строим массив с данными JS
	foreach($Graphs[$Key]['Data'] as $Line){
		#-------------------------------------------------------------------------------
		// выходная строка
		$CurrLine = Array();
		#-------------------------------------------------------------------------------;
		// перебираем колонки, т.к. всё кроме типа "number", прячется в кавычки, собираем массив со значениями
		for($i = 0; $i < SizeOf($Graphs[$Key]['Columns']); $i++)
			$CurrLine[] = ($Graphs[$Key]['Columns'][$i][0] == 'number')?$Line[$i]:SPrintF("'%s'",$Line[$i]);
		#-------------------------------------------------------------------------------
		// делаем выходную строку значений, вносим в массив данных
		$JsData[] = SPrintF("[%s]",Implode(',',$CurrLine));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// строим функции для графиков
	$JsFuncs = SPrintF("%s\n
	function draw_%s() {
		// Create the data table
		var data = new google.visualization.DataTable();
		// описание колонок таблицы
		%s
		// значения колонок таблицы
		data.addRows([%s]);
		// опции отображения графика (в т.ч. всякие заголовки)
		var options = {curveType:'function',animation:{duration:2000,easing:'out',startup:true},%s};
		// Instantiate and draw the chart
		var chart = new google.visualization.LineChart(document.getElementById('div_%s'));
		chart.draw(data,options);
	}\n",$JsFuncs,$FnName,Implode(" ",$Columns),Implode(',',$JsData),$Options,$FnName);
	#-------------------------------------------------------------------------------
	// обратные вызовы
	$CallBacks = SPrintF("%s\n\tgoogle.charts.setOnLoadCallback(draw_%s)",$CallBacks,$FnName);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
// скрипт на выход
$Script = SPrintF("google.charts.load('current', {'packages':['corechart']});\n\n%s\n%s",$CallBacks,$JsFuncs);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Script'=>$Script,'FnNames'=>$FnNames);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
