<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Result = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Interface']['User']['Notes']['Invoices'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Settings['UnPaidInvoicesReminders'])
	return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array("`UserID` = @local.__USER_ID","`StatusID` IN ('Waiting','Conditionally','NotConfirmed')");
#-------------------------------------------------------------------------------
$Invoices = DB_Select('InvoicesOwners','*',Array('Where'=>$Where));
switch(ValueOf($Invoices)){
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Invoices as $Invoice){
		#-------------------------------------------------------------------------------
		# достаём, что именно оплачивается счётом
		$Columns = Array(
				'*',
				'(SELECT `NameShort` FROM `ServicesOwners` WHERE `ServicesOwners`.`ID` = `InvoicesItems`.`ServiceID`) AS `ServiceName`',
				'(SELECT `Code` FROM `ServicesOwners` WHERE `ServicesOwners`.`ID` = `InvoicesItems`.`ServiceID`) AS `ServiceCode`',
				);
		$InvoicesItems = DB_Select('InvoicesItems',$Columns,Array('Where'=>SPrintF('`InvoiceID` = %u',$Invoice['ID'])));
		#-------------------------------------------------------------------------------
		switch(ValueOf($InvoicesItems)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			# счёт на поплнение? нету таких в соверменности, и быть не должно.
			continue 2;
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Formats/Currency',$Invoice['Summ']);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Params = Array('Invoice'=>$Invoice,'Summ'=>$Comp);
		#-------------------------------------------------------------------------------
		$Array = Array();
		#-------------------------------------------------------------------------------
		foreach($InvoicesItems as $InvoicesItem){
			#-------------------------------------------------------------------------------
			$Comment = ($InvoicesItem['Comment'])?SPrintF('%s / ',$InvoicesItem['Comment']):'';
			#-------------------------------------------------------------------------------
			$Summ = Comp_Load('Formats/Currency',$InvoicesItem['Summ']);
			if(Is_Error($Summ))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Array[] = SPrintF("<li>%s / %s%s</li>", $InvoicesItem['ServiceName'],$Comment,$Summ);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Params['Items'] = Implode("\n",$Array);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$NoBody = new Tag('NOBODY');
		#-------------------------------------------------------------------------------
		$NoBody->AddHTML(TemplateReplace(SPrintF('Notes.User.Invoices.%s',$Invoice['StatusID']),$Params));
		#-------------------------------------------------------------------------------
		$Result[] = $NoBody;
		#-------------------------------------------------------------------------------
		UnSet($NoBody);
		#-------------------------------------------------------------------------------
	}
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------


?>
