<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Mobile');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('libs/Server.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServersSettings = SelectServerSettingsByTemplate('SMS',FALSE);
#-------------------------------------------------------------------------------
switch(ValueOf($ServersSettings)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = 'server with template: SMS, params: IsActive, IsDefault not found';
	#-------------------------------------------------------------------------------
	if(IsSet($GLOBALS['IsCron']))
		return 3600;
	#-------------------------------------------------------------------------------
	return $ServersSettings;
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/Servers/SMSSelectServer]: $ServersSettings =  %s', print_r($ServersSettings,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
$MobileCountry = 'PriceDefault';
#-------------------------------------------------------------------------------
$RegCountrys = Array(
			'PriceRu'       => $Regulars['SMSPriceRu'],
			'PriceUa'       => $Regulars['SMSPriceUa'],
			'PriceSng'      => $Regulars['SMSPriceSng'],
			'PriceZone1'    => $Regulars['SMSPriceZone1'],
			'PriceZone2'    => $Regulars['SMSPriceZone2']
			);
#-------------------------------------------------------------------------------
foreach($RegCountrys as $RegCountryKey => $RegCountry)
        if(Preg_Match($RegCountry, $Mobile))
                $MobileCountry = $RegCountryKey;
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Servers/SMSSelectServer]: для (%s) страна определена как (%s)',$Mobile,$MobileCountry));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# перебираем сервера, сразу выставляем использовать первый же из списка и его цену для этой страны
$Server = 0;
#-------------------------------------------------------------------------------
$CacheID = SPrintF('%s_%s',Md5($__FILE__),$Mobile);
#-------------------------------------------------------------------------------
$PreviousServer = FALSE;
#-------------------------------------------------------------------------------
/* хардкодим страну */
if(SizeOf($ServersSettings) > 1 && $MobileCountry == 'PriceRu'){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Servers/SMSSelectServer]: для отправки SMS более 1 сервера: %sшт.',SizeOf($ServersSettings)));
	#-------------------------------------------------------------------------------
	if($PreviousServer = CacheManager::get($CacheID))
		Debug(SPrintF('[comp/Servers/SMSSelectServer]: для (%s) предыдущий сервер для отправки (%s)',$Mobile,$PreviousServer));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
// находим максимальный ценник
$Price = 0;
#-------------------------------------------------------------------------------
foreach($ServersSettings as $ServerKey => $Key){
	#-------------------------------------------------------------------------------
	if($ServersSettings[$ServerKey]['Params'][$MobileCountry] >= $Price){
		#-------------------------------------------------------------------------------
		$Price = $ServersSettings[$ServerKey]['Params'][$MobileCountry];
		#-------------------------------------------------------------------------------
		$Server = $ServerKey;
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Servers/SMSSelectServer]: для (%s) максимальный ценник %s на сервере %s',$Mobile,$Price,$ServersSettings[$ServerKey]['Address']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// находим минимальный ценник
foreach($ServersSettings as $ServerKey => $Key){
	#-------------------------------------------------------------------------------
	// если предыдущий сервер задан, и если он соответсвует текущему - пропускаем
	if($PreviousServer && $PreviousServer == $ServersSettings[$ServerKey]['Address'])
		continue;
	#-------------------------------------------------------------------------------
	# сравниваем цену сообщения для этой страны, с ранее найденной минимальной ценой
	if($ServersSettings[$ServerKey]['Params'][$MobileCountry] <= $Price){
		#-------------------------------------------------------------------------------
		// если предыдущий сервер задан, и если он не соответсвует текущему - выбираем его
		if(!$PreviousServer || $PreviousServer == $ServersSettings[$ServerKey]['Address']){
		#-------------------------------------------------------------------------------
			$Server = $ServerKey;
			#-------------------------------------------------------------------------------
			$Price = $ServersSettings[$ServerKey]['Params'][$MobileCountry];
			#-------------------------------------------------------------------------------
			CacheManager::add($CacheID,$ServersSettings[$ServerKey]['Address'],3600);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$ServerSettings = $ServersSettings[$Server];
#-------------------------------------------------------------------------------
CacheManager::add($CacheID,$ServerSettings['Address'],12*60*60);	/* на 12 часов запоминаем */
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Servers/SMSSelectServer]: для (%s) выбран сервер (%s) для страны (%s), цена (%s)',$Mobile,$ServerSettings['Address'],$MobileCountry,$ServerSettings['Params'][$MobileCountry]));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Formats/Currency',Str_Replace(',','.',$ServerSettings['Params'][$MobileCountry]));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array($ServerSettings,$MobileCountry,$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>





