<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsCreate       = (boolean) @$Args['IsCreate'];
$StartDate      = (integer) @$Args['StartDate'];
$FinishDate     = (integer) @$Args['FinishDate'];
$Details        =   (array) @$Args['Details'];
$ShowTables     = (boolean) @$Args['ShowTables'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result = Array('Title'=>'Структура договоров');
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY');
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('P','Данная статистика содержит информацию о всех типах договорах заключенных с клиентами (выводяться только договоры имеющие оплаченные счета).'));
$NoBody->AddChild(new Tag('P','Под структурой в данном случае подразумевается количественное соотношение между различными типами договоров, а так же суммами балансов на договорах.'));
#-------------------------------------------------------------------------------
if(!$IsCreate)
	return $Result;
#-------------------------------------------------------------------------------
$Contracts = DB_Select('Contracts',Array('SUM(`Balance`) as `Balance`','TypeID','COUNT(*) as `Count`'),Array('Where'=>Array("EXISTS(SELECT * FROM `Invoices` WHERE `ID` = `Contracts`.`ID` AND `IsPosted` = 'yes')",'`UserID` NOT IN (100)'),'GroupBy'=>'TypeID'));
#-------------------------------------------------------------------------------
switch(ValueOf($Contracts)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Result;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Table = Array(Array(new Tag('TD',Array('class'=>'Head'),'Тип договора'),new Tag('TD',Array('class'=>'Head'),'Сумма балансов'),new Tag('TD',Array('class'=>'Head'),'Кол-во')));
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Types = $Config['Contracts']['Types'];
#-------------------------------------------------------------------------------
$Total = 0.00;
#-------------------------------------------------------------------------------
// для графиков
$dGraphs = $bGraphs = Array();
#-------------------------------------------------------------------------------
foreach($Contracts as $Contract){
	#-------------------------------------------------------------------------------
	$String = $Type = $Types[$Contract['TypeID']]['Name'];
	#-------------------------------------------------------------------------------
	// выходной массив для графика по количеству
	$dGraphs[] = Array($String,$Contract['Count']);
	#-------------------------------------------------------------------------------
	// выходной массив для графика по баллансу
	$bGraphs[] = Array($String,$Contract['Balance']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Formats/Currency',$Contract['Balance']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array($Type,$Comp,(integer)$Contract['Count']);
	#-------------------------------------------------------------------------------
	$Total += $Contract['Balance'];
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Formats/Currency',$Total);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('TD',Array('colspan'=>3,'class'=>'Standard','align'=>'right'),SPrintF('Общая сумма на балансах: %s',$Comp)));
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Extended',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($ShowTables)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left;'),$Comp));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Count($dGraphs) > 1){
	#-------------------------------------------------------------------------------
	$Graphs = Array('Структура по количеству'=>$dGraphs,'Структура по баллансу'=>$bGraphs);
	#-------------------------------------------------------------------------------
	$Pie = Comp_Load('Charts/Pie',$Graphs);
	if(Is_Error($Pie))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// накидываем DIV'ы в тело страницы
	foreach($Pie['FnNames'] as $FnName)
		$NoBody->AddChild(new Tag('DIV',Array('style'=>SPrintF('float:left;width:%u%%;height:400px;',$ShowTables?30:50),'id'=>SPrintF('div_%s',$FnName)),$FnName));
	#-------------------------------------------------------------------------------
	$Result['Script'] = $Pie['Script'];
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Result['DOM'] = $NoBody;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
