<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsCreate	= (boolean) @$Args['IsCreate'];
$StartDate	= (integer) @$Args['StartDate'];
$FinishDate	= (integer) @$Args['FinishDate'];
$Details	=   (array) @$Args['Details'];
$Words		=   (array) @$Args['Words'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$PaymentSystems = $Config['Invoices']['PaymentSystems'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY');
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('P','Информация о количестве пользователей, заказов, тарифных планах и счетах по статусам'));
#-------------------------------------------------------------------------------
$Result = Array('Title'=>'Общая статистика*');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$IsCreate)
	return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
//  группировка
$GroupBy = Array(
		'ByDays'	=> Array('ISO_Date'),
		'ByMonth'	=> Array('Month','Year'),
		'ByQuarter'	=> Array('Quarter','Year'),
		'ByYear'	=> Array('Year')
		);
#-------------------------------------------------------------------------------
// ключи для выбора дат
$DateKeys = Array(
		'ByDays'	=> 'ISO_Date',
		'ByMonth'	=> 'YearMonth',
		'ByQuarter'	=> 'Quarter',
		'ByYear'	=> 'Year'
		);
// выхлоп с графиками
$Graphs = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(
		SPrintF('`Stamp` >= %u',$StartDate),
		SPrintF('`Stamp` <= %u',$FinishDate),
		);
#-------------------------------------------------------------------------------
// колонки для выбора из БД
$Columns = Array(
		'DATE_FORMAT(FROM_UNIXTIME(`Stamp`),GET_FORMAT(DATE,"ISO")) AS `ISO_Date`',
		"DATE_FORMAT(FROM_UNIXTIME(`Stamp`),'%Y-%m') AS `YearMonth`",
/*		'GET_DAY_FROM_TIMESTAMP(`Stamp`) as `Date`',
		'MONTH(FROM_UNIXTIME(`Stamp`)) as `Month`',
		'GET_QUARTER_FROM_TIMESTAMP(`Stamp`) as `Quarter`',
		'YEAR(FROM_UNIXTIME(`Stamp`)) as Year',*/
		'PackageID','Year',
		'GET_QUARTER_FROM_TIMESTAMP(`Stamp`) as `Quarter`',
		'CEIL(SUM(`Total`)/COUNT(`Total`)/7) AS `Total`',
		'CEIL(SUM(`Active`)/COUNT(`Active`)/7) AS `Active`',
		'CEIL(SUM(`New`)/COUNT(`New`)/7) AS `New`',
		'CEIL(SUM(`Waiting`)/COUNT(`Waiting`)/7) AS `Waiting`',
		'CEIL(SUM(`Suspended`)/COUNT(`Suspended`)/7) AS `Suspended`',
/*		 'SUM(`Total`) AS `Total`',
		 'SUM(`Active`) AS `Active`',
		 'SUM(`New`) AS `New`',
		 'SUM(`Waiting`) AS `Waiting`',
		 'SUM(`Suspended`) AS `Suspended`'*/
		);

// перебираем запрошенные детализации
foreach($Details as $Detail){
	#-------------------------------------------------------------------------------
	// выбираем список уникальных сервисов что есть в статситике
	$Tables = DB_Select('Statistics',Array('DISTINCT(`TableID`) AS `TableID`','(SELECT `NameShort` FROM `Services` WHERE `Code` = `Statistics`.`TableID` LIMIT 1) AS `NameShort`','(SELECT `Name` FROM `Services` WHERE `Code` = `Statistics`.`TableID` LIMIT 1) AS `Name`'),Array('Where'=>$Where,'SortOn'=>Array('NameShort','ID')));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Tables)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		continue 2;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	foreach($Tables as $Table){
		#-------------------------------------------------------------------------------
		$Where1 = $Where;
		$Where1[] = SPrintF('`TableID` = "%s"',$Table['TableID']);
		#-------------------------------------------------------------------------------
		// выбираем строки этой таблицы
		$Statistics = DB_Select('Statistics',$Columns,Array('GroupBy'=>$GroupBy[$Detail],'Where'=>$Where1,'SortOn'=>'Stamp'));
		#-------------------------------------------------------------------------------
		switch(ValueOf($Statistics)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			// ничего не выбрано (что кстати весьма странно)
			continue 2;
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		// заголовок графика
		if(!Is_Null($Table['Name'])){
			#-------------------------------------------------------------------------------
			$Title = SPrintF('Заказов на услугу: %s',$Table['Name']);
			#-------------------------------------------------------------------------------
		}elseif($Table['TableID'] == 'Users'){
			#-------------------------------------------------------------------------------
			$Title = 'Количество пользователей зарегистрированых в биллинге';
			#-------------------------------------------------------------------------------
		}elseif($Table['TableID'] == 'Invoices'){
			#-------------------------------------------------------------------------------
			$Title = 'cчетов оплаченных клиентами';
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Title = SPrintF('%s / %s',$Title,$Detail);
		#-------------------------------------------------------------------------------
		// строим параметры графика
		$Out = Array(
				'Columns'	=> Array(Array('string','Дата'),/*Array('number','Total'),*/Array('number','Active'),Array('number','New'),Array('number','Waiting'),Array('number','Suspended')),
				'Title'		=> $Title,
				'hAxisTitle'	=> 'Даты',
				'vAxisTitle'	=> 'вертикальная надпись',
				'Data'		=> Array()
				);
		#-------------------------------------------------------------------------------
		// перебираем полученную стаитистку
		foreach($Statistics as $Statistic){
			#-------------------------------------------------------------------------------
			// возможны варианты
			// 1. строим сразу по выбранной строке (юзеры, счета и услуги - если PackageID == NULL)
			// 1.1 у счетов два варианта - количество и сумма, у количества PackageID == NULL
			// 2. для услуг, либо строим сразу, если  PackageID == NULL, либо собираем графики Total/Active/New/Waiting/Suspended со всеми тарифами
			#-------------------------------------------------------------------------------
			if(Is_Null($Statistic['PackageID'])){
				#-------------------------------------------------------------------------------
				$Out['Data'][] = Array($Statistic[$DateKeys[$Detail]],/*$Statistic['Total'],*/$Statistic['Active'],$Statistic['New'],$Statistic['Waiting'],$Statistic['Suspended']);
			}else{


			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------

		}
		#-------------------------------------------------------------------------------
		// вносим данные графиков
		$Graphs[] = $Out;

	}
}

/*

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// перебираем детализацию, строим графики
foreach($Details as $Detail){
	#-------------------------------------------------------------------------------
	$Invoices = DB_Select('Invoices',$Columns,Array('GroupBy'=>$GroupBy[$Detail],'Where'=>$Where,'SortOn'=>'Stamp'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Invoices)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		// массив для дат (ключей), по которым будут строиться графики по платёжным системам
		$Dates = Array();
		#-------------------------------------------------------------------------------
		foreach($Invoices as $Invoice){
			#-------------------------------------------------------------------------------
			// готовим массив с датами в качестве ключей, для графиков по платёжным системам
			if($Detail == 'ByMonth'){
				#-------------------------------------------------------------------------------
				$DateKey = $Invoice['YearMonth'];
				#-------------------------------------------------------------------------------
			}elseif($Detail == 'ByDays'){
				#-------------------------------------------------------------------------------
				$DateKey = $Invoice['ISO_Date'];
				#-------------------------------------------------------------------------------
			}elseif($Detail == 'ByQuarter'){
				#-------------------------------------------------------------------------------
				$DateKey = SPrintF('%u/%u',$Invoice['Year'],$Invoice['Quarter']);
				#-------------------------------------------------------------------------------
			}elseif($Detail == 'ByYear'){
				#-------------------------------------------------------------------------------
				$DateKey = $Invoice['Year'];
				#-------------------------------------------------------------------------------
			}
                        #-------------------------------------------------------------------------------
                        $Dates[$DateKey] = Array();
			#-------------------------------------------------------------------------------
			//Debug(SPrintF('[comp/Statistics/Invoices]: 1. DateKey = %s',$DateKey));
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// график по сумме платежей
			$Graphs[SPrintF('%sPay',$Detail)]['Data'][] = Array($DateKey,Ceil($Invoice['Summ']));
			#-------------------------------------------------------------------------------
			// график по числу платежей
			$Graphs[SPrintF('%sCount',$Detail)]['Data'][] = Array($DateKey,Ceil($Invoice['Count']));
			#-------------------------------------------------------------------------------
			// график среднего чека
			$Graphs[SPrintF('%sPayAvg',$Detail)]['Data'][] = Array($DateKey,Ceil($Invoice['Summ']/$Invoice['Count']));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// выбираем платёжные системы использовавшиеся в этот же период
		$PSs = DB_Select('Invoices',Array('DISTINCT(`PaymentSystemID`) AS `PaymentSystem`'),Array('Where'=>$Where));
		#-------------------------------------------------------------------------------
		switch(ValueOf($PSs)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		// перебираем полученный список платёжных систем
		foreach($PSs as $PS){
			#-------------------------------------------------------------------------------
			// делаем запрос к базе, достаём платежи по конкретной платёжной системе в указанный период
			$Where1 = $Where;
			$Where1[] = SPrintF('`PaymentSystemID` = "%s"',$PS['PaymentSystem']);
			#-------------------------------------------------------------------------------
			$Invoices = DB_Select('Invoices',$Columns,Array('GroupBy'=>$GroupBy[$Detail],'Where'=>$Where1,'SortOn'=>'Stamp'));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Invoices)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				# No more...
				break;
			case 'array':
				// перебираем полученный список платежей, вносим платежи в массив дат
                                foreach($Invoices as $Invoice){
					#-------------------------------------------------------------------------------
					// готовим ключи
					if($Detail == 'ByMonth'){
						#-------------------------------------------------------------------------------
						$DateKey = $Invoice['YearMonth'];
						#-------------------------------------------------------------------------------
					}elseif($Detail == 'ByDays'){
						#-------------------------------------------------------------------------------
						$DateKey = $Invoice['ISO_Date'];
						#-------------------------------------------------------------------------------
					}elseif($Detail == 'ByQuarter'){
						#-------------------------------------------------------------------------------
						$DateKey = SPrintF('%u/%u',$Invoice['Year'],$Invoice['Quarter']);
						#-------------------------------------------------------------------------------
					}elseif($Detail == 'ByYear'){
						#-------------------------------------------------------------------------------
						$DateKey = $Invoice['Year'];
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
					//Debug(SPrintF('[comp/Statistics/Invoices]: 2. Detail = %s; DateKey = %s',$Detail,$DateKey));
					#-------------------------------------------------------------------------------
					#-------------------------------------------------------------------------------
					$Dates[$DateKey][$PS['PaymentSystem']]['Summ'] = $Invoice['Summ'];
					#-------------------------------------------------------------------------------
					$Dates[$DateKey][$PS['PaymentSystem']]['Count'] = $Invoice['Count'];
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			// некоторые платёжные системы удалены, могут быть проблемы с именем
			$PaymentSystemName = IsSet($PaymentSystems[$PS['PaymentSystem']]['Name'])?$PaymentSystems[$PS['PaymentSystem']]['Name']:$PS['PaymentSystem'];
			#-------------------------------------------------------------------------------
			// добавляем описание платёжной системы в описание колонок
			$Graphs[SPrintF('%sPayPS',$Detail)]['Columns'][] = Array('number',$PaymentSystemName);
			$Graphs[SPrintF('%sCountPS',$Detail)]['Columns'][] = Array('number',$PaymentSystemName);
			$Graphs[SPrintF('%sAvgPS',$Detail)]['Columns'][] = Array('number',$PaymentSystemName);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// перебираем полученный массив дат, заполняем массив для графиков
		foreach(Array_Keys($Dates) as $Key){
			#-------------------------------------------------------------------------------
			// строка таблицы графика
			$ArrayPayPS = Array($Key);
			$ArrayCountPS = Array($Key);
			$ArrayAvgPS = Array($Key);
			// перебираем платёжные системы, чтобы в том же порядке заполнить массивы
			foreach($PSs as $PS){
				#-------------------------------------------------------------------------------
				// если в этот день платёжной системой платили, то вносим цифры платежей, иначе - нули
				$Value = IsSet($Dates[$Key][$PS['PaymentSystem']])?1:0;
				#-------------------------------------------------------------------------------
				$ArrayPayPS[] = ($Value)?$Dates[$Key][$PS['PaymentSystem']]['Summ']:0;
				#-------------------------------------------------------------------------------
				$ArrayCountPS[] = ($Value)?$Dates[$Key][$PS['PaymentSystem']]['Count']:0;
				#-------------------------------------------------------------------------------
				$ArrayAvgPS[] = ($Value)?Ceil($Dates[$Key][$PS['PaymentSystem']]['Summ']/$Dates[$Key][$PS['PaymentSystem']]['Count']):0;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// вносим значение в массив для графика
			$Graphs[SPrintF('%sPayPS',$Detail)]['Data'][] = $ArrayPayPS;
			$Graphs[SPrintF('%sCountPS',$Detail)]['Data'][] = $ArrayCountPS;
			$Graphs[SPrintF('%sAvgPS',$Detail)]['Data'][] = $ArrayAvgPS;
			#-------------------------------------------------------------------------------
		}
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
*/
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#if(Count($NoBody->Childs) < 2)
#	return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// добавляем графики в страницу
$Line = Comp_Load('Charts/Line',$Graphs);
if(Is_Error($Line))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
// накидываем DIV'ы в тело страницы
foreach($Line['FnNames'] as $FnName)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left;width:100%;height:400px;','id'=>SPrintF('div_%s',$FnName)),$FnName));
#-------------------------------------------------------------------------------
$Result['Script'] = $Line['Script'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result['DOM'] = $NoBody;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
