<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['BackUp'];
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return 3600;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$TmpData = DB_Select('TmpData','*',Array('UNIQ','Where'=>Array('`AppID` = "Tasks.BackUp"'),'SortOn'=>'CreateDate','Limits'=>Array(0,1)));
#-------------------------------------------------------------------------------
switch(ValueOf($TmpData)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	//Debug(SprintF('[comp/Tasks/BackUp]: первый запуск, вносим массив в БД'));
	#-------------------------------------------------------------------------------
	// первый запуск
	$Result = DB_Query('SHOW TABLE STATUS');
	if(Is_Error($Result))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Tables = MySQL::Result($Result);
	if(Is_Error($Tables))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Tasks.BackUp','Params'=>$Tables));
	if(Is_Error($IsInsert))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// верёнмся к задаче в след. цикл
	return 20;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($TmpData['Params']) as $Key){
		#-----------------------------------------------------------------------------
		$Table = $TmpData['Params'][$Key];
		#-----------------------------------------------------------------------------
		$TableID = $Table['Name'];
		#-----------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo'] = Array(SPrintF('Repair table: %s',$TableID));
		#-----------------------------------------------------------------------------
		if(!$Table['Engine']){
			#-----------------------------------------------------------------------------
			UnSet($TmpData['Params'][$Key]);
			#-----------------------------------------------------------------------------
			continue;
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
		$TimeStart = Explode(" ",MicroTime());
		#-------------------------------------------------------------------------------
		if($Table['Engine'] == 'MyISAM'){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/BackUp]: Исправление ошибок в таблице (%s)',$TableID));
			#-------------------------------------------------------------------------------
			$Result = DB_Query(SPrintF('REPAIR TABLE `%s`',$TableID));
			if(Is_Error($Result))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Rows = MySQL::Result($Result);
			if(Is_Error($Rows))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Row = Current($Rows);
			#-----------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/BackUp]: Результат восстановления таблицы (%s) (%s)=[%s]',$TableID,$Row['Msg_type'],$Row['Msg_text']));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Result = DB_Query(SPrintF('OPTIMIZE TABLE `%s`',$TableID));
		if(Is_Error($Result))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Rows = MySQL::Result($Result);
		if(Is_Error($Rows))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Row = Current($Rows);
		#-------------------------------------------------------------------------------
		$TimeEnd = Explode(" ",MicroTime());
		#-------------------------------------------------------------------------------
		$TimeExecute = $TimeEnd[0] + $TimeEnd[1] - $TimeStart[0] - $TimeStart[1];
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/BackUp]: Время на таблицу: %s; результат оптимизации таблицы (%s) (%s)=[%s]',Round($TimeExecute,3),$TableID,$Row['Msg_type'],$Row['Msg_text']));
		#-------------------------------------------------------------------------------
		// удаляем обработанную
		UnSet($TmpData['Params'][$Key]);
		#-------------------------------------------------------------------------------
		// сохраняем обновлённый массив
		$IsUpdate = DB_Update('TmpData',Array('Params'=>$TmpData['Params']),Array('ID'=>$TmpData['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		// один заход - одна таблица
		return 20;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// тут мы оказываемся если все таблицы обработаны
	// удаляем запись из таблицы
	$IsDelete = DB_Delete('TmpData',Array('ID'=>$TmpData['ID']));
	if(Is_Error($IsDelete))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
default:                                                
	return ERROR | @Trigger_Error(101);             
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DBConnection = $Config['DBConnection'];
#-------------------------------------------------------------------------------
$Tmp = System_Element('tmp');
if(Is_Error($Tmp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Folder = SPrintF('%s/db',$Tmp);
#-------------------------------------------------------------------------------
if(!File_Exists($Folder)){
	#-------------------------------------------------------------------------------
	if(!@MkDir($Folder,0777,TRUE))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$MyCnf = SPrintF('%s/my.cnf',$Tmp);
#-------------------------------------------------------------------------------
if(File_Exists($MyCnf))
	UnLink($MyCnf);
#-------------------------------------------------------------------------------
if(!@File_Put_Contents($MyCnf, SPrintF("[client]\nhost = %s\nport = %u\nuser = %s\npassword = %s\n",$DBConnection['Server'],$DBConnection['Port'],$DBConnection['User'],$DBConnection['Password'])))
	Error(SPrintF('<P>Не удалось сохранить текущие настройки соединения с базой данных в файле (%s)</P>', $MyCnf));
#-------------------------------------------------------------------------------
$File = SPrintF('%s/%s.sql',$Folder,Date('D'));
#-------------------------------------------------------------------------------
$Command = SPrintF('mysqldump --defaults-extra-file=%s --set-gtid-purged=OFF --quote-names -R --single-transaction --skip-lock-tables --quick -r %s %s',$MyCnf,$File,$DBConnection['DbName']);
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Tasks/BackUp]: команда консоли (%s)',$Command));
#-------------------------------------------------------------------------------
$Log = Array();
#-------------------------------------------------------------------------------
if(Exec($Command,$Log))
	return ERROR | @Trigger_Error(SPrintF("[comp/Tasks/BackUp]: ошибка выполнения команды:\n%s",Implode("\n",$Log)));
#-------------------------------------------------------------------------------
if(!File_Exists($File))
	return ERROR | @Trigger_Error('[comp/Tasks/BackUp]: файл резервной копии не был создан');
#-------------------------------------------------------------------------------
UnLink($MyCnf);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = Array(SPrintF('DB dump size: %s Mb',Ceil(FileSize($File)/(1024*1024))));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
