<?php

#-------------------------------------------------------------------------------
/** @author Alex keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['CheckSoftWareSettings'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# задаём константу
@define('PHP_INI_PATH', php_ini_loaded_file());
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем необходимые для работы модули
$Extensions = Array('hash','gd','json','libxml','mbstring','openssl','xml','zlib','imap','mailparse','fileinfo');
#-------------------------------------------------------------------------------
foreach($Extensions as $Extension){
	#-------------------------------------------------------------------------------
	if(!Extension_Loaded($Extension)){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/CheckSoftWare]: Extensions not found: %s',$Extension));
		#-------------------------------------------------------------------------------
		if($Settings['IsEvent'])
			$Messages[] = SPrintF('Не найден модуль php, требуемый для работы: %s.',$Extension);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем параметры php
if(Ini_Get('safe_mode'))
	if($Settings['IsEvent'])
		$Messages[] = SPrintF('Необходимо выключить безопасный режим в PHP, т.к. это существенно ограничивает возможности PHP интерпретатора. Найдите в файле %s опцию "safe_mode" и установите ее значение в 0.',PHP_INI_PATH);
#-------------------------------------------------------------------------------
if($disable_functions = Ini_Get('disable_functions'))
	if($Settings['IsEvent'])
		$Messages[] = SPrintF('Внимание! В PHP выключены следюущие функции: "%s". Возможно данные функции потребуются для работы системы. Найдите в файле %s опцию "disable_functions" и установите для нее пустое значение.',$disable_functions,PHP_INI_PATH);
#-------------------------------------------------------------------------------
if(Ini_Get('open_basedir'))
	if($Settings['IsEvent'])
		$Messages[] = SPrintF('Включено ограничение open_basedir. Если необходимые для работы приложения не будут найдены, необходимо закомментировать опцию "open_basedir" в файле %s, или в конфигурации виртуалхоста apache',PHP_INI_PATH);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем наличие утилиты wkhtmltopdf
$Result = Exec('wkhtmltopdf --version 2>&1');
#-------------------------------------------------------------------------------
if(!Preg_Match('/not\sfound/',$Result)){
	#-------------------------------------------------------------------------------
	if(!Preg_Match('/with patched qt/',$Result))
		$Messages[] = 'Установлена непропатченная версия wkhtmltopdf, для её работы требуется Х сервер. Установите версию не требующую X сервер.';
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Messages[] = 'Приложение wkhtmltopdf не найдено.';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем наличие утилиты ipmitool
$Result = Exec('ipmitool -V 2>&1');
#-------------------------------------------------------------------------------
if(!Preg_Match('/not\sfound/',$Result)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/CheckSoftWare]: ipmitool version: %s',$Result));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Messages[] = 'Приложение ipmitool не найдено.';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем наличие утилиты convert
$Result = Exec('convert -version 2>&1');
#-------------------------------------------------------------------------------
if(!Preg_Match('/not\sfound/',$Result)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/CheckSoftWare]: convert version: %s',$Result));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Messages[] = 'Приложение convert не найдено.';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# развешиваем сообщения
if(SizeOf($Messages) > 0){
	foreach($Messages as $Message){
		#-------------------------------------------------------------------------------
		$Event = Array(
				'UserID'        => 100,
				'PriorityID'    => 'Error',
				'Text'          => SPrintF('%s Биллинговая система может работать с ошибками, или часть функционала будет недоступна.',$Message),
				'IsReaded'      => FALSE
				);
		#-------------------------------------------------------------------------------
		$Event = Comp_Load('Events/EventInsert',$Event);
		#-------------------------------------------------------------------------------
		if(!$Event)
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
