<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('libs/Tree.php','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['TicketsMessages'];
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$MessagesCount = 0;
#-------------------------------------------------------------------------------
$Columns = Array(
		'ID','UserID','EdeskID','SUBSTR(`Content`,1,4096) AS `Content`',
		SPrintF('CONCAT("[%s-",`EdeskID`,"] ",(SELECT `Theme` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`)) as `Theme`',$Settings['KeyPrefix']),
		'(SELECT `TargetGroupID` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`) as `TargetGroupID`',
		'(SELECT `TargetUserID` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`) as `TargetUserID`',
		'(SELECT `UserID` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`) as `OwnerID`',
		'(SELECT `StatusID` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`) as `StatusID`',
		'(SELECT `NotifyEmail` FROM `Edesks` WHERE `Edesks`.`ID` = `EdeskID`) as `NotifyEmail`'
		);
#-------------------------------------------------------------------------------
$Where = Array(
		"`IsNotify` = 'no'",
		"`IsVisible` = 'yes'"
		);
#-------------------------------------------------------------------------------
$Messages = DB_Select('EdesksMessages',$Columns,Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($Messages)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# No more...
	return $ExecuteTime;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Messages as $Message){
	#-------------------------------------------------------------------------------
	$TargetUserID	= (integer)$Message['TargetUserID'];
	$TargetGroupID	= (integer)$Message['TargetGroupID'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// если файлы добавлены, то собираем массив вложений
	$Attachments = GetUploadedFiles('EdesksMessages',$Message['ID'],TRUE);
	#-------------------------------------------------------------------------------
	if(!Is_Array($Attachments))
		$Attachments = Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($TargetGroupID != 1){
		#-------------------------------------------------------------------------------
		// оповещения сотрудников о новых тикетах и ответах в старые
		#-------------------------------------------------------------------------------
		// массивы, будем складывать туда тех кому слать оповещения
		$Recipients = $NotifyAllNewEdesks = $NotifyAllNewMessages = Array();
		#-------------------------------------------------------------------------------
		// ищем всех сотрудников, перебираем их, смотрим у кого включена настройка - оповещать о всех тикетах.
		$Entrance = Tree_Entrance('Groups',3000000);
		#-------------------------------------------------------------------------------
		switch(ValueOf($Entrance)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			#-------------------------------------------------------------------------------
			$Employers = DB_Select('Users',Array('ID','Params'),Array('Where'=>SPrintF('`GroupID` IN (%s)',Implode(',',$Entrance))));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Employers)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return ERROR | @Trigger_Error(400);
			case 'array':
				#-------------------------------------------------------------------------------
				foreach($Employers as $Employer)
					if($Employer['Params']['Settings']['NotifyAllNewEdesks'] == 'Yes')
						$NotifyAllNewEdesks[] = $Employer['ID'];
				#-------------------------------------------------------------------------------
				foreach($Employers as $Employer)
					if($Employer['Params']['Settings']['NotifyAllNewMessages'] == 'Yes')
						$NotifyAllNewMessages[] = $Employer['ID'];
				#-------------------------------------------------------------------------------
				Debug(SPrintF("[comp/Tasks/TicketsMessages]: найдено %u сотрудников, оповещаются о всех новых тикетах %u, о всех новых сообщениях %u ",SizeOf($Employers),SizeOf($NotifyAllNewEdesks),SizeOf($NotifyAllNewMessages)));
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// массивы сотрудников, найденные ранее, объединям с массивом конкретной группы которой назначен тикет, или юзера, которому он назначен
		#-------------------------------------------------------------------------------
		// юзер сообщения соответствует владельцу тикета
		$IsOwner = ($Message['UserID'] == ($OwnerID = $Message['OwnerID']));
		#-------------------------------------------------------------------------------
		if($IsOwner){
			#-------------------------------------------------------------------------------
			if($TargetUserID != 100){
				#-------------------------------------------------------------------------------
				// тикет кому-то назначен, конкретному сотруднику
				#-------------------------------------------------------------------------------
				// докидываем сотрудников кому надо оповещения о таких тикетах
				$Recipients = Array_Unique(Array_Merge(Array($TargetUserID),$NotifyAllNewMessages));
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				// тикет никому не назначен (назначен системному пользователю с ID = 100), новый тикет
				#-------------------------------------------------------------------------------
				// добавляем в получатели тех кого надо оповещать о всех новых тикетах
				$Recipients = $NotifyAllNewEdesks;
				#-------------------------------------------------------------------------------
				$Entrance = Tree_Entrance('Groups',$TargetGroupID);
				#-------------------------------------------------------------------------------
				switch(ValueOf($Entrance)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					return ERROR | @Trigger_Error(400);
				case 'array':
					break;
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
				$Employers = DB_Select('Users','ID',Array('Where'=>SPrintF('`GroupID` IN (%s)',Implode(',',$Entrance))));
				#-------------------------------------------------------------------------------
				switch(ValueOf($Employers)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					# No more...
					break;
				case 'array':
					#-------------------------------------------------------------------------------
					// добавляем найденных сотрудников отдела, которому назначен тикет
					foreach($Employers as $Employer)
						if(!In_Array($Employer['ID'],$Recipients))
							$Recipients[] = $Employer['ID'];
					#-------------------------------------------------------------------------------
					break;
					#-------------------------------------------------------------------------------
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// отправляем сообщениям получателям
			foreach($Recipients as $Recipient){
				#-------------------------------------------------------------------------------
				$msgParams = Array(
							'TicketID'		=> $Message['EdeskID'],
							'Theme'			=> $Message['Theme'],
							'Message'		=> $Message['Content'],
							'MessageID'		=> $Message['ID'],
							'Attachments'		=> $Attachments
							);
				#-------------------------------------------------------------------------------
				$msg = new Message('ToTicketsMessages',(integer)$Recipient, $msgParams);
				#-------------------------------------------------------------------------------
				$IsSend = NotificationManager::sendMsg($msg);
				#-------------------------------------------------------------------------------
				switch(ValueOf($IsSend)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					# No more...
				case 'true':
					#-------------------------------------------------------------------------------
					$MessagesCount++;
					#-------------------------------------------------------------------------------
					$IsUpdate = DB_Update('EdesksMessages',Array('IsNotify'=>TRUE),Array('ID'=>$Message['ID']));
					if(Is_Error($IsUpdate))
						return ERROR | @Trigger_Error(500);
					#-------------------------------------------------------------------------------
					break;
					#-------------------------------------------------------------------------------
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// оповещение пользователей о новых ответах от сотрудников
			$String = $Message['Content'];
			#-------------------------------------------------------------------------------
			switch($Message['StatusID']){
			case 'Closed':
				#-------------------------------------------------------------------------------
				$String = SPrintF("%s\n\nЕсли потребуется какая-либо помощь, пожалуйста, откройте новый запрос.\nСпасибо.",$String);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'Working':
				#-------------------------------------------------------------------------------
				$String = SPrintF("%s\n\nНа данный момент мы решаем Ваш вопрос.\nСпасибо.",$String);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				# No more...
			}
			#-------------------------------------------------------------------------------
			$Message['Content'] = $String;
			#-------------------------------------------------------------------------------
			$msgParams = Array(
						'TicketID'		=> $Message['EdeskID'],
						'Theme'			=> $Message['Theme'],
						'Message'		=> $Message['Content'],
						'MessageID'		=> $Message['ID'],
						'Attachments'		=> $Attachments
						);
			#-------------------------------------------------------------------------------
			if(StrLen($Message['NotifyEmail']) > 5)
				$msgParams['Recipient'] = $Message['NotifyEmail'];
			#-------------------------------------------------------------------------------
			#Debug(print_r($msgParams,true));
			#-------------------------------------------------------------------------------
			$msg = new FromTicketsMessagesMsg($msgParams, (integer)$OwnerID);
			#-------------------------------------------------------------------------------
			$IsSend = NotificationManager::sendMsg($msg);
			#-------------------------------------------------------------------------------
			switch(ValueOf($IsSend)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				# No more...
			case 'true':
				#-------------------------------------------------------------------------------
				$MessagesCount++;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('EdesksMessages',Array('IsNotify'=>TRUE),Array('ID'=>$Message['ID']));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		# No more...
		continue;
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($MessagesCount > 0 && !IsSet($GLOBALS['TaskReturnInfo']))
	$GLOBALS['TaskReturnInfo'] = SPrintF('%u new messages',$MessagesCount);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
