<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Task','Address','Message','Attribs');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
// возможно, параметры не заданы/требуется немедленная отправка - время не опредлеяем
if(!IsSet($Attribs['IsImmediately']) || !$Attribs['IsImmediately']){
	#-------------------------------------------------------------------------------
	// проверяем, можно ли отправлять в заданное время
	$TransferTime = Comp_Load('Formats/Task/TransferTime',$Attribs['Contact']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($TransferTime)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'integer':
		return $TransferTime;
	case 'false':
		break;
	default:
		return ERROR | @Trigger_Error(100);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Tasks/Viber]: отправка Viber сообщения для (%s)', $Address));
Debug(SPrintF('[comp/Tasks/Viber]: Attribs = %s',print_r($Attribs,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','libs/Viber.php','libs/Server.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Settings = SelectServerSettingsByTemplate('Viber');
#-------------------------------------------------------------------------------
switch(ValueOf($Settings)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = 'server with template: Viber, params: IsActive, IsDefault not found';
	#-------------------------------------------------------------------------------
	if(IsSet($GLOBALS['IsCron']))
		return 3600;
	#-------------------------------------------------------------------------------
	return $Settings;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	$Viber = new Viber($Settings['Params']['Token']);
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// вырезаем некоторые теги, очень уж мешаются при просмотре сообщений
$Message = Preg_Replace('/\[size=([0-9]+)\](.+)\[\/size\]/sU','_\\2_',$Message);
// 
$Message = Preg_Replace('/\[color=([a-z]+)\](.+)\[\/color\]/sU','```\\2```',$Message);
// цитата, моноширинным
$Message = Preg_Replace('/\[quote\](.+)\[\/quote\]/sU',"```\n\\1```\n",$Message);
// код, моноширинный
$Message = Preg_Replace('/\[code\](.+)\[\/code\]/sU',"```\n\\1```\n",$Message);
// жирный
$Message = Preg_Replace('/\[b\](.+)\[\/b\]/sU',"*\\1*",$Message);
// наклонный
$Message = Preg_Replace('/\[i\](.+)\[\/i\]/sU',"_\\1_",$Message);
// ссылка с текстом
$Message = Preg_Replace("(\[link\=[\"']?((http|ftp|https):\/\/[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-\|]*[\w@?^=%&amp;\/~+#-\|])?)[\"']?\](.+?)\[/link\])","[$5]($1)",$Message);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// добавляем привествие, если необходимо
if($Config['Notifies']['Methods']['Viber']['Greeting'])
	$Message = SPrintF("%s\n\n%s",SPrintF(Trim($Config['Notifies']['Methods']['Viber']['Greeting']),$Attribs['UserName']),Trim($Message));
#-------------------------------------------------------------------------------
// добавляем подпись, если необходимо
if(!$Config['Notifies']['Methods']['Viber']['CutSign'])
	$Message = SPrintF("%s\n\n--\n%s",Trim($Message),$GLOBALS['__USER']['Sign']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# достаём данные юзера которому идёт письмо
$User = DB_Select('Users',Array('ID','Params','Email'),Array('UNIQ','ID'=>$Attribs['UserID']));
if(!Is_Array($User))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Viber->MessageSend($Attribs['Contact']['ExternalID'],$Message)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/Viber]: сообщение для %s отправлено',$User['Email']));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	// если не отправилось, ждём час и пробуем снова
	return 3600;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// шлём файл, если он есть
$Attribs['Attachments'] = Is_Array($Attribs['Attachments'])?$Attribs['Attachments']:Array();
#-------------------------------------------------------------------------------
if(SizeOf($Attribs['Attachments']) > 0){
	#-------------------------------------------------------------------------------
	// шлём файл, если он есть
	if($Viber->FileSend($Attribs['Contact']['ExternalID'],$Attribs['Attachments']))
		Debug(SPrintF('[comp/Tasks/Viber]: отправлен файл в Viber'));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/Viber]: отсутствуют файлы приложенные к сообщению'));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Config['Notifies']['Methods']['Viber']['IsEvent'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Event = Comp_Load('Events/EventInsert', Array('UserID'=>$Attribs['UserID'],'Text'=>SPrintF('Сообщение для (%s) через службу Viber отправлено', $Address)));
if(!$Event)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'][$User['Email']]	= Array($Address,$Attribs['Contact']['ExternalID']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
