<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$RowsIDs	= (array)  @$Args['RowsIDs'];
$OrdersIDs	= (array)  @$Args['OrdersIDs'];
$ServiceID	= (string) @$Args['ServiceID'];
$UseBalance	= (boolean)@$Args['UseBalance'];
$ItemsPay	= (integer)@$Args['ItemsPay'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServiceID)
	return ERROR | @Trigger_Error('[comp/www/OrdersPay]: Не задан сервис, невозможно определить что именно оплачивается');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Orders = Array();
$WhereColumn = 'ID';	// по какой колонке выбираем заказы
#-------------------------------------------------------------------------------
foreach($RowsIDs as $RowsID)
	if(!In_Array(IntVal($RowsID),$Orders))
		$Orders[] = IntVal($RowsID);
#-------------------------------------------------------------------------------
// может OrdersIDs прислали?
if(SizeOf($Orders) < 1){
	#-------------------------------------------------------------------------------
	foreach($OrdersIDs as $RowsID)
		if(!In_Array(IntVal($RowsID),$Orders))
			$Orders[] = IntVal($RowsID);
	#-------------------------------------------------------------------------------
	if(SizeOf($Orders) < 1){
		#-------------------------------------------------------------------------------
		return new gException('NO_SELECTED_ORDERS','Необходимо выбрать оплачиваемые заказы');
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$WhereColumn = 'OrderID';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/OrdersPay]: используем колонку: %s',$WhereColumn));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Service = DB_Select('Services',Array('ID','Code','Item','ConsiderTypeID'),Array('UNIQ','ID'=>$ServiceID));
switch(ValueOf($Service)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(
		'`UserID` = @local.__USER_ID',
		SPrintF('`%s` IN (%s)',$WhereColumn,Implode(",",$Orders))
		);
#-------------------------------------------------------------------------------
$Orders = DB_Select(SPrintF('%sOrdersOwners',($Service['Code'] == 'Default')?'':$Service['Code']),Array('*'),Array('Where'=>$Where));
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('NO_ORDERS_FOR_PAY','Отсутствуют заказы которые можно оплатить');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Path = SPrintF('www/API/%sOrderPay',($Service['Code'] == 'Default')?'Service':$Service['Code']);
#-------------------------------------------------------------------------------
if(Is_Error(System_Element(SPrintF('comp/%s.comp.php',$Path)))){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/OrdersPay]: API для заказа сервиса не найдено: %s',$Path));
	#-------------------------------------------------------------------------------
	return new gException('NO_API_SERVICE_ORDER','Не удалось определить API для заказа сервиса');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Count = 0;
foreach($Orders as $Order){
	#-------------------------------------------------------------------------------
	if($Order['StatusID'] == 'Deleted')
		#return new gException('DELETED_ORDERS_CANNOT_BE_PAY','Удалённый заказ нельзя оплатить без восстановления. Обратитесь в техническую поддержку, для восстановления заказа.');
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$OrderPay = Comp_Load($Path,Array(SprintF('%sOrderID',($Service['Code'] == 'Default')?'Service':$Service['Code'])=>$Order['ID'],'DaysPay'=>$ItemsPay,'IsUseBasket'=>(!$UseBalance),'IsNoBasket'=>$UseBalance));
	#-------------------------------------------------------------------------------
	switch(ValueOf($OrderPay)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Count++;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Basket = DB_Count('BasketOwners',Array('Where'=>'`UserID` = @local.__USER_ID'));
if(Is_Error($Basket))
	return ERROR | Trigger_Error(500);
#-----------------------------------------------------------------------------
if($Basket){
	#-------------------------------------------------------------------------------
	return Array('Status'=>'Url','Location'=>'/Basket');
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Message = ($Count > 0)?SPrintF('%s заказов успешно оплачено',$Count):'Не оплачено ни одного заказа, либо не требуется продление, либо они удалены. Для восстановления заказов обратитесь в техническую поддержку';
	return Array('Status'=>'Ok','Count'=>$Count,'Message'=>$Message);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------

?>
