<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ProfileID	= (integer) @$Args['ProfileID'];
$TemplateID	=  (string) @$Args['TemplateID'];
$Simple		=  (string) @$Args['Simple'];
$Window		=  (string) @$Args['Window'];
$Agree		= (boolean) @$Args['Agree'];
$AgreeHandle	= (boolean) @$Args['AgreeHandle'];
$CheckFields	= (boolean) @$Args['CheckFields'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$GLOBALS['__USER']['IsAdmin']){
	#-------------------------------------------------------------------------------
	if(!$Agree)
		return new gException('NOT_AGREE','Вы не дали согласия на передачу информации');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!$AgreeHandle)
		return new gException('NOT_AGREE_HANDLE','Вы не дали согласия на обработку ваших персональных данных');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// редактирование существующего
if($ProfileID){
	#-------------------------------------------------------------------------------
	$Profile = DB_Select('Profiles',Array('UserID','TemplateID'),Array('UNIQ','ID'=>$ProfileID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Profile)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IsPermission = Permission_Check('ProfilesEdit',(integer)$__USER['ID'],(integer)$Profile['UserID']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($IsPermission)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'false':
		return ERROR | @Trigger_Error(700);
	case 'true':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$TemplateID = $Profile['TemplateID'];
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Template = System_XML(SPrintF('profiles/%s.xml',$TemplateID));
if(Is_Error($Template))
	return new gException('ERROR_TEMPLATE_LOAD','Ошибка загрузки шаблона');
#-------------------------------------------------------------------------------
$Params = $Template['Attribs'];
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
$Errors = $Attribs = Array();
#-------------------------------------------------------------------------------
// упрощённый профиль
if($Simple){
	#-------------------------------------------------------------------------------
	$Simple = @JSON_Decode(Base64_Decode($Simple),TRUE);
	if(!$Simple)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Simple = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// разбираем все поля
foreach(Array_Keys($Params) as $AttribID){
	#-------------------------------------------------------------------------------
	$Attrib = $Params[$AttribID];
	#-------------------------------------------------------------------------------
	$Value = (IsSet($Args[$AttribID])?$Args[$AttribID]:$Params[$AttribID]['Value']);
	#-------------------------------------------------------------------------------
	$Attribs[$AttribID] = $Value;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достали с неверным вводом мобильного. не могут по образцу ввести хоть ты тресни
	//Debug(SPrintF('[www/API/ProfileEdit]: $AttribID = %s',$AttribID));
	if(In_Array($AttribID,Array('Phone','CellPhone','Fax'))){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[www/API/ProfileEdit]: $AttribID = %s; Value = %s',$AttribID,$Value));
		#-------------------------------------------------------------------------------
		// телефон, цифры
		$PhoneDigit = Preg_Replace('/[^0-9]/','',$Value);
		#-------------------------------------------------------------------------------
		// длинна телефона
		$PhoneLen = StrLen($PhoneDigit);
		#-------------------------------------------------------------------------------
		// первый символ в номере
		$SymFirst = SubStr($PhoneDigit,0,1);
		#-------------------------------------------------------------------------------
		// если первый 8 то надо заменить на 7
		if($SymFirst == 8){
			#-------------------------------------------------------------------------------
			// меняем первый символ на 7
			$PhoneDigit = SprintF('7%s',SubStr($PhoneDigit,1));
			#-------------------------------------------------------------------------------
			$SymFirst = 7;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// длинна 11 и начинается с 7 - считаем чтоэто телефон РФ
		if($PhoneLen == 11 && $SymFirst == 7){
			#-------------------------------------------------------------------------------
			$Value = SPrintF('+%s %s %s',SubStr($PhoneDigit,0,1),SubStr($PhoneDigit,1,3),SubStr($PhoneDigit,4,7));
			#-------------------------------------------------------------------------------
		}elseif(SubStr($PhoneDigit,0,3) == 375){     // беларусь
			#-------------------------------------------------------------------------------
			$Value = SPrintF('+%s %s %s',SubStr($PhoneDigit,0,3),SubStr($PhoneDigit,3,2),SubStr($PhoneDigit,5,7));
			#-------------------------------------------------------------------------------
		}elseif(SubStr($PhoneDigit,0,3) == 374){     // армения
			#-------------------------------------------------------------------------------
			$Value = SPrintF('+%s %s %s',SubStr($PhoneDigit,0,3),SubStr($PhoneDigit,3,3),SubStr($PhoneDigit,6,7));
			#-------------------------------------------------------------------------------
		}elseif(SubStr($PhoneDigit,0,3) == 996){     // киргизия
			#-------------------------------------------------------------------------------
			$Value = SPrintF('+%s %s %s',SubStr($PhoneDigit,0,3),SubStr($PhoneDigit,3,3),SubStr($PhoneDigit,6,7));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[www/API/ProfileEdit]: после обработки: $AttribID = %s; Value = %s',$AttribID,$Value));
		#-------------------------------------------------------------------------------
		// переназначаем выходное значение
		$Attribs[$AttribID] = $Value;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Count($Simple)){
		#-------------------------------------------------------------------------------
		if(IsSet($Simple[$AttribID])){
			#-------------------------------------------------------------------------------
			$Attrib['IsDuty'] = $Simple[$AttribID];
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	switch($Attrib['Type']){
	case 'Input':
		# No more...
	case 'TextArea':
		#-------------------------------------------------------------------------------
		if($Value){
			#-------------------------------------------------------------------------------
			$Check = $Attrib['Check'];
			#-------------------------------------------------------------------------------
			if(IsSet($Regulars[$Check]))
				$Check = $Regulars[$Check];
			#-------------------------------------------------------------------------------
			if(!Preg_Match($Check,$Value))
				$Errors[] = $AttribID;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			if($Attrib['IsDuty'])
				$Errors[] = $AttribID;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Select':
		#-------------------------------------------------------------------------------
		if(!IsSet($Attrib['Options'][$Value]))
			$Errors[] = $AttribID;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(100);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если есть ошибки - выводим сообщение, не сохраняем
if((Count($Errors) && !$GLOBALS['__USER']['IsAdmin']) || ($GLOBALS['__USER']['IsAdmin'] && $CheckFields)){
	#-------------------------------------------------------------------------------
	$Attribs1 = $Template['Attribs'];
	#-------------------------------------------------------------------------------
	$Parent = NULL;
	#-------------------------------------------------------------------------------
	$Errors = Array_Reverse($Errors);
	#-------------------------------------------------------------------------------
	foreach($Errors as $AttribID){
		#-------------------------------------------------------------------------------
		$Attrib = $Attribs1[$AttribID];
		#-------------------------------------------------------------------------------
		$Exception = new gException(StrToUpper($AttribID),$Attrib['Comment'],$Parent);
		#-------------------------------------------------------------------------------
		$Parent = $Exception;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(IsSet($Exception))
		return new gException('FIELDS_WRONG_FILLED','Неверно заполнены поля',$Exception);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Replace = Array_ToLine($Attribs,'%');
#-------------------------------------------------------------------------------
$ProfileName = $Template['ProfileName'];
#-------------------------------------------------------------------------------
foreach(Array_Keys($Replace) as $Key)
	$ProfileName = Str_Replace($Key,$Replace[$Key],$ProfileName);
#-------------------------------------------------------------------------------
#-----------------------------TRANSACTION---------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('ProfileEdit'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$UProfile = Array('Name'=>$ProfileName,'Attribs'=>$Attribs);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// профиль существует - обновляем, иначе - новый
if($ProfileID){
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('Profiles',$UProfile,Array('ID'=>$ProfileID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Contracts = DB_Select('Contracts',Array('ID','StatusID'),Array('Where'=>SPrintF('`ProfileID` = %u',$ProfileID)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Contracts)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		// собираем договора, меняем статус
		foreach($Contracts as $Contract){
			#-------------------------------------------------------------------------------
			$ContractID = (integer)$Contract['ID'];
			#-------------------------------------------------------------------------------
			if(!Count($Simple)){
				#-------------------------------------------------------------------------------
				if($Contract['StatusID'] == 'OnForming'){
					#-------------------------------------------------------------------------------
					$Comp = Comp_Load('Contracts/Build',$ContractID);
					if(Is_Error($Comp))
						return ERROR | @Trigger_Error(500);
					#-------------------------------------------------------------------------------
					$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Contracts','StatusID'=>'Public','RowsIDs'=>$ContractID,'Comment'=>'Заполнение профиля'));
					#-------------------------------------------------------------------------------
					switch(ValueOf($Comp)){
					case 'error':
						return ERROR | @Trigger_Error(500);
					case 'exception':
						return ERROR | @Trigger_Error(400);
					case 'array':
						# No more...
						break;
					default:
						return ERROR | @Trigger_Error(101);
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(100);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$UProfile = Array_Merge($UProfile,Array('TemplateID'=>$TemplateID,'UserID'=>$__USER['ID']));
	#-------------------------------------------------------------------------------
	$ProfileID = DB_Insert('Profiles',$UProfile);
	if(Is_Error($ProfileID))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// если это системный юзер проверяем наличие профиля с номером 100 - он используется в документообороте
	if($__USER['ID'] == 100){
		#-------------------------------------------------------------------------------
		$Count = DB_Count('Profiles',Array('ID'=>100));
		if(Is_Error($Count))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if(!$Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('Profiles',Array('ID'=>100),Array('ID'=>$ProfileID));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$ProfileID = 100;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Answer = Array('Status'=>'Ok','ProfileID'=>$ProfileID);
#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
$Files = Upload_Get('Document');
#-------------------------------------------------------------------------------
switch(ValueOf($Files)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# No more...
	break;
case 'array':
	#-------------------------------------------------------------------------------
	// сохраняем файлы в таблицу
	if(Is_Error(SaveUploadedFile($Files,'Profiles',$ProfileID)))
		return new gException('CANNOT_SAVE_UPLOADED_FILES','Не удалось сохранить загруженные файлы');
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$StatusID = (Count($Simple)?'OnFilling':'Filled');
#-------------------------------------------------------------------------------
if(Count($Errors)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[www/API/ProfileEdit]: $Errors = %s',print_r($Errors,true)));
	#-------------------------------------------------------------------------------
	$StatusID = 'OnFilling';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Profiles','StatusID'=>$StatusID,'RowsIDs'=>$ProfileID,'Comment'=>'Редактирование профиля'));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(DB_Commit($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!SORM_add('user',$GLOBALS['__USER']['service_aaa'],Array('ProfileID'=>$ProfileID,'ActionTypeId'=>$StatusID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если заполнение профиля вызывано из окна - окно же и вертаем добавив параметр с номером профиля
if($Window){
	#-------------------------------------------------------------------------------
	$Window = JSON_Decode(Base64_Decode($Window),TRUE);
	#-------------------------------------------------------------------------------
	$Window['Args']['ProfileID'] = $ProfileID;
	#-------------------------------------------------------------------------------
	$Answer = Array('Status'=>'Window','Window'=>$Window);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# реализация JBS-539 - активизируем задачи по регистрации доменов этого юзера
$Where = Array(
		"`IsExecuted` = 'no'",
		"`IsActive` = 'no'",
		"`TypeID` = 'DomainRegister'",
		SPrintF('`UserID` = %u',$__USER['ID'])
		);
#-------------------------------------------------------------------------------
$Tasks = DB_Select('Tasks',Array('ID'),Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($Tasks)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# no tasks
	break;
case 'array':
	#-------------------------------------------------------------------------------
	# активируем задачи
	foreach($Tasks as $Task){
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('Tasks',Array('ExecuteDate'=>Time(),'Errors'=>0,'Result'=>'','IsActive'=>TRUE),Array('ID'=>$Task['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Answer;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
