<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DaysPay	= (integer) @$Args['DaysPay'];
$ServiceID	= (integer) @$Args['ServiceID'];
$SchemeID	= (integer) @$Args['SchemeID'];
$UserID		= (integer) @$Args['UserID'];
$CostPay	=  (double) @$Args['CostPay'];
$CostDay	=  (double) @$Args['CostDay'];
$OrderID	= (integer) @$Args['OrderID'];
$ConsiderTypeID	=  (string) @$Args['ConsiderTypeID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если учёт не указан - то по дням
$ConsiderTypeID = IsSet($ConsiderTypeID)?$ConsiderTypeID:'Daily';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// используем текущего юзера, раз не задан
if(!$UserID)
	$UserID = $GLOBALS['__USER']['ID'];
#-------------------------------------------------------------------------------
// достаём группу юзера
$User = DB_Select('Users',Array('*'),Array('UNIQ','ID'=>$UserID));
#-------------------------------------------------------------------------------
switch(ValueOf($User)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------TRANSACTION-------------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('Discounts'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// загружаем политики, может появтся скидки на периоды
$Comp = Comp_Load('Services/Politics',$UserID,$User['GroupID'],$ServiceID,$SchemeID,$DaysPay,SPrintF('Запрос АПИ, %s/%s',$ServiceID,$SchemeID));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Services/Bonuses',$DaysPay,$ServiceID,$SchemeID,$UserID,$CostPay,$CostDay,$OrderID,$ConsiderTypeID,TRUE);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// откатываем транзакцию
if(Is_Error(DB_Roll($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Bonuses = Array();
#-------------------------------------------------------------------------------
foreach($Comp['Bonuses'] as $Bonus){
	#-------------------------------------------------------------------------------
	// если скидка ноль - пропускаем
	if($Bonus[1] == 0)
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Bonuses[] = Array(
				'Days'		=> $Bonus[0]*1,		// можно было IntVal сделать...
				'Discount'	=> $Bonus[1]*100,
				'Economy'	=> Round($Bonus[0]*$Bonus[1]*$CostDay,2)
				);

	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('CostPay'=>Round($Comp['CostPay'],2),'Bonuses'=>$Bonuses);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
