<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ContactID = (integer) @$Args['ContactID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Tree.php','libs/Server.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ContactID)
	return new gException('CONTACT_ID_NOT_SET','Не указан идентификатор контакта');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$Count = DB_Count('Contacts',Array('Where'=>SPrintF('`ID` = %u AND `UserID` = %u',$ContactID,$__USER['ID'])));
if(!$Count)
	return new gException('CONTACT_NOT_FOUND',SPrintF('Контакт (%u) не найден или Вам не принадлежит',$ContactID));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Contact = DB_Select('Contacts','*',Array('UNIQ','ID'=>$ContactID));
switch(ValueOf($Contact)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(100);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Contact['Confirmed'])
	return new gException('CONTACT_NOT_FOUND',SPrintF('Контактный адрес (%s) не подтверждён. Для настройки уведомлений, его необходимо подтвердить',$Contact['Address']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Config['Notifies']['Methods'][$Contact['MethodID']]['IsActive'])
	return new gException('METHOD_ID_DISABLED',SPrintF('Метод уведомления %s отключён и более не используется',$Contact['MethodID']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// заголовок таблицы
$Out = Array('Title'=>SPrintF('%s / %s',$Contact['MethodID'],$Contact['Address']),'Message'=>'','ContactID'=>$ContactID);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если это SMS, достаём цену, пишем объявление о стоимости
if($Contact['MethodID'] == 'SMS'){
	#-------------------------------------------------------------------------------
	$ServersSettings = Comp_Load('Servers/SMSSelectServer',$Contact['Address']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($ServersSettings)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	case 'integer':
		return new gException('SMS_SERVER_NOT_FOUND',SPrintF('Сервер для отправки SMS уведомлений не найден, невозможно настроить параметры уведомлений'));
	default:
		return ERROR | @Trigger_Error(100);
	}
	#-------------------------------------------------------------------------------
	$ServerSettings = $ServersSettings[0];
	#-------------------------------------------------------------------------------
	$Country = $ServersSettings[1];
	#-------------------------------------------------------------------------------
	$Price = $ServersSettings[2];
	#-------------------------------------------------------------------------------
	$Message = SPrintF('SMS платные (%s), включайте только "Уведомления о блокировках заказов"',$Price);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/UserNotifiesSet]: SMS Price = %s',$Price));
	#-------------------------------------------------------------------------------
	// прочeкать SMSExceptionsPaidInvoices, если надо - получить сумму счетов, надпись по итогам вывести
	if(FloatVal($ServerSettings['Params']['ExceptionsPaidInvoices']) >= 0){
		#-------------------------------------------------------------------------------
		$IsSelect = DB_Select('InvoicesOwners','SUM(`Summ`) AS `Summ`',Array('UNIQ','Where'=>SPrintF('`UserID` = %u AND `IsPosted` = "yes" AND `StatusDate` > UNIX_TIMESTAMP() - %u * 24 * 60 *60',$__USER['ID'],$ServerSettings['Params']['ExceptionsPaidInvoicesPeriod'])));
		#-------------------------------------------------------------------------------
		switch(ValueOf($IsSelect)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Formats/Currency',$IsSelect['Summ']);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/www/UserNotifiesSet]: оплачено счетов на сумму (%s)', $Comp));
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Formats/Currency',FloatVal($ServerSettings['Params']['ExceptionsPaidInvoices']));
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Message = ($IsSelect['Summ'] >= FloatVal($ServerSettings['Params']['ExceptionsPaidInvoices']))?SPrintF('Сумма ваших оплаченных счетов больше %s, SMS для вас бесплатны',$Comp):$Message;
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(100);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(Str_Replace(',','.',$ServerSettings['Params'][$Country]) == 0)
			$Message = SPrintF('Для вашей страны (%s) сообщения через SMS бесплатны',$Country);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Out['Message'] = $Message;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out['MethodID'] = $Contact['MethodID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём юзерские настройки уведомлений, т.е. отключенные уведомления
$uNotifies = Array();
#-------------------------------------------------------------------------------
$Notifies = DB_Select('Notifies','*',Array('Where'=>SPrintF('`ContactID` = %u',$ContactID)));
#-------------------------------------------------------------------------------
switch(ValueOf($Notifies)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# No more...
	break;
case 'array':
	#-------------------------------------------------------------------------------
	// собираем в массив уведомления отключенные юзером
	#-------------------------------------------------------------------------------
	foreach($Notifies as $Value)
		$uNotifies[] = $Value['TypeID'];
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(100);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// перебираем уведомления, строим строчки с галочками
$Code = 'Default';
#-------------------------------------------------------------------------------
$Services = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($Config['Notifies']['Types']) as $TypeID){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/UserNotifiesSet]: TypeID = %s',$TypeID));
	#-------------------------------------------------------------------------------
	$Type = $Config['Notifies']['Types'][$TypeID];
	#-------------------------------------------------------------------------------
	// проверяем группу для уведомлений
	if(!IsSet($Type['GroupID']))
		continue;
	#-------------------------------------------------------------------------------
	$Entrance = Tree_Entrance('Groups',(integer)$Type['GroupID']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($Entrance)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		#-------------------------------------------------------------------------------
		if(!In_Array($GLOBALS['__USER']['GroupID'],$Entrance))
			continue 2;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем, есть ли такие услуги у юзера
	$Code = IsSet($Type['Code'])?$Type['Code']:$Code;
	#-------------------------------------------------------------------------------
	$Regulars = SPrintF('/^%s/',$Code);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Preg_Match($Regulars,$TypeID)){
		#-------------------------------------------------------------------------------
		// проверяем по ранее исканному
		if(!In_Array($Code,$Services)){
			#-------------------------------------------------------------------------------
			# код уведомления совпадает с уведомлением
			$Count = DB_Count(SPrintF('%sOrdersOwners',$Code),Array('Where'=>SPrintF('`UserID` = %u',$__USER['ID'])));
			if(Is_Error($Count))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			// сохраняем в массив значение, чтобы не искать снова по БД на следующей галке то что уже есть
			if($Count)
				$Services[] = $Code;
			#-------------------------------------------------------------------------------
			if(!$Count)
				continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// шапочка подраздела, если она задана в конфиге
	if(IsSet($Type['Title'])){
		#-------------------------------------------------------------------------------
		$Title = $Type['Title'];
		#-------------------------------------------------------------------------------
		$Out[$Title] = Array();
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$UseName = SPrintF('Use%s',$Contact['MethodID']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// этот тип уведомлений отключен глобально
//	if(IsSet($Type[$UseName]) && !$Type[$UseName])
//		$Comp->AddAttribs(Array('disabled'=>'true'));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Out[$Title][$TypeID] = In_Array($TypeID,$uNotifies)?FALSE:TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
