<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$PromoCodeID	= (integer) @$Args['PromoCodeID'];
$Code		=  (string) @$Args['Code'];
$ServiceID	= (integer) @$Args['ServiceID'];
$SchemeID       = (integer) @$Args['SchemeID'];
$SchemesGroupID	= (integer) @$Args['SchemesGroupID'];
$ExpirationDate = (integer) @$Args['ExpirationDate'];
$MaxAmount	= (integer) @$Args['MaxAmount'];
$UseOwnerID	= (boolean) @$Args['UseOwnerID'];
$OwnerID	= (integer) @$Args['OwnerID'];
$ForceOwner	= (boolean) @$Args['ForceOwner'];
$DaysDiscont	= (integer) @$Args['DaysDiscont'];
$Discont        = (integer) @$Args['Discont'];
$Comment        =  (string) @$Args['Comment'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Code && !$PromoCodeID)
	return new gException('WRONG_PROMOCODE','Укажите промокод');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServiceID && !$SchemesGroupID)
	return new gException('WRONG_SERVICE_OR_GROUP','Выберите сервис или группу, для которой назначается промокод');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServiceID && $SchemesGroupID)
	return new gException('WRONG_SERVICE_AND_GROUP','Промокод назначается либо на сервис либо на группу');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ExpirationDate < Time())
	return new gException('WRONG_EXPIRATION_DATE','Дата окончания действия находится в прошлом');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($MaxAmount < 1)
	return new gException('WRONG_MAX_AMOUNT','Количество использований промокода не может быть меньше единицы');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($DaysDiscont < 1)
	return new gException('WRONG_DAYS_DISCOUNT','Количество дней скидки промокода не может быть меньше единицы');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Discont < 5 || $Discont > 100)
	return new gException('WRONG_DISCOUNT','Скидка должна принимать значение от 5 до 100');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($UseOwnerID && $OwnerID <= 2000)
	return new gException('WRONG_OWNER','Клиент не может стать рефералом системного пользователя');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$UseOwnerID){
	$OwnerID	= 1;
	$ForceOwner	= FALSE;
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IPromoCode = Array(
	#-----------------------------------------------------------------------------
	'ServiceID'     => ($ServiceID?$ServiceID:NULL),
	'SchemeID'      => ($SchemeID?$SchemeID:NULL),
	'SchemesGroupID'=> ($SchemesGroupID?$SchemesGroupID:NULL),
	'ExpirationDate'=> $ExpirationDate,
	'MaxAmount'	=> $MaxAmount,
	'OwnerID'	=> $OwnerID,
	'ForceOwner'	=> $ForceOwner,
	'DaysDiscont'	=> $DaysDiscont,
	'Discont'       => $Discont/100,
	'Comment'       => $Comment
);
#-------------------------------------------------------------------------------
if($PromoCodeID){
	#-----------------------------------------------------------------------------
	$IsUpdate = DB_Update('PromoCodes',$IPromoCode,Array('ID'=>$PromoCodeID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
}else{
	#-------------------------------------------------------------------------------
	$Count = DB_Count('PromoCodes',Array('Where'=>SPrintF('LOWER(`Code`) = "%s"',StrToLower($Code))));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if($Count)
		return new gException('WRONG_OWNER',' Такой промокод уже есть');
	#-----------------------------------------------------------------------------
	$IPromoCode['Code']		= $Code;
	$IPromoCode['CreateDate'] 	= Time();
	#-----------------------------------------------------------------------------
	$IsInsert = DB_Insert('PromoCodes',$IPromoCode);
	if(Is_Error($IsInsert))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
