<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServiceOrderID	= (integer) @$Args['ServiceOrderID'];
$ContractID	= (integer) @$Args['ContractID'];
$ServerID	= (integer) @$Args['ServerID'];
$DependOrderID	= (integer) @$Args['DependOrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServerID)
	$ServerID = NULL;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServiceOrderID)
	return new gException('ServiceOrderID_NOT_FOUND','Не указан идентификатор заказа на услугу');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Count = DB_Count('Servers',Array('ID'=>$ServerID));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Count)
	return new gException('SERVER_NOT_FOUND','Сервер не найден');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Order = DB_Select('OrdersOwners',Array('UserID','ContractID','ServiceID','(SELECT `NameShort` FROM `Services` WHERE `Services`.`ID` = `ServiceID`) as `NameShort`'),Array('UNIQ','ID'=>$ServiceOrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Order)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Service = DB_Select('Services',Array('ID','Name','IsActive'),Array('UNIQ','ID'=>$Order['ServiceID']));
#-------------------------------------------------------------------------------
switch(ValueOf($Service)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	#-------------------------------------------------------------------------------
	if(!$Service['IsActive'])
		return new gException('SERVICE_NOT_ACTIVE','Услуга не активна');
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServiceOrderFields = DB_Select('OrdersFields',Array('*'),Array('Where'=>SPrintF('`OrderID` = %u',$ServiceOrderID)));
#-------------------------------------------------------------------------------
switch(ValueOf($ServiceOrderFields)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('FIELDS_NOT_DEFINED','Поля услуги не определены');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Validators = $Config['Services']['Fields']['Validators'];
#-------------------------------------------------------------------------------
#---------------------------TRANSACTION-----------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('ServiceOrder'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ContractID != $Order['ContractID']){
	#-------------------------------------------------------------------------------
	$Contract = DB_Select('Contracts','ID',Array('UNIQ','ID'=>$ContractID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Contract)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('Orders',Array('ContractID'=>$ContractID),Array('ID'=>$ServiceOrderID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Keys = Array();
#-------------------------------------------------------------------------------
foreach($ServiceOrderFields as $ServiceOrderField){
	#-------------------------------------------------------------------------------
	$ServiceField = DB_Select('ServicesFields',Array('*'),Array('UNIQ','ID'=>$ServiceOrderField['ServiceFieldID']));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ServiceField)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$UOrderField = Array();
	#-------------------------------------------------------------------------------
	$FieldID = SPrintF('ID%u',$ServiceOrderField['ID']);
	#-------------------------------------------------------------------------------
	$Value = (string) @$Args[$FieldID];
	#-------------------------------------------------------------------------------
	switch($ServiceField['TypeID']){
	case 'File':
		#-------------------------------------------------------------------------------
		$Upload = Upload_Get($FieldID);
		#-------------------------------------------------------------------------------
		switch(ValueOf($Upload)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			$Value = NULL;
			break;
		case 'array':
			#-------------------------------------------------------------------------------
			$UOrderField['FileName'] = $Upload['Name'];
			#-------------------------------------------------------------------------------
			$Value = Base64_Encode($Upload['Data']);
			#-------------------------------------------------------------------------------
                        break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Select':
		#-------------------------------------------------------------------------------
		$Options = Explode("\n",$ServiceField['Options']);
		#-------------------------------------------------------------------------------
		$Alternatives = Array();
		#-------------------------------------------------------------------------------
		foreach($Options as $Option){
			#-------------------------------------------------------------------------------
			$Option = Explode("=",$Option);
			#-------------------------------------------------------------------------------
			$Alternatives[] = Current($Option);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if(!In_Array($Value,$Alternatives))
			return new gException('OPTION_NOT_EXISTS',SPrintF('Неверное значение (%s) поля (%s)',$Value,$ServiceField['Name']));
		#-------------------------------------------------------------------------------
		if($ServiceField['IsKey'])
			$Keys[] = $Value;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		#-------------------------------------------------------------------------------
		$Regulars = Regulars();
		#-------------------------------------------------------------------------------
		if($Value || $ServiceField['IsDuty']){
			#-------------------------------------------------------------------------------
			if(!Preg_Match($Regulars[$ServiceField['ValidatorID']],$Value))
				return new gException('WRONG_FIELD_VALUE',SPrintF('Неверное значение поля (%s) ожидается (%s)',$ServiceField['Name'],$Validators[$ServiceField['ValidatorID']]['Name']));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if($ServiceField['IsKey'])
			$Keys[] = $Value;
	}
	#-------------------------------------------------------------------------------
	$UOrderField['Value'] = $Value;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!Is_Null($Value)){
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('OrdersFields',$UOrderField,Array('ID'=>$ServiceOrderField['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!Count($Keys))
$Keys[] = '-';
#-------------------------------------------------------------------------------
$IsUpdate = DB_Update('Orders',Array('Keys'=>Implode(', ',$Keys),'ServerID'=>$ServerID,'DependOrderID'=>$DependOrderID),Array('ID'=>$ServiceOrderID));
if(Is_Error($IsUpdate))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(Is_Error(DB_Commit($TransactionID)))
return ERROR | @Trigger_Error(500);
#---------------------END TRANSACTION-------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','ServiceOrderID'=>$ServiceOrderID);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
