<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$UserID		= (integer) @$Args['UserID'];
$Confirmed	= (array)   @$Args['Confirmed'];
$IsPrimary	= (array)   @$Args['IsPrimary'];
$IsHidden	= (array)   @$Args['IsHidden'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$UserID)
	return new gException('USER_NOT_SET','Не указан пользователь');
#-------------------------------------------------------------------------------
if(Count($IsPrimary) < 1)
	return new gException('PRIMARY_ADDRESS_NOT_SELECT','Хотя бы один адрес должен быть назачен логином');
#-------------------------------------------------------------------------------
if(Count($IsPrimary) > 1)
	return new gException('TOO_MORE_PRIMARY_ADDRESSES','Логином может быть только один адрес');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Contacts = DB_Select('Contacts',Array('*'),Array('Where' => SPrintF('`UserID` = %s',$UserID)));
#-------------------------------------------------------------------------------
switch(ValueOf($Contacts)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// обновление делаем внутри транзакции, оно может затронуть более одной таблицы
if(Is_Error(DB_Transaction($TransactionID = UniqID('ContactsEdit'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Contacts as $Contact){
	#-------------------------------------------------------------------------------
	// проверяем владельца контакта (на всякий случай)
	if($Contact['UserID'] != $UserID)
		return new gException('CONTACT_USER_AND_USER_NOT_MATCH','Не совпадают владелец контакта и редактируемый пользователь');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// массив значений которые будем обновлять для этого контакта
	$Array = Array('IsPrimary'=>FALSE,'Confirmed'=>0,'IsHidden'=>FALSE);
	#-------------------------------------------------------------------------------
	// этот контакт выставлен первичным
	if(In_Array($Contact['ID'],$IsPrimary)){
		#-------------------------------------------------------------------------------
		// первичным адресом может быть только почта
		if($Contact['MethodID'] != "Email")
			return new gException('ONLY_EMAIL_CAN_BE_PRIMARY_ADDRESS','Логином может быть только почтовый адрес');
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// первичный адрес не может быть скрытым
		if(In_Array($Contact['ID'],$IsHidden))
			return new gException('ONLY_NOT_HIDDEN_ADDRESS_CAN_BE_PRIMARY_ADDRESS','Логином НЕ может быть скрытый адрес');
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// JBS-1346 проверяем что такая почта не является чьим-то логином кроме как у этого же юзера
		$Count = DB_Count('Users',Array('Where'=>SPrintF('`Email` = "%s" AND `ID` != %u',$Contact['Address'],$UserID)));
		if(Is_Error($Count))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count)
			return new gException('ONLY_EMAIL_CAN_BE_PRIMARY_ADDRESS',SPrintF('Адрес (%s) уже является логином у другого пользователя',$Contact['Address']));
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// обновляем поле с логином юзера
		$IsUpdate = DB_Update('Users',Array('Email'=>$Contact['Address']),Array('ID'=>$UserID));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		// добавляем в обновляемые параметры
		$Array['IsPrimary'] = TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// если стоит галка что контакт подтверждён
	if(In_Array($Contact['ID'],$Confirmed)){
		#-------------------------------------------------------------------------------
		// если контакт уже подтвреждён, сохраняем дату подтверждения, иначе ставим 1, чтобы было понятно что не сам подвердил а админ
		$Array['Confirmed'] = ($Contact['Confirmed'])?$Contact['Confirmed']:1;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// если стоит галка что контакт удалён
	if(In_Array($Contact['ID'],$IsHidden))
		$Array['IsHidden'] = TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// обновляем контакт
	$IsUpdate = DB_Update('Contacts',$Array,Array('ID'=>$Contact['ID']));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// коммитим изменения
if(Is_Error(DB_Commit($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!SORM_add('user',$GLOBALS['__USER']['service_aaa'],Array('ActionTypeId'=>'Edit','UserId'=>$UserID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
