<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$UserID		= (integer) @$Args['UserID'];
$Name		=  (string) @$Args['Name'];
$Email		=  (string) @$Args['Email'];
$Password	=  (string) @$Args['Password'];
$GroupID	= (integer) @$Args['GroupID'];
$OwnerID	= (integer) @$Args['OwnerID'];
$IsManaged	= (boolean) @$Args['IsManaged'];
$IsInheritGroup	= (boolean) @$Args['IsInheritGroup'];
$LayPayMaxDays	= (integer) @$Args['LayPayMaxDays'];
$LayPayMaxSumm	=  (double) @$Args['LayPayMaxSumm'];
$LayPayThreshold=  (double) @$Args['LayPayThreshold'];
$Rating		=  (double) @$Args['Rating'];
$IsActive	= (boolean) @$Args['IsActive'];
$LockReason	=  (string) @$Args['LockReason'];
$IsNotifies	= (boolean) @$Args['IsNotifies'];
$IsHidden	= (boolean) @$Args['IsHidden'];
$IsProtected	= (boolean) @$Args['IsProtected'];
$AdminNotice	=  (string) @$Args['AdminNotice'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Name = Trim($Name);
#-------------------------------------------------------------------------------
if(StrLen($Name) < 2)
	return new gException('TOO_SHORT_NAME','Имя пользователя не может быть короче двух символов');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Email = StrToLower($Email);
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['Email'],$Email))
	return new gException('WRONG_EMAIL','Неверно указан электронный адрес');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$User = DB_Select('Users',Array('ID','Email'),Array('UNIQ','ID'=>$UserID));
#-------------------------------------------------------------------------------
switch(ValueOf($User)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Password = Trim($Password);
#-------------------------------------------------------------------------------
if(StrLen($Password) < 8 && $Password != 'Default')
	return new gException('TOO_SHORT_PASSWORD','Пароль не может быть короче 8 символов');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Count = DB_Count('Groups',Array('ID'=>$GroupID));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Count)
	return new gException('GROUP_NOT_FOUND','Группа пользователя не найдена');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Count = DB_Count('Users',Array('ID'=>$OwnerID));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Count)
	return new gException('OWNER_NOT_FOUND','Владелец не найден');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IUser = Array(
		'Name'			=> $Name,
		'Email'			=> $Email,
		'GroupID'		=> $GroupID,
		'OwnerID'		=> $OwnerID,
		'IsManaged'		=> $IsManaged,
		'IsInheritGroup'	=> $IsInheritGroup,
		'LayPayMaxDays'		=> $LayPayMaxDays,
		'LayPayMaxSumm'		=> $LayPayMaxSumm,
		'LayPayThreshold'	=> $LayPayThreshold,
		'Rating'		=> $Rating,
		'IsActive'		=> $IsActive,
		'LockReason'		=> $LockReason,
		'IsNotifies'		=> $IsNotifies,
		'IsHidden'		=> $IsHidden,
		'IsProtected'		=> $IsProtected,
		'AdminNotice'		=> $AdminNotice
		);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Password != 'Default'){
	#-------------------------------------------------------------------------------
	#$IUser['Watchword'] = Md5($Password);
	$Comp = Comp_Load('www/API/UserPasswordChange',Array('Password'=>$Password,'UserID'=>$UserID));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// обновление делаем внутри транзакции, оно может затронуть более одной таблицы
if(Is_Error(DB_Transaction($TransactionID = UniqID('ContactEdit'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($User['Email'] != $Email){
	#-------------------------------------------------------------------------
	$Count = DB_Count('Users',Array('Where'=>SPrintF("`Email` = '%s'",$Email)));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------
	if($Count)
		return new gException('USER_EXISTS','Пользователь с таким логином (электронным адресом) уже существует в системе');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// скидываем все адреса юзера как не-примари
	$IsUpdate = DB_Update('Contacts',Array('IsPrimary'=>FALSE),Array('Where'=>SPrintF('`UserID` = %u',$User['ID'])));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// проверяем есть ли такой контакт у этого юзера
	$Where = SPrintF("`UserID` = %u AND `Address` = '%s' AND `MethodID` = 'Email'",$User['ID'],$Email);
	#-------------------------------------------------------------------------------
	$Count = DB_Count('Contacts',Array('Where'=>$Where));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if($Count){
		#-------------------------------------------------------------------------------
		// адрес есть, ставим первичным
		$IsUpdate = DB_Update('Contacts',Array('IsPrimary'=>TRUE,'IsActive'=>TRUE),Array('Where'=>$Where));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		// адреса нет, втыкаем его в таблицу
		$IContact = Array(
					'CreateDate'	=> Time(),
					'UserID'	=> $User['ID'],
					'MethodID'	=> 'Email',
					'Address'	=> $Email,
					'IsPrimary'	=> TRUE,
					'IsActive'	=> TRUE
				);
		#-------------------------------------------------------------------------------
		$IsInsert = DB_Insert('Contacts',$IContact);
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IsUpdate = DB_Update('Users',$IUser,Array('ID'=>$UserID));
if(Is_Error($IsUpdate))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# исправляем юзера, на всякий случай
$Comp = Comp_Load('Tasks/RecoveryUsers',NULL,$UserID);
#-------------------------------------------------------------------------------
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// коммитим изменения
if(Is_Error(DB_Commit($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!SORM_add('user',$GLOBALS['__USER']['service_aaa'],Array('ActionTypeId'=>'Edit','UserId'=>$User['ID'])))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
