<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$BonusID = (integer) @$Args['BonusID'];
#-------------------------------------------------------------------------------
if($BonusID){
  #-----------------------------------------------------------------------------
  $Bonus = DB_Select('Bonuses','*',Array('UNIQ','ID'=>$BonusID));
  #-----------------------------------------------------------------------------
  switch(ValueOf($Bonus)){
    case 'error':
      return ERROR | @Trigger_Error(500);
    case 'exception':
      return ERROR | @Trigger_Error(400);
    case 'array':
      # No more...
    break;
    default:
      return ERROR | @Trigger_Error(101);
  }
}else{
  #-----------------------------------------------------------------------------
  $Bonus = Array(
     #--------------------------------------------------------------------------
    'UserID'        => 1,
    'ServiceID'     => 0,
    'SchemeID'      => 0,
    'SchemesGroupID'=> 0,
    'ExpirationDate'=> Time() + 365 * 24 * 3600,
    'DaysReserved'  => 30,
    'DaysRemainded' => 30,
    'Discont'       => 0.5,
    'Comment'       => 'Как партнеру'
  );
}
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddAttribs('Body',Array('onload'=>SPrintF("GetSchemes(%s,'SchemeID','%s');",$Bonus['ServiceID'],$Bonus['SchemeID'])));
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/GetSchemes.js}')));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Title = ($BonusID?'Редактирование бонуса':'Добавление нового бонуса');
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
$Table = Array('Общая информация');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Users/Select','UserID',$Bonus['UserID']);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Пользователь',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(
		'`IsActive` = "yes"',
		'`IsHidden` != "yes"',
		);
#-------------------------------------------------------------------------------
$Services = DB_Select('ServicesOwners','*',Array('Where'=>$Where,'SortOn'=>'SortID'));
#-------------------------------------------------------------------------------
switch(ValueOf($Services)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('SERVICES_NOT_FOUND','Для назначения бонуса необходим хотя бы один активный сервис');
	break;
case 'array':
	#-------------------------------------------------------------------------------
	$Options = Array('Любой активный сервис');
	#-------------------------------------------------------------------------------
	foreach($Services as $Service)
		$Options[$Service['ID']] = SPrintF('%s (%s)',$Service['Code'],$Service['NameShort']);
	#-------------------------------------------------------------------------------
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'ServiceID','onchange'=>SPrintF("GetSchemes(this.value,'SchemeID','%s');",$Bonus['SchemeID']),'style'=>'width:100%'),$Options,$Bonus['ServiceID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Сервис',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Options = Array('Любой тариф');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'SchemeID','id'=>'SchemeID','disabled'=>TRUE,'style'=>'width:100%'),$Options,$Bonus['SchemeID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Тариф',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$SchemesGroups = DB_Select('SchemesGroups','*');
#-------------------------------------------------------------------------------
switch(ValueOf($SchemesGroups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	$Options = Array('Нет групп тарифов');
	break;
case 'array':
	#---------------------------------------------------------------------------
	$Options = Array('Не использовать');
	#---------------------------------------------------------------------------
	foreach($SchemesGroups as $SchemesGroup)
		$Options[$SchemesGroup['ID']] = $SchemesGroup['Name'];
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'SchemesGroupID','style'=>'width:100%'),$Options,$Bonus['SchemesGroupID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Группа тарифов',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('jQuery/DatePicker','ExpirationDate',$Bonus['ExpirationDate']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Дата окончания',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
  'Form/Input',
  Array(
    'type'  => 'text',
    'name'  => 'DaysReserved',
    'value' => $Bonus['DaysReserved'],
    'prompt'=> 'Число дней выданной скидки. Для доменов - это года, для дополнительных услуг - дни, года, штуки.',
    'style' => 'width:100%',
  )
);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Сколько действителен',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
  'Form/Input',
  Array(
    'type'  => 'text',
    'name'  => 'DaysRemainded',
    'value' => $Bonus['DaysRemainded'],
    'prompt'=> 'Сколько дней/лет/штук скидки осталось неизрасходованными',
    'style' => 'width:100%',
  )
);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Действителен, осталось',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
  'Form/Input',
  Array(
    'type'  => 'text',
    'name'  => 'Discont',
    'value' => $Bonus['Discont']*100,
    'prompt'=> 'Число от 5 до 100',
    'style' => 'width:100%',
  )
);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Размер скидки в %',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
  'Form/TextArea',
  Array(
    'name'  => 'Comment',
    'style' => 'width:100%;',
    'rows'  => 5,
    'prompt'=> 'Цель/причина создания этой скидки клиенту'
  ),
  $Bonus['Comment']
);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = 'Комментарий';
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
  'Form/Input',
  Array(
    'type'    => 'button',
    'onclick' => SPrintF("FormEdit('/Administrator/API/BonusEdit','BonusEditForm','%s');",$Title),
    'value'   => ($BonusID?'Сохранить':'Добавить')
  )
);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'BonusEditForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
if($BonusID){
  #-----------------------------------------------------------------------------
  $Comp = Comp_Load(
    'Form/Input',
    Array(
      'name'  => 'BonusID',
      'type'  => 'hidden',
      'value' => $BonusID
    )
  );
  if(Is_Error($Comp))
    return ERROR | @Trigger_Error(500);
  #-----------------------------------------------------------------------------
  $Form->AddChild($Comp);
}
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------

?>
