<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ServiceID = (integer) @$Args['ServiceID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServiceID){
	#-------------------------------------------------------------------------------
	$Service = DB_Select('Services','*',Array('UNIQ','ID'=>$ServiceID));
	switch(ValueOf($Service)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		# No more...
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Service = Array(
			'GroupID'		=> 20,
			'UserID'		=> 1,
			'ServicesGroupID'	=> 1000,
			'Name'			=> 'Новая нужная услуга',
			'NameShort'		=> 'Новая услуга',
			'Item'			=> 'Услуга',
			'Measure'		=> 'шт.',
			'ConsiderTypeID'	=> 'Upon',
			'PartnersRewardPercent'	=> -1,
			'CostOn'		=> 10,
			'Cost'			=> 10,
			'IsProtected'		=> FALSE,
			'IsActive'		=> TRUE,
			'IsProlong'		=> TRUE,
			'IsConditionally'	=> FALSE,
			'IsAutoInvoicing'	=> TRUE,
			'Priority'		=> 100,
			'SortID'		=> 10
			);
}
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Script = new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/Pages/Administrator/ServiceEdit.js}'));
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',$Script);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Title = ($ServiceID?SPrintF('Редактирование услуги "%s"',$Service['NameShort']):'Добавление новой услуги');
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Owner','Владелец услуги',$Service['GroupID'],$Service['UserID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$ServicesGroups = DB_Select('ServicesGroups',Array('ID','Name'));
#-------------------------------------------------------------------------------
switch(ValueOf($ServicesGroups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($ServicesGroups as $ServiceGroup)
	$Options[$ServiceGroup['ID']] = $ServiceGroup['Name'];
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'ServicesGroupID','style'=>'width:240px;'),$Options,$Service['ServicesGroupID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Группа услуг',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'Name','value'=>$Service['Name'],'prompt'=>'Это название используется в документах'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Название услуги',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'NameShort','value'=>$Service['NameShort'],'prompt'=>'Используется в напоминаниях, листингах и т.п.'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Краткое название услуги',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'Item','value'=>$Service['Item'],'prompt'=>'Название для отображения в меню'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Раздел меню',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = '';
#-------------------------------------------------------------------------------
// эмблема, может быть только если сервис уже существует
if($ServiceID){
	#-------------------------------------------------------------------------------
	$Files = GetUploadedFilesInfo('Services',$Service['ID']);
	#-------------------------------------------------------------------------------
	foreach($Files as $File){
		#-------------------------------------------------------------------------------
		$Delete = SPrintF('title="Удалить файл" style="cursor:pointer;font-size:11px;text-decoration:underline;" onclick="JavaScript:ShowConfirm(\'Вы подтверждаете удаление файла?\',\'AjaxCall(\\\'/API/FileDelete\\\',{FileID:%u},\\\'Удаление файла\\\',\\\'UploadHideFile(\\\\\\\'file_%s\\\\\\\');\\\');\');"',$File['ID'],$File['ID']);
		#-------------------------------------------------------------------------------
		$NoBR = SPrintF('<NOBR id="file_%s" %s>%s%s/%01.2fkB</NOBR>',$File['ID'],$Delete,($Out)?'<BR />':'',Mb_SubStr($File['Name'],0,16),$File['Size']/1024);
		#-------------------------------------------------------------------------------
		$Out = SPrintF('%s%s',$Out,$NoBR);
		#-------------------------------------------------------------------------------
		// интересен только первый файл
		break;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Files = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Upload','Emblem',SizeOf($Files)?$Out:'-');
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Эмблема (72x72, *.jpg)',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsActive','id'=>'IsActive','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Service['IsActive'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsActive'),'Услуга активна'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Финансовые настройки';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'Measure','value'=>$Service['Measure']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsProtected = $Service['IsProtected'];
#-------------------------------------------------------------------------------
if($IsProtected)
	$Comp->AddAttribs(Array('disabled'=>TRUE));
#-------------------------------------------------------------------------------
$Table[] = Array('Ед. измерения',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Types = $Config['Services']['Consider']['Types'];
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($Types as $TypeID=>$Type)
	$Options[$TypeID] = $Type['Name'];
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'ConsiderTypeID','style'=>'width:240px;',),$Options,$Service['ConsiderTypeID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($IsProtected)
	$Comp->AddAttribs(Array('disabled'=>TRUE));
#-------------------------------------------------------------------------------
$Table[] = Array('Способ учета',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Attribs = Array('name'=>'CostOn','value'=>SPrintF('%01.2f',$Service['CostOn']));
#-------------------------------------------------------------------------------
if($IsProtected)
	$Attribs['disabled'] = TRUE;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',$Attribs);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Стоимость подключения',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Attribs = Array('name'=>'Cost','value'=>SPrintF('%01.2f',$Service['Cost']));
#-------------------------------------------------------------------------------
if($IsProtected)
	$Attribs['disabled'] = TRUE;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',$Attribs);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Начальная цена',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'  => 'text',
			'name'  => 'PartnersRewardPercent',
			'value' => $Service['PartnersRewardPercent'],
			'prompt'=> SPrintF('Процент начисляемый по партнёрской программе, при оплате этой услуги. 0 - не начислять, -1 - начислять процент используемый по умолчанию (%s%%)',$Config['Tasks']['Types']['CaclulatePartnersReward']['PartnersRewardPercent'])
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Партнёрские отчисления, %',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsProlong','id'=>'IsProlong','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Service['IsProlong'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsProlong'),'Возможность продления'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsConditionally','id'=>'IsConditionally','value'=>'yes','prompt'=>'Пользователь может продлевать эту услугу условным счётом, при условии что он её ранее оплачивал'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Service['IsConditionally'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsConditionally'),'Может быть оплачена условно'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsAutoInvoicing','id'=>'IsAutoInvoicing','value'=>'yes','prompt'=>'Разрешить автоматическую выписку счетов для данной услуги'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Service['IsAutoInvoicing'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsAutoInvoicing'),'АвтоВыписка счетов'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Service['Code'])){
	#-------------------------------------------------------------------------------
	$Table[] = 'Действия при установке статусов';
	#-------------------------------------------------------------------------------
	# все услуги как услуги, а для кода Default вечные исключения ... переименовтаь его чтоле ...
	$Statuses = $Config['Statuses'][SPrintF('%sOrders',(($Service['Code'] == 'Default')?'':$Service['Code']))];
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Statuses) as $StatusID){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/www/Administrator/ServiceEdit]: StatusID = %s, Name = %s',$StatusID,$Statuses[$StatusID]['Name']));
		#-------------------------------------------------------------------------------
		# почему я это пропустил? вполне возможен варинат когда надо действие на заказ услуги, до оплаты
		# а пропущено именно это, и только это ... 
		if(IsSet($Statuses[$StatusID]['IsNoAction']) && $Statuses[$StatusID]['IsNoAction'])
			continue;
		#-------------------------------------------------------------------------------
		$Table[] = SPrintF('-%s / %s',$Statuses[$StatusID]['Name'],$StatusID);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# скриптов для штатаных услуг не надо. по крайней мере пока ...
		if($Service['Code'] == 'Default'){
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load(
					'Form/Input',
					Array(
						'type'  => 'text',
						'name'  => SPrintF('Statuses[%s][Script]',$StatusID),
						'value' => @$Service['Params']['Statuses'][$StatusID]['Script'],
						'prompt'=> SPrintF('Скрипт исполняемый при установке статуса "%s". Если имя начинается с символа "/", путь считается полным, иначе скрипт ищется в директории "%s/hosts/%s/scripts/" (возможно создание субдиректорий и указание относительных путей). Скрипты выполняются через exec() (соответственно, файлы должны быть исполняемыми). Если код возврата выполнившегося скрипта отличается от "0", скрипт считается невыполнившимся, как и задание. Пустое поле - не выполнять никаких скриптов.',$Statuses[$StatusID]['Name'],SYSTEM_PATH,HOST_ID)
						)
					);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Table[] = Array('Выполняемый скрипт',$Comp);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>SPrintF('Statuses[%s][IsNoAction]',$StatusID),'id'=>SPrintF('Statuses[%s][IsNoAction]',$StatusID),'value'=>'yes','prompt'=>'Требуется в случаях, когда установка статуса не требует никаких действий от сотрудников - например продление оказываемых услуг. Обратите внимание, что при установке галочки, скрипт задаваемый для статуса выполняться не будет.'));
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if(IsSet($Service['Params']['Statuses'][$StatusID]['IsNoAction']) && $Service['Params']['Statuses'][$StatusID]['IsNoAction'])
				$Comp->AddAttribs(Array('checked'=>'yes'));
			#-------------------------------------------------------------------------------
			$Table[] = Array(new Tag('LABEL',Array('for'=>SPrintF('Statuses[%s][IsNoAction]',$StatusID)),'Не выполнять задачу'),$Comp);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# строим список шаблонов для тикетов, группа статей с ID=10
		$Clauses = DB_Select('Clauses',Array('*'),Array('Where'=>Array('`IsPublish` = "yes"','`GroupID` = 10'),'SortOn'=>'Partition'));
		#-------------------------------------------------------------------------------
		switch(ValueOf($Clauses)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		$Options = Array('0'=>'Не создавать тикет');
		#-------------------------------------------------------------------------------
		foreach($Clauses as $Clause)
			$Options[$Clause['ID']] = SPrintF('[%s] %s',$Clause['Partition'],$Clause['Title']);
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('prompt'=>'Статья которая будет вставлена в тикет, в виде его текста. Используются статьи только из группы статей "Шаблоны тикетов". Обратите внимание, что тикет будет создан только если для данной услуги назначен сервер','name'=>SPrintF('Statuses[%s][ClauseID]',$StatusID),'style'=>'width: 100%;'),$Options,@$Service['Params']['Statuses'][$StatusID]['ClauseID']);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array('Шаблон тикета',$Comp);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# флаг для создаваемого тикета
		$Flags = $Config['Edesks']['Flags'];
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('name'=>SPrintF('Statuses[%s][Flag]',$StatusID),'style'=>'width:100%;','prompt'=>'Флаг, устанавливаемый для создаваемого тикета'),$Flags,@$Service['Params']['Statuses'][$StatusID]['Flag']);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array('Флаг',$Comp);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# не дублировать тикет
		$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>SPrintF('Statuses[%s][IsNoDuplicate]',$StatusID),'id'=>SPrintF('Statuses[%s][IsNoDuplicate]',$StatusID),'value'=>'yes','prompt'=>'Не создавать дубликаты тикетов - тикет создаётся с идентификатором услуги в заголовке тикета, при повторной установке статуса (например, блокировке или активации при оплате) проверяется есть ли тикет с таким заголовком, если есть - то новый не создаётся. Актуально для одноразовых тикетов, например при активации выделенного сервера и т.п.'));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if(IsSet($Service['Params']['Statuses'][$StatusID]['IsNoDuplicate']) && $Service['Params']['Statuses'][$StatusID]['IsNoDuplicate'])
			$Comp->AddAttribs(Array('checked'=>'yes'));
		#-------------------------------------------------------------------------------
		$Table[] = Array(new Tag('LABEL',Array('for'=>SPrintF('Statuses[%s][IsNoDuplicate]',$StatusID)),'Не дублировать тикет'),$Comp);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// к каким услугам относится эта услуга
$Tags = '';
#-------------------------------------------------------------------------------
if(IsSet($Service['Params']['Tags']))
	foreach(Array_Keys($Service['Params']['Tags']) as $Key)
		$Tags = SPrintF("\n%s\n%s:%s",$Tags,$Key,Implode(',',$Service['Params']['Tags'][$Key]));
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/TextArea',Array('name'=>'Tags','style'=>'width:100%;','rows'=>3,'prompt'=>"У каких услуг отображать эту услугу на странице дополнительных услуг. Возможно указать сервис, сервер или группу серверов:\nServices:10000,20000\nServers:3,1\nServersGroups:22,5\n\nМожно указать только один сервер, например, не указывая сервис/группу:\nServers:3,5\n\nИли точно также один сервис/группу"),Trim($Tags));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = 'Для каких сервисов эта услуга';
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Порядок сортировки сервисов';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'SortID','value'=>$Service['SortID']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Порядок сортировки',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Приоритет оплаты';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'Priority','value'=>$Service['Priority'],'prompt'=>'Если в одном счёте содержится несколько сервисов, то первыми будут оплачены те, у которых приоритет выше. Бывает необходимо, когда в одном счёте несколкьо услуг а цена изменилась - например, чтобы домен точно продлился'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Приоритет при оплате',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>'ServiceEdit();','value'=>($ServiceID?'Сохранить':'Добавить')));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ServiceEditForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServiceID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'ServiceID','type'=>'hidden','value'=>$ServiceID));
	if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServiceID){
	#-------------------------------------------------------------------------------
	if(!$IsProtected){
		#-------------------------------------------------------------------------------
		$Iframe = new Tag('IFRAME',Array('name'=>'ServiceFields','src'=>SPrintF('/Administrator/ServiceFields?ServiceID=%s',$ServiceID),'width'=>'450px','height'=>'450px'),'Загрузка...');
		#-------------------------------------------------------------------------------
		$Form = new Tag('TABLE',Array('cellspacing'=>5),new Tag('TR',new Tag('TD',$Form),new Tag('TD',$Iframe)));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
