<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ServiceOrderID = (integer) @$Args['ServiceOrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServiceOrderID)
	return new gException('ServiceOrderID_NOT_FOUND','Не указан идентификатор заказа на услугу');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Order = DB_Select('OrdersOwners',Array('*','(SELECT `NameShort` FROM `Services` WHERE `Services`.`ID` = `ServiceID`) as `NameShort`','(SELECT `Params` FROM `Services` WHERE `Services`.`ID` = `ServiceID`) as `Params`'),Array('UNIQ','ID'=>$ServiceOrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Order)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$OrderID = Comp_Load('Formats/Order/Number',$ServiceOrderID);
if(Is_Error($OrderID))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Title = SPrintF('Редактирование заказа #%s на %s',$OrderID,$Order['NameShort']);
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ServiceOrderEditForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
$Table = $Options = Array();
#-------------------------------------------------------------------------------
$Table[] = 'Общая информация';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Contracts/Select','ContractID',$Order['ContractID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Договор клиента',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServiceOrderFields = DB_Select('OrdersFields',Array('*'),Array('Where'=>SPrintF('`OrderID` = %u',$ServiceOrderID)));
#-------------------------------------------------------------------------------
switch(ValueOf($ServiceOrderFields)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	//return new gException('FIELDS_NOT_DEFINED','Поля услуги не определены');
	$ServiceOrderFields = Array();
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Параметры заказа';
#-------------------------------------------------------------------------------
// скармливаем Tags, проверяем выхлоп
$Options = Comp_Load('Services/Orders/TagsExplain',$Order['Params']['Tags'],$Order['UserID']);
if(Is_Error($Options))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(SizeOf($Options['Orders']) > 0){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('prompt'=>'Выберите заказ к которому относится услуга','name'=>'DependOrderID','style'=>'width: 100%;'),$Options['Options'],$Order['DependOrderID']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Заказ',$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServersGroup = DB_Select('ServersGroups',Array('*'),Array('UNIQ','Where'=>SPrintF('`ServiceID` = %u',$Order['ServiceID']),'Limits'=>Array(0,1),'SortOn'=>'SortID'));
#-------------------------------------------------------------------------------
switch(ValueOf($ServersGroup)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	$Servers = DB_Select('Servers',Array('ID','Address'),Array('Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID']),'SortOn'=>'Address'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Servers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		# No more...
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Options = Array();
	#-------------------------------------------------------------------------------
	foreach($Servers as $Server)
		$Options[$Server['ID']] = $Server['Address'];
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'ServerID','style'=>'width: 100%;'),$Options,$Order['ServerID']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Сервер размещения',$Comp);
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($ServiceOrderFields as $ServiceOrderField){
	#-------------------------------------------------------------------------------
	$ServiceField = DB_Select('ServicesFields',Array('*'),Array('UNIQ','ID'=>$ServiceOrderField['ServiceFieldID']));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ServiceField)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$FieldID = SPrintF('ID%u',$ServiceOrderField['ID']);
	#Debug(SPrintF('[comp/www/Administrator/ServiceOrderEdit]: FieldID = %s',$FieldID));
	#-------------------------------------------------------------------------------
	switch($ServiceField['TypeID']){
	case 'Input':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'name'   => $FieldID,
					'type'   => 'text',
					'prompt' => $ServiceField['Prompt'],
					'value'  => $ServiceOrderField['Value'],
					'style'  => 'width: 100%;'
					)
				);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'TextArea':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/TextArea',
				Array(
					'name'   => $FieldID,
					'rows'   => 4,
					'prompt' => $ServiceField['Prompt'],
					'cols'   => 40,
					'value'  => $ServiceOrderField['Value']
					),
				$ServiceOrderField['Value']
				);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Select':
		#-------------------------------------------------------------------------------
		$Options = Explode("\n",$ServiceField['Options']);
		#-------------------------------------------------------------------------------
		if(!Count($Options))
			return new gException('OPTIONS_IS_EMPTY',SPrintF('Список выбора поля (%s) пуст',$ServiceField['Name']));
		#-------------------------------------------------------------------------------
		$Alternatives = Array();
		#-------------------------------------------------------------------------------
		foreach($Options as $Option){
			#-------------------------------------------------------------------------------
			$Option = Explode("=",$Option);
			#-------------------------------------------------------------------------------
			$Cost = (double)End($Option);
			#-------------------------------------------------------------------------------
			Reset($Option);
			#-------------------------------------------------------------------------------
			if($Cost){
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('Formats/Currency',$Cost);
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				$Alternatives[Current($Option)] = SPrintF('%s (+%s)',Next($Option),$Comp);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$Alternatives[Current($Option)] = Next($Option);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('prompt'=>$ServiceField['Prompt'],'name'=>$FieldID,'style'=>'width: 100%;'),$Alternatives,$ServiceOrderField['Value']);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Hidden':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'name'  => $FieldID,
					'type'  => 'hidden',
					'value' => $ServiceOrderField['Value']
					)
				);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Form->AddChild($Comp);
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'File':
		#-------------------------------------------------------------------------------
		$File = ($ServiceOrderField['Value'])?StrLen(Base64_Decode($ServiceOrderField['Value'])):0;
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Upload',$FieldID,$File?SPrintF('%01.2f Кб.',$File/1024):'-');
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$SizeText = ' (не более 12Mb)';
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Table[] = Array(SPrintF($ServiceField['IsDuty']?'*%s':'%s',SPrintF('%s%s',$ServiceField['Name'],IsSet($SizeText)?$SizeText:'')),$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'    => 'button',
			'onclick' => SPrintF("FormEdit('/Administrator/API/ServiceOrderEdit','ServiceOrderEditForm','%s');",$Title),
			'value'   => ($ServiceOrderID?'Сохранить':'Добавить')
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServiceOrderID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'ServiceOrderID',
				'type'  => 'hidden',
				'value' => $ServiceOrderID
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
