<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddText('Title','Перевод средств между счетами');
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Contracts']['Types'];
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/www/ContractFundsTransfer]: $Settings = %s',print_r($Settings,true)));
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ContractFundsTransferForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// строим список типов договоров С которых можно переводить
$Array = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($Settings) as $Key)
	if($Settings[$Key]['FundTransferFrom'])
		$Array[] = SPrintF("'%s'",$Key);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/www/ContractFundsTransfer]: From `TypeID` IN (%s)',Implode(',',$Array)));
#-------------------------------------------------------------------------------
$Where = SPrintF("`UserID` = %u AND `TypeID` IN (%s)",$GLOBALS['__USER']['ID'],Implode(',',$Array));
#-------------------------------------------------------------------------------
$ContractsFrom = DB_Select('Contracts',Array('ID','TypeID','Customer','Balance'),Array('Where'=>$Where));
switch(ValueOf($ContractsFrom)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('CONTRACT_FROM_NOT_FOUND','Нет подходящих договоров, с которых можно делать переводы.');
case 'array':
        break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// строим список типов договоров НА которые можно переводить
$Array = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($Settings) as $Key)
	if($Settings[$Key]['FundTransferTo'])
		$Array[] = SPrintF("'%s'",$Key);
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/www/ContractFundsTransfer]: To `TypeID` IN (%s)',Implode(',',$Array)));
#-------------------------------------------------------------------------------
$Where = SPrintF("`UserID` = %u AND `TypeID` IN (%s)",$GLOBALS['__USER']['ID'],Implode(',',$Array));
#-------------------------------------------------------------------------------
$ContractsTo = DB_Select('Contracts',Array('ID','TypeID','Customer','Balance'),Array('Where'=>$Where));
switch(ValueOf($ContractsTo)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('CONTRACT_TO_NOT_FOUND','Нет подходящих договоров, на которые можно делать переводы.');
case 'array':
        break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
$Script = 'var PaySumm = {};';
#-------------------------------------------------------------------------------
foreach($ContractsFrom as $Contract){
	#-------------------------------------------------------------------------------
	# проверяем, что баланс не нулевой
	if($Contract['Balance'] > 0){
		if(!IsSet($Summ))
			$Summ = $Contract['Balance'];
		#-------------------------------------------------------------------------------
		$Customer = $Contract['Customer'];
		if(Mb_StrLen($Customer) > 20)
			$Customer = SPrintF('%s...',Mb_SubStr($Customer,0,20));
		#-------------------------------------------------------------------------------
		$Balance = Comp_Load('Formats/Currency',$Contract['Balance']);
		if(Is_Error($Balance))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Number = Comp_Load('Formats/Contract/Number',$Contract['ID']);
		if(Is_Error($Number))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Options[$Contract['ID']] = SPrintF('%s / %s [%s]',$Number,$Customer,$Balance);
		#-------------------------------------------------------------------------------
		$Script = SPrintF("%s PaySumm['%s'] = '%s';",$Script,$Contract['ID'],$Contract['Balance']);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Script = SPrintF('%s form.Summ.value = PaySumm[value]; ',$Script);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
if(SizeOf($Options) == 0)
	return new gException('CONTRACT_FROM_NOT_FOUND','На всех договорах, с которых можно сделать перевод, нулевой баланс');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'FromContractID','style'=>'width: 100%;','onchange'=>$Script),$Options);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY',$Comp);
#-------------------------------------------------------------------------------
$Table[] = Array('Откуда',$NoBody);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($ContractsTo as $Contract){
	#-------------------------------------------------------------------------------
	$Customer = $Contract['Customer'];
	if(Mb_StrLen($Customer) > 20)
		$Customer = SPrintF('%s...',Mb_SubStr($Customer,0,20));
	#-------------------------------------------------------------------------------
	$Balance = Comp_Load('Formats/Currency',$Contract['Balance']);
	if(Is_Error($Balance))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Number = Comp_Load('Formats/Contract/Number',$Contract['ID']);
	if(Is_Error($Number))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Options[$Contract['ID']] = SPrintF('%s / %s [%s]',$Number,$Customer,$Balance);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'ToContractID','style'=>'width: 100%;'),$Options);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY',$Comp);
#-------------------------------------------------------------------------------
$Table[] = Array('Куда',$NoBody);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'name'  => 'Summ',
			'value' => $Summ,
			'type'  => 'text',
			'style'	=> 'width: 100%;',
			'prompt'=> 'Сумма которую вы хотите перевести между договорами'
		)
	);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Сумма',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'onclick' => "FormEdit('/API/ContractFundsTransfer','ContractFundsTransferForm','Осуществление перевода средств между договорами');",
			'type'    => 'button',
			'value'   => 'Перевести'
		)
	);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
$Out = $DOM->Build(FALSE);
#-------------------------------------------------------------------------------
if(Is_Error($Out))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
