<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
if(!Count($Args))
	return "No args...\n";
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сортируем ключи по алфавиту
KSort($Args);
#-------------------------------------------------------------------------------
foreach(Array_Keys($Args) as $Key)
	Debug(SPrintF('[comp/www/Merchant/PayBox]: Args[%s] => %s',$Key,$Args[$Key]));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Invoices']['PaymentSystems']['PayBox'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Sign = @$Args['pg_sig']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/PayBox]: отсутствует подпись, Args[pg_sig] => %s',@$Args['pg_sig']));
	#-------------------------------------------------------------------------------
	return "No sign\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
// удаляем подпись из массива
UnSet($Args['pg_sig']);
#-------------------------------------------------------------------------------
$String = SPrintF('PayBox;%s;%s',Implode(';',$Args),$Settings['Hash']);
//Debug(SPrintF('[comp/www/Merchant/PayBox]: строка = %s',$String));
// проверяем подпись
if($Sign != Md5($String)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/PayBox]: неверная подпись, пришло: %s вычислено: %s',$Sign,Md5($String)));
	#-------------------------------------------------------------------------------
	return "Bad sign\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
//foreach(Array_Keys($Args) as $Key)
//	Debug(SPrintF('[comp/www/Merchant/PayBox]: Args[%s] => %s',$Key,$Args[$Key]));
#-------------------------------------------------------------------------------
// тестовый режим, ничего не делаем
if(@$Args['pg_testing_mode']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/PayBox]: Тестовый запрос, Args[pg_testing_mode] => %s',@$Args['pg_testing_mode']));
	#-------------------------------------------------------------------------------
	return "Test mode not supported\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
// результат платежа
if(!@$Args['pg_result']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/PayBox]: Платёж неудачен, Args[pg_result] => %s',@$Args['pg_result']));
	#-------------------------------------------------------------------------------
	return "Payment not success\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Invoice = DB_Select('Invoices',Array('ID','Summ'),Array('UNIQ','ID'=>$Args['pg_order_id']));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoice)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
if(Round($Invoice['Summ']/$Settings['Course'],2) != $Args['pg_amount']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/PayBox]: сумма/курс = %s, передано = %s',Round($Invoice['Summ']/$Settings['Course'],2),$Args['pg_amount']));
	#-------------------------------------------------------------------------------
	return ERROR | @Trigger_Error('[comp/Merchant/PayBox]: проверка суммы платежа завершилась неудачей');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Users/Init',100);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>'Payed','RowsIDs'=>$Invoice['ID'],'Comment'=>SPrintF('Автоматическое зачисление [%s]',IsSet($Args['pg_payment_method'])?$Args['pg_payment_method']:'not set')));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	return 'Ok';
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
