<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda (for www.host-food.ru) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#Debug(SPrintF("[comp/www/Merchant/PayPal]: before Args = %s",print_r($Args,true)));
#-------------------------------------------------------------------------------
if(!Count($Args))
	return "No args...\n";
#-------------------------------------------------------------------------------
$ArgsIDs = Array('invoice','mc_gross','payment_status','payer_email');
#-------------------------------------------------------------------------------
foreach($ArgsIDs as $ArgID)
	$Args[$ArgID] = @$Args[$ArgID];
#-------------------------------------------------------------------------------
#Debug(SPrintF("[comp/www/Merchant/PayPal]: Args = %s",print_r($Args,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$OrderID = $Args['invoice'];
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Invoices']['PaymentSystems']['PayPal'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Invoice = DB_Select('InvoicesOwners',Array('ID','UserID','Summ','ContractID'),Array('UNIQ','ID'=>$OrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoice)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$InvoiceID = $Invoice['ID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем валидность ответа - пихаем всё обратно в PayPal
#-------------------------------------------------------------------------------
# библиотека для работы с ХТТП
if(Is_Error(System_Load('libs/HTTP.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$HTTP = Array(
		'Protocol'	=> 'ssl',
		'Address'	=> 'www.paypal.com',
		'Port'		=> 443,
		'Host'		=> 'www.paypal.com',
		'Charset'	=> 'UTF-8',
		'IsLogging'	=> TRUE
		);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Query = $Args;
#-------------------------------------------------------------------------------
# параметр, означает, что проверка производится
$Query['cmd'] = '_notify-validate';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result = HTTP_Send('/cgi-bin/webscr',$HTTP,Array(),$Query);
if(Is_Error($Result))
	return ERROR | @Trigger_Error('[PayPal_Check_Payment]: не удалось выполнить запрос к серверу');
#-------------------------------------------------------------------------------
$Result = Trim($Result['Body']);
#-------------------------------------------------------------------------------
Debug(SPrintF("[comp/www/Merchant/PayPal]: Result = %s",print_r($Result,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Result != "VERIFIED")
	return ERROR | @Trigger_Error('[comp/www/Merchant/PayPal]: проверка подлинности завершилась неудачей');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Args['payment_status'] || $Args['payment_status'] != 'Completed'){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/PayPal]: операция неуспешна, payment_status = %s",@$Args['payment_status']));
	#-------------------------------------------------------------------------------
	return "Not success operation, ignored...";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Round($Invoice['Summ']/$Settings['Course'],2) != $Args['mc_gross'])
	return ERROR | @Trigger_Error(SPrintF('[comp/www/Merchant/PayPal]: сумма платежа не совпадает, %s != %s',Round($Invoice['Summ']/$Settings['Course'],2),$Args['mc_gross']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Users/Init',100);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comment = SPrintF('Автоматическое зачисление (%s)',$Args['payer_email']);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>'Payed','RowsIDs'=>$InvoiceID,'Comment'=>$Comment));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return "OK\n";
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
