<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda (for www.host-food.ru) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
if(!Count($Args))
	return "No args...\n";
#-------------------------------------------------------------------------------
$ArgsIDs = Array('amount','checksum','mdOrder','operation','orderNumber','status');
#-------------------------------------------------------------------------------
foreach($ArgsIDs as $ArgID)
	$Args[$ArgID] = @$Args[$ArgID];
#-------------------------------------------------------------------------------
UkSort($Args, "strcasecmp");
#-------------------------------------------------------------------------------
#Debug(SPrintF("[comp/www/Merchant/SberBank]: Args = %s",print_r($Args,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем параметры
if(!$Args['orderNumber']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/SberBank]: not set orderNumber; Args = %s",print_r($Args,true)));
	#-------------------------------------------------------------------------------
	return "No args...\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$OrderID = $Args['orderNumber'];
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Invoices']['PaymentSystems']['SberBank'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Invoice = DB_Select('InvoicesOwners',Array('ID','UserID','Summ','ContractID'),Array('UNIQ','ID'=>$OrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoice)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return "Invoice not found\n";
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$InvoiceID = $Invoice['ID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# два варианта - задан или нет redirect
if(IsSet($Args['redirect'])){
	#-------------------------------------------------------------------------------
	# возможный вариант - повторная попытка оплаты. достаём данные по этому счёту
	$Link = DB_Select('TmpData','Col4',Array('UNIQ','Where'=>Array('`AppID` = "SberBank"',SPrintF('`Col1` = %u',$InvoiceID)),'SortOn'=>'CreateDate','Limits'=>Array(0,1)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Link)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		Header(SPrintF('Location: %s',$Link['Col4']));
		#-------------------------------------------------------------------------------
		exit;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# надо запросить в сбербанке URL на который отсылаем клиента и выдать заголовок с отправкой на этот URL
	#-------------------------------------------------------------------------------
	# библиотека для работы с ХТТП
	if(Is_Error(System_Load('libs/HTTP.php')))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> (($Settings['TestMode'])?'3dsec.sberbank.ru':'securepayments.sberbank.ru'),
			'Port'		=> 443,
			'Host'		=> (($Settings['TestMode'])?'3dsec.sberbank.ru':'securepayments.sberbank.ru'),
			'Protocol'	=> 'ssl',
			'Charset'	=> 'UTF-8',
			'Hidden'	=> $Settings['Password'],
			'IsLogging'	=> FALSE
			);
	#-------------------------------------------------------------------------------
	# дата окончания действия счёта. время до отмены + время до удаления счёта
	$expirationDate = ($Config['Tasks']['Types']['GC']['Invoices']['DaysBeforeDeleted'] + $Config['Tasks']['Types']['GC']['Invoices']['DaysBeforeErase'] + 1) * 24 * 60 * 60 + Time();
	#-------------------------------------------------------------------------------
	$Query = Array(
			'userName'	=> $Settings['Login'],
			'password'	=> $Settings['Password'],
			'orderNumber'	=> $InvoiceID,
			'amount'	=> $Invoice['Summ'] * 100,
			'currency'	=> $Args['currency'],
			'returnUrl'	=> $Args['returnUrl'],
			'failUrl'	=> $Args['failUrl'],
			'description'	=> $Args['description'],
			'expirationDate'=> Date('c',$expirationDate)
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Result = HTTP_Send('/payment/rest/register.do',$HTTP,Array(),$Query);
	if(Is_Error($Result))
		return ERROR | @Trigger_Error('[SberBank_Get_Invoice_URL]: не удалось выполнить запрос к серверу');
	#-------------------------------------------------------------------------------
	$Result = Trim($Result['Body']);
	#-------------------------------------------------------------------------------
	$Result = Json_Decode($Result,TRUE);
	#-------------------------------------------------------------------------------
	#Debug(print_r($Result,true));
	#-------------------------------------------------------------------------------
	if(IsSet($Result['formUrl'])){
		#-------------------------------------------------------------------------------
		# сохраняем переданный URL
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'SberBank','Col1'=>$InvoiceID,'Col4'=>$Result['formUrl']));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		Header(SPrintF('Location: %s',$Result['formUrl']));
		#-------------------------------------------------------------------------------
		exit;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		# ошибка, нет УРЛ
		return ERROR | @Trigger_Error('[comp/www/Merchant/SberBank]: URL не передан, какая-то ошибка');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------

}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Args['status']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/SberBank]: операция неуспешна, status = %s",$Args['status']));
	#-------------------------------------------------------------------------------
	return "Not success operation, ignored...";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Values = '';
#-------------------------------------------------------------------------------
foreach($ArgsIDs as $ArgID)
	if($ArgID != 'checksum')
		if($Args[$ArgID])
			$Values .= SPrintF('%s;%s;',$ArgID,$Args[$ArgID]);
#-------------------------------------------------------------------------------
#Debug(SPrintF("[comp/www/Merchant/SberBank]: Values = %s",$Values));
#-------------------------------------------------------------------------------
if($Args['checksum'] != StrToUpper(Hash_Hmac('sha256',$Values,$Settings['Hash'])))
	return ERROR | @Trigger_Error('[comp/www/Merchant/SberBank]: проверка подлинности завершилась неудачей');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если сумма не задана, или равна нулю
if(!IsSet($Args['amount']) || !$Args['amount']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/SberBank]: параметр 'amount' не передан, проверка суммы платежа невозможна"));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	if($Invoice['Summ'] != $Args['amount'] / 100)
		return ERROR | @Trigger_Error(SPrintF('[comp/www/Merchant/SberBank]: сумма платежа не совпадает, %s != %s',$Invoice['Summ'],($Args['amount'] / 100)));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Users/Init',100);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
switch($Args['operation']){
case 'approved':
	#-------------------------------------------------------------------------------
	$StatusID = 'Waiting';
	#-------------------------------------------------------------------------------
	$Comment = 'Средства успешно заблокированы (выполнена авторизационная транзакция)';
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'deposited':
	#-------------------------------------------------------------------------------
	$StatusID = 'Payed';
	#-------------------------------------------------------------------------------
	$Comment = 'Оплачен (выполнена финансовая транзакция или заказ оплачен в электронной платёжной системе)';
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'refunded':
	#-------------------------------------------------------------------------------
case 'reversed':
	#-------------------------------------------------------------------------------
	# если сумма совпадает - отменяем транзакцию
	if(!IsSet($Args['amount']) || $Args['amount'] != $Invoice['Summ'] * 100){
		#-------------------------------------------------------------------------------
		Debug(SPrintF("[comp/www/Merchant/SberBank]: переданная сумма (%s) не совпадает с суммой счёта (%s)",$Args['amount']/100,$Invoice['Summ']));
		#-------------------------------------------------------------------------------
		return "Summ does not match";
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$StatusID = 'Rejected';
	#-------------------------------------------------------------------------------
	$Comment = 'Отменён (выполнена транзакция разблокировки	средств или выполнена операция по возврату платежа после списания средств)';
	#-------------------------------------------------------------------------------
	#----------------------------------TRANSACTION----------------------------------
	if(Is_Error(DB_Transaction($TransactionID = UniqID('Merchant/SberBank'))))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# ставим счёт как неоплаченный
	# плохая идея. появляется кнопка про оплату, а оплатить нельзя - юнителлер не даёт
	#$IsUpdate = DB_Update('Invoices',Array('IsPosted'=>FALSE),Array('ID'=>$Invoice['ID']));
	#if(Is_Error($IsUpdate))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# вычитаем сумму счёта из договора, на который счёт.
	$Contract = DB_Select('ContractsOwners','Balance',Array('UNIQ','ID'=>$Invoice['ContractID']));
	switch(ValueOf($Contract)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	# UPDATE 2018-04-30 in 20:32 MSK
	# ничего не делаем. эти придурки независимо от суммы возврата присылают сумму которая была оплачена
	#$After = $Contract['Balance'] - $Invoice['Summ'];
	#-------------------------------------------------------------------------------
	#$IsUpdate = DB_Update('Contracts',Array('Balance'=>$After),Array('ID'=>$Invoice['ContractID']));
	#if(Is_Error($IsUpdate))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# заносим запись в историю операций с контрактами
	$Number = Comp_Load('Formats/Invoice/Number',$Invoice['ID']);
	if(Is_Error($Number))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#$IPosting = Array(
	#		'ContractID' => $Invoice['ContractID'],
	#		'ServiceID'  => 2000,
	#		'Comment'    => SPrintF('Возврат средств зачисленных по счёту #%u (транзакция отменена)',$Number),
	#		'Before'     => $Contract['Balance'],
	#		'After'      => $After
	#		);
	#-------------------------------------------------------------------------------
	#$PostingID = DB_Insert('Postings',$IPosting);
	#if(Is_Error($PostingID))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Event = Array('UserID'=>$Invoice['UserID'],'PriorityID'=>'Billing','IsReaded'=>FALSE,'Text'=>SPrintF('Произведён возврат средств по счёту #%u, процессинговый центр прислал статус "%s". Требуется списание в ручном режиме',$Number,$Args['operation']));
	$Event = Comp_Load('Events/EventInsert',$Event);
	if(!$Event)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Invoices/PaymentSystems/SberBank]: статус "%s", счёт #%u проигнорирован',$Args['operation'],$InvoiceID));
	return "OK\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>$StatusID,'RowsIDs'=>$InvoiceID,'Comment'=>$Comment));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если была транзакция - коммитим
if(IsSet($TransactionID))
	if(Is_Error(DB_Commit($TransactionID)))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return "OK\n";
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
