<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda (for www.host-food.ru) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
if(!Count($Args))
	return "No args...\n";
#-------------------------------------------------------------------------------
$ArgsIDs = Array('TerminalKey','OrderId','Success','Status','PaymentId','ErrorCode','Amount','CardId','Pan','ExpDate','Token');
#-------------------------------------------------------------------------------
foreach($ArgsIDs as $ArgID)
	$Args[$ArgID] = @$Args[$ArgID];
#-------------------------------------------------------------------------------
#Debug(SPrintF("[comp/www/Merchant/Tinkoff]: Args = %s",print_r($Args,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Args['amount'])){
	#-------------------------------------------------------------------------------
	// внутри везде с большой буквы
	$Args['Amount'] = $Args['amount'];
	#-------------------------------------------------------------------------------
	UnSet($Args['amount']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# проверяем параметры
if(!$Args['OrderId']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/Tinkoff]: not set OrderId; Args = %s",print_r($Args,true)));
	#-------------------------------------------------------------------------------
	return "No args...\n";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$OrderID = $Args['OrderId'];
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Invoices']['PaymentSystems']['Tinkoff'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Invoice = DB_Select('InvoicesOwners',Array('ID','UserID','Summ','ContractID','StatusID'),Array('UNIQ','ID'=>$OrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoice)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return "Invoice not found\n";
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$InvoiceID = $Invoice['ID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# два варианта - задан или нет redirect
if(IsSet($Args['redirect'])){
	#-------------------------------------------------------------------------------
	# возможный вариант - повторная попытка оплаты. достаём данные по этому счёту
	$Link = DB_Select('TmpData','Col4',Array('UNIQ','Where'=>Array('`AppID` = "Tinkoff"',SPrintF('`Col1` = %u',$InvoiceID)),'SortOn'=>'CreateDate','Limits'=>Array(0,1)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Link)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		Header(SPrintF('Location: %s',$Link['Col4']));
		#-------------------------------------------------------------------------------
		exit;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# надо запросить в тинькофф URL на который отсылаем клиента и выдать заголовок с отправкой на этот URL
	#-------------------------------------------------------------------------------
	# библиотека для работы с ХТТП
	if(Is_Error(System_Load('libs/HTTP.php')))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> (($Settings['TestMode'])?'rest-api-test.tinkoff.ru':'securepay.tinkoff.ru'),
			'Port'		=> 443,
			'Host'		=> (($Settings['TestMode'])?'rest-api-test.tinkoff.ru':'securepay.tinkoff.ru'),
			'Protocol'	=> 'ssl',
			'Charset'	=> 'UTF-8',
			'IsLogging'	=> FALSE
			);
	#-------------------------------------------------------------------------------
	$Query = Array(
			'TerminalKey'		=> $Settings['TerminalKey'],
			'Amount'		=> Round($Invoice['Summ'] * 100),			// в копейках, целых, не дробных
			'OrderId'		=> $InvoiceID,
			'SuccessURL'		=> $Args['SuccessURL'],
			'FailURL'		=> $Args['FailURL'],
			'Description'		=> $Args['description'],
			'RedirectDueDate'	=> Date("Y-m-d\TH:i:s+03:00",Time() + 89*24*3600),	// срок жизни счёта/QR кода
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// подпись надо посчитать: https://www.tbank.ru/kassa/dev/payments/#section/Podpis-zaprosa
	$Token = Comp_Load('Invoices/TinkoffToken',$Query,$Settings);
	if(!$Token)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Query['Token']			= $Token;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Headers			= Array('Content-Type: application/json');
	#-------------------------------------------------------------------------------
	$Result = HTTP_Send('/v2/Init',$HTTP,Array(),Json_Encode($Query),$Headers);
	if(Is_Error($Result))
		return ERROR | @Trigger_Error('[Tinkoff_Get_Invoice_URL]: не удалось выполнить запрос к серверу');
	#-------------------------------------------------------------------------------
	$Result = Trim($Result['Body']);
	#-------------------------------------------------------------------------------
	$Result = Json_Decode($Result,TRUE);
	#-------------------------------------------------------------------------------
	#Debug(print_r($Result,true));
	#-------------------------------------------------------------------------------
	// надо ли показывать оплату через СБП
	if($Settings['ShowSBP']){
		#-------------------------------------------------------------------------------
		// достаём ссылку
		$Query = Array(
				'TerminalKey'	=> $Settings['TerminalKey'],
				'PaymentId'	=> $Result['PaymentId'],
				'DataType'	=> 'PAYLOAD',
				);
		#-------------------------------------------------------------------------------
		$Token = Comp_Load('Invoices/TinkoffToken',$Query,$Settings);
		if(!$Token)
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Query['Token']			= $Token;
		#-------------------------------------------------------------------------------
		$Result2 = HTTP_Send('/v2/GetQr',$HTTP,Array(),Json_Encode($Query),$Headers);
		if(Is_Error($Result))
			return ERROR | @Trigger_Error('[Tinkoff_Get_Invoice_URL]: не удалось выполнить запрос к серверу,QR');
		#-------------------------------------------------------------------------------
		$Result2 = Trim($Result2['Body']);
		#-------------------------------------------------------------------------------
		$Result2 = Json_Decode($Result2,TRUE);
		#-------------------------------------------------------------------------------
		//Debug(SPrintF("[comp/www/Merchant/Tinkoff]: QR; Result2 = %s",print_r($Result2,true)));
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// достаём QR код
		$Query = Array(
				'TerminalKey'	=> $Settings['TerminalKey'],
				'PaymentId'	=> $Result['PaymentId'],
				'DataType'	=> 'IMAGE',
				);
		#-------------------------------------------------------------------------------
		$Token = Comp_Load('Invoices/TinkoffToken',$Query,$Settings);
		if(!$Token)
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Query['Token']			= $Token;
		#-------------------------------------------------------------------------------
		$Result1 = HTTP_Send('/v2/GetQr',$HTTP,Array(),Json_Encode($Query),$Headers);
		if(Is_Error($Result))
			return ERROR | @Trigger_Error('[Tinkoff_Get_Invoice_URL]: не удалось выполнить запрос к серверу,QR');
		#-------------------------------------------------------------------------------
		$Result1 = Trim($Result1['Body']);
		#-------------------------------------------------------------------------------
		$Result1 = Json_Decode($Result1,TRUE);
		#-------------------------------------------------------------------------------
		$QR = $Result1['Data'];
		//Debug(SPrintF("[comp/www/Merchant/Tinkoff]: QR; Result = %s",print_r($Result1,true)));
		#-------------------------------------------------------------------------------
		$QR = Array('Data'=>$Result1['Data'],'Link'=>$Result2['Data'],'Mime'=>'image/svg+xml');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($Result['PaymentURL'])){
		#-------------------------------------------------------------------------------
		# сохраняем переданный URL
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Tinkoff','Col1'=>$InvoiceID,'Col4'=>$Result['PaymentURL'],'Params'=>IsSet($QR)?$QR:Array()));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if(IsSet($Args['SBP'])){
			#-------------------------------------------------------------------------------
			//return(Array('Data'=>$Result1['Data']));
			return TRUE;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			Header(SPrintF('Location: %s',$Result['PaymentURL']));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		exit;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		# ошибка, нет УРЛ
		return ERROR | @Trigger_Error('[comp/www/Merchant/Tinkoff]: URL не передан, какая-то ошибка');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------

}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Args['Status']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/Tinkoff]: операция неуспешна, Status = %s",$Args['Status']));
	#-------------------------------------------------------------------------------
	return "Not success operation, ignored...";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если сумма не задана, или равна нулю
if(!IsSet($Args['Amount']) || !$Args['Amount']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[comp/www/Merchant/Tinkoff]: параметр 'Amount' не передан, проверка суммы платежа невозможна"));
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	if($Invoice['Summ'] != $Args['Amount'] / 100){
		#-------------------------------------------------------------------------------
		// частичный возрат
		if($Args['Status'] == 'PARTIAL_REFUNDED'){
			#-------------------------------------------------------------------------------
			$Number = Comp_Load('Formats/Invoice/Number',$Invoice['ID']);
			if(Is_Error($Number))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Event = Array('UserID'=>$Invoice['UserID'],'PriorityID'=>'Billing','IsReaded'=>FALSE,'Text'=>SPrintF('Произведён частичный (%s/%s) возврат средств по счёту #%u, процессинговый центр прислал статус "%s". Требуется списание в ручном режиме',$Args['Amount'] / 100,$Invoice['Summ'],$Number,$Args['Status']));
			#-------------------------------------------------------------------------------
			$Event = Comp_Load('Events/EventInsert',$Event);
			if(!$Event)
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			return "OK";
		}
		#-------------------------------------------------------------------------------
		return ERROR | @Trigger_Error(SPrintF('[comp/www/Merchant/Tinkoff]: сумма платежа не совпадает, %s != %s',$Invoice['Summ'],($Args['Amount'] / 100)));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
//Debug(SPrintF("[comp/www/Merchant/Tinkoff]: Args = %s",print_r($Args,true)));
// прилетает 1/0, а для вычисления хэша надо строку trye/false!!!
// пидоррасы тинковские.... 4 часа убил пока понял, спасибо хоть в доке пример был с true/false
// а может это биллинг умничает. дамп сессии не снимал... лень уже.
$Args['Success'] = ($Args['Success'])?'true':'false';
#-------------------------------------------------------------------------------
$Token = Comp_Load('Invoices/TinkoffToken',$Args,$Settings);
if(!$Token)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Args['Token'] != $Token)
	return ERROR | @Trigger_Error('[comp/www/Merchant/Tinkoff]: проверка подлинности завершилась неудачей');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Users/Init',100);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
switch($Args['Status']){
# закомментировал. за два емсяца 5 случаев когда статусы вообще одновремнно приходили ...
#case 'AUTHORIZED':
#	#-------------------------------------------------------------------------------
#	// статус не меняем. однажды пришло AUTHORIZED после CONFIRMED ...
#	$StatusID = $Invoice['StatusID'];
#	#-------------------------------------------------------------------------------
#	$Comment = 'Средства успешно заблокированы (выполнена авторизационная транзакция)';
#	#-------------------------------------------------------------------------------
#	break;
#	#-------------------------------------------------------------------------------
case 'CONFIRMED':
	#-------------------------------------------------------------------------------
	$StatusID = 'Payed';
	#-------------------------------------------------------------------------------
	$Comment = 'Оплачен (выполнена финансовая транзакция или заказ оплачен в электронной платёжной системе)';
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'REFUNDED':
	#-------------------------------------------------------------------------------
	# если сумма совпадает - отменяем транзакцию
	if(!IsSet($Args['Amount']) || $Args['Amount'] != $Invoice['Summ'] * 100){
		#-------------------------------------------------------------------------------
		Debug(SPrintF("[comp/www/Merchant/Tinkoff]: переданная сумма (%s) не совпадает с суммой счёта (%s)",$Args['Amount']/100,$Invoice['Summ']));
		#-------------------------------------------------------------------------------
		return "Summ does not match";
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$StatusID = 'Rejected';
	#-------------------------------------------------------------------------------
	$Comment = 'Отменён (выполнена транзакция разблокировки	средств или выполнена операция по возврату платежа после списания средств)';
	#-------------------------------------------------------------------------------
	#----------------------------------TRANSACTION----------------------------------
	if(Is_Error(DB_Transaction($TransactionID = UniqID('Merchant/Tinkoff'))))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# ставим счёт как неоплаченный
	# плохая идея. появляется кнопка про оплату, а оплатить нельзя - юнителлер не даёт
	#$IsUpdate = DB_Update('Invoices',Array('IsPosted'=>FALSE),Array('ID'=>$Invoice['ID']));
	#if(Is_Error($IsUpdate))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# вычитаем сумму счёта из договора, на который счёт.
	$Contract = DB_Select('ContractsOwners','Balance',Array('UNIQ','ID'=>$Invoice['ContractID']));
	switch(ValueOf($Contract)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	# UPDATE 2018-04-30 in 20:32 MSK
	# ничего не делаем. эти придурки независимо от суммы возврата присылают сумму которая была оплачена
	#$After = $Contract['Balance'] - $Invoice['Summ'];
	#-------------------------------------------------------------------------------
	#$IsUpdate = DB_Update('Contracts',Array('Balance'=>$After),Array('ID'=>$Invoice['ContractID']));
	#if(Is_Error($IsUpdate))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# заносим запись в историю операций с контрактами
	$Number = Comp_Load('Formats/Invoice/Number',$Invoice['ID']);
	if(Is_Error($Number))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#$IPosting = Array(
	#		'ContractID' => $Invoice['ContractID'],
	#		'ServiceID'  => 2000,
	#		'Comment'    => SPrintF('Возврат средств зачисленных по счёту #%u (транзакция отменена)',$Number),
	#		'Before'     => $Contract['Balance'],
	#		'After'      => $After
	#		);
	#-------------------------------------------------------------------------------
	#$PostingID = DB_Insert('Postings',$IPosting);
	#if(Is_Error($PostingID))
	#	return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Event = Array('UserID'=>$Invoice['UserID'],'PriorityID'=>'Billing','IsReaded'=>FALSE,'Text'=>SPrintF('Произведён возврат средств по счёту #%u, процессинговый центр прислал статус "%s". Требуется списание в ручном режиме',$Number,$Args['Status']));
	$Event = Comp_Load('Events/EventInsert',$Event);
	if(!$Event)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Merchant/Tinkoff]: статус "%s", счёт #%u проигнорирован',$Args['Status'],$InvoiceID));
	return "OK";
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>$StatusID,'RowsIDs'=>$InvoiceID,'Comment'=>$Comment));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если была транзакция - коммитим
if(IsSet($TransactionID))
	if(Is_Error(DB_Commit($TransactionID)))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return "OK";
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
