<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('libs/HTTP.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Messages();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!IsSet($Args['code']))
	return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['NoCode']),FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Interface']['User']['OAuth']['OK'];
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['Disabled']),FALSE);
#-------------------------------------------------------------------------------
if(!$Settings['ClientSecret'] || !$Settings['ClientID'])
	return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['NoSettings']),FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// код для получения токена, меняем на токен
$HTTP = Array(
		'Address'	=> 'api.ok.ru',
		'Port'		=> 443,
		'Host'		=> 'api.ok.ru',
		'Protocol'	=> 'ssl',
		);
#-------------------------------------------------------------------------------
$Body = Array(
		'grant_type'	=> 'authorization_code',
		'code'		=> $Args['code'],
		'client_id'	=> $Settings['ClientID'],
		'client_secret'	=> $Settings['ClientSecret'],
		'redirect_uri'	=> SPrintF('%s://%s/OAuth/OK',URL_SCHEME,HOST_ID),
		);
#-------------------------------------------------------------------------------
$Result = HTTP_Send('/oauth/token.do',$HTTP,Array(),$Body,Array());
if(Is_Error($Result))
	return ERROR | @Trigger_Error('[API]: не удалось выполнить запрос к серверу api.ok.ru');
#-------------------------------------------------------------------------------
$Result = Json_Decode(Trim($Result['Body']),TRUE);
#-------------------------------------------------------------------------------
if(!IsSet($Result['access_token']))
	return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['NoAccessToken']),FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// по полученному токену, достаём данные клиента
$HTTP = Array(
		'Address'	=> 'api.ok.ru',
		'Port'		=> 443,
		'Host'		=> 'api.ok.ru',
		'Protocol'	=> 'ssl',
		);
#-------------------------------------------------------------------------------
$Query = Array('method'=>'users.getCurrentUser','fields'=>'email','access_token'=>$Result['access_token'],'application_key'=>$Settings['PublicKey']);
#-------------------------------------------------------------------------------
$Result = HTTP_Send('/fb.do',$HTTP,$Query,Array(),Array());
#-------------------------------------------------------------------------------
if(Is_Error($Result))
	return ERROR | @Trigger_Error('[API]: не удалось выполнить запрос к серверу api.ok.ru');
#-------------------------------------------------------------------------------
$Result = Json_Decode(Trim($Result['Body']),TRUE);
#-------------------------------------------------------------------------------
// это поделие требует чтобы на api-support@ok.ru накатали письмо с ID приложения и 
// аргуметацией - а зачем вам почтовый адрес пользоватетеля... дурдом, надо отдельную ошибку по 
// этому поводу выводить чтобы на этапе тестирвоания понимали что делать
if(!IsSet($Result['email']))
	return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['NoEmail']),FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# TODO портрет юзера
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// данные для аккаунта
$Address= $Result['email'];
$UserID	= $Result['uid'];
$Name	= IsSet($Result['name'])?$Result['name']:FALSE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IsUser = Comp_Load('OAuth/ManageAccount','OK',$Address,$UserID,$Name);
#-------------------------------------------------------------------------------
//Debug(SPrintF('[comp/www/OAuth/OK]: IsUser = %s',print_r($IsUser,true)));
switch(ValueOf($IsUser)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
        return TemplateReplace('OAuth.Error',Array('TEXT'=>$IsUser->String),FALSE);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// закрываем окно
return TemplateReplace('OAuth.Error',Array('TEXT'=>$Messages['Errors']['OAuth']['Completed'],'CLOSE'=>1),FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
