<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$UserID = (integer) @$Args['UserID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddAttribs('Body',Array('onload'=>"window.document.getElementById('Message').focus();"));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($UserID){
	#-------------------------------------------------------------------------------
	$User = DB_Select('Users',Array('ID','GroupID','Name','Email'),Array('UNIQ','ID'=>$UserID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($User)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('USER_NOT_FOUND','Пользователь не найден');
	case 'array':
		# No more...
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$UserID?SPrintF('Новый запрос для [%s]',$User['Email']):'Новый запрос');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Script = new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/TicketFunctions.js}'));
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',$Script);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'TicketEditForm','onsubmit'=>'return false;','OnKeyPress'=>"ctrlEnterEvent(event) && FormEdit('/API/TicketEdit','TicketEditForm','Добавление запроса');"));
#-------------------------------------------------------------------------------
$Table = Array('Общие параметры');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Theme','style'=>'width: 100%','type'=>'text','prompt'=>"Краткое описание Вашей проблемы или вопроса.\nНапример: Проблемы с почтой"));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Тема запроса',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Groups = DB_Select('Groups',Array('ID','Name','Comment'),Array('Where'=>"`IsDepartment` = 'yes'"));
#-------------------------------------------------------------------------------
switch(ValueOf($Groups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('DEPARTMENTS_NOT_FOUND','Отделы не определены');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($Groups as $Group)
	$Options[$Group['ID']] = SPrintF('%s (%s)',$Group['Name'],$Group['Comment']);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'TargetGroupID','style'=>'width: 100%'),$Options);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Отдел',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($__USER['IsAdmin']){
	#-------------------------------------------------------------------------------
	$Workers = DB_Select('Users',Array('ID','Name'),Array('Where'=>SPrintF("(SELECT `IsDepartment` FROM `Groups` WHERE `Groups`.`ID` = `Users`.`GroupID`) = 'yes' OR `ID` = 100")));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Workers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('WORKERS_NOT_FOUND','Сотрудники не определены');
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Options = Array();
	#-------------------------------------------------------------------------------
	foreach($Workers as $Worker)
		$Options[$Worker['ID']] = $Worker['Name'];
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'TargetUserID','style'=>'width: 100%'),$Options,$__USER['ID']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Сотрудник',$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Сообщение';
#-------------------------------------------------------------------------------
$Tr = new Tag('TR');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Upload','TicketMessageFile','-',($__USER['IsAdmin'])?$Config['Interface']['User']['Files']['EdesksMessages']['MaxFiles']:100500);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Tr->AddChild(new Tag('NOBODY',new Tag('TD',Array('class'=>'Comment'),'Прикрепить файл'),new Tag('TD',$Comp)));
#-------------------------------------------------------------------------------
if($__USER['IsAdmin']){ # is support
	#-------------------------------------------------------------------------------
	$Articles = DB_Select('Clauses','*',Array('Where'=>"`GroupID` = 10 AND `IsPublish` = 'yes'",'SortOn'=>'Partition'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Articles)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		$A = new Tag('A',Array('title'=>'как добавить шаблоны быстрых ответов','href'=>'https://wiki.joonte.com/index.php?title=TiketAnswerTemplate'),'шаблоны ответов');
		#-------------------------------------------------------------------------------
		$Tr->AddChild(new Tag('TD',$A));
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($Articles as $Article){
			#-------------------------------------------------------------------------------
			# prepare text: delete tags, begin/end space
			$Text = trim(Strip_Tags($Article['Text']));
			# delete space on string begin
			$Text = Str_Replace("\n ","\n",$Text);
			# delete double spaces
			$Text = Str_Replace("  "," ",$Text);
			# delete carrier return
			$Text = Str_Replace("\r","",$Text);
			# delete many \n
			$Text = Str_Replace("\n\n","\n",$Text);
			# prepare for java script
			$Text = Str_Replace("\n",'\\n',$Text);
			# format: /Administrator/Buttons:SortOrder:ImageName.gif
			# button image, get image name
			$Partition = explode(":", $Article['Partition']);
			$Extension = (IsSet($Partition[2])?Explode(".", StrToLower($Partition[2])):'');
			# если есть чё-то после точки, и если оно похоже на расширение картинки, ставим это как картинку
			if(IsSet($Extension[1]) && In_Array($Extension[1],Array('png','gif','jpg','jpeg'))){
				#-------------------------------------------------------------------------------
				$Image = $Partition[2];
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				# иначе - дефолтовую информационную картинку
				$Image = 'Info.gif';
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			# делаем кнопку
			$Comp = Comp_Load('Buttons/Standard',Array('onclick'=>SPrintF("form.Message.value += '%s'; form.Message.focus();",$Text),'style'=>'cursor: pointer;'),$Article['Title'],$Image);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Td = new Tag('TD');
			#-------------------------------------------------------------------------------
			$Td->AddChild($Comp);
			#-------------------------------------------------------------------------------
			$Tr->AddChild($Td);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
} # is support
#-------------------------------------------------------------------------------
$Table[] = new Tag('TABLE',$Tr);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/TextArea',Array('name'=>'Message','id'=>'Message','style'=>'width:100%;','rows'=>10,'AutoFocus'=>'yes','PlaceHolder'=>'Введите ваше сообщение'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Disabled = Array();
#-------------------------------------------------------------------------------
// у простого юзера не все кнопки отображаются
if(!$__USER['IsAdmin']){
	#-------------------------------------------------------------------------------
	$Disabled[] = 'hidden';
	#-------------------------------------------------------------------------------
	$Disabled[] = 'code';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Edesks/Panel',$Disabled);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Tr = new Tag('TR',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>"FormEdit('/API/TicketEdit','TicketEditForm','Добавление запроса');",'value'=>'Добавить'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($__USER['IsAdmin']){
	#-------------------------------------------------------------------------------
	# сотрудник, добавляем флаги
	$Config = Config();
	#-------------------------------------------------------------------------------
	$Positions = $Config['Edesks']['Flags'];
	#-------------------------------------------------------------------------------
	$Comp1 = Comp_Load('Form/Select',Array('name'=>'Flags'),$Positions,'CloseOnSee');
	if(Is_Error($Comp1))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Div = new Tag('DIV',$Comp1,new Tag('SPAN','и'),$Comp);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	# юзер. тока кнопка
	$Div = new Tag('DIV',$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Tr->AddChild(new Tag('TD',Array('align'=>'right'),$Div));
#-------------------------------------------------------------------------------
$Table[] = new Tag('TABLE',Array('width'=>'100%'),$Tr);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($UserID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('type'=>'hidden','name'=>'UserID','value'=>$UserID));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$Tr = new Tag('TR',new Tag('TD',Array('valign'=>'top'),$Form));
#-------------------------------------------------------------------------------
if(!$UserID){
	#-------------------------------------------------------------------------------
	$Users = DB_Select('Users',Array('ID','Name','(SELECT `Name` FROM `Groups` WHERE `Users`.`GroupID` = `Groups`.`ID`) as `GroupName`'),Array('Where'=>"(SELECT `IsDepartment` FROM `Groups` WHERE `Groups`.`ID` = `Users`.`GroupID`) = 'yes' AND `IsHidden` = 'no' AND UNIX_TIMESTAMP() - `EnterDate` < 600"));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Users)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Table = new Tag('TABLE',Array('class'=>'Standard','cellspacing'=>5,'id'=>'NowOnlineSupport'),new Tag('CAPTION','Сейчас в сети'));
		#-------------------------------------------------------------------------------
		$Block = new Tag('TR');
		#-------------------------------------------------------------------------------
		foreach($Users as $User){
			#-------------------------------------------------------------------------------
			// достаём фотку юзера

			$Block->AddHTML(TemplateReplace('www.TicketEdit',$User));
			#-------------------------------------------------------------------------------
			if(Count($Block->Childs)%2 == 0){
				#-------------------------------------------------------------------------------
				$Table->AddChild($Block);
				#-------------------------------------------------------------------------------
				$Block = new Tag('TR');
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if(Count($Block->Childs))
			$Table->AddChild($Block);
		#-------------------------------------------------------------------------------
		$Tr->AddChild(new Tag('TD',Array('valign'=>'top'),$Table));
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',new Tag('TABLE',$Tr));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
