<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/


// функция доставания выписки. вызывается снаружи.
// всё остальное - внутренние функции
function GetStatement($Settings){
	#-------------------------------------------------------------------------------
	// Информация о счетах
	$Answer = OpenRuAPI($Settings);
	#-------------------------------------------------------------------------------
	if(!IsSet($Answer['data']['content']) || !Is_Array($Answer['data']['content']))
		return ERROR | @Trigger_Error('[OpenRu/GetStatement]: не удалось получить список счетов');
	#-------------------------------------------------------------------------------
	// ищем идентфикатор аккаунта по номер р/с
	foreach($Answer['data']['content'] as $Account)
		if($Account['accountNumber'] == $Settings['AccountNumber'])
			$accountId = $Account['accountId'];
	#-------------------------------------------------------------------------------
	if(!IsSet($accountId))
		return ERROR | @Trigger_Error(SPrintF('[OpenRu/GetStatement]: не удалось найти расчётный счёт %s',$Account['accountNumber']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// запрашиваем выписку, даты - сегодня и вчера, т.к. могут быть новые сутки
	$Answer = OpenRuAPI($Settings,SPrintF('/%s/statement?format=JSON&from=%s&to=%s',$accountId,Date('Y-m-d',Time()-24*60*60),Date('Y-m-d')),Array('format'=>'JSON'));
	#-------------------------------------------------------------------------------
	if(!IsSet($Answer['data']['statementId']))
		return ERROR | @Trigger_Error('[OpenRu/GetStatement]: не удалось запросить выписку');
	#-------------------------------------------------------------------------------
	$statementId = $Answer['data']['statementId'];
	#-------------------------------------------------------------------------------
	// ждём, пока сгенерируется
	Sleep(3);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем статус выписки, три попытки, с таймаутами между ними
	for ($i = 1; $i <= 5; $i++){
		#-------------------------------------------------------------------------------
		$Answer = OpenRuAPI($Settings,SPrintF('/%s/statement/%s',$accountId,$statementId));
		#-------------------------------------------------------------------------------
		if($Answer['data']['status'] != 'SUCCESS'){
			#-------------------------------------------------------------------------------
			Sleep(30);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// проверим итоги
	if($Answer['data']['status'] != 'SUCCESS')
		return ERROR | @Trigger_Error('[OpenRu/GetStatement]: превышен таймаут ожидания выписки');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// Получаем саму выписку
	$Answer = OpenRuAPI($Settings,SPrintF('/%s/statement/%s/print?print=true',$accountId,$statementId));
	#-------------------------------------------------------------------------------
	// проверяем платежи
	if(Is_Array(@$Answer['account']['sendTransactionsToWARequest']['paymentDocumentList']) && SizeOf(@$Answer['account']['sendTransactionsToWARequest']['paymentDocumentList']))
		$Payments = $Answer['account']['sendTransactionsToWARequest']['paymentDocumentList'];
	#-------------------------------------------------------------------------------
	if(Is_Array(@$Answer['account']['getStatementSyncResponse']['paymentDocumentList']) && SizeOf($Answer['account']['getStatementSyncResponse']['paymentDocumentList']))
		$Payments = $Answer['account']['getStatementSyncResponse']['paymentDocumentList'];
	#-------------------------------------------------------------------------------
	if(!IsSet($Payments) || !SizeOf($Payments)){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/DBO_open.ru]: нет платежей, Answer = %s',print_r($Answer,true)));
		#-------------------------------------------------------------------------------
		return Array();
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/DBO_open.ru]: есть платежи'));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#Debug(SprintF('[system/libs/DBO_open.ru]: Выписка = %s',print_r($Answer,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем платежи, строим выходной массив
	$Out = Array();
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Payments) as $Key){
		#-------------------------------------------------------------------------------
		// пропускаем то что оплатили мы кому-то
		if($Payments[$Key]['payerInfo']['accountNumber'] == $Settings['AccountNumber'])
			continue;
		#-------------------------------------------------------------------------------
		$Out[] = Array(
				'Key'		=> $Key,	// для дебага в задаче
				'Summ'		=> $Payments[$Key]['documentAmount']['amount'],
				'Customer'	=> $Payments[$Key]['payerInfo']['name'],
				'Inn'		=> $Payments[$Key]['payerInfo']['inn'],
				'Purpose'	=> $Payments[$Key]['paymentPurpose'],
				);
		#-------------------------------------------------------------------------------
		Debug(SprintF('[system/libs/DBO_open.ru]: [%s]: ИНН: %s, сумма: %s; %s',$Key,$Payments[$Key]['payerInfo']['inn'],$Payments[$Key]['documentAmount']['amount'],$Payments[$Key]['paymentPurpose']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	Debug(SprintF('[system/libs/DBO_open.ru]:'));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// работа с АПИ
function OpenRuAPI($Settings,$Url = '',$Post = Array()){
	#-------------------------------------------------------------------------------
	// строим полный адрес который вызываем
	$Url = SPrintF('/webapi-2.1/accounts%s',$Url);
	#-------------------------------------------------------------------------------
	// параметры вызова
	$HTTP = Array(
			'Address'	=> 'internetbankmb.open.ru',
			'Port'          => '443',
			'Host'          => 'internetbankmb.open.ru',
			'Protocol'      => 'ssl',
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// заголовки
	$Headers = Array(SPrintF('Authorization: Bearer sso_1.0_%s',$Settings['Token']));
	#-------------------------------------------------------------------------------
	// у POST заголовок сам добавляется
	if(!SizeOf($Post))
		$Headers[] = 'Content-Type: application/json';
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Result = HTTP_Send($Url,$HTTP,Array(),$Post,$Headers);
	#-------------------------------------------------------------------------------
	if(Is_Error($Result))
		return ERROR | @Trigger_Error('[OpenRu/API]: не удалось выполнить запрос к серверу');
	#-------------------------------------------------------------------------------
	$Result = Trim($Result['Body']);
	#-------------------------------------------------------------------------------
	$Result = Json_Decode($Result,TRUE);
	#-------------------------------------------------------------------------------
	#Debug(Print_r($Result,true));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}



?>
