<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/


// функция доставания выписки. вызывается снаружи.
// всё остальное - внутренние функции
function GetStatement($Settings){
	#-------------------------------------------------------------------------------
	// запрашиваем выписку, даты - сегодня и вчера, т.к. могут быть новые сутки
	$Answer = TinkoffRuAPI($Settings,SPrintF('from=%sT00:00:00Z',Date('Y-m-d',Time()-1*24*60*60)),Array('format'=>'JSON'));
	#-------------------------------------------------------------------------------
	if(!IsSet($Answer['operations']))
		return ERROR | @Trigger_Error('[TinkoffRu/GetStatement]: не удалось запросить выписку');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем платежи
	if(Is_Array(@$Answer['operations']) && SizeOf(@$Answer['operations']))
		$Payments = $Answer['operations'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!IsSet($Payments) || !SizeOf($Payments)){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/DBO_tinkoff.ru]: нет платежей, Answer = %s',print_r($Answer,true)));
		#-------------------------------------------------------------------------------
		return Array();
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/DBO_tinkoff.ru]: есть платежи'));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#Debug(SprintF('[system/libs/DBO_tinkoff.ru]: Выписка = %s',print_r($Answer,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем платежи, строим выходной массив
	$Out = Array();
	#-------------------------------------------------------------------------------
	foreach($Payments as $Payment){
		#-------------------------------------------------------------------------------
		// какие-то оплаты за СБП
		if(!IsSet($Payment['payer']))
			continue;
		#-------------------------------------------------------------------------------
		// пропускаем то что оплатили мы кому-то
		if($Payment['payer']['acct'] == $Settings['AccountNumber'])
			continue;
		#-------------------------------------------------------------------------------
		$Out[] = Array(
				'Summ'		=> $Payment['operationAmount'],
				'Customer'	=> $Payment['payer']['name'],
				'Inn'		=> $Payment['payer']['inn'],
				'Purpose'	=> $Payment['payPurpose'],
				);
		#-------------------------------------------------------------------------------
		Debug(SprintF('[system/libs/DBO_tinkoff.ru]: ИНН: %s, сумма: %s; %s',$Payment['payer']['inn'],$Payment['operationAmount'],$Payment['payPurpose']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	Debug(SprintF('[system/libs/DBO_tinkoff.ru]:'));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// работа с АПИ
function TinkoffRuAPI($Settings,$Url = ''){
	#-------------------------------------------------------------------------------
	// строим полный адрес который вызываем
	$Url = SPrintF('/openapi/api/v1/statement?accountNumber=%s&%s',$Settings['AccountNumber'],$Url);
	#-------------------------------------------------------------------------------
	// параметры вызова
	$HTTP = Array(
			'Address'	=> 'business.tbank.ru',
			'Port'          => '443',
			'Host'          => 'business.tbank.ru',
			'Protocol'      => 'ssl',
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// заголовки
	$Headers = Array(SPrintF('Authorization: Bearer %s',$Settings['Token']),'Accept: application/json');
	#-------------------------------------------------------------------------------
	// у POST заголовок сам добавляется
	#if(!SizeOf($Post))
	#	$Headers[] = 'Content-Type: application/json';
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Result = HTTP_Send($Url,$HTTP,Array(),Array(),$Headers);
	#-------------------------------------------------------------------------------
	if(Is_Error($Result))
		return ERROR | @Trigger_Error('[TinkoffRu/API]: не удалось выполнить запрос к серверу');
	#-------------------------------------------------------------------------------
	$Result = Trim($Result['Body']);
	#-------------------------------------------------------------------------------
	$Result = Json_Decode($Result,TRUE);
	#-------------------------------------------------------------------------------
	Debug(Print_r($Result,true));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}



?>
