<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/

class VK
{
	#-------------------------------------------------------------------------------
	// параметры
	public $Address	= 'api.vk.com';
	public $Host	= 'api.vk.com';
	public $Token	= '00-000-00';
	#-------------------------------------------------------------------------------
	public function __construct($Token) {
		$this->Token	= $Token;
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// отправка сообщения
	public function MessageSend($user_id,$Text = 'not set'){
		#-------------------------------------------------------------------------------
		$Query = Array('user_id'=>$user_id,'message'=>Mb_SubStr($Text,0,4096));
		#-------------------------------------------------------------------------------
		$Result = $this->API('messages.send',$Query);
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/VK]: $Result = %s',print_r($Result,true)));
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(IsSet($Result['response']) && $Result['response']){
			#-------------------------------------------------------------------------------
			// возвращаем внутренний идентфикатор сообщения в ВКонтакте
			return Array($Result['response']);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// TODO по идее там есть человекочитемое сообщение о ошибке. надо словить и выдать в ответе
			if(IsSet($Result['error']) && IsSet($Result['error']['error_code'])){
				#-------------------------------------------------------------------------------
				// ругается на cущности. когда мусор типа <http://ya.ru/> воспринимается как тег
				if($Result['error']['error_code'] == 400)
					return TRUE;
				#-------------------------------------------------------------------------------
				// юзер залочил бота. по уму, надо бы куда-то деть VkUserID или сразу выпилить из оповещений его
				if($Result['error']['error_code'] == 403)
					return TRUE;
				#-------------------------------------------------------------------------------
				// юзер залочил бота v2. по уму, надо бы куда-то деть VkUserID или сразу выпилить из оповещений его
				if($Result['error']['error_code'] == 901)
					return TRUE;
				#-------------------------------------------------------------------------------
				// контакт не найден...
				if($Result['error']['error_code'] == 936)
					return TRUE;
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[system/libs/VK]: Неизвестный код ошибки %s',$Result['error']['error_code']));
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[system/libs/VK]: Неизвестный ответ'));
				#-------------------------------------------------------------------------------
				return FALSE;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// отправка файла
	public function FileSend($VkUserID,$Attachments = Array()){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[FileSend]: Attachments = %s',print_r($Attachments,true)));
		#-------------------------------------------------------------------------------
		// массив под идентифкаторы отправленных сообщений
		$Array = Array();
		#-------------------------------------------------------------------------------
		foreach ($Attachments as $Attachment){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/VK]: обработка вложения (%s), размер (%s), тип (%s)',$Attachment['Name'],$Attachment['Size'],$Attachment['Mime']));
			#-------------------------------------------------------------------------------
			// по дефолту, метод для документов
			$Method = 'doc';
			#-------------------------------------------------------------------------------
			// если это картинка - меняем метод
			$Mime = Explode('/',$Attachment['Mime']);
			#-------------------------------------------------------------------------------
			if(In_Array($Attachment['Mime'],Array('image/png','image/gif','image/jpeg','image/tiff')))
				$Method = 'photo';
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// получаем адрес на который надо отослать файл
			$Url = $this->API(($Method == 'photo')?'photos.getMessagesUploadServer':'docs.getMessagesUploadServer',Array('peer_id'=>$VkUserID));
			#-------------------------------------------------------------------------------
			if(!IsSet($Url['response']['upload_url'])){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[system/libs/VK]: не удалось получить URL для отправки файла, *.getMessagesUploadServer = %s',print_r($Url,true)));
				#-------------------------------------------------------------------------------
				continue;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// отправляем файл на заданный URL
			$Result = $this->API($Method,Array(),$Attachment,$Url['response']['upload_url']);
			#-------------------------------------------------------------------------------
			if(!IsSet($Result['server']) && !IsSet($Result['file'])){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[system/libs/VK]: не удалось отправить файл %s = %s',$Method,print_r($Result,true)));
				#-------------------------------------------------------------------------------
				continue;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// сохраняем файл
			$Result = $this->API(($Method == 'photo')?'photos.saveMessagesPhoto':'docs.save',$Result);
			#-------------------------------------------------------------------------------
			if($Method == 'photo'){
				#-------------------------------------------------------------------------------
				if(!IsSet($Result['response'][0]['id'])){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[system/libs/VK]: не удалось сохранить изображение *.save = %s',print_r($Result,true)));
					#-------------------------------------------------------------------------------
					continue;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				$Upload = $Result['response'][0];
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				if(!IsSet($Result['response']['doc']['id'])){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[system/libs/VK]: не удалось сохранить документ *.save = %s',print_r($Result,true)));
					#-------------------------------------------------------------------------------
					continue;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				$Upload = $Result['response']['doc'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// отправляем сообщение с вложением
			$Result = $this->API('messages.send',Array('user_id'=>$VkUserID,'attachment'=>SPrintF('%s%s_%s',$Method,$Upload['owner_id'],$Upload['id'])));
			#-------------------------------------------------------------------------------
			if(IsSet($Result['response']) && $Result['response']){
				#-------------------------------------------------------------------------------
				$Array[] = $Result['response'];
				#-------------------------------------------------------------------------------
				continue;
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[system/libs/VK]: $Result = %s',print_r($Result,true)));
				#-------------------------------------------------------------------------------
				// TODO по идее там есть человекочитемое сообщение о ошибке. надо словить и выдать в ответе
				return FALSE;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $Array;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// скачиваем файл во временную директорию, отдаём его данные
	public function GetFile($Url,$Name = FALSE){
		#-------------------------------------------------------------------------------
		// если имя файла не задано, достаём из URL
		if(!$Name)
			$Name = BaseName($Url);
		#-------------------------------------------------------------------------------
		$Tmp = System_Element('tmp');
		if(Is_Error($Tmp))
			return ERROR | @Trigger_Error('[system/libs/VK]: не удалось найти временную папку');
		#-------------------------------------------------------------------------------
		// скачиваем файл во временную директорию
		$Context= Stream_Context_Create(Array('http'=>Array('timeout'=>2)));
		#-------------------------------------------------------------------------------
		$File	= @File_Get_Contents($Url,FALSE,$Context);
		#-------------------------------------------------------------------------------
		$FilePath = SPrintF('%s/files/%s',$Tmp,$Name);
		#-------------------------------------------------------------------------------
		$IsWrited = IO_Write($FilePath,$File,TRUE);
		if(Is_Error($IsWrited))
			return ERROR | @Trigger_Error('[system/libs/VK->GetFile]: не удалось сохранить файл');
		#-------------------------------------------------------------------------------
		if(FileSize($FilePath)){
			#-------------------------------------------------------------------------------
			return Array('size'=>FileSize($FilePath),'error'=>0,'tmp_name'=>$FilePath,'name'=>$Name);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			return FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
        // АПИ
        private function API($Method,$Query = Array(),$Attachment = Array(),$Url = FALSE){
		#-------------------------------------------------------------------------------
		$HTTP = Array(
				'Port'		=> 443,
				'Protocol'	=> 'ssl',
				);
		#-------------------------------------------------------------------------------
		if(!$Url){
			#-------------------------------------------------------------------------------
			$HTTP['Address']	= $this->Address;
			$HTTP['Host']		= $this->Host;
			#-------------------------------------------------------------------------------
			$Url = SPrintF('/method/%s',$Method);
			#-------------------------------------------------------------------------------
			$Query['access_token']	= $this->Token;
			$Query['v']		= '5.107';
			#-------------------------------------------------------------------------------
			// для уникальности сообщения. пока так, рандомно
			if($Method == 'messages.send')
				$Query['random_id']	= IntVal(MicroTime(TRUE) * 10000);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// загрузка фоток/документов идёт по отдельному УРЛ
			$Parts = Parse_Url($Url);
			#-------------------------------------------------------------------------------
			$HTTP['Address']	= $Parts['host'];
			$HTTP['Host']		= $Parts['host'];
			#-------------------------------------------------------------------------------
			$Url = SPrintF('%s?%s',$Parts['path'],$Parts['query']);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if($Method == 'doc' || $Method == 'photo'){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/VK]: обработка вложения (%s), размер (%s), тип (%s)',$Attachment['Name'],$Attachment['Size'],$Attachment['Mime']));
			#-------------------------------------------------------------------------------
			// имя поля в форме
			$FieldName = ($Method == 'photo')?'photo':'file';
			#-------------------------------------------------------------------------------
			$HTTP['Charset'] = '';
			#-------------------------------------------------------------------------------
			$Boundary = SPrintF('----%s',Md5(Rand()));
			#-------------------------------------------------------------------------------
			$Body = SPrintF("--%s\r\n",$Boundary);
			$Body = SPrintF("%sContent-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n",$Body,$FieldName,$Attachment['Name']);
			$Body = SPrintF("%sContent-Type: application/octet-stream\r\n",$Body);
			$Body = SPrintF("%sContent-Transfer-Encoding: binary\r\n",$Body);
			$Body = SPrintF("%s\r\n%s",$Body,Base64_Decode($Attachment['Data']));
			$Body = SPrintF("%s\r\n--%s--\r\n\r\n",$Body,$Boundary);
			#-------------------------------------------------------------------------------
			$Headers = Array(SPrintF('Content-Type: multipart/form-data; boundary=%s',$Boundary)/*,'Connection: keep-alive','Keep-Alive: 300'*/);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// без файла передаём через POST
			$Headers	= Array();
			$Body		= $Query;
			$Query		= Array();
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Result = HTTP_Send($Url,$HTTP,$Query,$Body,$Headers);
		#-------------------------------------------------------------------------------
		if(Is_Error($Result))
			return ERROR | @Trigger_Error('[API]: не удалось выполнить запрос к серверу');
		#-------------------------------------------------------------------------------
		$Result = Trim($Result['Body']);
		#-------------------------------------------------------------------------------
		$Result = Json_Decode($Result,TRUE);
		#-------------------------------------------------------------------------------
		// вообще, надо разобраться на этом этапе с результатом, и вернуть уже итог, и в случае ошибки - параметры
		return $Result;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// сохраняем MessageID, просто в файлик, нефига ради такого колонку в базе держать. пока, по крайней мере
	public function SaveThreadID($UserID,$TicketID,$MessageID,$VkMessageID){
		#-------------------------------------------------------------------------------
		// если нет номера тикета - сохранять не надо
		if($TicketID == 0)
			return TRUE;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// сохраняем переданные данные
		$IsInsert = DB_Insert('TmpData',Array('UserID'=>$UserID,'AppID'=>'VK','Col1'=>$TicketID,'Col2'=>$MessageID,'Col3'=>$VkMessageID));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// поиск тикета по номеру сообщения в телеграмме
	public function FindThreadID($VkMessageID){
		#-------------------------------------------------------------------------------
		$Thread = DB_Select('TmpData','*',Array('UNIQ','Where'=>Array('`AppID` = "VK"',SPrintF('`Col3` = "%s"',$VkMessageID)),'SortOn'=>'CreateDate','Limits'=>Array(0,1)));
		#-------------------------------------------------------------------------------
		switch(ValueOf($Thread)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return FALSE;
		case 'array':
			#-------------------------------------------------------------------------------
			return Array('UserID'=>$Thread['UserID'],'TicketID'=>$Thread['Col1'],'MessageID'=>$Thread['Col2']);
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}    
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
