<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Zone','Format');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
/*
 * Format - формат выдачи, на данный момент поддерживается
 * Name - список описаний доменных зон с ключами по полю Name
 * List - просто список всех поддерживаемых доменных зон
 * HTML - используется вместе с $Zone, выдаёт подкрашенное имя зоны в зависимости от IsSupported
 *
 * Zone - выдать информацию по конкретной доменной зоне
 */
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: Zone = %s; Format = %s',$Zone,$Format));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$CacheID1 = Md5($__FILE__);
$CacheID2 = Md5(SPrintF('Format-%s-%s',$__FILE__,$Format));
$CacheID3 = Md5(SPrintF('Zone-%s-%s-%s',$__FILE__,$Format,$Zone));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DomainZones = CacheManager::get($CacheID1);
#-------------------------------------------------------------------------------
if(!$DomainZones){
	#-------------------------------------------------------------------------------
	// достаём список доменных зон
	$DomainZones = System_XML('config/DomainZones.xml');
	if(Is_Error($DomainZones))
		return ERROR | @Trigger_Error('[comp/Formats/DomainOrder/DomainZones]: не удалось загрузить базу WhoIs серверов');
	#-------------------------------------------------------------------------------
	// кэшируем, 5 минут достаточно - главное чтоб все тыканья при првоерке домена в разных зонах отдать из кэша
	CacheManager::add($CacheID1,$DomainZones,300);
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если не задана конкретная зона или формат - возвращаем список доменных зон
if(!$Zone && !$Format)
	return $DomainZones;

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// запрашивают инфу по конкретной зоне
if($Zone){
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: Zone = %s',$Zone));
	#-------------------------------------------------------------------------------
	$Out = CacheManager::get($CacheID3);
	#-------------------------------------------------------------------------------
	if($Out)
		return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем зоны, ищем информацию по конкретной
	foreach($DomainZones as $DomainZone){
		#-------------------------------------------------------------------------------
		if($Zone == $DomainZone['Name']){
			#-------------------------------------------------------------------------------
			$Out = $DomainZone;
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// если зона не найдена, то надо вставить данные для затычки
	if($Out){
		#-------------------------------------------------------------------------------
		// добавляем флажок что зона поддерживается
		$Out['IsSupported'] = TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Out = Array(
				'Server'		=> SPrintF('whois.nic.%s',$Zone),
				'Name'			=> $Zone,
				'Available'		=> 'DOMAIN\sNOT\sFOUND',
				'NotAvailable'		=> 'cannot\sbe\sregistered',
				'MinChars'		=> 3,
				'Regular'		=> '/^[0-9a-z]([0-9a-z\-]*[0-9a-z])*$/ui',
				'ExpirationDate'	=> 'Expir[a-zA-Z0-9\s]+Date:\s+([0-9]{4}\-[0-9]{2}\-[0-9]{2})',
				'NsName'		=> 'Name\sServer\:\s+([a-zA-Z0-9\.\-]{2,})',
				'Registrar'		=> 'Default',
				'IsUseRegistratorWhoIs'	=> 0,
				'RegistrationMessage'	=> SPrintF('Обращаем ваше внимание, что при регистрации домена в доменной зоне .%s на ваш почтовый адрес может быть выслано письмо со ссылкой, для подтверждении регистрации. Если вы не пройдёте по этой ссылке, то через 2 недели домен перестанет работать, т.к. владелец доменной зоны снимет его с делегирования.',$Zone),
				'IsSupported'		=> FALSE,
				);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// возможно запрашивают не-HTML?
	if(!$Format || $Format != 'HTML'){
		#-------------------------------------------------------------------------------
		CacheManager::add($CacheID3,$Out,300);
		#-------------------------------------------------------------------------------
		return $Out;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// сюда мы дошли если запросили HTML
	$HTML = new Tag('SPAN',Array('style'=>SPrintF('color:%s;',($Out['IsSupported'])?'black':'#FFA500')),$Zone);
	#-------------------------------------------------------------------------------
	CacheManager::add($CacheID3,$HTML,300);
	#-------------------------------------------------------------------------------
	return $HTML;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// запрашивают именованный список
if($Format && $Format == 'Name'){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: запрошен именованный список зон, Format = Name'));
	#-------------------------------------------------------------------------------
	$Zones = CacheManager::get($CacheID2);
	#-------------------------------------------------------------------------------
	if(!$Zones){
		#-------------------------------------------------------------------------------
		$Zones = Array();
		#-------------------------------------------------------------------------------
		foreach($DomainZones as $DomainZone)
			$Zones[$DomainZone['Name']] = $DomainZone;
		#-------------------------------------------------------------------------------
		CacheManager::add($CacheID2,$Zones,300);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: Zones = %s',print_r($Zones,true)));
	return $Zones;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// запрашивают просто список поддерживаемых зон
if($Format && $Format == 'List'){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: запрошен простой список зон, Format = List'));
	#-------------------------------------------------------------------------------
	$Zones = CacheManager::get($CacheID2);
	#-------------------------------------------------------------------------------
	if(!$Zones){
		#-------------------------------------------------------------------------------
		$Zones = Array();
		#-------------------------------------------------------------------------------
		foreach($DomainZones as $DomainZone)
			$Zones[] = $DomainZone['Name'];
		#-------------------------------------------------------------------------------
		CacheManager::add($CacheID2,$Zones,300);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Formats/DomainOrder/DomainZones]: Zones = %s',print_r($Zones,true)));
	return $Zones;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $DomainZones;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
