<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsCreate	= (boolean) @$Args['IsCreate'];
$StartDate	= (integer) @$Args['StartDate'];
$FinishDate	= (integer) @$Args['FinishDate'];
$Details	=   (array) @$Args['Details'];
$ShowTables	= (boolean) @$Args['ShowTables'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result = Array('Title'=>'Распределение заказов на IP адреса по тарифам');
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY');
#-------------------------------------------------------------------------------
if(!$IsCreate)
	return $Result;
#-------------------------------------------------------------------------------
$ExtraIPOrders = DB_Select('ExtraIPSchemes',Array('Name','(SELECT COUNT(*) FROM `ExtraIPOrders` WHERE `SchemeID` = `ExtraIPSchemes`.`ID` AND `StatusID`="Active") as `Count`'),Array('SortOn'=>'SortID'));
#-------------------------------------------------------------------------------
switch(ValueOf($ExtraIPOrders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Result;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('P','Данный вид статистики дает детальную информацию о количестве активных заказов на каждом из тарифов.'));
#-------------------------------------------------------------------------------
$Table = Array(Array(new Tag('TD',Array('class'=>'Head'),'Наименование тарифа'),new Tag('TD',Array('class'=>'Head'),'Кол-во заказов')));
#-------------------------------------------------------------------------------
$sGroupName = UniqID();
#-------------------------------------------------------------------------------
// для построения графиков на выхлопе
$dGraphs = Array();
#-------------------------------------------------------------------------------
foreach($ExtraIPOrders as $ExtraIPOrder){
	#-------------------------------------------------------------------------------
	$Table[] = Array($ExtraIPOrder['Name'],(integer)$ExtraIPOrder['Count']);
	#-------------------------------------------------------------------------------
	$Params[] = $ExtraIPOrder['Count'];
	$Labels[] = $ExtraIPOrder['Name'];
	#-------------------------------------------------------------------------------
	// массив для графика
	$dGraphs[] = Array($ExtraIPOrder['Name'],$ExtraIPOrder['Count']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Extended',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($ShowTables)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left;'),$Comp));
#-------------------------------------------------------------------------------
// графики
if(Count($dGraphs) > 1){
	#-------------------------------------------------------------------------------
	$Graphs = Array('Распределение заказов по тарифам на IP адреса'=>$dGraphs);
	#-------------------------------------------------------------------------------
	$Pie = Comp_Load('Charts/Pie',$Graphs);
	if(Is_Error($Pie))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// накидываем DIV'ы в тело страницы
	foreach($Pie['FnNames'] as $FnName)
		$NoBody->AddChild(new Tag('DIV',Array('style'=>SPrintF('float:left;width:%u%%;height:400px;',$ShowTables?30:50),'id'=>SPrintF('div_%s',$FnName)),$FnName));
	#-------------------------------------------------------------------------------
	$Result['Script'] = $Pie['Script'];
        #-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result['DOM'] = $NoBody;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
