<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsCreate       = (boolean) @$Args['IsCreate'];
$StartDate      = (integer) @$Args['StartDate'];
$FinishDate     = (integer) @$Args['FinishDate'];
$Details        =   (array) @$Args['Details'];
$ShowTables     = (boolean) @$Args['ShowTables'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result = Array('Title'=>'Распределение заказов на ПО ISPsystem по времени');
#-------------------------------------------------------------------------------
if(!$IsCreate)
	return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// выхлоп с графиками
$Graphs = Array(
		// по дням
		'ByDay'	=> Array(
				'Columns'       => Array(
							Array('string','Дата'),		// даты
							Array('number','Заказы'),	// число заказов
							),
				'Title'         => 'Число заказов, по дням',
				'hAxisTitle'    => 'Даты',
				'vAxisTitle'    => 'Число заказов',
				'Data'          => Array()
				),
		#-------------------------------------------------------------------------------
		// по месяцам
		'ByMonth'=> Array(
				'Columns'       => Array(
							Array('string','Месяц'),	// даты
							Array('number','Заказы'),	// число заказов
							),
				'Title'         => 'Число заказов, по месяцам',
				'hAxisTitle'    => 'Месяцы',
				'vAxisTitle'    => 'Число заказов',
				'Data'          => Array()
				),
		);
#-------------------------------------------------------------------------------
$MonthsNames = Array('Декабрь','Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY');
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('P','Данный вид статистики содержит информацию о количестве заказов в указанный период времени.'));
#-------------------------------------------------------------------------------
$Where = SPrintF('`ISPswOrders`.`OrderID` = `Orders`.`ID` AND `ISPswOrders`.`StatusID` = "Active" AND `OrderDate` >= %u AND `OrderDate` <= %u',$StartDate,$FinishDate);
#-------------------------------------------------------------------------------
if(In_Array('ByDays',$Details)){
	#-------------------------------------------------------------------------------
	$ISPswOrders = DB_Select(Array('Orders','ISPswOrders'),Array('COUNT(*) as `Count`','OrderID','OrderDate',' GET_DAY_FROM_TIMESTAMP(`OrderDate`) as `Day`','DATE_FORMAT(FROM_UNIXTIME(`OrderDate`),GET_FORMAT(DATE,"ISO")) AS `ISO_Date`'),Array('Where'=>$Where,'GroupBy'=>'Day','SortOn'=>'OrderDate'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ISPswOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Table = Array(Array(new Tag('TD',Array('class'=>'Head'),'Дата'),new Tag('TD',Array('class'=>'Head'),'Кол-во')));
		#-------------------------------------------------------------------------------
		$CurrentMonth = 0;
		#-------------------------------------------------------------------------------
		foreach($ISPswOrders as $ISPswOrder){
			#-------------------------------------------------------------------------------
			// график по заказам
			$Graphs['ByDay']['Data'][] = Array($ISPswOrder['ISO_Date'],$ISPswOrder['Count']);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			if(Date('n',$ISPswOrder['Day']*86400) != $CurrentMonth){
				#-------------------------------------------------------------------------------
				$CurrentMonth = Date('n',$ISPswOrder['Day']*86400);
				#-------------------------------------------------------------------------------
				$Table[] = SPrintF('%s %u г.',$MonthsNames[$CurrentMonth],Date('Y',$ISPswOrder['Day']*86400));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Table[] = Array(Date('d',$ISPswOrder['Day']*86400),(integer)$ISPswOrder['Count']);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$NoBody->AddChild(new Tag('H2','Распределение заказов по дням'));
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Tables/Extended',$Table);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($ShowTables)
			$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left; display:none;'),$Comp));
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(In_Array('ByMonth',$Details)){
	#-------------------------------------------------------------------------------
	$ISPswOrders = DB_Select(Array('Orders','ISPswOrders'),Array("DATE_FORMAT(FROM_UNIXTIME(`OrderDate`),'%Y-%m') AS `YearMonth`",'OrderID','COUNT(*) as `Count`','MONTH(FROM_UNIXTIME(`OrderDate`)) as `Month`','OrderDate','YEAR(FROM_UNIXTIME(`OrderDate`)) as Year'),Array('Where'=>$Where,'GroupBy'=>Array('Month','Year'),'SortOn'=>'OrderDate'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ISPswOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Table = Array(Array(new Tag('TD',Array('class'=>'Head'),'Месяц'),new Tag('TD',Array('class'=>'Head'),'Кол-во')));
		#-------------------------------------------------------------------------------
		$Order = Current($ISPswOrders);
		$sMonth = $Order['Month']+$Order['Year']*12;
		#-------------------------------------------------------------------------------
		$Order = End($ISPswOrders);
		$eMonth = $Order['Month']+$Order['Year']*12;
		#-------------------------------------------------------------------------------
		$Months = Array();
		#-------------------------------------------------------------------------------
		foreach($ISPswOrders as $Order)
			$Months[$Order['Month']+$Order['Year']*12] = $Order;
		#-------------------------------------------------------------------------------
		$CurrentYear = 0;
		#-------------------------------------------------------------------------------
		for($Month=$sMonth;$Month<=$eMonth;$Month++){
			#-------------------------------------------------------------------------------
			$Order = (IsSet($Months[$Month])?$Months[$Month]:Array('Month'=>$Month%12,'Year'=>(integer)($Month/12),'YearMonth'=>SPrintF('%u-%02d',(integer)($Month/12),$Month%12),'Count'=>0,'OrderID'=>'-'));
			#-------------------------------------------------------------------------------
			// график по заказам
			$Graphs['ByMonth']['Data'][] = Array($Order['YearMonth'],$Order['Count']);
			#-------------------------------------------------------------------------------
			if($Order['Year'] != $CurrentYear){
				#-------------------------------------------------------------------------------
				$CurrentYear = $Order['Year'];
				#-------------------------------------------------------------------------------
				$Table[] = SPrintF('%u г.',$CurrentYear);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Table[] = Array($MonthsNames[$Order['Month']],(integer)$Order['Count']);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$NoBody->AddChild(new Tag('H2','Распределение заказов по месяцам'));
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Tables/Extended',$Table);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($ShowTables)
			$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left; display:none;'),$Comp));
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Count($NoBody->Childs) < 2)
	return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// добавляем графики в страницу
$Line = Comp_Load('Charts/Line',$Graphs);
if(Is_Error($Line))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
// накидываем DIV'ы в тело страницы
foreach($Line['FnNames'] as $FnName)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>SPrintF('float:left;width:%u%%;height:400px;',$ShowTables?80:100),'id'=>SPrintF('div_%s',$FnName)),$FnName));
#-------------------------------------------------------------------------------
$Result['Script'] = $Line['Script'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result['DOM'] = $NoBody;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
