<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsCreate       = (boolean) @$Args['IsCreate'];
$ShowTables     = (boolean) @$Args['ShowTables'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result = Array('Title'=>'Распределение доходов по серверам');
#-------------------------------------------------------------------------------
if(!$IsCreate)
	return $Result;
#-------------------------------------------------------------------------------
$NoBody = new Tag('NOBODY');
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('P','Данный вид статистики содержит информацию о доходности каждого из имеющихся серверов за 1 месяц (30 дней)'));
$NoBody->AddChild(new Tag('P','Суммируются цены за месяц тарифов всех активных заказов размещенных на сервере.'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Graphs = Array();	# для построения графиков на выхлопе
#-------------------------------------------------------------------------------
# перебираем группы серверов
$ServersGroups = DB_Select('ServersGroups',Array('*'),Array('SortOn'=>'SortID'));
#-------------------------------------------------------------------------------
switch(ValueOf($ServersGroups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	Debug('[comp/Statistics/ServersIncome]: no groups found');
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
case 'array':
	# All OK, Servers Groups found
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// таблица для данных, одна на всё
$Table = $TmpData = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($ServersGroups as $ServersGroup){
	#-------------------------------------------------------------------------------
	#if($ServersGroup['ServiceID'] != 20000)
	#	continue;
	#-------------------------------------------------------------------------------
	# выбираем сервера группы
	$Servers = DB_Select('Servers',Array('*'),Array('Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID']),'SortOn'=>'Address'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Servers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Statistics/ServersIncome]: no servers for group %s',$ServersGroup['ID']));
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Balance = $Accounts = $NumPaid = 0;
	#-------------------------------------------------------------------------------
	$Params = $Labels = $SrvAccounts = Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = SPrintF('Группа серверов: %s',$ServersGroup['Name']);
	#-------------------------------------------------------------------------------
	$Table[] = Array(new Tag('TD',Array('class'=>'Head'),'Адрес сервера'),new Tag('TD',Array('class'=>'Head'),'Аккаунтов (всего/платно)'),new Tag('TD',Array('class'=>'Head'),'Доход сервера'),new Tag('TD',Array('class'=>'Head'),'Доход аккаунта')/*,new Tag('TD',Array('class'=>'Head'),'Диск, Gb'),new Tag('TD',Array('class'=>'Head'),'Память, Mb')*/);
	#-------------------------------------------------------------------------------
	foreach($Servers as $Server){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Statistics/ServersIncome]: Address = %s',$Server['Address']));
		#-------------------------------------------------------------------------------
		# достаём все активные аккаунты сервера
		$ServerAccounts = DB_Select('Orders',Array('ID'),Array('Where'=>SPrintF('`ServerID` = %u AND `StatusID` = "Active" AND `ServiceID` = %u',$Server['ID'],$ServersGroup['ServiceID'])));
		#-------------------------------------------------------------------------------
		switch(ValueOf($ServerAccounts)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			Debug(SPrintF('[comp/Statistics/ServersIncome]: no accounts for server %s',$Server['Address']));
			continue 2;
		case 'array':
			# All OK, accounts found
			Debug(SPrintF('[comp/Statistics/ServersIncome]: server %s, found %u accounts',$Server['Address'],SizeOf($ServerAccounts)));
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		$Array = Array();
		#-------------------------------------------------------------------------------
		foreach($ServerAccounts as $Account)
			$Array[] = $Account['ID'];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
                if($ServersGroup['ServiceID'] == 20000){
			#-------------------------------------------------------------------------------
			# домены обсчитываем отдельно.
			# выбираем
			$Incomes = DB_Select('DomainOrders',Array('SUM((SELECT `CostOrder` FROM `DomainSchemes` WHERE `DomainSchemes`.`ID` = `DomainOrders`.`SchemeID`)) AS `CostOrders`'),Array('UNIQ','Where'=>SPrintF('`OrderID` IN (%s)',Implode(',',$Array))));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Incomes)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				Debug(SPrintF('[comp/Statistics/ServersIncome]: no summ for registrator %s',$Server['Address']));
				continue 2;
			case 'array':
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			$PaidAccounts = SizeOf($Array);
			#-------------------------------------------------------------------------------
			$ServerIncome	= $Incomes['CostOrders'] / 12;	# в месяц
			$AccountIncome	= $ServerIncome / $PaidAccounts;
			$Income['DaysRemainded'] = $PaidAccounts * 365;
			#Debug(SPrintF('[comp/Statistics/ServersIncome]: Income = %s',print_r($Income,true)));
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			# считаем стоимость одного дня для каждого аккаунта сервера
			$Where = Array('`DaysRemainded` > 0',SPrintF('`OrderID` IN (%s)',Implode(',',$Array)));
			#-------------------------------------------------------------------------------
			$Incomes = DB_Select('OrdersConsider',Array('SUM(`DaysRemainded`*`Cost`*(1-`Discont`))/SUM(`DaysRemainded`) as `CostDay`'),Array('Where'=>$Where,'GroupBy'=>'OrderID'));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Incomes)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Statistics/ServersIncome]: no summ for server %s',$Server['Address']));
				#-------------------------------------------------------------------------------
				continue 2;
				#-------------------------------------------------------------------------------
			case 'array':
				#-------------------------------------------------------------------------------
				// изначально, всё по нулям
				$PaidAccounts = $ServerIncome = $AccountIncome = 0;
				#-------------------------------------------------------------------------------
				// перебираем аккаунты, считаем сумму дохода всего сервера в ДЕНЬ, стоимость одного аккаунта, количество платных аккаунтов
				foreach($Incomes as $Income){
					#-------------------------------------------------------------------------------
					// если стомость аккаунта равна нулю, пропускаем его
					if($Income['CostDay'] == 0)
						continue;
					#-------------------------------------------------------------------------------
					$PaidAccounts++;
					#-------------------------------------------------------------------------------
					$ServerIncome = $ServerIncome + $Income['CostDay'];
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				// если платных аккаунтов нет - пропускаем
				Debug(SPrintF('[comp/Statistics/ServersIncome]: ServerIncome = %s; PaidAccounts = %s',$ServerIncome,$PaidAccounts));
				if($PaidAccounts == 0)
					continue 2;
				#-------------------------------------------------------------------------------
				// доход сервера
				$ServerIncome = $ServerIncome * 30;		# 30 дней в месяце
				// доход одного аккаунта
				$AccountIncome = $ServerIncome / $PaidAccounts;	# только по платным аккаунтам
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[comp/Statistics/ServersIncome]: Incomes = %s',print_r($Incomes,true)));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		#Debug("[comp/Statistics/ServersIncome]: before calculate");
		$NumAccounts = SizeOf($Array);
		#-------------------------------------------------------------------------------
		$AccountIncomeCurrency = Comp_Load('Formats/Currency',$AccountIncome);
		if(Is_Error($AccountIncomeCurrency))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#Debug("[comp/Statistics/ServersIncome]: debug - 1");
		$Comp = Comp_Load('Formats/Currency',$ServerIncome);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$TmpData[$Server['Address']] = Array('NumAccounts'=>$NumAccounts,'PaidAccounts'=>$PaidAccounts,'ServerIncome'=>$ServerIncome,'AccountIncome'=>$AccountIncome);
		#Debug("[comp/Statistics/ServersIncome]: debug - 2");
		$Table[] = Array($Server['Address'],SPrintF('%s / %s',$NumAccounts,$PaidAccounts),$Comp,$AccountIncomeCurrency);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		#Debug("[comp/Statistics/ServersIncome]: debug - 3");
		$Params[]	= $ServerIncome;
		$SrvAccounts[]	= $NumAccounts;
		$Labels[]	= $Server['Address'];
		#-------------------------------------------------------------------------------
		#Debug("[comp/Statistics/ServersIncome]: debug - 4");
		#Debug(SPrintF('Balance = %s',print_r($Balance,true)));
		#Debug(SPrintF('ServerIncome = %s',print_r($ServerIncome,true)));
		#Debug(SPrintF('NumAccounts = %s',print_r($NumAccounts,true)));
		#Debug(SPrintF('PaidAccounts = %s',print_r($PaidAccounts,true)));
		$Balance += $ServerIncome;
		$Accounts+= $NumAccounts;
		$NumPaid += $PaidAccounts;
		#-------------------------------------------------------------------------------
		#Debug("[comp/Statistics/ServersIncome]: cycle complete");
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(SizeOf($Servers) > 1 && $Balance > 0){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Formats/Currency',$Balance);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array(new Tag('TD',Array('colspan'=>5,'class'=>'Standard'),SPrintF('Общий доход от серверов группы: %s',$Comp)));
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Formats/Currency',$Balance / SizeOf($Servers));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array(new Tag('TD',Array('colspan'=>5,'class'=>'Standard'),SPrintF('Средний доход от сервера группы: %s',$Comp)));
		#-------------------------------------------------------------------------------
		$Table[] = Array(new Tag('TD',Array('colspan'=>5,'class'=>'Standard'),SPrintF('Число аккаунтов в группе: %s / %s',$Accounts,$NumPaid)));
		#-------------------------------------------------------------------------------
		# средняя стоимость аккаунта
		$Comp = Comp_Load('Formats/Currency',($NumPaid > 0)?($Balance / $NumPaid):0);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array(new Tag('TD',Array('colspan'=>5,'class'=>'Standard'),SPrintF('Средняя цена аккаунта в группе: %s',$Comp)));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = Array(new Tag('TD',Array('colspan'=>5,'class'=>'Standard','style'=>'color:white;'),'конец группы серверов'));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	//Debug("[comp/Statistics/ServersIncome]: before Graphs");
	// сознательно задаём незаданную переменную NumAccounts - если на сервер нет платных аккаунтов.
	// либо переписывать код выше, либо будет деление на ноль... проще не учитывать
	if(!IsSet($NumAccounts))
		$NumAccounts = 0;
	#-------------------------------------------------------------------------------
	$Graphs[$ServersGroup['ID']] = Array('Name'=>$ServersGroup['Name'],'Balance'=>$Balance,'NumPaid'=>$NumPaid,'Accounts'=>$Accounts,'Params'=>$Params,'Labels'=>$Labels,'NumAccounts'=>$NumAccounts,'SrvAccounts'=>$SrvAccounts);
	#----------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# строим графики, считаем суммы
$Balance = 0;
$Accounts = 0;
$NumPaid = 0;
#-------------------------------------------------------------------------------
foreach($ServersGroups as $ServersGroup){
	#-------------------------------------------------------------------------------
	if(IsSet($Graphs[$ServersGroup['ID']])){
		#-------------------------------------------------------------------------------
		$Balance += $Graphs[$ServersGroup['ID']]['Balance'];
		#-------------------------------------------------------------------------------
		$Accounts+= $Graphs[$ServersGroup['ID']]['Accounts'];
		#-------------------------------------------------------------------------------
		$NumPaid += $Graphs[$ServersGroup['ID']]['NumPaid'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Formats/Currency',$Balance);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('SPAN',SPrintF('Доход от всех серверов: %s',$Comp)));
$NoBody->AddChild(new Tag('BR'));
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('SPAN',SPrintF('Число активных аккаунтов: %s',$Accounts)));
$NoBody->AddChild(new Tag('BR'));
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('SPAN',SPrintF('Число активных платных аккаунтов: %s',$NumPaid)));
$NoBody->AddChild(new Tag('BR'));
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('BR'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// рисуем таблицу
$Comp = Comp_Load('Tables/Extended',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($ShowTables)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left;'),$Comp));
#-------------------------------------------------------------------------------
$NoBody->AddChild(new Tag('BR'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// для общей статистики, по группам
$GraphByGroup = Array();
// выходные графики
$OutGraphs = Array('Доходы всех групп'=>Array());
#-------------------------------------------------------------------------------
foreach($ServersGroups as $ServersGroup){
	#-------------------------------------------------------------------------------
	if(IsSet($Graphs[$ServersGroup['ID']])){
		#-------------------------------------------------------------------------------
		$iParam = 0;
		#-------------------------------------------------------------------------------
		Debug(print_r($Graphs[$ServersGroup['ID']],true));
		#-------------------------------------------------------------------------------
		if(Count($Graphs[$ServersGroup['ID']]['Params']) > 1){
			#-------------------------------------------------------------------------------
			$Name		= $Graphs[$ServersGroup['ID']]['Name'];
			$NameSumm	= SPrintF('Доход по серверам, группа %s',$Name);
			$NameCount	= SPrintF('Число аккаунтов, группа %s',$Name);
			#-------------------------------------------------------------------------------
			$OutGraphs[$NameSumm] = $OutGraphs[$NameCount] = Array();
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Graphs[$ServersGroup['ID']]['Labels']) as $Key){
				#-------------------------------------------------------------------------------
				$OutGraphs[$NameSumm][]	= Array($Graphs[$ServersGroup['ID']]['Labels'][$Key],$Graphs[$ServersGroup['ID']]['Params'][$Key]);
				$OutGraphs[$NameCount][]= Array($Graphs[$ServersGroup['ID']]['Labels'][$Key],$Graphs[$ServersGroup['ID']]['SrvAccounts'][$Key]);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Graphs[$ServersGroup['ID']]['Params']) as $Key)
			$iParam = $iParam + $Graphs[$ServersGroup['ID']]['Params'][$Key];
		#-------------------------------------------------------------------------------
		// для выхлопного графика по всем группам
		if($iParam > 0)
			$OutGraphs['Доходы всех групп'][] = Array($ServersGroup['Name'],$iParam);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Pie = Comp_Load('Charts/Pie',$OutGraphs);
if(Is_Error($Pie))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
// накидываем DIV'ы в тело страницы
foreach($Pie['FnNames'] as $FnName)
	$NoBody->AddChild(new Tag('DIV',Array('style'=>'float:left;width:50%;height:400px;','id'=>SPrintF('div_%s',$FnName)),$FnName));
#-------------------------------------------------------------------------------
$Result['Script'] = $Pie['Script'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Result['DOM'] = $NoBody;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// проверяем временную таблицу, если там даныне - надо удалить
$IsDelete = DB_Delete('TmpData',Array('Where'=>'`AppID` = "Statistics/ServersIncome"'));
if(Is_Error($IsDelete))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
// сохраяем данные во временную таблицу, потом достанем при сохранении общей статистики
$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Statistics/ServersIncome','Params'=>$TmpData));
if(Is_Error($IsInsert))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
//Debug(SPrintF('[comp/Statistics/ServersIncome]: TmpData = %s',print_r($TmpData,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Result;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
