<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
# выбираем группы серверов где есть сервера для проверки
$ServersGroups = DB_Select('ServersGroups',Array('*','(SELECT `Code` FROM `Services` WHERE `ID` = `ServersGroups`.`ServiceID`) AS `Code`'),Array('Where'=>'`IsCheckUsers` = "yes"'));
switch(ValueOf($ServersGroups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# нету таких групп серверов, завтра снова поищщем
	return TRUE;
case 'array':
	# All OK, servers found
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($ServersGroups as $ServersGroup){
	#-------------------------------------------------------------------------------
	if($ServersGroup['Code'] == 'Default')
		continue;
	#-------------------------------------------------------------------------------
	#if($ServersGroup['Code'] == 'DNSmanager')
	#	continue;
	#-------------------------------------------------------------------------------
	if($ServersGroup['Code'] == 'ISPsw')
		continue;
	#-------------------------------------------------------------------------------
	if($ServersGroup['Code'] == 'Domain')
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$ClassName = SPrintF('%sServer',$ServersGroup['Code']);
	#-------------------------------------------------------------------------------
	# загружаем класс для работы с серверами услуги
	if(Is_Error(System_Load(SPrintF('classes/%s.class.php',$ClassName))))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Config = Config();
	#-------------------------------------------------------------------------------
	$Settings = $Config['Tasks']['Types']['GC']['ServersCheckUsersSettings'];
	#-------------------------------------------------------------------------------
	if(!$Settings['IsActive'])
		return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$EAs = Array();
	#-------------------------------------------------------------------------------
	if(StrLen($Settings['ExcludeServerAccounts']) < 1){
		#-------------------------------------------------------------------------------
		$EAs[] = Md5(Time());
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$ExcludeAccounts = Explode(',',$Settings['ExcludeServerAccounts']);
		#-------------------------------------------------------------------------------
		foreach ($ExcludeAccounts as &$value)
			$EAs[] = Trim($value);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Servers = DB_Select('Servers',Array('ID','Address'),Array('Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID']),'SortOn'=>'Address'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Servers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		Debug(SprintF('[comp/Tasks/GC/ServersCheckUsers]: в группе #%u нет серверов',$ServersGroup['ID']));
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#---------------------------------------------------------------------------
	foreach($Servers as $Server){
		#-------------------------------------------------------------------------------
		#if($Server['Address'] != 's31.host-food.ru')
		#	continue;
		#-------------------------------------------------------------------------------
		$ClassServer = new $ClassName();
		#-------------------------------------------------------------------------------
		$IsSelected = $ClassServer->Select((integer)$Server['ID']);
		#-------------------------------------------------------------------------------
		switch(ValueOf($IsSelected)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'true':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Users = $ClassServer->GetUsers();
		#-------------------------------------------------------------------------------
		switch(ValueOf($Users)){
		case 'error':
			# No more...
			continue 3;
		case 'exception':
			# No more...
			continue 3;
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(!Count($Users))
			continue 2;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$SUsers = Array();
		#-------------------------------------------------------------------------------
		$Where = Array(SPrintF('`ServerID` = %u',$Server['ID']),"`StatusID` = 'Active' OR `StatusID` = 'Suspended'");
		#-------------------------------------------------------------------------------
		$ServerUsers = DB_Select(SPrintF('%sOrdersOwners',$ServersGroup['Code']),Array('UserID','Login'),Array('Where'=>$Where));
		#-------------------------------------------------------------------------------
		switch(ValueOf($ServerUsers)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			# надо событие вешать. ахтунг какой-то - нет юзеров. а на сервере есть.
			# ненадо ничё вешать, так как сервер может быть новый, и кроме технических аккаунтов там ничего нет
			#$Event = Array(
			#		'UserID'        => 1,
			#		'PriorityID'    => 'Hosting',
			#		'Text'          => SPrintF('В биллинге, на сервере (%s) не обнаружено пользователей; на самом сервере обнаружено %u пользователей',$Server['Address'],SizeOf($Users)),
			#		'IsReaded'      => FALSE
			#		);
			#$Event = Comp_Load('Events/EventInsert',$Event);
			#if(!$Event)
			#	return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			# вылезаем из этого цикла, иначе будет ошибка
			continue 2;
			#-------------------------------------------------------------------------------
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		foreach($ServerUsers as $ServerUser){
			#-------------------------------------------------------------------------------
			# тут проверяем наличие аккаунта биллинга на сервере
			if(!In_Array($ServerUser['Login'],$Users)){
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'        => $ServerUser['UserID'],
						'PriorityID'    => 'Warning',
						'Text'          => SPrintF('Не найден %s/%s имеющийся в биллинге',$Server['Address'],$ServerUser['Login']),
						'IsReaded'      => FALSE
						);
				#-------------------------------------------------------------------------------
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			# собираем массив для обратной проверки - наличие аккаунтов сервера в биллинге
			$SUsers[] = $ServerUser['Login'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# тут проверяем наличие аккаунтов сервера в биллинге
		foreach($Users as $UserID){
			#-------------------------------------------------------------------------------
			# исключаем юзеров из списка исключаемых
			if(!In_Array($UserID, $SUsers)){
				#-------------------------------------------------------------------------------
				# проверяем лишнего по массиву исключений
				foreach($EAs as $EA){
					#-------------------------------------------------------------------------------
					if(Preg_Match(SPrintF("/%s/A",$EA),$UserID)){
						#-------------------------------------------------------------------------------
						# совпало с исключениями. пропускаем.
						continue 2;
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'        => 1,
						'PriorityID'    => 'Warning',
						'Text'          => SPrintF('Найден %s/%s отсутствующий в биллинге',$Server['Address'],$UserID),
						'IsReaded'      => FALSE
						);
				#-------------------------------------------------------------------------------
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
