<?php

#-------------------------------------------------------------------------------
/** @author Лапшин С.М. (Joonte Ltd)*/
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['ServersUpTime'];
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return 3600;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$CacheID = 'ServersUpTime';
#-------------------------------------------------------------------------------
$Cache = CacheManager::get($CacheID);
if(!$Cache)
	$Cache = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Servers = DB_Select('Servers',Array('ID','Address','TemplateID','Port','Monitoring','IsActive','IsDefault','(SELECT `Name` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `Servers`.`ServersGroupID`) AS `GroupName`'),Array('SortOn'=>Array('ServersGroupID','Address')));
#-------------------------------------------------------------------------------
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $ExecuteTime;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(500);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = Array();
#-------------------------------------------------------------------------------
foreach($Servers as $Server){
	#-------------------------------------------------------------------------------
	if(Is_Null($Server['GroupName']))
		$Server['GroupName'] = 'NoGroup';
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# если имя группы есть в кэше - пропускаем
	if(IsSet($Cache[$Server['GroupName']]) && IsSet($Cache[$Server['GroupName']]['IsComplete'])){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/ServersUpTime]: IsSet $Cache=>$GroupName = %s',$Server['GroupName']));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	# если текущая группа не задана - задём её
	if(!IsSet($Group))
		$Group = $Server['GroupName'];
	#-------------------------------------------------------------------------------
	# если сервер есть в кэше - пропускаем
	if(IsSet($Cache[$Group][$Server['Address']])){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/ServersUpTime]: IsSet $Cache=>GroupName=>Address = %s',$Cache[$Group][$Server['Address']]));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	# если группа не соответствует текущей - пропускаем
	if($Server['GroupName'] != $Group){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/ServersUpTime]: группы не соответствуют %s != %s',$Server['GroupName'],$Group));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!IsSet($GLOBALS['TaskReturnInfo'][$Server['GroupName']]))
		$GLOBALS['TaskReturnInfo'][$Server['GroupName']] = Array();
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'][$Server['GroupName']][] = $Server['Address'];
	#-------------------------------------------------------------------------------
	if(StrLen($Server['Monitoring']) > 3){
		#-------------------------------------------------------------------------------
		$Services = Preg_Split('/\n+/',$Server['Monitoring']);
		#-------------------------------------------------------------------------------
		foreach($Services as $Service){
			#-------------------------------------------------------------------------------
			$Service = Explode('=',$Service);
			#-------------------------------------------------------------------------------
			$ServiceName = Current($Service);
			#-------------------------------------------------------------------------------
			$Port = IntVal(Next($Service));
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[comp/Tasks/ServersUpTime]: connect to %s:%u',$Server['Address'],$Port));
			#-------------------------------------------------------------------------------
			$Socket = @FsockOpen($Server['Address'],$Port,$nError,$sError,$Settings['SocketTimeout']);
			#-------------------------------------------------------------------------------
			if(!Is_Resource($Socket)){
				#-------------------------------------------------------------------------------
				#Debug(SPrintF('[comp/Tasks/ServersUpTime]: cannot connect %s:%u with error: %s (%s)',$Server['Address'],$Port,$sError,$nError));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$IPage = Array(
					'TestDate'	=> Time(),
					'ServerID'	=> $Server['ID'],
					'Service'	=> Trim($ServiceName),
					'UpTime'	=> (Is_Resource($Socket)?100:0),
					'Day'		=> Date('d'),
					'Month'		=> Date('m'),
					'Year'		=> Date('Y')
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('ServersUpTime',$IPage);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if(Is_Resource($Socket))
				FClose($Socket);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		# рассчиытваем значение IsOK
		$UpTimes = DB_Select('ServersUpTime',Array('(SUM(`UpTime`*`Count`)/SUM(`Count`)) as `UpTime`'),Array('UNIQ','Where'=>SPrintF('`TestDate` > UNIX_TIMESTAMP() - %u * 24 * 60 *60  AND `ServerID` = %u',($Settings['DaysAgregate'])?$Settings['DaysAgregate']:1,$Server['ID'])));
		switch(ValueOf($Server)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$IsOK = TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$IsOK = IsSet($IsOK)?NULL:Round($UpTimes['UpTime']);
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('Servers',Array('TestDate'=>Time(),'IsOK'=>$IsOK),Array('ID'=>$Server['ID']));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	UnSet($IsOK);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# добавляем в кэш обработанный сервер
	if(!IsSet($Cache[$Group]))
		$Cache[$Group] = Array();
	#-------------------------------------------------------------------------------
	$Cache[$Group][] = $Server['Address'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// вебхуки, телеграмма и вайбера
	if($Server['IsActive'] && $Server['IsDefault'] && In_Array($Server['TemplateID'],Array('Telegram','Viber'))){
		#-------------------------------------------------------------------------------
		// кэшируем данные о вебхуках, на сутки наверное...
		$CacheWebHookID = 'CacheWebHook';
		#-------------------------------------------------------------------------------
		$CacheWebHook = CacheManager::get($CacheWebHookID);
		if(!$CacheWebHook)
			$CacheWebHook = Array();
		#-------------------------------------------------------------------------------
		// если есть кэшированное значение - пропускаем
		if(In_Array($Server['TemplateID'],Array_Keys($CacheWebHook))){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/ServersUpTime]: WebHook for %s; last register time = %s',$Server['TemplateID'],Date('Y-m-d/H:i:s',$CacheWebHook[$Server['TemplateID']])));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// библиотеки для работы
		if(Is_Error(System_Load('libs/HTTP.php','libs/Server.php',SPrintF('libs/%s.php',$Server['TemplateID']))))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$ServerSettings = SelectServerSettingsByTemplate($Server['TemplateID']);
		#-------------------------------------------------------------------------------
		switch(ValueOf($ServerSettings)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return new gException('NO_WEB_HOOK_SERVER',SPrintF('Отсуствует настроенный сервер %s',$Server['TemplateID']));
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$IM = new $ServerSettings['TemplateID']($ServerSettings['Params']['Token'],$ServerSettings['Params']['Secret']);
		#-------------------------------------------------------------------------------
		//$Viber = new Viber($ServerSettings['Params']['Token']);
		#-------------------------------------------------------------------------------
		if($IM->SetWebHook())
			$CacheWebHook[$Server['TemplateID']] = Time();
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// на 30 дней кэшируем =)
		CacheManager::add($CacheWebHookID,$CacheWebHook,30 * 24 * 3600);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# помечаем группу как обработанную
if(IsSet($Group))
	$Cache[$Group]['IsComplete'] = TRUE;
#-------------------------------------------------------------------------------
# Сохраняем кэшированные данные
CacheManager::add($CacheID,$Cache,300);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если в процессе работы была задана группа - то возможно она не последняя, короткий цикл, если не задана - то все сервера обработаны - длинный
return IsSet($Group)?(Time() + 10):$ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
