<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$id		= (integer) @$Args['id'];		# elid лицензии
$elid		=  (string) @$Args['elid'];		# происходящее событие
$module		=  (string) @$Args['module'];
$IP		=  (string) @$_SERVER['REMOTE_ADDR'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/ISPswSettingURL]: id = "%s"; elid = "%s"; module = "%s"',$id,$elid,$module));
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/XXTEA.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($id < 1)
	return new gException('ID_NOT_SET','Не задан идентификатор лицензии');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($elid != 'install')
	return new gException('IS_NOT_INSTALL','Работает только при инсталляции');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($module != 'dns')
	if($module != '')
		return new gException('IS_NOT_DNS_MODULE',SPrintF('Настройки передаются только при активации модуля DNS (текущий модуль = %s)',$module));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
$Settings = $Config['Other']['ISPswSettingURL'];
#-------------------------------------------------------------------------------
# пользователь на котором значится лицензия
$Owner = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# надо посмотреть по лицензии
$Where = Array(SPrintF('`LicenseID` = (SELECT `ID` FROM `ISPswLicenses` WHERE `elid` = %u)',$id));
#-------------------------------------------------------------------------------
$Order = DB_Select('ISPswOrdersOwners',Array('ID','UserID','(SELECT `Email` FROM `Users` WHERE `ID` = `ISPswOrdersOwners`.`UserID`) AS `Email`'),Array('UNIQ','Where'=>$Where,'Limits'=>Array(0,1),'SortOn'=>'ID','IsDesc'=>TRUE));
#-------------------------------------------------------------------------------
switch(ValueOf($Order)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	Debug(SPrintF('[comp/www/API/ISPswSettingURL]: license order not found'));
	break;
case 'array':
	#-------------------------------------------------------------------------------
	$Owner[] = $Order;
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# ищщем в базе IP  с которого пришёл запрос, определяем VPS на котором запущена лицензия
if($Settings['slaveserver-edit']['UseForVPS']){
	#-------------------------------------------------------------------------------
	$Where = Array(SPrintF('`IP` = "%s"',$IP),'`StatusID` IN ("Active","OnCreate","SchemeChange","Suspended")');
	#-------------------------------------------------------------------------------
	$Order = DB_Select('VPSOrdersOwners',Array('ID','OrderID','UserID','(SELECT `Email` FROM `Users` WHERE `ID` = `VPSOrdersOwners`.`UserID`) AS `Email`'),Array('UNIQ','Where'=>$Where,'Limits'=>Array(0,1)));
	switch(ValueOf($Order)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		Debug(SPrintF('[comp/www/API/ISPswSettingURL]: VPS not found'));
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Owner[] = $Order;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# ищщем в базе IP  с которого пришёл запрос, определяем выделенный сервер на котором запущена лицензия
if($Settings['slaveserver-edit']['UseForDS']){
	#-------------------------------------------------------------------------------
	$Where = Array(SPrintF('`IP` = "%s" OR `ExtraIP` LIKE "%%%s%%"',$IP,$IP),'`StatusID` IN ("Active","OnCreate","SchemeChange","Suspended")');
	#-------------------------------------------------------------------------------
	$Order = DB_Select('DSOrdersOwners',Array('ID','OrderID','UserID','(SELECT `Email` FROM `Users` WHERE `ID` = `DSOrdersOwners`.`UserID`) AS `Email`'),Array('UNIQ','Where'=>$Where,'Limits'=>Array(0,1)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Order)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		Debug(SPrintF('[comp/www/API/ISPswSettingURL]: Dedicated Server not found'));
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Owner[] = $Order;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# если не найден владелец - валим
if(SizeOf($Owner) < 1){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/ISPswSettingURL]: License owner not found'));
	#-------------------------------------------------------------------------------
	return new gException('LICENSE_OWNER_NOT_FOUND','Владелец лицензии не найден');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# массив, с элементами выходной XML
$Array = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# настройки сети из которой можно выполнять команды
if($Settings['xset-up-param']['IsActive'])
	$Array[] = SPrintF('<func name="xset.up.param"><arg name="ip">%s</arg></func>',$Settings['xset-up-param']['LAN']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# настройки DNS
$Args = Array('<arg name="sok">ok</arg><arg name="sync">on</arg>');
#-------------------------------------------------------------------------------
if($Settings['dnsparam']['IsActive'])
	foreach(Array_Keys($Settings['dnsparam']) as $Name)
		if($Name != 'IsActive')
			$Args[] = SPrintF('<arg name="%s">%s</arg>',Str_Replace('dnsparam.','',Str_Replace('-','.',$Name)),($Name == 'dnsparam-email')?$Owner[0]['Email']:$Settings['dnsparam'][$Name]);
#-------------------------------------------------------------------------------

$Array[] = SPrintF('<func name="dnsparam">%s</func>',Implode('',$Args));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# TODO надо вытянуть номерки автосоздаваемых тарифов, и юзать их заказы
#-------------------------------------------------------------------------------
# по юзеру, которому принадлежит заказ находим заказы на DNSmanager
if($Settings['slaveserver-edit']['IsActive']){
	#-------------------------------------------------------------------------------
	$DNSmanagerOrders = DB_Select('DNSmanagerOrdersOwners',Array('ServerID','Login','Password','(SELECT `Params` FROM `Servers` WHERE `Servers`.`ID` = `ServerID`) AS `Params`'),Array('Where'=>SPrintF('`UserID` = %u',$Owner[0]['UserID']),'IsDesc'=>TRUE,'SortOn'=>'ID'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($DNSmanagerOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('DNS_NOT_FOUND','Заказ на вторичные DNS не найдены');
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# выбираем все заказы относящися к разным DNS серверам
	$Servers = Array();
	#-------------------------------------------------------------------------------
	foreach($DNSmanagerOrders as $DNSmanagerOrder)
		if(!IsSet($Servers[$DNSmanagerOrder['ServerID']]))
			$Servers[$DNSmanagerOrder['ServerID']] = $DNSmanagerOrder;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# выдаём данные DNSmanager в ответе
	$XML = '<func name="%s"><arg name="sok">ok</arg><arg name="sync">off</arg><arg name="username">%s</arg><arg name="password">%s</arg><arg name="url">%s</arg></func>';
	#-------------------------------------------------------------------------------
	foreach($Servers as $Server)
		foreach(Array('slaveserver.edit') as $Func)
			$Array[] = SPrintF($XML,$Func,$Server['Login'],$Server['Password'],$Server['Params']['Url']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# строим выхлопную XML'ину
$Out = SPrintF('<?xml version="1.0" encoding="UTF-8"?><doc>%s</doc>',Implode('',$Array));
Debug(SPrintF('[comp/www/API/ISPswSettingURL]: Out XML = %s',$Out));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$License = DB_Select('ISPswLicenses',Array('LicKey'),Array('UNIQ','Where'=>SPrintF('`elid` = %u',$id)));
switch(ValueOf($License)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('LICENSE_NOT_FOUND','Лицензия не найдена');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
echo Bin2Hex(xxtea_encrypt($Out,$License['LicKey']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
