<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$OrderID	= (integer) @$Args['OrderID'];
$Period		=  (string) @$Args['Period'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// разбираем присланный период
switch($Period){
	case "w": $Period = Time() - 7*24*60*60;	break;	// week
	case "m": $Period = Time() - 30*24*60*60;	break;	// month
	case "a": $Period = 0;				break;	// all
	default:  $Period = Time() - 24*60*60;		break;	// day, default
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// выбираем данные графиковa
$Columns = Array(
		'ID','Params','Col1','Col2',
		'(SELECT `StatusID` FROM `OrdersOwners` WHERE `ID` = `TmpData`.`Col1`) AS `StatusID`',
		'(SELECT `UserID` FROM `OrdersOwners` WHERE `ID` = `TmpData`.`Col1`) AS `UserID`',
		);
#-------------------------------------------------------------------------------
$TmpData = DB_Select('TmpData',$Columns,Array('Where'=>Array('`AppID` = "Order.Statistics"',SPrintF('`Col1` = %u',$OrderID)),'Limits'=>Array(0,1),'UNIQ'));
switch(ValueOf($TmpData)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return Array();
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// проверяем права юзера на этот заказ
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('ServiceOrderRead',(integer)$__USER['ID'],(integer)$TmpData['UserID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// меняем формат графиков на выходе
$Comp = Comp_Load('Formats/GraphOut',$TmpData['Params'],$TmpData['StatusID'],$Period);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

