<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$OrderID	= (integer) @$Args['OrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = Array();
#-------------------------------------------------------------------------------
$Where = Array(SPrintF('`UserID` = %u',$GLOBALS['__USER']['ID']));
#-------------------------------------------------------------------------------
if($OrderID > 0)
	$Where[] = SPrintF('`OrderID` = %u',$OrderID);
#-------------------------------------------------------------------------------
$Columns = Array(
		'*',
		'(SELECT `Customer` FROM `Contracts` WHERE `Contracts`.`ID` = `VPSOrdersOwners`.`ContractID`) AS `Customer`','(SELECT `ServerID` FROM `OrdersOwners` WHERE `OrdersOwners`.`ID` = `VPSOrdersOwners`.`OrderID`) AS `ServerID`',
		'(SELECT `IsPayed` FROM `OrdersOwners` WHERE `OrdersOwners`.`ID` = `VPSOrdersOwners`.`OrderID`) AS `IsPayed`',
		"(SELECT `Params` FROM `TmpData` WHERE `AppID` = 'Order.Statistics' AND `VPSOrdersOwners`.`OrderID` = `TmpData`.`Col1` LIMIT 1) AS `Params`",
		);
#-------------------------------------------------------------------------------
$VPSOrders = DB_Select('VPSOrdersOwners',$Columns,Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($VPSOrders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Out;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Servers = Array();
#-------------------------------------------------------------------------------
foreach($VPSOrders as $VPSOrder){
	#-------------------------------------------------------------------------------
	$ServerID = $VPSOrder['ServerID'];
	#-------------------------------------------------------------------------------
	// чтоб не делать запрросы на каждый тариф, храним сервера в массиве
	if(!IsSet($Servers[$ServerID])){
		#-------------------------------------------------------------------------------
		$Server = DB_Select('ServersOwners',Array('Address','Params'),Array('UNIQ','ID'=>$ServerID));
		#-------------------------------------------------------------------------------
		if(!Is_Array($Server))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Servers[$ServerID] = $Server;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// добавляем сервер
	$VPSOrder['Address'] = $Servers[$ServerID]['Address'];
	#-------------------------------------------------------------------------------
	// добавляем ДНС
	for($i = 1; $i <= 4; $i++){
		#-------------------------------------------------------------------------------
		$NsName = SPrintF('Ns%sName',$i);
		#-------------------------------------------------------------------------------
		$VPSOrder[$NsName] = $Servers[$ServerID]['Params'][$NsName];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
        #-------------------------------------------------------------------------------
	if($Servers[$ServerID]['Params']['SystemID'] == 'VmManager6_Hosting')
		$VPSOrder['Login'] = SPrintF('%s@%s',$VPSOrder['Login'],$Servers[$ServerID]['Params']['Domain']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// меняем формат графиков на выходе
	$Comp = Comp_Load('Formats/GraphOut',$VPSOrder['Params'],$VPSOrder['StatusID']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$VPSOrder['Graphs'] = $Comp;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	UnSet($VPSOrder['Params']);
	UnSet($VPSOrder['AdminNotice']);
	#-------------------------------------------------------------------------------
	$Out[$VPSOrder['ID']] = $VPSOrder;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return ($OrderID > 0)?Current($Out):$Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

