<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ServerID	= (integer) @$Args['ServerID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
$Settings = $Config['Interface']['Administrator']['Servers'];
#-------------------------------------------------------------------------------
if(!$Settings['AllowManage'])
	return new gException('SERVER_MANAGE_NOT_ALLOWED','Переход в панель управления сервером запрещён системными настройками');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Server = DB_Select('Servers','*',Array('UNIQ','ID'=>$ServerID));
#-------------------------------------------------------------------------------
switch(ValueOf($Server)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Path = SPrintF('classes/%sServer.class.php',$Server['TemplateID']);
#-------------------------------------------------------------------------------
if(Is_Error(System_Load($Path)))
	return new gException('CLASS_NOT_FOUND',SPrintF('Не найден класс для управления сервером: %s',$Path));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('ServerManage',(integer)$GLOBALS['__USER']['ID'],100);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ClassName = SPrintF('%sServer',$Server['TemplateID']);
#-------------------------------------------------------------------------------
$ClassServer = new $ClassName();
#-------------------------------------------------------------------------------
$IsSelected = $ClassServer->Select((integer)$Server['ID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsSelected)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Params = Array('Login'=>$Server['Login'],'Password'=>$Server['Password']);
#-------------------------------------------------------------------------------
$IsLogon = $ClassServer->Logon($Params);
#-------------------------------------------------------------------------------
switch(ValueOf($IsLogon)){
case 'error':
	return new gException('ERROR_SERVER_ACCESS','Ошибка доступа к серверу');
case 'exception':
	return $IsLogon;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$IsLogon['Status'] = 'Ok';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $IsLogon;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
