<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$DomainOrderID = (integer) @$Args['DomainOrderID'];
$IsShowAllZones= (boolean) @$Args['IsShowAllZones'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DomainOrder = DB_Select('DomainOrdersOwners',Array('*'),Array('UNIQ','ID'=>$DomainOrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Title = SPrintF('Редактирование заказа на домен %s.%s',$DomainOrder['DomainName'],$DomainOrder['Name']);
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table = Array('Общие параметры');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Contracts/Select','ContractID',$DomainOrder['ContractID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Договор клиента',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'DomainName','type'=>'text','value'=>$DomainOrder['DomainName']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменное имя',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$UniqID = UniqID('DomainSchemes');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Services/Schemes','DomainSchemes',$DomainOrder['UserID'],Array('Name','ServerID'),$UniqID,($IsShowAllZones)?Array():SPrintF('`IsActive` = "yes" OR `ID` = %u OR `Name` = "%s"',$DomainOrder['SchemeID'],$DomainOrder['Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Columns = Array('ID','Name',SPrintF('(SELECT `Params` FROM `Servers` WHERE `Servers`.`ID` = `%s`.`ServerID`) as `Params`',$UniqID),'CostOrder');
#-------------------------------------------------------------------------------
$DomainSchemes = DB_Select($UniqID,$Columns,Array('SortOn'=>'Name'));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainSchemes)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# No more...
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($DomainSchemes as $DomainScheme){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Formats/Currency',$DomainScheme['CostOrder']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Options[$DomainScheme['ID']] = SPrintF('%s, %s, %s',$DomainScheme['Name'],$DomainScheme['Params']['Name'],$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'SchemeID','style'=>'width: 100%;'),$Options,$DomainOrder['SchemeID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Тарифный план',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('jQuery/DatePicker','ExpirationDate',$DomainOrder['ExpirationDate']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Дата окончания',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'PersonID','type'=>'text','value'=>$DomainOrder['PersonID']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Договор регистратора',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// выбираем все услуги юзера
$Comp = Comp_Load('Services/Orders/SelectDependOrder',$DomainOrder['UserID'],$DomainOrder['OrderID'],$DomainOrder['DependOrderID']);
if(Is_Error($Comp))
        return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Заказ',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Messages();
#-------------------------------------------------------------------------------
$Table[] = 'Первичный сервер имен';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns1Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>'IsNewNs();','value'=>$DomainOrder['Ns1Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns1IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns1IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Вторичный сервер имен';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns2Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>'IsNewNs();','value'=>$DomainOrder['Ns2Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns2IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns2IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Дополнительный сервер имен';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns3Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>'IsNewNs();','value'=>$DomainOrder['Ns3Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns3IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns3IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Расширенный сервер имен';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns4Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>'IsNewNs();','value'=>$DomainOrder['Ns4Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns4IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns4IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>SPrintF("FormEdit('/Administrator/API/DomainOrderEdit','DomainOrderEditForm','%s');",$Title),'value'=>'Сохранить','prompt'=>'Сохранить изменения'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Comp1 = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>SPrintF("javascript:ShowWindow('/Administrator/DomainOrderEdit',{DomainOrderID:%u,IsShowAllZones:1});",$DomainOrderID),'value'=>'Открыть с полным списком доменов','prompt'=>'Открыть форму редактирования заново, с полным списком доменных зон (сейчас отображаются только активные)'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Div = new Tag('DIV',Array('style'=>'text-align: right;'));
#-------------------------------------------------------------------------------
if(!$IsShowAllZones)
	$Div->AddChild($Comp1);
#-------------------------------------------------------------------------------
$Div->AddChild($Comp);
#-------------------------------------------------------------------------------
$Table[] = $Div;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'DomainOrderEditForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'DomainOrderID','type'=>'hidden','value'=>$DomainOrderID));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
