<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$ExtraIPOrderID = (integer) @$Args['ExtraIPOrderID'];
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Script = new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/Pages/Administrator/OrderCompensation.js}'));
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',$Script);
#-------------------------------------------------------------------------------
$DOM->AddText('Title','Компенсация времени');
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'OrderCompensationForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
if($ExtraIPOrderID){
	#-------------------------------------------------------------------------------
	$ExtraIPOrder = DB_Select('ExtraIPOrdersOwners',Array('ID','Login','Domain','StatusID'),Array('UNIQ','ID'=>$ExtraIPOrderID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ExtraIPOrder)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('ExtraIP_ORDER_NOT_FOUND','Заказ на выделенный IP адрес не найден');
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	if($ExtraIPOrder['StatusID'] != 'Active')
		return new gException('ExtraIP_ORDER_NOT_ACTIVE','Заказ выделенного IP адреса не активен');
	#-------------------------------------------------------------------------------
	$Table[] = Array('Заказ выделенного IP адреса',SPrintF('%s',$ExtraIPOrder['Login']));
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('type'=>'hidden','name'=>'ExtraIPOrderID','value'=>$ExtraIPOrder['ID']));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}else{
	$Servers = DB_Select('Servers',Array('ID','Address','Params','TemplateID','(SELECT `Name` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `ServersGroupID`) AS `ServersGroupName`'),Array('Where'=>'`ID` IN (SELECT `ServerID` FROM `Orders` WHERE `ServiceID` = 50000)','SortOn'=>Array('TemplateID','ServersGroupID','Address')));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Servers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('ExtraIP_ORDERs_NOT_FOUND','Заказы на IP адреса не найдены');
	case 'array':
		#-------------------------------------------------------------------------------
		$Options = $DisabledIDs = Array();
		#-------------------------------------------------------------------------------
		foreach($Servers as $Server){
			#-------------------------------------------------------------------------------
			# имя группы серверов
			if(!IsSet($GroupName) || $GroupName != $Server['ServersGroupName']){
				#-------------------------------------------------------------------------------
				$GroupName = SPrintF('%s / %s',$Server['TemplateID'],$Server['ServersGroupName']);
				#-------------------------------------------------------------------------------
				$DisabledIDs[] = $GroupName;
				#-------------------------------------------------------------------------------
				$Options[$GroupName] = $GroupName;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Options[$Server['ID']] = $Server['Address'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('name'=>'ServerID','style'=>'width: 100%;'),$Options,'не-задано',$DisabledIDs);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array('Сервер размещения',$Comp);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'DaysReserved','value'=>10));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Дней компенсации',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>"ShowConfirm('Подверждаете выполнение операции?','OrderCompensation(\'/Administrator/API/ExtraIPCompensation\');')",'value'=>'Компенсировать'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
