<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$ExtraIPSchemeID = (integer) @$Args['ExtraIPSchemeID'];
#-------------------------------------------------------------------------------
if($ExtraIPSchemeID){
	#-------------------------------------------------------------------------------
	$ExtraIPScheme = DB_Select('ExtraIPSchemes','*',Array('UNIQ','ID'=>$ExtraIPSchemeID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ExtraIPScheme)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$ExtraIPScheme = Array(
				'GroupID'		=> 1,
				'UserID'		=> 1,
				'Name'			=> 'default1',
				'PackageID'		=> 'IP1',
				'CostDay'		=> 2.50,
				'CostMonth'		=> 75.00,
				'CostInstall'		=> 25.00,
				'Discount'		=> -1,
				'AddressType'		=> 'IPv4',
				'Comment'		=> 'Один сайт - один IP адрес',
				'IsActive'		=> TRUE,
				'IsProlong'		=> TRUE,
				'MinDaysPay'		=> 31,
				'MinDaysProlong'	=> 14,
				'MaxDaysPay'		=> 1460,
				'MaxOrders'		=> 0,
				'MinOrdersPeriod'	=> 0,
				'Params'		=> Array('Servers'=>Array()),
				'SortID'		=> 10
			);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Messages();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Title = ($ExtraIPSchemeID?'Редактирование нового тарифа ExtraIP':'Добавление нового тарифа ExtraIP');
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
$Table = Array('Общая информация');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Owner','Владелец тарифа',$ExtraIPScheme['GroupID'],$ExtraIPScheme['UserID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'Name',
			'value'	=> $ExtraIPScheme['Name']
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Название тарифного плана',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'PackageID',
			'value'	=> $ExtraIPScheme['PackageID']
			),
		'Точное имя пакета в панели управления'
);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Идентификатор пакета в панели',$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostDay','value'=>SPrintF('%01.2f',$ExtraIPScheme['CostDay'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость дня'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Используется в расчетах стоимости')),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostMonth','value'=>SPrintF('%01.2f',$ExtraIPScheme['CostMonth'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость месяца'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Используется для отображения')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostInstall','value'=>SPrintF('%01.2f',$ExtraIPScheme['CostInstall'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость подключения'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Плата за подключение IP адреса')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
                'Form/Input',
                Array(
                        'type'  => 'text',
                        'name'  => 'Discount',
                        'value' => SPrintF('%01.0f',$ExtraIPScheme['Discount']),
                        'prompt'=> 'Если указано число от нуля до 100, то при оплате используется именно указанная скидка, все глобальные скидки и бонусы игнорируются. При указании отрицательного числа - используются глобальные скидки и бонусы',
                        )
                );
if(Is_Error($Comp))
        return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Скидка'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Скидка на этот тариф')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Options = Array('IPv4' => 'IPv4', 'IPv6' => 'IPv6');
$Comp = Comp_Load('Form/Select',Array('name'=>'AddressType','style'=>'width: 240px;'),$Options,$ExtraIPScheme['AddressType']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Тип адреса',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Параметры тарифа';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsActive','id'=>'IsActive','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($ExtraIPScheme['IsActive'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsActive'),'Тариф активен'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsProlong','id'=>'IsProlong','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($ExtraIPScheme['IsProlong'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsProlong'),'Возможность продления'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'MinDaysPay',
			'value'	=> $ExtraIPScheme['MinDaysPay']
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальное кол-во дней оплаты',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'MinDaysProlong',
			'value'	=> $ExtraIPScheme['MinDaysProlong'],
			'prompt'=> 'Минимальное число дней, на которое можно продлевать заказ'
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальное кол-во дней продления',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'MaxDaysPay',
			'value'	=> $ExtraIPScheme['MaxDaysPay']
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Максимальное кол-во дней оплаты',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'MaxOrders',
			'value'	=> $ExtraIPScheme['MaxOrders'],
			'prompt'=> $Messages['Prompts']['MaxOrders']
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Максимальное кол-во заказов',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MinOrdersPeriod','value'=>$ExtraIPScheme['MinOrdersPeriod'],'prompt'=>$Messages['Prompts']['MinOrdersPeriod']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальный период между заказами',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'	=> 'text',
			'name'	=> 'SortID',
			'value'	=> $ExtraIPScheme['SortID']
			)
		);
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Порядок сортировки',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'На каких серверах используется';
#-------------------------------------------------------------------------------
# выбрать все сервера всех услуг
$Servers = DB_Select('Servers',Array('ID','Address','Params','AdminNotice','TemplateID','(SELECT `Name` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `ServersGroupID`) AS `ServersGroupName`'),Array('Where'=>'`TemplateID` IN ("Hosting","VPS","DS")','SortOn'=>Array('TemplateID','ServersGroupID','Address')));
#-------------------------------------------------------------------------------
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Result;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
# перебираем сервера
foreach($Servers as $Server){
	#-------------------------------------------------------------------------------
	# имя группы серверов
	if(!IsSet($GroupName) || $GroupName != $Server['ServersGroupName'])
		$Table[] = SPrintF('- %s / %s',$Server['TemplateID'],$Server['ServersGroupName']);
	#-------------------------------------------------------------------------------
	$GroupName = $Server['ServersGroupName'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# добавляем сервер к списку
	$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'Servers[]','id'=>$Server['Address'],'value'=>$Server['ID']));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if(Is_Array($ExtraIPScheme['Params']['Servers']))
		if(In_Array($Server['ID'],$ExtraIPScheme['Params']['Servers']))
			$Comp->AddAttribs(Array('checked'=>'yes'));
	#-------------------------------------------------------------------------------
	# отображаем примечание к серверу как подсказку, если оно есть
	if($Server['AdminNotice']){
		#-------------------------------------------------------------------------------
		$LinkID = UniqID('String');
		#-------------------------------------------------------------------------------
		$Links = &Links();
		#-------------------------------------------------------------------------------
		$Text = new Tag('DIV',$Server['Address']);
		#-------------------------------------------------------------------------------
		$Links[$LinkID] = &$Text;
		#-------------------------------------------------------------------------------
		$Comp1 = Comp_Load('Form/Prompt',$LinkID,$Server['AdminNotice']);
		if(Is_Error($Comp1))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		UnSet($Links[$LinkID]);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Text = $Server['Address'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Table[] = Array(new Tag('LABEL',Array('for'=>$Server['Address']),$Text),$Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/TextArea',
		Array(
			'name'	=> 'Comment',
			'style'	=> 'width:100%;',
			'rows'	=> 3
			),
		$ExtraIPScheme['Comment']
);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = 'Описание тарифа';
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Div = new Tag('DIV',Array('align'=>'right'));
#-------------------------------------------------------------------------------
if($ExtraIPSchemeID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'		=> 'checkbox',
				'onclick'	=> 'form.ExtraIPSchemeID.value = (checked?0:value);',
				'value'		=> $ExtraIPSchemeID,
				'id'		=> 'IsCreateNewScheme'
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Div->AddChild($Comp);
	#-------------------------------------------------------------------------------
	$Div->AddChild(new Tag('LABEL',Array('class'=>'Comment','for'=>'IsCreateNewScheme'),'создать новый тариф'));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'		=> 'button',
			'onclick'	=> SPrintF("FormEdit('/Administrator/API/ExtraIPSchemeEdit','ExtraIPSchemeEditForm','%s');",$Title),
			'value'		=> ($ExtraIPSchemeID?'Сохранить':'Добавить')
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Div->AddChild($Comp);
#-------------------------------------------------------------------------------
$Table[] = $Div;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ExtraIPSchemeEditForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'name'	=> 'ExtraIPSchemeID',
			'type'	=> 'hidden',
			'value'	=> $ExtraIPSchemeID
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
