<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$ServerID	= (integer) @$Args['ServerID'];
$TemplateID	=  (string) @$Args['TemplateID'];
$Window		=  (string) @$Args['Window'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','libs/Tree.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
if($ServerID){
	#-------------------------------------------------------------------------------
	$Server = DB_Select('Servers',Array('*'),Array('UNIQ','ID'=>$ServerID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Server)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		#-------------------------------------------------------------------------------
		$TemplateID = $Server['TemplateID'];
		#-------------------------------------------------------------------------------
		$Server['Password'] = 'Default';
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Server = Array(
			'ServersGroupID'	=> 0,
			'IsDefault'		=> TRUE,
			'IsActive'		=> TRUE,
			'SortID'		=> 99999,
			'Protocol'		=> 'ssl',
			'Address'		=> 'srv1.isp.su',
			'Port'			=> 443,
			'Login'			=> 'root',
			'Password'		=> 'Default',
			'Monitoring'		=> "HTTP=80\nHTTPS=443\nFTP=21\nMySQL=3306\nSMTP=25\nPOP=110\nIMAP=143",
			'AdminNotice'		=> "Платформа: HP Proliant DL165 G7\nПроцессоры: 2x AMD Opteron 6238 Twelve Core (G34, 2600MHz, 16Mb, 12 ядер)\nОперативная память: DDR3, 2x4Gb + 4x2Gb, всего 16Gb\nRAID контроллер: 3Ware 9750-4I, 512Mb RAM\nЖёсткие диски: 4x Western Digital WD5003ABYX (собраны в RAID10)\nАдминистратор: Василий Алибабаевич\n\nДоступ к встроенной IP-KVM: 222.111.123.123/admin/cw4rf34n3"
			);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ServerEditForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
if($Window){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'Window',
				'type'  => 'hidden',
				'value' => $Window
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$ServerID)
	$DOM->AddAttribs('Body',Array('onload'=>'SettingsUpdate();'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# IO_Scan по всем директориям servers - создать массив уникальных имён шаблонов
$HostsIDs = $GLOBALS['HOST_CONF']['HostsIDs'];
#-------------------------------------------------------------------------------
$Templates = $Array = $Array1 = $ServiceIDs = Array();
#-------------------------------------------------------------------------------
foreach(Array_Reverse($HostsIDs) as $HostID){
	#-------------------------------------------------------------------------------
	$Path = SPrintF('%s/hosts/%s/servers',SYSTEM_PATH,$HostID);
	#-------------------------------------------------------------------------------
	if(!Is_Dir($Path))
		continue;
	#-------------------------------------------------------------------------------
	$Files = IO_Scan($Path);
	#-------------------------------------------------------------------------------
	if(Is_Error($Files))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach($Files as $File)
		if(!In_Array($File,$Array))
			$Array[] = $File;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Array as $Value){
	#-------------------------------------------------------------------------------
	$Value = Str_Replace('.xml','',$Value);
	#-------------------------------------------------------------------------------
	$Template = System_XML(SPrintF('servers/%s.xml',$Value));
	if(Is_Error($Template))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Array1[$Value] = $Template;
	#-------------------------------------------------------------------------------
	if(IsSet($Template['ServiceID']))
		$ServiceIDs[] = $Template['ServiceID'];
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# кастыли, для красивой сортировки списка
ASort($ServiceIDs);
#-------------------------------------------------------------------------------
# добавляем шаблоны с указанным сервисом, сортировка по номеру сервиса
foreach($ServiceIDs as $ServiceID)
	foreach(Array_Keys($Array1) as $Key)
		if(IsSet($Array1[$Key]['ServiceID']))
			if($ServiceID == $Array1[$Key]['ServiceID'])
				$Templates[$Key] = $Array1[$Key];
#-------------------------------------------------------------------------------
# удаляем из исходного массива то что уже добавили
foreach(Array_Keys($Array1) as $Key)
	if(IsSet($Templates[$Key]))
		Unset($Array1[$Key]);
#-------------------------------------------------------------------------------
# дефолтовый абстрактный сервер двигаем на последнее место
if(IsSet($Array1['Default'])){
	#-------------------------------------------------------------------------------
	$Default = $Array1['Default'];
	#-------------------------------------------------------------------------------
	UnSet($Array1['Default']);
	#-------------------------------------------------------------------------------
	$Array1['Default'] = $Default;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
# складываем получившиеся массивы
$Templates = $Templates + $Array1;
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/www/Administrator/ServerEdit]: Templates = %s',print_r($Templates,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$TemplateID){
	#-------------------------------------------------------------------------------
	$DOM->AddText('Title','Новый сервер');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# перебрать все шаблоны - надо имя
	$Options = $DisabledIDs = Array();
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Templates) as $TemplateID){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[comp/www/Administrator/ServerEdit]: TemplateID = %s',$TemplateID));
		#-------------------------------------------------------------------------------
		$Options[$TemplateID] = $Templates[$TemplateID]['Name'];
		#-------------------------------------------------------------------------------
		if(!$Templates[$TemplateID]['IsActive'])
			$DisabledIDs[] = $TemplateID;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!Count($Options))
		return new gException('TEMPLATES_NOT_DEFINED','Шаблоны не определены');
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'TemplateID','style'=>'width: 100%;'),$Options,NULL,$DisabledIDs);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table = Array(Array('Шаблон',$Comp));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'onclick' => "ShowWindow('/Administrator/ServerEdit',FormGet(form));",
				'type'    => 'button',
				'value'   => 'Продолжить'
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = $Comp;
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Tables/Standard',$Table);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$DOM->AddText('Title',SPrintF('%s: %s %s',($ServerID)?'Редактирование':'Добавление',$Templates[$TemplateID]['Name'],$Server['Address']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Template = $Templates[$TemplateID];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём дефолтовые значения для формы
	if(IsSet($Template['Defaults']))
		if(!$ServerID)
			foreach(Array_Keys($Template['Defaults']) as $Key)
				$Server[$Key] = $Template['Defaults'][$Key];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# строим массив параметров подстановки
	foreach(Array_Keys($Template) as $Key){
		if($Key != 'SystemID')
			continue;
		#-------------------------------------------------------------------------------
		if(Is_Array($Template[$Key])){
			#-------------------------------------------------------------------------------
			$Script = Array('var Settings = {};');
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Template[$Key]) as $SystemID)
				$Script[] = SPrintF("Settings['%s'] = %s;",$SystemID,JSON_Encode($Template[$Key][$SystemID]['Settings']));
			#-------------------------------------------------------------------------------
			$Script[] = "function SettingsUpdate(){\nvar \$Form = document.forms['ServerEditForm'];\nvar \$System = Settings[\$Form.$Key.value];\nfor(var i in \$System)\n\$Form[i].value = \$System[i];\n}";
			#-------------------------------------------------------------------------------
			$DOM->AddChild('Head',new Tag('SCRIPT',Implode("\n",$Script)));
			#-------------------------------------------------------------------------------
		
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'TemplateID',
				'type'  => 'hidden',
				'value' => $TemplateID
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table = Array();
	#-------------------------------------------------------------------------------
	$Table[] = 'Общие параметры';
	#-------------------------------------------------------------------------------
	$ServersGroups = DB_Select('ServersGroups',Array('ID','Name','ServiceID','(SELECT `Code` FROM `Services` WHERE `ServersGroups`.`ServiceID` = `Services`.`ID`) AS `Code`'),Array('SortOn'=>'SortID'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ServersGroups)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		# No more...
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Options = Array(0=>'Не входит в группу');
	#-------------------------------------------------------------------------------
	$Selected = 0;
	#-------------------------------------------------------------------------------
	if(Is_Array($ServersGroups)){
		#-------------------------------------------------------------------------------
		foreach($ServersGroups as $ServersGroup){
			#-------------------------------------------------------------------------------
			$Options[$ServersGroup['ID']] = SPrintF('[%s] %s',($ServersGroup['Code'])?$ServersGroup['Code']:'любой сервис',$ServersGroup['Name']);
			#-------------------------------------------------------------------------------
			if(IsSet($Templates[$TemplateID]['ServiceID']))
				if($ServersGroup['ServiceID'] == $Templates[$TemplateID]['ServiceID'])
					if(!$Selected)
						$Selected = $ServersGroup['ID'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if($Server['ServersGroupID'])
		$Selected = $Server['ServersGroupID'];
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'ServersGroupID','prompt'=>'Группа серверов, в которую входит сервер','style'=>'width: 100%;'),$Options,$Selected);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Группа серверов',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'IsActive','id'=>'IsActive','type'=>'checkbox','value'=>'yes'));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if($Server['IsActive'])
		$Comp->AddAttribs(Array('checked'=>'yes'));
	#-------------------------------------------------------------------------------
	$Table[] = Array(new Tag('LABEL',Array('for'=>'IsActive'),'Активен'),$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'IsDefault','id'=>'IsDefault','type'=>'checkbox','value'=>'yes'));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if($Server['IsDefault'])
		$Comp->AddAttribs(Array('checked'=>'yes'));
	#-------------------------------------------------------------------------------
	$Table[] = Array(new Tag('LABEL',Array('for'=>'IsDefault'),'Основной в группе'),$Comp);
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'          => 'text',
				'name'          => 'SortID',
				'style'         => 'width: 100%;',
				'value'         => $Server['SortID'],
				'prompt'        => 'В каком порядке сортировать группы, при отображении'
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Порядок сортировки',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = 'Параметры соединения';
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'Protocol','style'=>'width: 100%;'),Array('ssl'=>'ssl','tcp'=>'tcp'),$Server['Protocol']);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Протокол',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'class'	=> 'Duty',
				'type'	=> 'text',
				'name'	=> 'Address',
				'prompt'=> 'Используется для связи с сервером',
				'value'	=> $Server['Address'],
				'style'	=> 'width: 100%;',
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Адрес сервера',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'class'	=> 'Duty',
				'type'  => 'text',
				'name'  => 'Port',
				'prompt'=> 'Порт на который устанавливать соединение с сервером (для SSL - обычно 443, для HTTP - 80)',
				'value' => $Server['Port'],
				'style' => 'width: 100%;',
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Порт',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'	=> 'text',
				'class'	=> 'Duty',
				'prompt'=> 'Имя администратора или реселлера имеющего права на создание новых клиентов, на сервере, через систему управления',
				'name'	=> 'Login',
				'value'	=> $Server['Login'],
				'style' => 'width: 100%;',
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Логин',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'class' => 'Duty',
				'type'  => ($ServerID?'password':'text'),
				'name'  => 'Password',
				'value' => $Server['Password'],
				'style' => 'width: 100%;',
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Пароль',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($ServerID){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'name'  => 'ServerID',
					'type'  => 'hidden',
					'value' => $Server['ID'],
					'style' => 'width: 100%;',
					)
				);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Form->AddChild($Comp);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Template = System_XML(SPrintF('servers/%s.xml',$TemplateID));
	if(Is_Error($Template))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($Template['Attribs'])){
		#-------------------------------------------------------------------------------
		$Attribs = $Template['Attribs'];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Replace = Array_ToLine($__USER,'%');
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Attribs) as $AttribID){
			#-------------------------------------------------------------------------------
			$Attrib = $Attribs[$AttribID];
			#-------------------------------------------------------------------------------
			if(IsSet($Attrib['Title']))
				$Table[] = $Attrib['Title'];
			#-------------------------------------------------------------------------------
			if($ServerID){
				#-------------------------------------------------------------------------------
				$Value = (string)@$Server['Params'][$AttribID];
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$Value = $Attrib['Value'];
				#-------------------------------------------------------------------------------
				foreach(Array_Keys($Replace) as $Key)
					$Value = Str_Replace($Key,$Replace[$Key],$Value);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Params = &$Attrib['Attribs'];
			#-------------------------------------------------------------------------------
			$Params['name'] = $AttribID;
			#-------------------------------------------------------------------------------
			if($Attrib['IsDuty'])
				$Params['class'] = 'Duty';
			#-------------------------------------------------------------------------------
			switch($Attrib['Type']){
			case 'Input':
				#-------------------------------------------------------------------------------
				$Params['value'] = $Value;
				#-------------------------------------------------------------------------------
				# костыль для чекбоксов - у них всегда одно значение
				if(IsSet($Attrib['Attribs']['type']) && $Attrib['Attribs']['type'] == 'checkbox')
					$Params['value'] = 'yes';
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('Form/Input',$Params);
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(101);
				#-------------------------------------------------------------------------------
				# костыль для чекбоксов - у них дополнительный параметр "checked", если задано значение
				if(IsSet($Attrib['Attribs']['type']) && $Attrib['Attribs']['type'] == 'checkbox' && $Value)
					$Comp->AddAttribs(Array('checked'=>'yes'));
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'TextArea':
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('Form/TextArea',$Params,$Value);
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(101);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'Select':
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('Form/Select',$Params,$Attrib['Options'],$Value);
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(101);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'Hidden':
				#-------------------------------------------------------------------------------
				$Params['value'] = $Value;
				#-------------------------------------------------------------------------------
				$Params['type'] = 'hidden';
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('Form/Input',$Params);
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(101);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------

			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			if($Attrib['Type'] == 'Hidden'){
				#-------------------------------------------------------------------------------
				$Form->AddChild($Comp);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$NoBody = new Tag('NOBODY',new Tag('SPAN',(IsSet($Attrib['CommentAttribs'])?$Attrib['CommentAttribs']:Array()),$Attrib['Comment']));
				#-------------------------------------------------------------------------------
				$NoBody->AddChild(new Tag('BR'));
				#-------------------------------------------------------------------------------
				if(IsSet($Attrib['Example']))
					$NoBody->AddChild(new Tag('SPAN',Array('class'=>'Comment'),SPrintF('Например: %s',$Attrib['Example'])));
				#-------------------------------------------------------------------------------
				$Table[] = Array($NoBody,$Comp);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = 'Служба мониторинга';
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/TextArea',
			Array(
				'name'		=> 'Monitoring',
				'style'		=> 'width:100%;',
				'rows'		=> 5,
				'prompt'	=> 'Сервисы которые необходимо мониторить на данном сервере. Список, по одному значению СЕРВИС=ПОРТ на каждой строке'
				),
			Str_Replace(" ","\n",$Server['Monitoring'])
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = Array('Сервисы',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Table[] = 'Заметка';
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/TextArea',
			Array(
				'name'		=> 'AdminNotice',
				'style'		=> 'width:100%;',
				'rows'		=> 5,
				'prompt'	=> 'Информация о сервере, "чисто для себя"'
				),
			$Server['AdminNotice']
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = $Comp;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'    => 'button',
				'onclick' => SPrintF("FormEdit('/Administrator/API/ServerEdit','ServerEditForm','%s');",($ServerID?'Сохранение настроек':'Добавление сервера')),
				'value'   => ($ServerID?'Сохранить':'Добавить сервер')
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = $Comp;
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Tables/Standard',$Table,Array('style'=>'width:500px;'));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
