<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ServerID = (integer) @$Args['ServerID'];
$Month    = (integer) @$Args['Month'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Server = DB_Select('Servers',Array('ID','Address'),Array('UNIQ','ID'=>$ServerID));
switch(ValueOf($Server)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddText('Title',SPrintF('Мониторинг сервера %s',$Server['Address']));
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
if(!$Month)
	$Month = Date('n');
#-------------------------------------------------------------------------------
$Where = SPrintF('`ServerID` = %u AND `Month` = %u',$ServerID,$Month);
#-------------------------------------------------------------------------------
$UpTimes = DB_Select('ServersUpTime',Array('Service','(SUM(`UpTime`*`Count`)/SUM(`Count`)) as `UpTime`','TestDate','Day','Month','Year'),Array('SortOn'=>Array('TestDate'),'IsDesc'=>TRUE,'Where'=>$Where,'GroupBy'=>Array('Service','Year','Month','Day')));
#-------------------------------------------------------------------------------
switch(ValueOf($UpTimes)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('DATA_NOT_FOUND','Данные не найдены');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$dMonths = DB_Select('ServersUpTime','Month',Array('GroupBy'=>'Month'));
#-------------------------------------------------------------------------------
switch(ValueOf($dMonths)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('MONTHS_NOT_FOUND','Месяцы не найдены');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$MonthsNames = Array('Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь');
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach($dMonths as $dMonth)
	$Options[$dMonth['Month']] = $MonthsNames[$dMonth['Month']-1];
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'Month','onchange'=>SPrintF("ShowWindow('/Administrator/ServerUpTimeInfo',{ServerID:%u,Month:value});",$ServerID)),$Options,$Month);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Rows = Array();
#-------------------------------------------------------------------------------
$Tr = new Tag('TR');
#-------------------------------------------------------------------------------
$Date = UniqID();
#-------------------------------------------------------------------------------
foreach($UpTimes as $UpTime){
	#-------------------------------------------------------------------------------
	$CurrentDate = SPrintF('%02u.%02u.%02u',$UpTime['Day'],$UpTime['Month'],$UpTime['Year']);
	#-------------------------------------------------------------------------------
	if($Date != $CurrentDate){
		#-------------------------------------------------------------------------------
		$Date = $CurrentDate;
		#-------------------------------------------------------------------------------
		if(Count($Tr->Childs)){
			#-------------------------------------------------------------------------------
			$Rows[] = $Tr;
			#-------------------------------------------------------------------------------
			$Tr = new Tag('TR');
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Rows[] = new Tag('TR',new Tag('TD',Array('colspan'=>6,'class'=>'Separator','style'=>'font-size:16px;'),$Date));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Tr->AddChild(new Tag('TD',Array('class'=>'Comment'),$UpTime['Service']));
	#-------------------------------------------------------------------------------
	$Tr->AddChild(new Tag('TD',Array('class'=>'Standard','align'=>'Right','style'=>SPrintF('background-color:#%s',(integer)$UpTime['UpTime'] < 100?'FF6666':'D5F66C')),SPrintF('%u%%',$UpTime['UpTime'])));
	#-------------------------------------------------------------------------------
	if(Count($Tr->Childs)%6 == 0){
		#-------------------------------------------------------------------------------
		$Rows[] = $Tr;
		#-------------------------------------------------------------------------------
		$Tr = new Tag('TR');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
if(Count($Tr->Childs))
	$Rows[] = $Tr;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Extended',$Rows);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = $DOM->Build(FALSE);
#-------------------------------------------------------------------------------
if(Is_Error($Out))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
