<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$DomainOrderID = (integer) @$Args['DomainOrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DomainOrder = DB_Select('DomainOrdersOwners',Array('ID','UserID','SchemeID','DomainName','Ns1Name','Ns1IP','Ns2Name','Ns2IP','Ns3Name','Ns3IP','Ns4Name','Ns4IP','StatusID','StatusDate'),Array('UNIQ','ID'=>$DomainOrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('DomainOrdersRead',(integer)$__USER['ID'],(integer)$DomainOrder['UserID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($DomainOrder['StatusID'] != 'Active')
	return new gException('ORDER_NOT_ACTIVE','Заказ домена не активен');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DomainScheme = DB_Select('DomainSchemes','Name',Array('UNIQ','ID'=>$DomainOrder['SchemeID']));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainScheme)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// возможно слишком быстро меняют, после регистрации или предыдущей смены.
if(!$__USER['IsAdmin'] && Time() - $DomainOrder['StatusDate'] < 600)
	return new gException('TOO_FAST_CHANGE_NS','Изменять сервера DNS можно не чаще чем раз в 10 минут');

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Domain = SPrintF('%s.%s',$DomainOrder['DomainName'],$DomainScheme['Name']);
#-------------------------------------------------------------------------------
$IDNA = new Net_IDNA();
#-------------------------------------------------------------------------------
$IDNA_Domain = $IDNA->encode($Domain);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
#-------------------------------------------------------------------------------
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddText('Title','Смена именных серверов');
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/Pages/DomainOrderNsChange.js}')));
#-------------------------------------------------------------------------------
$Script = SPrintF('IsNewNs(\'%s\',\'%s\');',$Domain,$IDNA_Domain);
#-------------------------------------------------------------------------------
$DOM->AddAttribs('Body',Array('onload'=>$Script));
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
$Table[] = Array('Доменное имя',$Domain);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Messages();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Первичный сервер имен';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns1Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>$Script,'value'=>$DomainOrder['Ns1Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns1IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns1IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

$Table[] = 'Вторичный сервер имен';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns2Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>$Script,'value'=>$DomainOrder['Ns2Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns2IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns2IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

$Table[] = 'Дополнительный сервер имен';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns3Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>$Script,'value'=>$DomainOrder['Ns3Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns3IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns3IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

$Table[] = 'Расширенный сервер имен';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns4Name','type'=>'text','prompt'=>$Messages['Prompts']['Domain']['NsName'],'onkeyup'=>$Script,'value'=>$DomainOrder['Ns4Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Доменный адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'Ns4IP','prompt'=>$Messages['Prompts']['IP'],'type'=>'text','value'=>$DomainOrder['Ns4IP']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('IP адрес',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>'DomainOrderNsChange();','value'=>'Изменить'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'DomainOrderNsChangeForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'DomainOrderID','type'=>'hidden','value'=>$DomainOrder['ID']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',new Tag('SCRIPT',Array('type'=>'text/javascript'),SPrintF("var \$Domain = '%s';",$Domain)));
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
