<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$DomainOrderID	= (integer) @$Args['DomainOrderID'];
$OrderID	= (integer) @$Args['OrderID'];
$ProfileID	= (integer) @$Args['ProfileID'];
$StepID		= (integer) @$Args['StepID'];
$OwnerTypeID	=  (string) @$Args['OwnerTypeID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = ($DomainOrderID?SPrintF('`ID` = %u',$DomainOrderID):SPrintF('`OrderID` = %u',$OrderID));
#-------------------------------------------------------------------------------
$DomainOrder = DB_Select('DomainOrdersOwners',Array('ID','UserID','SchemeID','StatusID'),Array('UNIQ','Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('DomainOrdersRead',(integer)$__USER['ID'],(integer)$DomainOrder['UserID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$StatusID = $DomainOrder['StatusID'];
#-------------------------------------------------------------------------------
if(!In_Array($StatusID,Array('Waiting','ClaimForRegister','ForContractRegister','ForRegister','ForTransfer')))
	return new gException('ORDER_NOT_CLAIM_STATUS','Владелец может быть определён, только для не зарегистрированных доменов и не поступивших на регистрацию или перенос');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DomainScheme = DB_Select('DomainSchemes',Array('Name','ServerID','(SELECT `Params` FROM `Servers` WHERE `ServerID` = `Servers`.`ID`) as `Params`'),Array('UNIQ','ID'=>$DomainOrder['SchemeID']));
#-------------------------------------------------------------------------------
switch(ValueOf($DomainScheme)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddText('Title','Владелец домена');
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'DomainSelectOwnerForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
if($DomainOrderID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'DomainOrderID','type'=>'hidden','value'=>$DomainOrderID));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($StepID){
	#-------------------------------------------------------------------------------
	$DOM->AddChild('Head',new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/Pages/DomainSelectOwner.js}')));
	#-------------------------------------------------------------------------------
	$Table = Array();
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('type'=>'hidden','name'=>'OwnerTypeID','value'=>$OwnerTypeID));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
	switch($OwnerTypeID){
	case 'Person':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'PersonID'));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Adding = new Tag('NOBODY',$Comp);
		#-------------------------------------------------------------------------------
		$NoBody = new Tag('NOBODY',new Tag('SPAN','Договор регистратора'));
		#-------------------------------------------------------------------------------
		if($DomainScheme['Params']['PersonID']){
			#-------------------------------------------------------------------------------
			$NoBody->AddChild(new Tag('BR'));
			$NoBody->AddChild(new Tag('SPAN',Array('class'=>'Comment'),new Tag('SPAN',$DomainScheme['Params']['PersonID'])));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Where = SPrintF("`ID` != %u AND `PersonID` != '' AND `UserID` = %u AND `DomainOrdersOwners`.`SchemeID` IN (SELECT `ID` FROM `DomainSchemes` WHERE `DomainSchemes`.`ServerID` = %u)",$DomainOrder['ID'],$__USER['ID'],$DomainScheme['ServerID']);
		#-------------------------------------------------------------------------------
		$Persons = DB_Select('DomainOrdersOwners','PersonID',Array('Where'=>$Where));
		#-------------------------------------------------------------------------------
		switch(ValueOf($Persons)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			# No more...
			break;
		case 'array':
			#-------------------------------------------------------------------------------
			$Options = Array(NULL=>'ввести в ручную');
			#-------------------------------------------------------------------------------
			foreach($Persons as $Person)
				$Options[$Person['PersonID']] = $Person['PersonID'];
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Form/Select',Array('onchange'=>"form.PersonID.value = value;"),$Options);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Adding->AddChild(new Tag('SPAN','из списка'));
			#-------------------------------------------------------------------------------
			$Adding->AddChild($Comp);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		$Table[] = Array($NoBody,$Adding);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Profile':
		#-------------------------------------------------------------------------------
		$Where = SPrintF("`UserID` = %u AND `TemplateID` IN ('Natural','Juridical') AND `StatusID` != 'Rejected'",$__USER['ID']);
		#-------------------------------------------------------------------------------
		$Profiles = DB_Select('Profiles',Array('ID','Name','StatusID'),Array('Where'=>$Where));
		#-------------------------------------------------------------------------------
		switch(ValueOf($Profiles)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			$Window = JSON_Encode(Array('Url'=>'/DomainSelectOwner','Args'=>Array('DomainOrderID'=>$DomainOrder['ID'],'StepID'=>1,'OwnerTypeID'=>'Profile')));
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('www/ProfileEdit',Array('Window'=>Base64_Encode($Window),'TemplatesIDs'=>'Natural,Juridical'));
			#-------------------------------------------------------------------------------
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			return $Comp;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			if(Count($Profiles) < 2){
				#-------------------------------------------------------------------------------
				$Profile = Current($Profiles);
				#-------------------------------------------------------------------------------
				if($Profile['StatusID'] == 'OnFilling'){
					#-------------------------------------------------------------------------------
					$Window = JSON_Encode(Array('Url'=>'/DomainSelectOwner','Args'=>Array('DomainOrderID'=>$DomainOrder['ID'],'StepID'=>1,'OwnerTypeID'=>'Profile')));
					#-------------------------------------------------------------------------------
					$Comp = Comp_Load('www/ProfileEdit',Array('Window'=>Base64_Encode($Window),'ProfileID'=>$Profile['ID']));
					if(Is_Error($Comp))
						return ERROR | @Trigger_Error(500);
					#-------------------------------------------------------------------------------
					return $Comp;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			if($ProfileID)
				$DOM->AddAttribs('Body',Array('onload'=>'DomainSelectOwner();'));
			#-------------------------------------------------------------------------------
			$Options = Array();
			#-------------------------------------------------------------------------------
			foreach($Profiles as $Profile)
				$Options[$Profile['ID']] = $Profile['Name'];
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Form/Select',Array('name'=>'ProfileID'),$Options,$ProfileID);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$NoBody = new Tag('NOBODY',$Comp);
			#-------------------------------------------------------------------------------
			$Window = JSON_Encode(Array('Url'=>'/DomainSelectOwner','Args'=>Array('DomainOrderID'=>$DomainOrder['ID'],'StepID'=>1,'OwnerTypeID'=>'Profile')));
			#-------------------------------------------------------------------------------
			$A = new Tag('A',Array('href'=>SPrintF("javascript:ShowWindow('/ProfileEdit',{Window:'%s',TemplatesIDs:'Natural,Juridical'});",Base64_Encode($Window))),'[новый]');
			#-------------------------------------------------------------------------------
			$NoBody->AddChild($A);
			#-------------------------------------------------------------------------------
			$Table[] = Array('Использовать профиль',$NoBody);
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Form/Input',Array('name'=>'Agree','type'=>'checkbox','value'=>'yes','prompt'=>'Подверждаю своё согласие на передачу моих персональных данных вышестоящему регистратору доменов'));
			#-------------------------------------------------------------------------------
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Table[] = Array('Согласен на передачу моих персональных данных регистратору',$Comp);
			#-------------------------------------------------------------------------------
			break 2;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>'DomainSelectOwner();','value'=>'Продолжить'));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Table[] = $Comp;
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Tables/Standard',$Table);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('www/DomainSelectOwner',Array('DomainOrderID'=>$DomainOrder['ID'],'OwnerTypeID'=>'Profile','StepID'=>1));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	return $Comp;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
