<?php
/**
 *
 *  Joonte Billing System
 *
 *  Copyright © 2020 Alex Keda, for www.host-food.ru
 *
 */

class DNSmanagerOrdersSuspendedMsg extends Message {
	#-------------------------------------------------------------------------------
	public function __construct(array $params, $toUser) {
		#-------------------------------------------------------------------------------
		parent::__construct('DNSmanagerOrdersSuspended', $toUser, $params);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function getParams() {
		#-------------------------------------------------------------------------------
		$DNSmanagerScheme = DB_Select('DNSmanagerSchemes', Array('*'), Array('UNIQ', 'Where' => SPrintF('`ID` = %u',$this->params['SchemeID'])));
		#-------------------------------------------------------------------------------
		if(!Is_Array($DNSmanagerScheme))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$this->params['DNSmanagerScheme'] = $DNSmanagerScheme;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ссылка на продление заказа
		$this->params['ProlongLink'] = SPrintF('%s://%s/v2/DNSmanagerOrders/%u/',URL_SCHEME,HOST_ID,$this->params['OrderID']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ссылка на смену тарифа
		$this->params['SchemeChangeLink'] = SPrintF('%s://%s/v2/DNSmanagerOrders/%u/SchemeChange/',URL_SCHEME,HOST_ID,$this->params['OrderID']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $this->params;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

